/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.functions;

import cdm.base.staticdata.identifier.Identifier;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@ImplementedBy(value=FilterTradeLotDefault.class)
public abstract class FilterTradeLot
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public List<? extends TradeLot> evaluate(List<? extends TradeLot> tradeLots, List<? extends Identifier> lotIdentifier) {
        List<TradeLot.TradeLotBuilder> filteredTradeLots = this.doEvaluate(tradeLots, lotIdentifier);
        if (filteredTradeLots != null) {
            this.objectValidator.validate(TradeLot.class, filteredTradeLots);
        }
        return filteredTradeLots;
    }

    protected abstract List<TradeLot.TradeLotBuilder> doEvaluate(List<? extends TradeLot> var1, List<? extends Identifier> var2);

    public static class FilterTradeLotDefault
    extends FilterTradeLot {
        @Override
        protected List<TradeLot.TradeLotBuilder> doEvaluate(List<? extends TradeLot> tradeLots, List<? extends Identifier> lotIdentifier) {
            ArrayList<TradeLot.TradeLotBuilder> filteredTradeLots = new ArrayList<TradeLot.TradeLotBuilder>();
            return this.assignOutput(filteredTradeLots, tradeLots, lotIdentifier);
        }

        protected List<TradeLot.TradeLotBuilder> assignOutput(List<TradeLot.TradeLotBuilder> filteredTradeLots, List<? extends TradeLot> tradeLots, List<? extends Identifier> lotIdentifier) {
            List addVar = this.toBuilder(MapperC.of(tradeLots).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.mapC("getLotIdentifier", tradeLot -> tradeLot.getLotIdentifier()), (Mapper)MapperC.of((List)lotIdentifier), (CardinalityOperator)CardinalityOperator.All).get()).getMulti());
            filteredTradeLots.addAll(addVar);
            return Optional.ofNullable(filteredTradeLots).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

