/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.functions;

import cdm.base.staticdata.identifier.Identifier;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import java.util.List;
import java.util.Optional;

@ImplementedBy(value=Create_TradeLotDefault.class)
public abstract class Create_TradeLot
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public TradeLot evaluate(List<? extends Identifier> lotIdentifier, List<? extends PriceQuantity> priceQuantity) {
        TradeLot.TradeLotBuilder tradeLot = this.doEvaluate(lotIdentifier, priceQuantity);
        if (tradeLot != null) {
            this.objectValidator.validate(TradeLot.class, (RosettaModelObject)tradeLot);
        }
        return tradeLot;
    }

    protected abstract TradeLot.TradeLotBuilder doEvaluate(List<? extends Identifier> var1, List<? extends PriceQuantity> var2);

    public static class Create_TradeLotDefault
    extends Create_TradeLot {
        @Override
        protected TradeLot.TradeLotBuilder doEvaluate(List<? extends Identifier> lotIdentifier, List<? extends PriceQuantity> priceQuantity) {
            TradeLot.TradeLotBuilder tradeLot = TradeLot.builder();
            return this.assignOutput(tradeLot, lotIdentifier, priceQuantity);
        }

        protected TradeLot.TradeLotBuilder assignOutput(TradeLot.TradeLotBuilder tradeLot, List<? extends Identifier> lotIdentifier, List<? extends PriceQuantity> priceQuantity) {
            tradeLot.addLotIdentifier(MapperC.of(lotIdentifier).getMulti());
            tradeLot.addPriceQuantity(MapperC.of(priceQuantity).getMulti());
            return Optional.ofNullable(tradeLot).map(o -> o.prune()).orElse(null);
        }
    }
}

