/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.staticdata.party.AncillaryParty;
import cdm.base.staticdata.party.Counterparty;
import cdm.product.common.NotionalAdjustmentEnum;
import cdm.product.template.Product;
import cdm.product.template.TradeLot;
import cdm.product.template.meta.TradableProductMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface TradableProduct
extends RosettaModelObject {
    public static final TradableProductMeta metaData = new TradableProductMeta();

    public TradableProduct build();

    public TradableProductBuilder toBuilder();

    public NotionalAdjustmentEnum getAdjustment();

    public List<? extends AncillaryParty> getAncillaryParty();

    public List<? extends Counterparty> getCounterparty();

    public Product getProduct();

    public List<? extends TradeLot> getTradeLot();

    default public RosettaMetaData<? extends TradableProduct> metaData() {
        return metaData;
    }

    public static TradableProductBuilder builder() {
        return new TradableProductBuilderImpl();
    }

    default public Class<? extends TradableProduct> getType() {
        return TradableProduct.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("adjustment"), NotionalAdjustmentEnum.class, (Object)this.getAdjustment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("ancillaryParty"), processor, AncillaryParty.class, this.getAncillaryParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("counterparty"), processor, Counterparty.class, this.getCounterparty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("product"), processor, Product.class, this.getProduct(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeLot"), processor, TradeLot.class, this.getTradeLot(), new AttributeMeta[0]);
    }

    public static class TradableProductBuilderImpl
    implements TradableProductBuilder {
        protected NotionalAdjustmentEnum adjustment;
        protected List<AncillaryParty.AncillaryPartyBuilder> ancillaryParty = new ArrayList<AncillaryParty.AncillaryPartyBuilder>();
        protected List<Counterparty.CounterpartyBuilder> counterparty = new ArrayList<Counterparty.CounterpartyBuilder>();
        protected Product.ProductBuilder product;
        protected List<TradeLot.TradeLotBuilder> tradeLot = new ArrayList<TradeLot.TradeLotBuilder>();

        @Override
        public NotionalAdjustmentEnum getAdjustment() {
            return this.adjustment;
        }

        @Override
        public List<? extends AncillaryParty.AncillaryPartyBuilder> getAncillaryParty() {
            return this.ancillaryParty;
        }

        @Override
        public AncillaryParty.AncillaryPartyBuilder getOrCreateAncillaryParty(int _index) {
            if (this.ancillaryParty == null) {
                this.ancillaryParty = new ArrayList<AncillaryParty.AncillaryPartyBuilder>();
            }
            return (AncillaryParty.AncillaryPartyBuilder)this.getIndex(this.ancillaryParty, _index, () -> {
                AncillaryParty.AncillaryPartyBuilder newAncillaryParty = AncillaryParty.builder();
                return newAncillaryParty;
            });
        }

        @Override
        public List<? extends Counterparty.CounterpartyBuilder> getCounterparty() {
            return this.counterparty;
        }

        @Override
        public Counterparty.CounterpartyBuilder getOrCreateCounterparty(int _index) {
            if (this.counterparty == null) {
                this.counterparty = new ArrayList<Counterparty.CounterpartyBuilder>();
            }
            return (Counterparty.CounterpartyBuilder)this.getIndex(this.counterparty, _index, () -> {
                Counterparty.CounterpartyBuilder newCounterparty = Counterparty.builder();
                return newCounterparty;
            });
        }

        @Override
        public Product.ProductBuilder getProduct() {
            return this.product;
        }

        @Override
        public Product.ProductBuilder getOrCreateProduct() {
            Product.ProductBuilder result = this.product != null ? this.product : (this.product = Product.builder());
            return result;
        }

        @Override
        public List<? extends TradeLot.TradeLotBuilder> getTradeLot() {
            return this.tradeLot;
        }

        @Override
        public TradeLot.TradeLotBuilder getOrCreateTradeLot(int _index) {
            if (this.tradeLot == null) {
                this.tradeLot = new ArrayList<TradeLot.TradeLotBuilder>();
            }
            return (TradeLot.TradeLotBuilder)this.getIndex(this.tradeLot, _index, () -> {
                TradeLot.TradeLotBuilder newTradeLot = TradeLot.builder();
                return newTradeLot;
            });
        }

        @Override
        public TradableProductBuilder setAdjustment(NotionalAdjustmentEnum adjustment) {
            this.adjustment = adjustment == null ? null : adjustment;
            return this;
        }

        @Override
        public TradableProductBuilder addAncillaryParty(AncillaryParty ancillaryParty) {
            if (ancillaryParty != null) {
                this.ancillaryParty.add(ancillaryParty.toBuilder());
            }
            return this;
        }

        @Override
        public TradableProductBuilder addAncillaryParty(AncillaryParty ancillaryParty, int _idx) {
            this.getIndex(this.ancillaryParty, _idx, () -> ancillaryParty.toBuilder());
            return this;
        }

        @Override
        public TradableProductBuilder addAncillaryParty(List<? extends AncillaryParty> ancillaryPartys) {
            if (ancillaryPartys != null) {
                for (AncillaryParty ancillaryParty : ancillaryPartys) {
                    this.ancillaryParty.add(ancillaryParty.toBuilder());
                }
            }
            return this;
        }

        @Override
        public TradableProductBuilder setAncillaryParty(List<? extends AncillaryParty> ancillaryPartys) {
            this.ancillaryParty = ancillaryPartys == null ? new ArrayList<AncillaryParty.AncillaryPartyBuilder>() : (List)ancillaryPartys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public TradableProductBuilder addCounterparty(Counterparty counterparty) {
            if (counterparty != null) {
                this.counterparty.add(counterparty.toBuilder());
            }
            return this;
        }

        @Override
        public TradableProductBuilder addCounterparty(Counterparty counterparty, int _idx) {
            this.getIndex(this.counterparty, _idx, () -> counterparty.toBuilder());
            return this;
        }

        @Override
        public TradableProductBuilder addCounterparty(List<? extends Counterparty> counterpartys) {
            if (counterpartys != null) {
                for (Counterparty counterparty : counterpartys) {
                    this.counterparty.add(counterparty.toBuilder());
                }
            }
            return this;
        }

        @Override
        public TradableProductBuilder setCounterparty(List<? extends Counterparty> counterpartys) {
            this.counterparty = counterpartys == null ? new ArrayList<Counterparty.CounterpartyBuilder>() : (List)counterpartys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public TradableProductBuilder setProduct(Product product) {
            this.product = product == null ? null : product.toBuilder();
            return this;
        }

        @Override
        public TradableProductBuilder addTradeLot(TradeLot tradeLot) {
            if (tradeLot != null) {
                this.tradeLot.add(tradeLot.toBuilder());
            }
            return this;
        }

        @Override
        public TradableProductBuilder addTradeLot(TradeLot tradeLot, int _idx) {
            this.getIndex(this.tradeLot, _idx, () -> tradeLot.toBuilder());
            return this;
        }

        @Override
        public TradableProductBuilder addTradeLot(List<? extends TradeLot> tradeLots) {
            if (tradeLots != null) {
                for (TradeLot tradeLot : tradeLots) {
                    this.tradeLot.add(tradeLot.toBuilder());
                }
            }
            return this;
        }

        @Override
        public TradableProductBuilder setTradeLot(List<? extends TradeLot> tradeLots) {
            this.tradeLot = tradeLots == null ? new ArrayList<TradeLot.TradeLotBuilder>() : (List)tradeLots.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public TradableProduct build() {
            return new TradableProductImpl(this);
        }

        @Override
        public TradableProductBuilder toBuilder() {
            return this;
        }

        @Override
        public TradableProductBuilder prune() {
            this.ancillaryParty = this.ancillaryParty.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.counterparty = this.counterparty.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.product != null && !this.product.prune().hasData()) {
                this.product = null;
            }
            this.tradeLot = this.tradeLot.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getAdjustment() != null) {
                return true;
            }
            if (this.getAncillaryParty() != null && this.getAncillaryParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCounterparty() != null && this.getCounterparty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getProduct() != null && this.getProduct().hasData()) {
                return true;
            }
            return this.getTradeLot() != null && this.getTradeLot().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public TradableProductBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TradableProductBuilder o = (TradableProductBuilder)other;
            merger.mergeRosetta(this.getAncillaryParty(), o.getAncillaryParty(), this::getOrCreateAncillaryParty);
            merger.mergeRosetta(this.getCounterparty(), o.getCounterparty(), this::getOrCreateCounterparty);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getProduct(), (RosettaModelObjectBuilder)o.getProduct(), this::setProduct);
            merger.mergeRosetta(this.getTradeLot(), o.getTradeLot(), this::getOrCreateTradeLot);
            merger.mergeBasic((Object)this.getAdjustment(), (Object)o.getAdjustment(), this::setAdjustment, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TradableProduct _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.adjustment, (Object)_that.getAdjustment())) {
                return false;
            }
            if (!ListEquals.listEquals(this.ancillaryParty, _that.getAncillaryParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.counterparty, _that.getCounterparty())) {
                return false;
            }
            if (!Objects.equals(this.product, _that.getProduct())) {
                return false;
            }
            return ListEquals.listEquals(this.tradeLot, _that.getTradeLot());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.adjustment != null ? ((Object)((Object)this.adjustment)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.ancillaryParty != null ? this.ancillaryParty.hashCode() : 0);
            _result = 31 * _result + (this.counterparty != null ? this.counterparty.hashCode() : 0);
            _result = 31 * _result + (this.product != null ? this.product.hashCode() : 0);
            _result = 31 * _result + (this.tradeLot != null ? this.tradeLot.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradableProductBuilder {adjustment=" + (Object)((Object)this.adjustment) + ", ancillaryParty=" + this.ancillaryParty + ", counterparty=" + this.counterparty + ", product=" + this.product + ", tradeLot=" + this.tradeLot + '}';
        }
    }

    public static class TradableProductImpl
    implements TradableProduct {
        private final NotionalAdjustmentEnum adjustment;
        private final List<? extends AncillaryParty> ancillaryParty;
        private final List<? extends Counterparty> counterparty;
        private final Product product;
        private final List<? extends TradeLot> tradeLot;

        protected TradableProductImpl(TradableProductBuilder builder) {
            this.adjustment = builder.getAdjustment();
            this.ancillaryParty = Optional.ofNullable(builder.getAncillaryParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.counterparty = Optional.ofNullable(builder.getCounterparty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.product = Optional.ofNullable(builder.getProduct()).map(f -> f.build()).orElse(null);
            this.tradeLot = Optional.ofNullable(builder.getTradeLot()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        public NotionalAdjustmentEnum getAdjustment() {
            return this.adjustment;
        }

        @Override
        public List<? extends AncillaryParty> getAncillaryParty() {
            return this.ancillaryParty;
        }

        @Override
        public List<? extends Counterparty> getCounterparty() {
            return this.counterparty;
        }

        @Override
        public Product getProduct() {
            return this.product;
        }

        @Override
        public List<? extends TradeLot> getTradeLot() {
            return this.tradeLot;
        }

        @Override
        public TradableProduct build() {
            return this;
        }

        @Override
        public TradableProductBuilder toBuilder() {
            TradableProductBuilder builder = TradableProduct.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TradableProductBuilder builder) {
            Optional.ofNullable(this.getAdjustment()).ifPresent(builder::setAdjustment);
            Optional.ofNullable(this.getAncillaryParty()).ifPresent(builder::setAncillaryParty);
            Optional.ofNullable(this.getCounterparty()).ifPresent(builder::setCounterparty);
            Optional.ofNullable(this.getProduct()).ifPresent(builder::setProduct);
            Optional.ofNullable(this.getTradeLot()).ifPresent(builder::setTradeLot);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TradableProduct _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.adjustment, (Object)_that.getAdjustment())) {
                return false;
            }
            if (!ListEquals.listEquals(this.ancillaryParty, _that.getAncillaryParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.counterparty, _that.getCounterparty())) {
                return false;
            }
            if (!Objects.equals(this.product, _that.getProduct())) {
                return false;
            }
            return ListEquals.listEquals(this.tradeLot, _that.getTradeLot());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.adjustment != null ? ((Object)((Object)this.adjustment)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.ancillaryParty != null ? this.ancillaryParty.hashCode() : 0);
            _result = 31 * _result + (this.counterparty != null ? this.counterparty.hashCode() : 0);
            _result = 31 * _result + (this.product != null ? this.product.hashCode() : 0);
            _result = 31 * _result + (this.tradeLot != null ? this.tradeLot.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradableProduct {adjustment=" + (Object)((Object)this.adjustment) + ", ancillaryParty=" + this.ancillaryParty + ", counterparty=" + this.counterparty + ", product=" + this.product + ", tradeLot=" + this.tradeLot + '}';
        }
    }

    public static interface TradableProductBuilder
    extends TradableProduct,
    RosettaModelObjectBuilder {
        public AncillaryParty.AncillaryPartyBuilder getOrCreateAncillaryParty(int var1);

        public List<? extends AncillaryParty.AncillaryPartyBuilder> getAncillaryParty();

        public Counterparty.CounterpartyBuilder getOrCreateCounterparty(int var1);

        public List<? extends Counterparty.CounterpartyBuilder> getCounterparty();

        public Product.ProductBuilder getOrCreateProduct();

        @Override
        public Product.ProductBuilder getProduct();

        public TradeLot.TradeLotBuilder getOrCreateTradeLot(int var1);

        public List<? extends TradeLot.TradeLotBuilder> getTradeLot();

        public TradableProductBuilder setAdjustment(NotionalAdjustmentEnum var1);

        public TradableProductBuilder addAncillaryParty(AncillaryParty var1);

        public TradableProductBuilder addAncillaryParty(AncillaryParty var1, int var2);

        public TradableProductBuilder addAncillaryParty(List<? extends AncillaryParty> var1);

        public TradableProductBuilder setAncillaryParty(List<? extends AncillaryParty> var1);

        public TradableProductBuilder addCounterparty(Counterparty var1);

        public TradableProductBuilder addCounterparty(Counterparty var1, int var2);

        public TradableProductBuilder addCounterparty(List<? extends Counterparty> var1);

        public TradableProductBuilder setCounterparty(List<? extends Counterparty> var1);

        public TradableProductBuilder setProduct(Product var1);

        public TradableProductBuilder addTradeLot(TradeLot var1);

        public TradableProductBuilder addTradeLot(TradeLot var1, int var2);

        public TradableProductBuilder addTradeLot(List<? extends TradeLot> var1);

        public TradableProductBuilder setTradeLot(List<? extends TradeLot> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("adjustment"), NotionalAdjustmentEnum.class, (Object)this.getAdjustment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("ancillaryParty"), processor, AncillaryParty.AncillaryPartyBuilder.class, this.getAncillaryParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("counterparty"), processor, Counterparty.CounterpartyBuilder.class, this.getCounterparty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("product"), processor, Product.ProductBuilder.class, this.getProduct(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeLot"), processor, TradeLot.TradeLotBuilder.class, this.getTradeLot(), new AttributeMeta[0]);
        }

        public TradableProductBuilder prune();
    }
}

