/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.staticdata.party.PayerReceiverEnum;
import cdm.product.template.meta.StrikeMeta;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface Strike
extends RosettaModelObject,
GlobalKey {
    public static final StrikeMeta metaData = new StrikeMeta();

    public Strike build();

    public StrikeBuilder toBuilder();

    public PayerReceiverEnum getBuyer();

    public MetaFields getMeta();

    public PayerReceiverEnum getSeller();

    public BigDecimal getStrikeRate();

    default public RosettaMetaData<? extends Strike> metaData() {
        return metaData;
    }

    public static StrikeBuilder builder() {
        return new StrikeBuilderImpl();
    }

    default public Class<? extends Strike> getType() {
        return Strike.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("buyer"), PayerReceiverEnum.class, (Object)this.getBuyer(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("seller"), PayerReceiverEnum.class, (Object)this.getSeller(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("strikeRate"), BigDecimal.class, (Object)this.getStrikeRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
    }

    public static class StrikeBuilderImpl
    implements StrikeBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected PayerReceiverEnum buyer;
        protected MetaFields.MetaFieldsBuilder meta;
        protected PayerReceiverEnum seller;
        protected BigDecimal strikeRate;

        @Override
        public PayerReceiverEnum getBuyer() {
            return this.buyer;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public PayerReceiverEnum getSeller() {
            return this.seller;
        }

        @Override
        public BigDecimal getStrikeRate() {
            return this.strikeRate;
        }

        @Override
        public StrikeBuilder setBuyer(PayerReceiverEnum buyer) {
            this.buyer = buyer == null ? null : buyer;
            return this;
        }

        @Override
        public StrikeBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public StrikeBuilder setSeller(PayerReceiverEnum seller) {
            this.seller = seller == null ? null : seller;
            return this;
        }

        @Override
        public StrikeBuilder setStrikeRate(BigDecimal strikeRate) {
            this.strikeRate = strikeRate == null ? null : strikeRate;
            return this;
        }

        @Override
        public Strike build() {
            return new StrikeImpl(this);
        }

        @Override
        public StrikeBuilder toBuilder() {
            return this;
        }

        @Override
        public StrikeBuilder prune() {
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getBuyer() != null) {
                return true;
            }
            if (this.getSeller() != null) {
                return true;
            }
            return this.getStrikeRate() != null;
        }

        public StrikeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            StrikeBuilder o = (StrikeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeBasic((Object)this.getBuyer(), (Object)o.getBuyer(), this::setBuyer, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSeller(), (Object)o.getSeller(), this::setSeller, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getStrikeRate(), (Object)o.getStrikeRate(), this::setStrikeRate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Strike _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.buyer, (Object)_that.getBuyer())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals((Object)this.seller, (Object)_that.getSeller())) {
                return false;
            }
            return Objects.equals(this.strikeRate, _that.getStrikeRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.buyer != null ? ((Object)((Object)this.buyer)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.seller != null ? ((Object)((Object)this.seller)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.strikeRate != null ? this.strikeRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "StrikeBuilder {buyer=" + (Object)((Object)this.buyer) + ", meta=" + this.meta + ", seller=" + (Object)((Object)this.seller) + ", strikeRate=" + this.strikeRate + '}';
        }
    }

    public static class StrikeImpl
    implements Strike {
        private final PayerReceiverEnum buyer;
        private final MetaFields meta;
        private final PayerReceiverEnum seller;
        private final BigDecimal strikeRate;

        protected StrikeImpl(StrikeBuilder builder) {
            this.buyer = builder.getBuyer();
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
            this.seller = builder.getSeller();
            this.strikeRate = builder.getStrikeRate();
        }

        @Override
        public PayerReceiverEnum getBuyer() {
            return this.buyer;
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public PayerReceiverEnum getSeller() {
            return this.seller;
        }

        @Override
        public BigDecimal getStrikeRate() {
            return this.strikeRate;
        }

        @Override
        public Strike build() {
            return this;
        }

        @Override
        public StrikeBuilder toBuilder() {
            StrikeBuilder builder = Strike.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(StrikeBuilder builder) {
            Optional.ofNullable(this.getBuyer()).ifPresent(builder::setBuyer);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
            Optional.ofNullable(this.getSeller()).ifPresent(builder::setSeller);
            Optional.ofNullable(this.getStrikeRate()).ifPresent(builder::setStrikeRate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Strike _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.buyer, (Object)_that.getBuyer())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals((Object)this.seller, (Object)_that.getSeller())) {
                return false;
            }
            return Objects.equals(this.strikeRate, _that.getStrikeRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.buyer != null ? ((Object)((Object)this.buyer)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.seller != null ? ((Object)((Object)this.seller)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.strikeRate != null ? this.strikeRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Strike {buyer=" + (Object)((Object)this.buyer) + ", meta=" + this.meta + ", seller=" + (Object)((Object)this.seller) + ", strikeRate=" + this.strikeRate + '}';
        }
    }

    public static interface StrikeBuilder
    extends Strike,
    RosettaModelObjectBuilder {
        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public StrikeBuilder setBuyer(PayerReceiverEnum var1);

        public StrikeBuilder setMeta(MetaFields var1);

        public StrikeBuilder setSeller(PayerReceiverEnum var1);

        public StrikeBuilder setStrikeRate(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("buyer"), PayerReceiverEnum.class, (Object)this.getBuyer(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("seller"), PayerReceiverEnum.class, (Object)this.getSeller(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("strikeRate"), BigDecimal.class, (Object)this.getStrikeRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
        }

        public StrikeBuilder prune();
    }
}

