/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.datetime.DateRange;
import cdm.product.template.meta.SchedulePeriodMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface SchedulePeriod
extends RosettaModelObject {
    public static final SchedulePeriodMeta metaData = new SchedulePeriodMeta();

    public SchedulePeriod build();

    public SchedulePeriodBuilder toBuilder();

    public DateRange getCalculationPeriod();

    public DateRange getFixingPeriod();

    public Date getPaymentDate();

    default public RosettaMetaData<? extends SchedulePeriod> metaData() {
        return metaData;
    }

    public static SchedulePeriodBuilder builder() {
        return new SchedulePeriodBuilderImpl();
    }

    default public Class<? extends SchedulePeriod> getType() {
        return SchedulePeriod.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("paymentDate"), Date.class, (Object)this.getPaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("calculationPeriod"), processor, DateRange.class, this.getCalculationPeriod(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixingPeriod"), processor, DateRange.class, this.getFixingPeriod(), new AttributeMeta[0]);
    }

    public static class SchedulePeriodBuilderImpl
    implements SchedulePeriodBuilder {
        protected DateRange.DateRangeBuilder calculationPeriod;
        protected DateRange.DateRangeBuilder fixingPeriod;
        protected Date paymentDate;

        @Override
        public DateRange.DateRangeBuilder getCalculationPeriod() {
            return this.calculationPeriod;
        }

        @Override
        public DateRange.DateRangeBuilder getOrCreateCalculationPeriod() {
            DateRange.DateRangeBuilder result = this.calculationPeriod != null ? this.calculationPeriod : (this.calculationPeriod = DateRange.builder());
            return result;
        }

        @Override
        public DateRange.DateRangeBuilder getFixingPeriod() {
            return this.fixingPeriod;
        }

        @Override
        public DateRange.DateRangeBuilder getOrCreateFixingPeriod() {
            DateRange.DateRangeBuilder result = this.fixingPeriod != null ? this.fixingPeriod : (this.fixingPeriod = DateRange.builder());
            return result;
        }

        @Override
        public Date getPaymentDate() {
            return this.paymentDate;
        }

        @Override
        public SchedulePeriodBuilder setCalculationPeriod(DateRange calculationPeriod) {
            this.calculationPeriod = calculationPeriod == null ? null : calculationPeriod.toBuilder();
            return this;
        }

        @Override
        public SchedulePeriodBuilder setFixingPeriod(DateRange fixingPeriod) {
            this.fixingPeriod = fixingPeriod == null ? null : fixingPeriod.toBuilder();
            return this;
        }

        @Override
        public SchedulePeriodBuilder setPaymentDate(Date paymentDate) {
            this.paymentDate = paymentDate == null ? null : paymentDate;
            return this;
        }

        @Override
        public SchedulePeriod build() {
            return new SchedulePeriodImpl(this);
        }

        @Override
        public SchedulePeriodBuilder toBuilder() {
            return this;
        }

        @Override
        public SchedulePeriodBuilder prune() {
            if (this.calculationPeriod != null && !this.calculationPeriod.prune().hasData()) {
                this.calculationPeriod = null;
            }
            if (this.fixingPeriod != null && !this.fixingPeriod.prune().hasData()) {
                this.fixingPeriod = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCalculationPeriod() != null && this.getCalculationPeriod().hasData()) {
                return true;
            }
            if (this.getFixingPeriod() != null && this.getFixingPeriod().hasData()) {
                return true;
            }
            return this.getPaymentDate() != null;
        }

        public SchedulePeriodBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            SchedulePeriodBuilder o = (SchedulePeriodBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCalculationPeriod(), (RosettaModelObjectBuilder)o.getCalculationPeriod(), this::setCalculationPeriod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixingPeriod(), (RosettaModelObjectBuilder)o.getFixingPeriod(), this::setFixingPeriod);
            merger.mergeBasic((Object)this.getPaymentDate(), (Object)o.getPaymentDate(), this::setPaymentDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SchedulePeriod _that = this.getType().cast(o);
            if (!Objects.equals(this.calculationPeriod, _that.getCalculationPeriod())) {
                return false;
            }
            if (!Objects.equals(this.fixingPeriod, _that.getFixingPeriod())) {
                return false;
            }
            return Objects.equals(this.paymentDate, _that.getPaymentDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.calculationPeriod != null ? this.calculationPeriod.hashCode() : 0);
            _result = 31 * _result + (this.fixingPeriod != null ? this.fixingPeriod.hashCode() : 0);
            _result = 31 * _result + (this.paymentDate != null ? this.paymentDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SchedulePeriodBuilder {calculationPeriod=" + this.calculationPeriod + ", fixingPeriod=" + this.fixingPeriod + ", paymentDate=" + this.paymentDate + '}';
        }
    }

    public static class SchedulePeriodImpl
    implements SchedulePeriod {
        private final DateRange calculationPeriod;
        private final DateRange fixingPeriod;
        private final Date paymentDate;

        protected SchedulePeriodImpl(SchedulePeriodBuilder builder) {
            this.calculationPeriod = Optional.ofNullable(builder.getCalculationPeriod()).map(f -> f.build()).orElse(null);
            this.fixingPeriod = Optional.ofNullable(builder.getFixingPeriod()).map(f -> f.build()).orElse(null);
            this.paymentDate = builder.getPaymentDate();
        }

        @Override
        public DateRange getCalculationPeriod() {
            return this.calculationPeriod;
        }

        @Override
        public DateRange getFixingPeriod() {
            return this.fixingPeriod;
        }

        @Override
        public Date getPaymentDate() {
            return this.paymentDate;
        }

        @Override
        public SchedulePeriod build() {
            return this;
        }

        @Override
        public SchedulePeriodBuilder toBuilder() {
            SchedulePeriodBuilder builder = SchedulePeriod.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SchedulePeriodBuilder builder) {
            Optional.ofNullable(this.getCalculationPeriod()).ifPresent(builder::setCalculationPeriod);
            Optional.ofNullable(this.getFixingPeriod()).ifPresent(builder::setFixingPeriod);
            Optional.ofNullable(this.getPaymentDate()).ifPresent(builder::setPaymentDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SchedulePeriod _that = this.getType().cast(o);
            if (!Objects.equals(this.calculationPeriod, _that.getCalculationPeriod())) {
                return false;
            }
            if (!Objects.equals(this.fixingPeriod, _that.getFixingPeriod())) {
                return false;
            }
            return Objects.equals(this.paymentDate, _that.getPaymentDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.calculationPeriod != null ? this.calculationPeriod.hashCode() : 0);
            _result = 31 * _result + (this.fixingPeriod != null ? this.fixingPeriod.hashCode() : 0);
            _result = 31 * _result + (this.paymentDate != null ? this.paymentDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SchedulePeriod {calculationPeriod=" + this.calculationPeriod + ", fixingPeriod=" + this.fixingPeriod + ", paymentDate=" + this.paymentDate + '}';
        }
    }

    public static interface SchedulePeriodBuilder
    extends SchedulePeriod,
    RosettaModelObjectBuilder {
        public DateRange.DateRangeBuilder getOrCreateCalculationPeriod();

        @Override
        public DateRange.DateRangeBuilder getCalculationPeriod();

        public DateRange.DateRangeBuilder getOrCreateFixingPeriod();

        @Override
        public DateRange.DateRangeBuilder getFixingPeriod();

        public SchedulePeriodBuilder setCalculationPeriod(DateRange var1);

        public SchedulePeriodBuilder setFixingPeriod(DateRange var1);

        public SchedulePeriodBuilder setPaymentDate(Date var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("paymentDate"), Date.class, (Object)this.getPaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("calculationPeriod"), processor, DateRange.DateRangeBuilder.class, this.getCalculationPeriod(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixingPeriod"), processor, DateRange.DateRangeBuilder.class, this.getFixingPeriod(), new AttributeMeta[0]);
        }

        public SchedulePeriodBuilder prune();
    }
}

