/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.datetime.BusinessCenterTime;
import cdm.observable.asset.FxRate;
import cdm.observable.asset.FxSpotRateSource;
import cdm.product.template.meta.QuantoMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface Quanto
extends RosettaModelObject {
    public static final QuantoMeta metaData = new QuantoMeta();

    public Quanto build();

    public QuantoBuilder toBuilder();

    public BusinessCenterTime getFixingTime();

    public List<? extends FxRate> getFxRate();

    public FxSpotRateSource getFxSpotRateSource();

    default public RosettaMetaData<? extends Quanto> metaData() {
        return metaData;
    }

    public static QuantoBuilder builder() {
        return new QuantoBuilderImpl();
    }

    default public Class<? extends Quanto> getType() {
        return Quanto.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("fixingTime"), processor, BusinessCenterTime.class, this.getFixingTime(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxRate"), processor, FxRate.class, this.getFxRate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxSpotRateSource"), processor, FxSpotRateSource.class, this.getFxSpotRateSource(), new AttributeMeta[0]);
    }

    public static class QuantoBuilderImpl
    implements QuantoBuilder {
        protected BusinessCenterTime.BusinessCenterTimeBuilder fixingTime;
        protected List<FxRate.FxRateBuilder> fxRate = new ArrayList<FxRate.FxRateBuilder>();
        protected FxSpotRateSource.FxSpotRateSourceBuilder fxSpotRateSource;

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getFixingTime() {
            return this.fixingTime;
        }

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateFixingTime() {
            BusinessCenterTime.BusinessCenterTimeBuilder result = this.fixingTime != null ? this.fixingTime : (this.fixingTime = BusinessCenterTime.builder());
            return result;
        }

        @Override
        public List<? extends FxRate.FxRateBuilder> getFxRate() {
            return this.fxRate;
        }

        @Override
        public FxRate.FxRateBuilder getOrCreateFxRate(int _index) {
            if (this.fxRate == null) {
                this.fxRate = new ArrayList<FxRate.FxRateBuilder>();
            }
            return (FxRate.FxRateBuilder)this.getIndex(this.fxRate, _index, () -> {
                FxRate.FxRateBuilder newFxRate = FxRate.builder();
                return newFxRate;
            });
        }

        @Override
        public FxSpotRateSource.FxSpotRateSourceBuilder getFxSpotRateSource() {
            return this.fxSpotRateSource;
        }

        @Override
        public FxSpotRateSource.FxSpotRateSourceBuilder getOrCreateFxSpotRateSource() {
            FxSpotRateSource.FxSpotRateSourceBuilder result = this.fxSpotRateSource != null ? this.fxSpotRateSource : (this.fxSpotRateSource = FxSpotRateSource.builder());
            return result;
        }

        @Override
        public QuantoBuilder setFixingTime(BusinessCenterTime fixingTime) {
            this.fixingTime = fixingTime == null ? null : fixingTime.toBuilder();
            return this;
        }

        @Override
        public QuantoBuilder addFxRate(FxRate fxRate) {
            if (fxRate != null) {
                this.fxRate.add(fxRate.toBuilder());
            }
            return this;
        }

        @Override
        public QuantoBuilder addFxRate(FxRate fxRate, int _idx) {
            this.getIndex(this.fxRate, _idx, () -> fxRate.toBuilder());
            return this;
        }

        @Override
        public QuantoBuilder addFxRate(List<? extends FxRate> fxRates) {
            if (fxRates != null) {
                for (FxRate fxRate : fxRates) {
                    this.fxRate.add(fxRate.toBuilder());
                }
            }
            return this;
        }

        @Override
        public QuantoBuilder setFxRate(List<? extends FxRate> fxRates) {
            this.fxRate = fxRates == null ? new ArrayList<FxRate.FxRateBuilder>() : (List)fxRates.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public QuantoBuilder setFxSpotRateSource(FxSpotRateSource fxSpotRateSource) {
            this.fxSpotRateSource = fxSpotRateSource == null ? null : fxSpotRateSource.toBuilder();
            return this;
        }

        @Override
        public Quanto build() {
            return new QuantoImpl(this);
        }

        @Override
        public QuantoBuilder toBuilder() {
            return this;
        }

        @Override
        public QuantoBuilder prune() {
            if (this.fixingTime != null && !this.fixingTime.prune().hasData()) {
                this.fixingTime = null;
            }
            this.fxRate = this.fxRate.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.fxSpotRateSource != null && !this.fxSpotRateSource.prune().hasData()) {
                this.fxSpotRateSource = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getFixingTime() != null && this.getFixingTime().hasData()) {
                return true;
            }
            if (this.getFxRate() != null && this.getFxRate().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getFxSpotRateSource() != null && this.getFxSpotRateSource().hasData();
        }

        public QuantoBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            QuantoBuilder o = (QuantoBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixingTime(), (RosettaModelObjectBuilder)o.getFixingTime(), this::setFixingTime);
            merger.mergeRosetta(this.getFxRate(), o.getFxRate(), this::getOrCreateFxRate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxSpotRateSource(), (RosettaModelObjectBuilder)o.getFxSpotRateSource(), this::setFxSpotRateSource);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Quanto _that = this.getType().cast(o);
            if (!Objects.equals(this.fixingTime, _that.getFixingTime())) {
                return false;
            }
            if (!ListEquals.listEquals(this.fxRate, _that.getFxRate())) {
                return false;
            }
            return Objects.equals(this.fxSpotRateSource, _that.getFxSpotRateSource());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.fixingTime != null ? this.fixingTime.hashCode() : 0);
            _result = 31 * _result + (this.fxRate != null ? this.fxRate.hashCode() : 0);
            _result = 31 * _result + (this.fxSpotRateSource != null ? this.fxSpotRateSource.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "QuantoBuilder {fixingTime=" + this.fixingTime + ", fxRate=" + this.fxRate + ", fxSpotRateSource=" + this.fxSpotRateSource + '}';
        }
    }

    public static class QuantoImpl
    implements Quanto {
        private final BusinessCenterTime fixingTime;
        private final List<? extends FxRate> fxRate;
        private final FxSpotRateSource fxSpotRateSource;

        protected QuantoImpl(QuantoBuilder builder) {
            this.fixingTime = Optional.ofNullable(builder.getFixingTime()).map(f -> f.build()).orElse(null);
            this.fxRate = Optional.ofNullable(builder.getFxRate()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.fxSpotRateSource = Optional.ofNullable(builder.getFxSpotRateSource()).map(f -> f.build()).orElse(null);
        }

        @Override
        public BusinessCenterTime getFixingTime() {
            return this.fixingTime;
        }

        @Override
        public List<? extends FxRate> getFxRate() {
            return this.fxRate;
        }

        @Override
        public FxSpotRateSource getFxSpotRateSource() {
            return this.fxSpotRateSource;
        }

        @Override
        public Quanto build() {
            return this;
        }

        @Override
        public QuantoBuilder toBuilder() {
            QuantoBuilder builder = Quanto.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(QuantoBuilder builder) {
            Optional.ofNullable(this.getFixingTime()).ifPresent(builder::setFixingTime);
            Optional.ofNullable(this.getFxRate()).ifPresent(builder::setFxRate);
            Optional.ofNullable(this.getFxSpotRateSource()).ifPresent(builder::setFxSpotRateSource);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Quanto _that = this.getType().cast(o);
            if (!Objects.equals(this.fixingTime, _that.getFixingTime())) {
                return false;
            }
            if (!ListEquals.listEquals(this.fxRate, _that.getFxRate())) {
                return false;
            }
            return Objects.equals(this.fxSpotRateSource, _that.getFxSpotRateSource());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.fixingTime != null ? this.fixingTime.hashCode() : 0);
            _result = 31 * _result + (this.fxRate != null ? this.fxRate.hashCode() : 0);
            _result = 31 * _result + (this.fxSpotRateSource != null ? this.fxSpotRateSource.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Quanto {fixingTime=" + this.fixingTime + ", fxRate=" + this.fxRate + ", fxSpotRateSource=" + this.fxSpotRateSource + '}';
        }
    }

    public static interface QuantoBuilder
    extends Quanto,
    RosettaModelObjectBuilder {
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateFixingTime();

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getFixingTime();

        public FxRate.FxRateBuilder getOrCreateFxRate(int var1);

        public List<? extends FxRate.FxRateBuilder> getFxRate();

        public FxSpotRateSource.FxSpotRateSourceBuilder getOrCreateFxSpotRateSource();

        @Override
        public FxSpotRateSource.FxSpotRateSourceBuilder getFxSpotRateSource();

        public QuantoBuilder setFixingTime(BusinessCenterTime var1);

        public QuantoBuilder addFxRate(FxRate var1);

        public QuantoBuilder addFxRate(FxRate var1, int var2);

        public QuantoBuilder addFxRate(List<? extends FxRate> var1);

        public QuantoBuilder setFxRate(List<? extends FxRate> var1);

        public QuantoBuilder setFxSpotRateSource(FxSpotRateSource var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("fixingTime"), processor, BusinessCenterTime.BusinessCenterTimeBuilder.class, this.getFixingTime(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxRate"), processor, FxRate.FxRateBuilder.class, this.getFxRate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxSpotRateSource"), processor, FxSpotRateSource.FxSpotRateSourceBuilder.class, this.getFxSpotRateSource(), new AttributeMeta[0]);
        }

        public QuantoBuilder prune();
    }
}

