/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.observable.asset.Price;
import cdm.observable.asset.ReferenceSwapCurve;
import cdm.product.asset.FixedRateSpecification;
import cdm.product.asset.metafields.ReferenceWithMetaFixedRateSpecification;
import cdm.product.template.AveragingStrikeFeature;
import cdm.product.template.meta.OptionStrikeMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface OptionStrike
extends RosettaModelObject {
    public static final OptionStrikeMeta metaData = new OptionStrikeMeta();

    public OptionStrike build();

    public OptionStrikeBuilder toBuilder();

    public AveragingStrikeFeature getAveragingStrikeFeature();

    public ReferenceSwapCurve getReferenceSwapCurve();

    public Price getStrikePrice();

    public ReferenceWithMetaFixedRateSpecification getStrikeReference();

    default public RosettaMetaData<? extends OptionStrike> metaData() {
        return metaData;
    }

    public static OptionStrikeBuilder builder() {
        return new OptionStrikeBuilderImpl();
    }

    default public Class<? extends OptionStrike> getType() {
        return OptionStrike.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("averagingStrikeFeature"), processor, AveragingStrikeFeature.class, this.getAveragingStrikeFeature(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("referenceSwapCurve"), processor, ReferenceSwapCurve.class, this.getReferenceSwapCurve(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikePrice"), processor, Price.class, this.getStrikePrice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikeReference"), processor, ReferenceWithMetaFixedRateSpecification.class, this.getStrikeReference(), new AttributeMeta[0]);
    }

    public static class OptionStrikeBuilderImpl
    implements OptionStrikeBuilder {
        protected AveragingStrikeFeature.AveragingStrikeFeatureBuilder averagingStrikeFeature;
        protected ReferenceSwapCurve.ReferenceSwapCurveBuilder referenceSwapCurve;
        protected Price.PriceBuilder strikePrice;
        protected ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder strikeReference;

        @Override
        public AveragingStrikeFeature.AveragingStrikeFeatureBuilder getAveragingStrikeFeature() {
            return this.averagingStrikeFeature;
        }

        @Override
        public AveragingStrikeFeature.AveragingStrikeFeatureBuilder getOrCreateAveragingStrikeFeature() {
            AveragingStrikeFeature.AveragingStrikeFeatureBuilder result = this.averagingStrikeFeature != null ? this.averagingStrikeFeature : (this.averagingStrikeFeature = AveragingStrikeFeature.builder());
            return result;
        }

        @Override
        public ReferenceSwapCurve.ReferenceSwapCurveBuilder getReferenceSwapCurve() {
            return this.referenceSwapCurve;
        }

        @Override
        public ReferenceSwapCurve.ReferenceSwapCurveBuilder getOrCreateReferenceSwapCurve() {
            ReferenceSwapCurve.ReferenceSwapCurveBuilder result = this.referenceSwapCurve != null ? this.referenceSwapCurve : (this.referenceSwapCurve = ReferenceSwapCurve.builder());
            return result;
        }

        @Override
        public Price.PriceBuilder getStrikePrice() {
            return this.strikePrice;
        }

        @Override
        public Price.PriceBuilder getOrCreateStrikePrice() {
            Price.PriceBuilder result = this.strikePrice != null ? this.strikePrice : (this.strikePrice = Price.builder());
            return result;
        }

        @Override
        public ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder getStrikeReference() {
            return this.strikeReference;
        }

        @Override
        public ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder getOrCreateStrikeReference() {
            ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder result = this.strikeReference != null ? this.strikeReference : (this.strikeReference = ReferenceWithMetaFixedRateSpecification.builder());
            return result;
        }

        @Override
        public OptionStrikeBuilder setAveragingStrikeFeature(AveragingStrikeFeature averagingStrikeFeature) {
            this.averagingStrikeFeature = averagingStrikeFeature == null ? null : averagingStrikeFeature.toBuilder();
            return this;
        }

        @Override
        public OptionStrikeBuilder setReferenceSwapCurve(ReferenceSwapCurve referenceSwapCurve) {
            this.referenceSwapCurve = referenceSwapCurve == null ? null : referenceSwapCurve.toBuilder();
            return this;
        }

        @Override
        public OptionStrikeBuilder setStrikePrice(Price strikePrice) {
            this.strikePrice = strikePrice == null ? null : strikePrice.toBuilder();
            return this;
        }

        @Override
        public OptionStrikeBuilder setStrikeReference(ReferenceWithMetaFixedRateSpecification strikeReference) {
            this.strikeReference = strikeReference == null ? null : strikeReference.toBuilder();
            return this;
        }

        @Override
        public OptionStrikeBuilder setStrikeReferenceValue(FixedRateSpecification strikeReference) {
            this.getOrCreateStrikeReference().setValue(strikeReference);
            return this;
        }

        @Override
        public OptionStrike build() {
            return new OptionStrikeImpl(this);
        }

        @Override
        public OptionStrikeBuilder toBuilder() {
            return this;
        }

        @Override
        public OptionStrikeBuilder prune() {
            if (this.averagingStrikeFeature != null && !this.averagingStrikeFeature.prune().hasData()) {
                this.averagingStrikeFeature = null;
            }
            if (this.referenceSwapCurve != null && !this.referenceSwapCurve.prune().hasData()) {
                this.referenceSwapCurve = null;
            }
            if (this.strikePrice != null && !this.strikePrice.prune().hasData()) {
                this.strikePrice = null;
            }
            if (this.strikeReference != null && !this.strikeReference.prune().hasData()) {
                this.strikeReference = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAveragingStrikeFeature() != null && this.getAveragingStrikeFeature().hasData()) {
                return true;
            }
            if (this.getReferenceSwapCurve() != null && this.getReferenceSwapCurve().hasData()) {
                return true;
            }
            if (this.getStrikePrice() != null && this.getStrikePrice().hasData()) {
                return true;
            }
            return this.getStrikeReference() != null && this.getStrikeReference().hasData();
        }

        public OptionStrikeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            OptionStrikeBuilder o = (OptionStrikeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAveragingStrikeFeature(), (RosettaModelObjectBuilder)o.getAveragingStrikeFeature(), this::setAveragingStrikeFeature);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReferenceSwapCurve(), (RosettaModelObjectBuilder)o.getReferenceSwapCurve(), this::setReferenceSwapCurve);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStrikePrice(), (RosettaModelObjectBuilder)o.getStrikePrice(), this::setStrikePrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStrikeReference(), (RosettaModelObjectBuilder)o.getStrikeReference(), this::setStrikeReference);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            OptionStrike _that = this.getType().cast(o);
            if (!Objects.equals(this.averagingStrikeFeature, _that.getAveragingStrikeFeature())) {
                return false;
            }
            if (!Objects.equals(this.referenceSwapCurve, _that.getReferenceSwapCurve())) {
                return false;
            }
            if (!Objects.equals(this.strikePrice, _that.getStrikePrice())) {
                return false;
            }
            return Objects.equals(this.strikeReference, _that.getStrikeReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.averagingStrikeFeature != null ? this.averagingStrikeFeature.hashCode() : 0);
            _result = 31 * _result + (this.referenceSwapCurve != null ? this.referenceSwapCurve.hashCode() : 0);
            _result = 31 * _result + (this.strikePrice != null ? this.strikePrice.hashCode() : 0);
            _result = 31 * _result + (this.strikeReference != null ? this.strikeReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "OptionStrikeBuilder {averagingStrikeFeature=" + this.averagingStrikeFeature + ", referenceSwapCurve=" + this.referenceSwapCurve + ", strikePrice=" + this.strikePrice + ", strikeReference=" + this.strikeReference + '}';
        }
    }

    public static class OptionStrikeImpl
    implements OptionStrike {
        private final AveragingStrikeFeature averagingStrikeFeature;
        private final ReferenceSwapCurve referenceSwapCurve;
        private final Price strikePrice;
        private final ReferenceWithMetaFixedRateSpecification strikeReference;

        protected OptionStrikeImpl(OptionStrikeBuilder builder) {
            this.averagingStrikeFeature = Optional.ofNullable(builder.getAveragingStrikeFeature()).map(f -> f.build()).orElse(null);
            this.referenceSwapCurve = Optional.ofNullable(builder.getReferenceSwapCurve()).map(f -> f.build()).orElse(null);
            this.strikePrice = Optional.ofNullable(builder.getStrikePrice()).map(f -> f.build()).orElse(null);
            this.strikeReference = Optional.ofNullable(builder.getStrikeReference()).map(f -> f.build()).orElse(null);
        }

        @Override
        public AveragingStrikeFeature getAveragingStrikeFeature() {
            return this.averagingStrikeFeature;
        }

        @Override
        public ReferenceSwapCurve getReferenceSwapCurve() {
            return this.referenceSwapCurve;
        }

        @Override
        public Price getStrikePrice() {
            return this.strikePrice;
        }

        @Override
        public ReferenceWithMetaFixedRateSpecification getStrikeReference() {
            return this.strikeReference;
        }

        @Override
        public OptionStrike build() {
            return this;
        }

        @Override
        public OptionStrikeBuilder toBuilder() {
            OptionStrikeBuilder builder = OptionStrike.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(OptionStrikeBuilder builder) {
            Optional.ofNullable(this.getAveragingStrikeFeature()).ifPresent(builder::setAveragingStrikeFeature);
            Optional.ofNullable(this.getReferenceSwapCurve()).ifPresent(builder::setReferenceSwapCurve);
            Optional.ofNullable(this.getStrikePrice()).ifPresent(builder::setStrikePrice);
            Optional.ofNullable(this.getStrikeReference()).ifPresent(builder::setStrikeReference);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            OptionStrike _that = this.getType().cast(o);
            if (!Objects.equals(this.averagingStrikeFeature, _that.getAveragingStrikeFeature())) {
                return false;
            }
            if (!Objects.equals(this.referenceSwapCurve, _that.getReferenceSwapCurve())) {
                return false;
            }
            if (!Objects.equals(this.strikePrice, _that.getStrikePrice())) {
                return false;
            }
            return Objects.equals(this.strikeReference, _that.getStrikeReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.averagingStrikeFeature != null ? this.averagingStrikeFeature.hashCode() : 0);
            _result = 31 * _result + (this.referenceSwapCurve != null ? this.referenceSwapCurve.hashCode() : 0);
            _result = 31 * _result + (this.strikePrice != null ? this.strikePrice.hashCode() : 0);
            _result = 31 * _result + (this.strikeReference != null ? this.strikeReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "OptionStrike {averagingStrikeFeature=" + this.averagingStrikeFeature + ", referenceSwapCurve=" + this.referenceSwapCurve + ", strikePrice=" + this.strikePrice + ", strikeReference=" + this.strikeReference + '}';
        }
    }

    public static interface OptionStrikeBuilder
    extends OptionStrike,
    RosettaModelObjectBuilder {
        public AveragingStrikeFeature.AveragingStrikeFeatureBuilder getOrCreateAveragingStrikeFeature();

        @Override
        public AveragingStrikeFeature.AveragingStrikeFeatureBuilder getAveragingStrikeFeature();

        public ReferenceSwapCurve.ReferenceSwapCurveBuilder getOrCreateReferenceSwapCurve();

        @Override
        public ReferenceSwapCurve.ReferenceSwapCurveBuilder getReferenceSwapCurve();

        public Price.PriceBuilder getOrCreateStrikePrice();

        @Override
        public Price.PriceBuilder getStrikePrice();

        public ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder getOrCreateStrikeReference();

        @Override
        public ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder getStrikeReference();

        public OptionStrikeBuilder setAveragingStrikeFeature(AveragingStrikeFeature var1);

        public OptionStrikeBuilder setReferenceSwapCurve(ReferenceSwapCurve var1);

        public OptionStrikeBuilder setStrikePrice(Price var1);

        public OptionStrikeBuilder setStrikeReference(ReferenceWithMetaFixedRateSpecification var1);

        public OptionStrikeBuilder setStrikeReferenceValue(FixedRateSpecification var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("averagingStrikeFeature"), processor, AveragingStrikeFeature.AveragingStrikeFeatureBuilder.class, this.getAveragingStrikeFeature(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("referenceSwapCurve"), processor, ReferenceSwapCurve.ReferenceSwapCurveBuilder.class, this.getReferenceSwapCurve(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikePrice"), processor, Price.PriceBuilder.class, this.getStrikePrice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikeReference"), processor, ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder.class, this.getStrikeReference(), new AttributeMeta[0]);
        }

        public OptionStrikeBuilder prune();
    }
}

