/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.staticdata.party.BuyerSeller;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.product.common.schedule.ObservationTerms;
import cdm.product.common.settlement.PayoutBase;
import cdm.product.common.settlement.PrincipalPayments;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.template.CommoditySchedule;
import cdm.product.template.OptionExercise;
import cdm.product.template.OptionFeature;
import cdm.product.template.OptionTypeEnum;
import cdm.product.template.Product;
import cdm.product.template.meta.OptionPayoutMeta;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface OptionPayout
extends PayoutBase,
GlobalKey {
    public static final OptionPayoutMeta metaData = new OptionPayoutMeta();

    @Override
    public OptionPayout build();

    @Override
    public OptionPayoutBuilder toBuilder();

    public BuyerSeller getBuyerSeller();

    public OptionExercise getExerciseTerms();

    public OptionFeature getFeature();

    public MetaFields getMeta();

    public ObservationTerms getObservationTerms();

    public OptionTypeEnum getOptionType();

    public CommoditySchedule getSchedule();

    public Product getUnderlier();

    default public RosettaMetaData<? extends OptionPayout> metaData() {
        return metaData;
    }

    public static OptionPayoutBuilder builder() {
        return new OptionPayoutBuilderImpl();
    }

    default public Class<? extends OptionPayout> getType() {
        return OptionPayout.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        PayoutBase.super.process(path, processor);
        processor.processBasic(path.newSubPath("optionType"), OptionTypeEnum.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSeller"), processor, BuyerSeller.class, this.getBuyerSeller(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseTerms"), processor, OptionExercise.class, this.getExerciseTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("feature"), processor, OptionFeature.class, this.getFeature(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("observationTerms"), processor, ObservationTerms.class, this.getObservationTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("schedule"), processor, CommoditySchedule.class, this.getSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlier"), processor, Product.class, this.getUnderlier(), new AttributeMeta[0]);
    }

    public static class OptionPayoutBuilderImpl
    extends PayoutBase.PayoutBaseBuilderImpl
    implements OptionPayoutBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected BuyerSeller.BuyerSellerBuilder buyerSeller;
        protected OptionExercise.OptionExerciseBuilder exerciseTerms;
        protected OptionFeature.OptionFeatureBuilder feature;
        protected MetaFields.MetaFieldsBuilder meta;
        protected ObservationTerms.ObservationTermsBuilder observationTerms;
        protected OptionTypeEnum optionType;
        protected CommoditySchedule.CommodityScheduleBuilder schedule;
        protected Product.ProductBuilder underlier;

        @Override
        public BuyerSeller.BuyerSellerBuilder getBuyerSeller() {
            return this.buyerSeller;
        }

        @Override
        public BuyerSeller.BuyerSellerBuilder getOrCreateBuyerSeller() {
            BuyerSeller.BuyerSellerBuilder result = this.buyerSeller != null ? this.buyerSeller : (this.buyerSeller = BuyerSeller.builder());
            return result;
        }

        @Override
        public OptionExercise.OptionExerciseBuilder getExerciseTerms() {
            return this.exerciseTerms;
        }

        @Override
        public OptionExercise.OptionExerciseBuilder getOrCreateExerciseTerms() {
            OptionExercise.OptionExerciseBuilder result = this.exerciseTerms != null ? this.exerciseTerms : (this.exerciseTerms = OptionExercise.builder());
            return result;
        }

        @Override
        public OptionFeature.OptionFeatureBuilder getFeature() {
            return this.feature;
        }

        @Override
        public OptionFeature.OptionFeatureBuilder getOrCreateFeature() {
            OptionFeature.OptionFeatureBuilder result = this.feature != null ? this.feature : (this.feature = OptionFeature.builder());
            return result;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public ObservationTerms.ObservationTermsBuilder getObservationTerms() {
            return this.observationTerms;
        }

        @Override
        public ObservationTerms.ObservationTermsBuilder getOrCreateObservationTerms() {
            ObservationTerms.ObservationTermsBuilder result = this.observationTerms != null ? this.observationTerms : (this.observationTerms = ObservationTerms.builder());
            return result;
        }

        @Override
        public OptionTypeEnum getOptionType() {
            return this.optionType;
        }

        @Override
        public CommoditySchedule.CommodityScheduleBuilder getSchedule() {
            return this.schedule;
        }

        @Override
        public CommoditySchedule.CommodityScheduleBuilder getOrCreateSchedule() {
            CommoditySchedule.CommodityScheduleBuilder result = this.schedule != null ? this.schedule : (this.schedule = CommoditySchedule.builder());
            return result;
        }

        @Override
        public Product.ProductBuilder getUnderlier() {
            return this.underlier;
        }

        @Override
        public Product.ProductBuilder getOrCreateUnderlier() {
            Product.ProductBuilder result = this.underlier != null ? this.underlier : (this.underlier = Product.builder());
            return result;
        }

        @Override
        public OptionPayoutBuilder setBuyerSeller(BuyerSeller buyerSeller) {
            this.buyerSeller = buyerSeller == null ? null : buyerSeller.toBuilder();
            return this;
        }

        @Override
        public OptionPayoutBuilder setExerciseTerms(OptionExercise exerciseTerms) {
            this.exerciseTerms = exerciseTerms == null ? null : exerciseTerms.toBuilder();
            return this;
        }

        @Override
        public OptionPayoutBuilder setFeature(OptionFeature feature) {
            this.feature = feature == null ? null : feature.toBuilder();
            return this;
        }

        @Override
        public OptionPayoutBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public OptionPayoutBuilder setObservationTerms(ObservationTerms observationTerms) {
            this.observationTerms = observationTerms == null ? null : observationTerms.toBuilder();
            return this;
        }

        @Override
        public OptionPayoutBuilder setOptionType(OptionTypeEnum optionType) {
            this.optionType = optionType == null ? null : optionType;
            return this;
        }

        @Override
        public OptionPayoutBuilder setSchedule(CommoditySchedule schedule) {
            this.schedule = schedule == null ? null : schedule.toBuilder();
            return this;
        }

        @Override
        public OptionPayoutBuilder setUnderlier(Product underlier) {
            this.underlier = underlier == null ? null : underlier.toBuilder();
            return this;
        }

        @Override
        public OptionPayoutBuilder setPayerReceiver(PayerReceiver payerReceiver) {
            this.payerReceiver = payerReceiver == null ? null : payerReceiver.toBuilder();
            return this;
        }

        @Override
        public OptionPayoutBuilder setPriceQuantity(ResolvablePriceQuantity priceQuantity) {
            this.priceQuantity = priceQuantity == null ? null : priceQuantity.toBuilder();
            return this;
        }

        @Override
        public OptionPayoutBuilder setPrincipalPayment(PrincipalPayments principalPayment) {
            this.principalPayment = principalPayment == null ? null : principalPayment.toBuilder();
            return this;
        }

        @Override
        public OptionPayoutBuilder setSettlementTerms(SettlementTerms settlementTerms) {
            this.settlementTerms = settlementTerms == null ? null : settlementTerms.toBuilder();
            return this;
        }

        @Override
        public OptionPayout build() {
            return new OptionPayoutImpl(this);
        }

        @Override
        public OptionPayoutBuilder toBuilder() {
            return this;
        }

        @Override
        public OptionPayoutBuilder prune() {
            super.prune();
            if (this.buyerSeller != null && !this.buyerSeller.prune().hasData()) {
                this.buyerSeller = null;
            }
            if (this.exerciseTerms != null && !this.exerciseTerms.prune().hasData()) {
                this.exerciseTerms = null;
            }
            if (this.feature != null && !this.feature.prune().hasData()) {
                this.feature = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            if (this.observationTerms != null && !this.observationTerms.prune().hasData()) {
                this.observationTerms = null;
            }
            if (this.schedule != null && !this.schedule.prune().hasData()) {
                this.schedule = null;
            }
            if (this.underlier != null && !this.underlier.prune().hasData()) {
                this.underlier = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getBuyerSeller() != null && this.getBuyerSeller().hasData()) {
                return true;
            }
            if (this.getExerciseTerms() != null && this.getExerciseTerms().hasData()) {
                return true;
            }
            if (this.getFeature() != null && this.getFeature().hasData()) {
                return true;
            }
            if (this.getObservationTerms() != null && this.getObservationTerms().hasData()) {
                return true;
            }
            if (this.getOptionType() != null) {
                return true;
            }
            if (this.getSchedule() != null && this.getSchedule().hasData()) {
                return true;
            }
            return this.getUnderlier() != null && this.getUnderlier().hasData();
        }

        @Override
        public OptionPayoutBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            OptionPayoutBuilder o = (OptionPayoutBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBuyerSeller(), (RosettaModelObjectBuilder)o.getBuyerSeller(), this::setBuyerSeller);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExerciseTerms(), (RosettaModelObjectBuilder)o.getExerciseTerms(), this::setExerciseTerms);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFeature(), (RosettaModelObjectBuilder)o.getFeature(), this::setFeature);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getObservationTerms(), (RosettaModelObjectBuilder)o.getObservationTerms(), this::setObservationTerms);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSchedule(), (RosettaModelObjectBuilder)o.getSchedule(), this::setSchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlier(), (RosettaModelObjectBuilder)o.getUnderlier(), this::setUnderlier);
            merger.mergeBasic((Object)this.getOptionType(), (Object)o.getOptionType(), this::setOptionType, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            OptionPayout _that = (OptionPayout)this.getType().cast(o);
            if (!Objects.equals(this.buyerSeller, _that.getBuyerSeller())) {
                return false;
            }
            if (!Objects.equals(this.exerciseTerms, _that.getExerciseTerms())) {
                return false;
            }
            if (!Objects.equals(this.feature, _that.getFeature())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.observationTerms, _that.getObservationTerms())) {
                return false;
            }
            if (!Objects.equals((Object)this.optionType, (Object)_that.getOptionType())) {
                return false;
            }
            if (!Objects.equals(this.schedule, _that.getSchedule())) {
                return false;
            }
            return Objects.equals(this.underlier, _that.getUnderlier());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.buyerSeller != null ? this.buyerSeller.hashCode() : 0);
            _result = 31 * _result + (this.exerciseTerms != null ? this.exerciseTerms.hashCode() : 0);
            _result = 31 * _result + (this.feature != null ? this.feature.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.observationTerms != null ? this.observationTerms.hashCode() : 0);
            _result = 31 * _result + (this.optionType != null ? ((Object)((Object)this.optionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.schedule != null ? this.schedule.hashCode() : 0);
            _result = 31 * _result + (this.underlier != null ? this.underlier.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "OptionPayoutBuilder {buyerSeller=" + this.buyerSeller + ", exerciseTerms=" + this.exerciseTerms + ", feature=" + this.feature + ", meta=" + this.meta + ", observationTerms=" + this.observationTerms + ", optionType=" + (Object)((Object)this.optionType) + ", schedule=" + this.schedule + ", underlier=" + this.underlier + '}' + " " + super.toString();
        }
    }

    public static class OptionPayoutImpl
    extends PayoutBase.PayoutBaseImpl
    implements OptionPayout {
        private final BuyerSeller buyerSeller;
        private final OptionExercise exerciseTerms;
        private final OptionFeature feature;
        private final MetaFields meta;
        private final ObservationTerms observationTerms;
        private final OptionTypeEnum optionType;
        private final CommoditySchedule schedule;
        private final Product underlier;

        protected OptionPayoutImpl(OptionPayoutBuilder builder) {
            super(builder);
            this.buyerSeller = Optional.ofNullable(builder.getBuyerSeller()).map(f -> f.build()).orElse(null);
            this.exerciseTerms = Optional.ofNullable(builder.getExerciseTerms()).map(f -> f.build()).orElse(null);
            this.feature = Optional.ofNullable(builder.getFeature()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
            this.observationTerms = Optional.ofNullable(builder.getObservationTerms()).map(f -> f.build()).orElse(null);
            this.optionType = builder.getOptionType();
            this.schedule = Optional.ofNullable(builder.getSchedule()).map(f -> f.build()).orElse(null);
            this.underlier = Optional.ofNullable(builder.getUnderlier()).map(f -> f.build()).orElse(null);
        }

        @Override
        public BuyerSeller getBuyerSeller() {
            return this.buyerSeller;
        }

        @Override
        public OptionExercise getExerciseTerms() {
            return this.exerciseTerms;
        }

        @Override
        public OptionFeature getFeature() {
            return this.feature;
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public ObservationTerms getObservationTerms() {
            return this.observationTerms;
        }

        @Override
        public OptionTypeEnum getOptionType() {
            return this.optionType;
        }

        @Override
        public CommoditySchedule getSchedule() {
            return this.schedule;
        }

        @Override
        public Product getUnderlier() {
            return this.underlier;
        }

        @Override
        public OptionPayout build() {
            return this;
        }

        @Override
        public OptionPayoutBuilder toBuilder() {
            OptionPayoutBuilder builder = OptionPayout.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(OptionPayoutBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getBuyerSeller()).ifPresent(builder::setBuyerSeller);
            Optional.ofNullable(this.getExerciseTerms()).ifPresent(builder::setExerciseTerms);
            Optional.ofNullable(this.getFeature()).ifPresent(builder::setFeature);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
            Optional.ofNullable(this.getObservationTerms()).ifPresent(builder::setObservationTerms);
            Optional.ofNullable(this.getOptionType()).ifPresent(builder::setOptionType);
            Optional.ofNullable(this.getSchedule()).ifPresent(builder::setSchedule);
            Optional.ofNullable(this.getUnderlier()).ifPresent(builder::setUnderlier);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            OptionPayout _that = (OptionPayout)this.getType().cast(o);
            if (!Objects.equals(this.buyerSeller, _that.getBuyerSeller())) {
                return false;
            }
            if (!Objects.equals(this.exerciseTerms, _that.getExerciseTerms())) {
                return false;
            }
            if (!Objects.equals(this.feature, _that.getFeature())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.observationTerms, _that.getObservationTerms())) {
                return false;
            }
            if (!Objects.equals((Object)this.optionType, (Object)_that.getOptionType())) {
                return false;
            }
            if (!Objects.equals(this.schedule, _that.getSchedule())) {
                return false;
            }
            return Objects.equals(this.underlier, _that.getUnderlier());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.buyerSeller != null ? this.buyerSeller.hashCode() : 0);
            _result = 31 * _result + (this.exerciseTerms != null ? this.exerciseTerms.hashCode() : 0);
            _result = 31 * _result + (this.feature != null ? this.feature.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.observationTerms != null ? this.observationTerms.hashCode() : 0);
            _result = 31 * _result + (this.optionType != null ? ((Object)((Object)this.optionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.schedule != null ? this.schedule.hashCode() : 0);
            _result = 31 * _result + (this.underlier != null ? this.underlier.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "OptionPayout {buyerSeller=" + this.buyerSeller + ", exerciseTerms=" + this.exerciseTerms + ", feature=" + this.feature + ", meta=" + this.meta + ", observationTerms=" + this.observationTerms + ", optionType=" + (Object)((Object)this.optionType) + ", schedule=" + this.schedule + ", underlier=" + this.underlier + '}' + " " + super.toString();
        }
    }

    public static interface OptionPayoutBuilder
    extends OptionPayout,
    PayoutBase.PayoutBaseBuilder,
    RosettaModelObjectBuilder {
        public BuyerSeller.BuyerSellerBuilder getOrCreateBuyerSeller();

        @Override
        public BuyerSeller.BuyerSellerBuilder getBuyerSeller();

        public OptionExercise.OptionExerciseBuilder getOrCreateExerciseTerms();

        @Override
        public OptionExercise.OptionExerciseBuilder getExerciseTerms();

        public OptionFeature.OptionFeatureBuilder getOrCreateFeature();

        @Override
        public OptionFeature.OptionFeatureBuilder getFeature();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public ObservationTerms.ObservationTermsBuilder getOrCreateObservationTerms();

        @Override
        public ObservationTerms.ObservationTermsBuilder getObservationTerms();

        public CommoditySchedule.CommodityScheduleBuilder getOrCreateSchedule();

        @Override
        public CommoditySchedule.CommodityScheduleBuilder getSchedule();

        public Product.ProductBuilder getOrCreateUnderlier();

        @Override
        public Product.ProductBuilder getUnderlier();

        public OptionPayoutBuilder setBuyerSeller(BuyerSeller var1);

        public OptionPayoutBuilder setExerciseTerms(OptionExercise var1);

        public OptionPayoutBuilder setFeature(OptionFeature var1);

        public OptionPayoutBuilder setMeta(MetaFields var1);

        public OptionPayoutBuilder setObservationTerms(ObservationTerms var1);

        public OptionPayoutBuilder setOptionType(OptionTypeEnum var1);

        public OptionPayoutBuilder setSchedule(CommoditySchedule var1);

        public OptionPayoutBuilder setUnderlier(Product var1);

        @Override
        public OptionPayoutBuilder setPayerReceiver(PayerReceiver var1);

        @Override
        public OptionPayoutBuilder setPriceQuantity(ResolvablePriceQuantity var1);

        @Override
        public OptionPayoutBuilder setPrincipalPayment(PrincipalPayments var1);

        @Override
        public OptionPayoutBuilder setSettlementTerms(SettlementTerms var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            PayoutBase.PayoutBaseBuilder.super.process(path, processor);
            processor.processBasic(path.newSubPath("optionType"), OptionTypeEnum.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSeller"), processor, BuyerSeller.BuyerSellerBuilder.class, this.getBuyerSeller(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseTerms"), processor, OptionExercise.OptionExerciseBuilder.class, this.getExerciseTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("feature"), processor, OptionFeature.OptionFeatureBuilder.class, this.getFeature(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("observationTerms"), processor, ObservationTerms.ObservationTermsBuilder.class, this.getObservationTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("schedule"), processor, CommoditySchedule.CommodityScheduleBuilder.class, this.getSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlier"), processor, Product.ProductBuilder.class, this.getUnderlier(), new AttributeMeta[0]);
        }

        @Override
        public OptionPayoutBuilder prune();
    }
}

