/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.product.template.AveragingCalculation;
import cdm.product.template.Barrier;
import cdm.product.template.FxFeature;
import cdm.product.template.Knock;
import cdm.product.template.PassThrough;
import cdm.product.template.StrategyFeature;
import cdm.product.template.meta.OptionFeatureMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface OptionFeature
extends RosettaModelObject {
    public static final OptionFeatureMeta metaData = new OptionFeatureMeta();

    public OptionFeature build();

    public OptionFeatureBuilder toBuilder();

    public AveragingCalculation getAveragingFeature();

    public Barrier getBarrier();

    public List<? extends FxFeature> getFxFeature();

    public Knock getKnock();

    public PassThrough getPassThrough();

    public StrategyFeature getStrategyFeature();

    default public RosettaMetaData<? extends OptionFeature> metaData() {
        return metaData;
    }

    public static OptionFeatureBuilder builder() {
        return new OptionFeatureBuilderImpl();
    }

    default public Class<? extends OptionFeature> getType() {
        return OptionFeature.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("averagingFeature"), processor, AveragingCalculation.class, this.getAveragingFeature(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("barrier"), processor, Barrier.class, this.getBarrier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxFeature"), processor, FxFeature.class, this.getFxFeature(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("knock"), processor, Knock.class, this.getKnock(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("passThrough"), processor, PassThrough.class, this.getPassThrough(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strategyFeature"), processor, StrategyFeature.class, this.getStrategyFeature(), new AttributeMeta[0]);
    }

    public static class OptionFeatureBuilderImpl
    implements OptionFeatureBuilder {
        protected AveragingCalculation.AveragingCalculationBuilder averagingFeature;
        protected Barrier.BarrierBuilder barrier;
        protected List<FxFeature.FxFeatureBuilder> fxFeature = new ArrayList<FxFeature.FxFeatureBuilder>();
        protected Knock.KnockBuilder knock;
        protected PassThrough.PassThroughBuilder passThrough;
        protected StrategyFeature.StrategyFeatureBuilder strategyFeature;

        @Override
        public AveragingCalculation.AveragingCalculationBuilder getAveragingFeature() {
            return this.averagingFeature;
        }

        @Override
        public AveragingCalculation.AveragingCalculationBuilder getOrCreateAveragingFeature() {
            AveragingCalculation.AveragingCalculationBuilder result = this.averagingFeature != null ? this.averagingFeature : (this.averagingFeature = AveragingCalculation.builder());
            return result;
        }

        @Override
        public Barrier.BarrierBuilder getBarrier() {
            return this.barrier;
        }

        @Override
        public Barrier.BarrierBuilder getOrCreateBarrier() {
            Barrier.BarrierBuilder result = this.barrier != null ? this.barrier : (this.barrier = Barrier.builder());
            return result;
        }

        @Override
        public List<? extends FxFeature.FxFeatureBuilder> getFxFeature() {
            return this.fxFeature;
        }

        @Override
        public FxFeature.FxFeatureBuilder getOrCreateFxFeature(int _index) {
            if (this.fxFeature == null) {
                this.fxFeature = new ArrayList<FxFeature.FxFeatureBuilder>();
            }
            return (FxFeature.FxFeatureBuilder)this.getIndex(this.fxFeature, _index, () -> {
                FxFeature.FxFeatureBuilder newFxFeature = FxFeature.builder();
                return newFxFeature;
            });
        }

        @Override
        public Knock.KnockBuilder getKnock() {
            return this.knock;
        }

        @Override
        public Knock.KnockBuilder getOrCreateKnock() {
            Knock.KnockBuilder result = this.knock != null ? this.knock : (this.knock = Knock.builder());
            return result;
        }

        @Override
        public PassThrough.PassThroughBuilder getPassThrough() {
            return this.passThrough;
        }

        @Override
        public PassThrough.PassThroughBuilder getOrCreatePassThrough() {
            PassThrough.PassThroughBuilder result = this.passThrough != null ? this.passThrough : (this.passThrough = PassThrough.builder());
            return result;
        }

        @Override
        public StrategyFeature.StrategyFeatureBuilder getStrategyFeature() {
            return this.strategyFeature;
        }

        @Override
        public StrategyFeature.StrategyFeatureBuilder getOrCreateStrategyFeature() {
            StrategyFeature.StrategyFeatureBuilder result = this.strategyFeature != null ? this.strategyFeature : (this.strategyFeature = StrategyFeature.builder());
            return result;
        }

        @Override
        public OptionFeatureBuilder setAveragingFeature(AveragingCalculation averagingFeature) {
            this.averagingFeature = averagingFeature == null ? null : averagingFeature.toBuilder();
            return this;
        }

        @Override
        public OptionFeatureBuilder setBarrier(Barrier barrier) {
            this.barrier = barrier == null ? null : barrier.toBuilder();
            return this;
        }

        @Override
        public OptionFeatureBuilder addFxFeature(FxFeature fxFeature) {
            if (fxFeature != null) {
                this.fxFeature.add(fxFeature.toBuilder());
            }
            return this;
        }

        @Override
        public OptionFeatureBuilder addFxFeature(FxFeature fxFeature, int _idx) {
            this.getIndex(this.fxFeature, _idx, () -> fxFeature.toBuilder());
            return this;
        }

        @Override
        public OptionFeatureBuilder addFxFeature(List<? extends FxFeature> fxFeatures) {
            if (fxFeatures != null) {
                for (FxFeature fxFeature : fxFeatures) {
                    this.fxFeature.add(fxFeature.toBuilder());
                }
            }
            return this;
        }

        @Override
        public OptionFeatureBuilder setFxFeature(List<? extends FxFeature> fxFeatures) {
            this.fxFeature = fxFeatures == null ? new ArrayList<FxFeature.FxFeatureBuilder>() : (List)fxFeatures.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public OptionFeatureBuilder setKnock(Knock knock) {
            this.knock = knock == null ? null : knock.toBuilder();
            return this;
        }

        @Override
        public OptionFeatureBuilder setPassThrough(PassThrough passThrough) {
            this.passThrough = passThrough == null ? null : passThrough.toBuilder();
            return this;
        }

        @Override
        public OptionFeatureBuilder setStrategyFeature(StrategyFeature strategyFeature) {
            this.strategyFeature = strategyFeature == null ? null : strategyFeature.toBuilder();
            return this;
        }

        @Override
        public OptionFeature build() {
            return new OptionFeatureImpl(this);
        }

        @Override
        public OptionFeatureBuilder toBuilder() {
            return this;
        }

        @Override
        public OptionFeatureBuilder prune() {
            if (this.averagingFeature != null && !this.averagingFeature.prune().hasData()) {
                this.averagingFeature = null;
            }
            if (this.barrier != null && !this.barrier.prune().hasData()) {
                this.barrier = null;
            }
            this.fxFeature = this.fxFeature.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.knock != null && !this.knock.prune().hasData()) {
                this.knock = null;
            }
            if (this.passThrough != null && !this.passThrough.prune().hasData()) {
                this.passThrough = null;
            }
            if (this.strategyFeature != null && !this.strategyFeature.prune().hasData()) {
                this.strategyFeature = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAveragingFeature() != null && this.getAveragingFeature().hasData()) {
                return true;
            }
            if (this.getBarrier() != null && this.getBarrier().hasData()) {
                return true;
            }
            if (this.getFxFeature() != null && this.getFxFeature().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getKnock() != null && this.getKnock().hasData()) {
                return true;
            }
            if (this.getPassThrough() != null && this.getPassThrough().hasData()) {
                return true;
            }
            return this.getStrategyFeature() != null && this.getStrategyFeature().hasData();
        }

        public OptionFeatureBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            OptionFeatureBuilder o = (OptionFeatureBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAveragingFeature(), (RosettaModelObjectBuilder)o.getAveragingFeature(), this::setAveragingFeature);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBarrier(), (RosettaModelObjectBuilder)o.getBarrier(), this::setBarrier);
            merger.mergeRosetta(this.getFxFeature(), o.getFxFeature(), this::getOrCreateFxFeature);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getKnock(), (RosettaModelObjectBuilder)o.getKnock(), this::setKnock);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPassThrough(), (RosettaModelObjectBuilder)o.getPassThrough(), this::setPassThrough);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStrategyFeature(), (RosettaModelObjectBuilder)o.getStrategyFeature(), this::setStrategyFeature);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            OptionFeature _that = this.getType().cast(o);
            if (!Objects.equals(this.averagingFeature, _that.getAveragingFeature())) {
                return false;
            }
            if (!Objects.equals(this.barrier, _that.getBarrier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.fxFeature, _that.getFxFeature())) {
                return false;
            }
            if (!Objects.equals(this.knock, _that.getKnock())) {
                return false;
            }
            if (!Objects.equals(this.passThrough, _that.getPassThrough())) {
                return false;
            }
            return Objects.equals(this.strategyFeature, _that.getStrategyFeature());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.averagingFeature != null ? this.averagingFeature.hashCode() : 0);
            _result = 31 * _result + (this.barrier != null ? this.barrier.hashCode() : 0);
            _result = 31 * _result + (this.fxFeature != null ? this.fxFeature.hashCode() : 0);
            _result = 31 * _result + (this.knock != null ? this.knock.hashCode() : 0);
            _result = 31 * _result + (this.passThrough != null ? this.passThrough.hashCode() : 0);
            _result = 31 * _result + (this.strategyFeature != null ? this.strategyFeature.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "OptionFeatureBuilder {averagingFeature=" + this.averagingFeature + ", barrier=" + this.barrier + ", fxFeature=" + this.fxFeature + ", knock=" + this.knock + ", passThrough=" + this.passThrough + ", strategyFeature=" + this.strategyFeature + '}';
        }
    }

    public static class OptionFeatureImpl
    implements OptionFeature {
        private final AveragingCalculation averagingFeature;
        private final Barrier barrier;
        private final List<? extends FxFeature> fxFeature;
        private final Knock knock;
        private final PassThrough passThrough;
        private final StrategyFeature strategyFeature;

        protected OptionFeatureImpl(OptionFeatureBuilder builder) {
            this.averagingFeature = Optional.ofNullable(builder.getAveragingFeature()).map(f -> f.build()).orElse(null);
            this.barrier = Optional.ofNullable(builder.getBarrier()).map(f -> f.build()).orElse(null);
            this.fxFeature = Optional.ofNullable(builder.getFxFeature()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.knock = Optional.ofNullable(builder.getKnock()).map(f -> f.build()).orElse(null);
            this.passThrough = Optional.ofNullable(builder.getPassThrough()).map(f -> f.build()).orElse(null);
            this.strategyFeature = Optional.ofNullable(builder.getStrategyFeature()).map(f -> f.build()).orElse(null);
        }

        @Override
        public AveragingCalculation getAveragingFeature() {
            return this.averagingFeature;
        }

        @Override
        public Barrier getBarrier() {
            return this.barrier;
        }

        @Override
        public List<? extends FxFeature> getFxFeature() {
            return this.fxFeature;
        }

        @Override
        public Knock getKnock() {
            return this.knock;
        }

        @Override
        public PassThrough getPassThrough() {
            return this.passThrough;
        }

        @Override
        public StrategyFeature getStrategyFeature() {
            return this.strategyFeature;
        }

        @Override
        public OptionFeature build() {
            return this;
        }

        @Override
        public OptionFeatureBuilder toBuilder() {
            OptionFeatureBuilder builder = OptionFeature.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(OptionFeatureBuilder builder) {
            Optional.ofNullable(this.getAveragingFeature()).ifPresent(builder::setAveragingFeature);
            Optional.ofNullable(this.getBarrier()).ifPresent(builder::setBarrier);
            Optional.ofNullable(this.getFxFeature()).ifPresent(builder::setFxFeature);
            Optional.ofNullable(this.getKnock()).ifPresent(builder::setKnock);
            Optional.ofNullable(this.getPassThrough()).ifPresent(builder::setPassThrough);
            Optional.ofNullable(this.getStrategyFeature()).ifPresent(builder::setStrategyFeature);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            OptionFeature _that = this.getType().cast(o);
            if (!Objects.equals(this.averagingFeature, _that.getAveragingFeature())) {
                return false;
            }
            if (!Objects.equals(this.barrier, _that.getBarrier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.fxFeature, _that.getFxFeature())) {
                return false;
            }
            if (!Objects.equals(this.knock, _that.getKnock())) {
                return false;
            }
            if (!Objects.equals(this.passThrough, _that.getPassThrough())) {
                return false;
            }
            return Objects.equals(this.strategyFeature, _that.getStrategyFeature());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.averagingFeature != null ? this.averagingFeature.hashCode() : 0);
            _result = 31 * _result + (this.barrier != null ? this.barrier.hashCode() : 0);
            _result = 31 * _result + (this.fxFeature != null ? this.fxFeature.hashCode() : 0);
            _result = 31 * _result + (this.knock != null ? this.knock.hashCode() : 0);
            _result = 31 * _result + (this.passThrough != null ? this.passThrough.hashCode() : 0);
            _result = 31 * _result + (this.strategyFeature != null ? this.strategyFeature.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "OptionFeature {averagingFeature=" + this.averagingFeature + ", barrier=" + this.barrier + ", fxFeature=" + this.fxFeature + ", knock=" + this.knock + ", passThrough=" + this.passThrough + ", strategyFeature=" + this.strategyFeature + '}';
        }
    }

    public static interface OptionFeatureBuilder
    extends OptionFeature,
    RosettaModelObjectBuilder {
        public AveragingCalculation.AveragingCalculationBuilder getOrCreateAveragingFeature();

        @Override
        public AveragingCalculation.AveragingCalculationBuilder getAveragingFeature();

        public Barrier.BarrierBuilder getOrCreateBarrier();

        @Override
        public Barrier.BarrierBuilder getBarrier();

        public FxFeature.FxFeatureBuilder getOrCreateFxFeature(int var1);

        public List<? extends FxFeature.FxFeatureBuilder> getFxFeature();

        public Knock.KnockBuilder getOrCreateKnock();

        @Override
        public Knock.KnockBuilder getKnock();

        public PassThrough.PassThroughBuilder getOrCreatePassThrough();

        @Override
        public PassThrough.PassThroughBuilder getPassThrough();

        public StrategyFeature.StrategyFeatureBuilder getOrCreateStrategyFeature();

        @Override
        public StrategyFeature.StrategyFeatureBuilder getStrategyFeature();

        public OptionFeatureBuilder setAveragingFeature(AveragingCalculation var1);

        public OptionFeatureBuilder setBarrier(Barrier var1);

        public OptionFeatureBuilder addFxFeature(FxFeature var1);

        public OptionFeatureBuilder addFxFeature(FxFeature var1, int var2);

        public OptionFeatureBuilder addFxFeature(List<? extends FxFeature> var1);

        public OptionFeatureBuilder setFxFeature(List<? extends FxFeature> var1);

        public OptionFeatureBuilder setKnock(Knock var1);

        public OptionFeatureBuilder setPassThrough(PassThrough var1);

        public OptionFeatureBuilder setStrategyFeature(StrategyFeature var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("averagingFeature"), processor, AveragingCalculation.AveragingCalculationBuilder.class, this.getAveragingFeature(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("barrier"), processor, Barrier.BarrierBuilder.class, this.getBarrier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxFeature"), processor, FxFeature.FxFeatureBuilder.class, this.getFxFeature(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("knock"), processor, Knock.KnockBuilder.class, this.getKnock(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("passThrough"), processor, PassThrough.PassThroughBuilder.class, this.getPassThrough(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strategyFeature"), processor, StrategyFeature.StrategyFeatureBuilder.class, this.getStrategyFeature(), new AttributeMeta[0]);
        }

        public OptionFeatureBuilder prune();
    }
}

