/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.product.template.meta.InitialMarginCalculationMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface InitialMarginCalculation
extends RosettaModelObject {
    public static final InitialMarginCalculationMeta metaData = new InitialMarginCalculationMeta();

    public InitialMarginCalculation build();

    public InitialMarginCalculationBuilder toBuilder();

    public BigDecimal getHaircut();

    public List<BigDecimal> getHaircutThreshold();

    public BigDecimal getMarginRatio();

    public List<BigDecimal> getMarginRatioThreshold();

    default public RosettaMetaData<? extends InitialMarginCalculation> metaData() {
        return metaData;
    }

    public static InitialMarginCalculationBuilder builder() {
        return new InitialMarginCalculationBuilderImpl();
    }

    default public Class<? extends InitialMarginCalculation> getType() {
        return InitialMarginCalculation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("haircut"), BigDecimal.class, (Object)this.getHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("haircutThreshold"), BigDecimal.class, this.getHaircutThreshold(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("marginRatio"), BigDecimal.class, (Object)this.getMarginRatio(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("marginRatioThreshold"), BigDecimal.class, this.getMarginRatioThreshold(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class InitialMarginCalculationBuilderImpl
    implements InitialMarginCalculationBuilder {
        protected BigDecimal haircut;
        protected List<BigDecimal> haircutThreshold = new ArrayList<BigDecimal>();
        protected BigDecimal marginRatio;
        protected List<BigDecimal> marginRatioThreshold = new ArrayList<BigDecimal>();

        @Override
        public BigDecimal getHaircut() {
            return this.haircut;
        }

        @Override
        public List<BigDecimal> getHaircutThreshold() {
            return this.haircutThreshold;
        }

        @Override
        public BigDecimal getMarginRatio() {
            return this.marginRatio;
        }

        @Override
        public List<BigDecimal> getMarginRatioThreshold() {
            return this.marginRatioThreshold;
        }

        @Override
        public InitialMarginCalculationBuilder setHaircut(BigDecimal haircut) {
            this.haircut = haircut == null ? null : haircut;
            return this;
        }

        @Override
        public InitialMarginCalculationBuilder addHaircutThreshold(BigDecimal haircutThreshold) {
            if (haircutThreshold != null) {
                this.haircutThreshold.add(haircutThreshold);
            }
            return this;
        }

        @Override
        public InitialMarginCalculationBuilder addHaircutThreshold(BigDecimal haircutThreshold, int _idx) {
            this.getIndex(this.haircutThreshold, _idx, () -> haircutThreshold);
            return this;
        }

        @Override
        public InitialMarginCalculationBuilder addHaircutThreshold(List<? extends BigDecimal> haircutThresholds) {
            if (haircutThresholds != null) {
                for (BigDecimal bigDecimal : haircutThresholds) {
                    this.haircutThreshold.add(bigDecimal);
                }
            }
            return this;
        }

        @Override
        public InitialMarginCalculationBuilder setHaircutThreshold(List<? extends BigDecimal> haircutThresholds) {
            this.haircutThreshold = haircutThresholds == null ? new ArrayList<BigDecimal>() : (List)haircutThresholds.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public InitialMarginCalculationBuilder setMarginRatio(BigDecimal marginRatio) {
            this.marginRatio = marginRatio == null ? null : marginRatio;
            return this;
        }

        @Override
        public InitialMarginCalculationBuilder addMarginRatioThreshold(BigDecimal marginRatioThreshold) {
            if (marginRatioThreshold != null) {
                this.marginRatioThreshold.add(marginRatioThreshold);
            }
            return this;
        }

        @Override
        public InitialMarginCalculationBuilder addMarginRatioThreshold(BigDecimal marginRatioThreshold, int _idx) {
            this.getIndex(this.marginRatioThreshold, _idx, () -> marginRatioThreshold);
            return this;
        }

        @Override
        public InitialMarginCalculationBuilder addMarginRatioThreshold(List<? extends BigDecimal> marginRatioThresholds) {
            if (marginRatioThresholds != null) {
                for (BigDecimal bigDecimal : marginRatioThresholds) {
                    this.marginRatioThreshold.add(bigDecimal);
                }
            }
            return this;
        }

        @Override
        public InitialMarginCalculationBuilder setMarginRatioThreshold(List<? extends BigDecimal> marginRatioThresholds) {
            this.marginRatioThreshold = marginRatioThresholds == null ? new ArrayList<BigDecimal>() : (List)marginRatioThresholds.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public InitialMarginCalculation build() {
            return new InitialMarginCalculationImpl(this);
        }

        @Override
        public InitialMarginCalculationBuilder toBuilder() {
            return this;
        }

        @Override
        public InitialMarginCalculationBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getHaircut() != null) {
                return true;
            }
            if (this.getHaircutThreshold() != null && !this.getHaircutThreshold().isEmpty()) {
                return true;
            }
            if (this.getMarginRatio() != null) {
                return true;
            }
            return this.getMarginRatioThreshold() != null && !this.getMarginRatioThreshold().isEmpty();
        }

        public InitialMarginCalculationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            InitialMarginCalculationBuilder o = (InitialMarginCalculationBuilder)other;
            merger.mergeBasic((Object)this.getHaircut(), (Object)o.getHaircut(), this::setHaircut, new AttributeMeta[0]);
            merger.mergeBasic(this.getHaircutThreshold(), o.getHaircutThreshold(), this::addHaircutThreshold);
            merger.mergeBasic((Object)this.getMarginRatio(), (Object)o.getMarginRatio(), this::setMarginRatio, new AttributeMeta[0]);
            merger.mergeBasic(this.getMarginRatioThreshold(), o.getMarginRatioThreshold(), this::addMarginRatioThreshold);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            InitialMarginCalculation _that = this.getType().cast(o);
            if (!Objects.equals(this.haircut, _that.getHaircut())) {
                return false;
            }
            if (!ListEquals.listEquals(this.haircutThreshold, _that.getHaircutThreshold())) {
                return false;
            }
            if (!Objects.equals(this.marginRatio, _that.getMarginRatio())) {
                return false;
            }
            return ListEquals.listEquals(this.marginRatioThreshold, _that.getMarginRatioThreshold());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.haircut != null ? this.haircut.hashCode() : 0);
            _result = 31 * _result + (this.haircutThreshold != null ? this.haircutThreshold.hashCode() : 0);
            _result = 31 * _result + (this.marginRatio != null ? this.marginRatio.hashCode() : 0);
            _result = 31 * _result + (this.marginRatioThreshold != null ? this.marginRatioThreshold.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "InitialMarginCalculationBuilder {haircut=" + this.haircut + ", haircutThreshold=" + this.haircutThreshold + ", marginRatio=" + this.marginRatio + ", marginRatioThreshold=" + this.marginRatioThreshold + '}';
        }
    }

    public static class InitialMarginCalculationImpl
    implements InitialMarginCalculation {
        private final BigDecimal haircut;
        private final List<BigDecimal> haircutThreshold;
        private final BigDecimal marginRatio;
        private final List<BigDecimal> marginRatioThreshold;

        protected InitialMarginCalculationImpl(InitialMarginCalculationBuilder builder) {
            this.haircut = builder.getHaircut();
            this.haircutThreshold = Optional.ofNullable(builder.getHaircutThreshold()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.marginRatio = builder.getMarginRatio();
            this.marginRatioThreshold = Optional.ofNullable(builder.getMarginRatioThreshold()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
        }

        @Override
        public BigDecimal getHaircut() {
            return this.haircut;
        }

        @Override
        public List<BigDecimal> getHaircutThreshold() {
            return this.haircutThreshold;
        }

        @Override
        public BigDecimal getMarginRatio() {
            return this.marginRatio;
        }

        @Override
        public List<BigDecimal> getMarginRatioThreshold() {
            return this.marginRatioThreshold;
        }

        @Override
        public InitialMarginCalculation build() {
            return this;
        }

        @Override
        public InitialMarginCalculationBuilder toBuilder() {
            InitialMarginCalculationBuilder builder = InitialMarginCalculation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(InitialMarginCalculationBuilder builder) {
            Optional.ofNullable(this.getHaircut()).ifPresent(builder::setHaircut);
            Optional.ofNullable(this.getHaircutThreshold()).ifPresent(builder::setHaircutThreshold);
            Optional.ofNullable(this.getMarginRatio()).ifPresent(builder::setMarginRatio);
            Optional.ofNullable(this.getMarginRatioThreshold()).ifPresent(builder::setMarginRatioThreshold);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            InitialMarginCalculation _that = this.getType().cast(o);
            if (!Objects.equals(this.haircut, _that.getHaircut())) {
                return false;
            }
            if (!ListEquals.listEquals(this.haircutThreshold, _that.getHaircutThreshold())) {
                return false;
            }
            if (!Objects.equals(this.marginRatio, _that.getMarginRatio())) {
                return false;
            }
            return ListEquals.listEquals(this.marginRatioThreshold, _that.getMarginRatioThreshold());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.haircut != null ? this.haircut.hashCode() : 0);
            _result = 31 * _result + (this.haircutThreshold != null ? this.haircutThreshold.hashCode() : 0);
            _result = 31 * _result + (this.marginRatio != null ? this.marginRatio.hashCode() : 0);
            _result = 31 * _result + (this.marginRatioThreshold != null ? this.marginRatioThreshold.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "InitialMarginCalculation {haircut=" + this.haircut + ", haircutThreshold=" + this.haircutThreshold + ", marginRatio=" + this.marginRatio + ", marginRatioThreshold=" + this.marginRatioThreshold + '}';
        }
    }

    public static interface InitialMarginCalculationBuilder
    extends InitialMarginCalculation,
    RosettaModelObjectBuilder {
        public InitialMarginCalculationBuilder setHaircut(BigDecimal var1);

        public InitialMarginCalculationBuilder addHaircutThreshold(BigDecimal var1);

        public InitialMarginCalculationBuilder addHaircutThreshold(BigDecimal var1, int var2);

        public InitialMarginCalculationBuilder addHaircutThreshold(List<? extends BigDecimal> var1);

        public InitialMarginCalculationBuilder setHaircutThreshold(List<? extends BigDecimal> var1);

        public InitialMarginCalculationBuilder setMarginRatio(BigDecimal var1);

        public InitialMarginCalculationBuilder addMarginRatioThreshold(BigDecimal var1);

        public InitialMarginCalculationBuilder addMarginRatioThreshold(BigDecimal var1, int var2);

        public InitialMarginCalculationBuilder addMarginRatioThreshold(List<? extends BigDecimal> var1);

        public InitialMarginCalculationBuilder setMarginRatioThreshold(List<? extends BigDecimal> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("haircut"), BigDecimal.class, (Object)this.getHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("haircutThreshold"), BigDecimal.class, this.getHaircutThreshold(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("marginRatio"), BigDecimal.class, (Object)this.getMarginRatio(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("marginRatioThreshold"), BigDecimal.class, this.getMarginRatioThreshold(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public InitialMarginCalculationBuilder prune();
    }
}

