/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.staticdata.party.PayerReceiver;
import cdm.product.common.schedule.PaymentDates;
import cdm.product.common.settlement.FixedPrice;
import cdm.product.common.settlement.PayoutBase;
import cdm.product.common.settlement.PrincipalPayments;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.template.CommoditySchedule;
import cdm.product.template.meta.FixedPricePayoutMeta;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface FixedPricePayout
extends PayoutBase,
GlobalKey {
    public static final FixedPricePayoutMeta metaData = new FixedPricePayoutMeta();

    @Override
    public FixedPricePayout build();

    @Override
    public FixedPricePayoutBuilder toBuilder();

    public FixedPrice getFixedPrice();

    public MetaFields getMeta();

    public PaymentDates getPaymentDates();

    public CommoditySchedule getSchedule();

    default public RosettaMetaData<? extends FixedPricePayout> metaData() {
        return metaData;
    }

    public static FixedPricePayoutBuilder builder() {
        return new FixedPricePayoutBuilderImpl();
    }

    default public Class<? extends FixedPricePayout> getType() {
        return FixedPricePayout.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        PayoutBase.super.process(path, processor);
        this.processRosetta(path.newSubPath("fixedPrice"), processor, FixedPrice.class, this.getFixedPrice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDates"), processor, PaymentDates.class, this.getPaymentDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("schedule"), processor, CommoditySchedule.class, this.getSchedule(), new AttributeMeta[0]);
    }

    public static class FixedPricePayoutBuilderImpl
    extends PayoutBase.PayoutBaseBuilderImpl
    implements FixedPricePayoutBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected FixedPrice.FixedPriceBuilder fixedPrice;
        protected MetaFields.MetaFieldsBuilder meta;
        protected PaymentDates.PaymentDatesBuilder paymentDates;
        protected CommoditySchedule.CommodityScheduleBuilder schedule;

        @Override
        public FixedPrice.FixedPriceBuilder getFixedPrice() {
            return this.fixedPrice;
        }

        @Override
        public FixedPrice.FixedPriceBuilder getOrCreateFixedPrice() {
            FixedPrice.FixedPriceBuilder result = this.fixedPrice != null ? this.fixedPrice : (this.fixedPrice = FixedPrice.builder());
            return result;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public PaymentDates.PaymentDatesBuilder getPaymentDates() {
            return this.paymentDates;
        }

        @Override
        public PaymentDates.PaymentDatesBuilder getOrCreatePaymentDates() {
            PaymentDates.PaymentDatesBuilder result = this.paymentDates != null ? this.paymentDates : (this.paymentDates = PaymentDates.builder());
            return result;
        }

        @Override
        public CommoditySchedule.CommodityScheduleBuilder getSchedule() {
            return this.schedule;
        }

        @Override
        public CommoditySchedule.CommodityScheduleBuilder getOrCreateSchedule() {
            CommoditySchedule.CommodityScheduleBuilder result = this.schedule != null ? this.schedule : (this.schedule = CommoditySchedule.builder());
            return result;
        }

        @Override
        public FixedPricePayoutBuilder setFixedPrice(FixedPrice fixedPrice) {
            this.fixedPrice = fixedPrice == null ? null : fixedPrice.toBuilder();
            return this;
        }

        @Override
        public FixedPricePayoutBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public FixedPricePayoutBuilder setPaymentDates(PaymentDates paymentDates) {
            this.paymentDates = paymentDates == null ? null : paymentDates.toBuilder();
            return this;
        }

        @Override
        public FixedPricePayoutBuilder setSchedule(CommoditySchedule schedule) {
            this.schedule = schedule == null ? null : schedule.toBuilder();
            return this;
        }

        @Override
        public FixedPricePayoutBuilder setPayerReceiver(PayerReceiver payerReceiver) {
            this.payerReceiver = payerReceiver == null ? null : payerReceiver.toBuilder();
            return this;
        }

        @Override
        public FixedPricePayoutBuilder setPriceQuantity(ResolvablePriceQuantity priceQuantity) {
            this.priceQuantity = priceQuantity == null ? null : priceQuantity.toBuilder();
            return this;
        }

        @Override
        public FixedPricePayoutBuilder setPrincipalPayment(PrincipalPayments principalPayment) {
            this.principalPayment = principalPayment == null ? null : principalPayment.toBuilder();
            return this;
        }

        @Override
        public FixedPricePayoutBuilder setSettlementTerms(SettlementTerms settlementTerms) {
            this.settlementTerms = settlementTerms == null ? null : settlementTerms.toBuilder();
            return this;
        }

        @Override
        public FixedPricePayout build() {
            return new FixedPricePayoutImpl(this);
        }

        @Override
        public FixedPricePayoutBuilder toBuilder() {
            return this;
        }

        @Override
        public FixedPricePayoutBuilder prune() {
            super.prune();
            if (this.fixedPrice != null && !this.fixedPrice.prune().hasData()) {
                this.fixedPrice = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            if (this.paymentDates != null && !this.paymentDates.prune().hasData()) {
                this.paymentDates = null;
            }
            if (this.schedule != null && !this.schedule.prune().hasData()) {
                this.schedule = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getFixedPrice() != null && this.getFixedPrice().hasData()) {
                return true;
            }
            if (this.getPaymentDates() != null && this.getPaymentDates().hasData()) {
                return true;
            }
            return this.getSchedule() != null && this.getSchedule().hasData();
        }

        @Override
        public FixedPricePayoutBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FixedPricePayoutBuilder o = (FixedPricePayoutBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixedPrice(), (RosettaModelObjectBuilder)o.getFixedPrice(), this::setFixedPrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentDates(), (RosettaModelObjectBuilder)o.getPaymentDates(), this::setPaymentDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSchedule(), (RosettaModelObjectBuilder)o.getSchedule(), this::setSchedule);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FixedPricePayout _that = (FixedPricePayout)this.getType().cast(o);
            if (!Objects.equals(this.fixedPrice, _that.getFixedPrice())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.paymentDates, _that.getPaymentDates())) {
                return false;
            }
            return Objects.equals(this.schedule, _that.getSchedule());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.fixedPrice != null ? this.fixedPrice.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.paymentDates != null ? this.paymentDates.hashCode() : 0);
            _result = 31 * _result + (this.schedule != null ? this.schedule.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FixedPricePayoutBuilder {fixedPrice=" + this.fixedPrice + ", meta=" + this.meta + ", paymentDates=" + this.paymentDates + ", schedule=" + this.schedule + '}' + " " + super.toString();
        }
    }

    public static class FixedPricePayoutImpl
    extends PayoutBase.PayoutBaseImpl
    implements FixedPricePayout {
        private final FixedPrice fixedPrice;
        private final MetaFields meta;
        private final PaymentDates paymentDates;
        private final CommoditySchedule schedule;

        protected FixedPricePayoutImpl(FixedPricePayoutBuilder builder) {
            super(builder);
            this.fixedPrice = Optional.ofNullable(builder.getFixedPrice()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
            this.paymentDates = Optional.ofNullable(builder.getPaymentDates()).map(f -> f.build()).orElse(null);
            this.schedule = Optional.ofNullable(builder.getSchedule()).map(f -> f.build()).orElse(null);
        }

        @Override
        public FixedPrice getFixedPrice() {
            return this.fixedPrice;
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public PaymentDates getPaymentDates() {
            return this.paymentDates;
        }

        @Override
        public CommoditySchedule getSchedule() {
            return this.schedule;
        }

        @Override
        public FixedPricePayout build() {
            return this;
        }

        @Override
        public FixedPricePayoutBuilder toBuilder() {
            FixedPricePayoutBuilder builder = FixedPricePayout.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FixedPricePayoutBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getFixedPrice()).ifPresent(builder::setFixedPrice);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
            Optional.ofNullable(this.getPaymentDates()).ifPresent(builder::setPaymentDates);
            Optional.ofNullable(this.getSchedule()).ifPresent(builder::setSchedule);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FixedPricePayout _that = (FixedPricePayout)this.getType().cast(o);
            if (!Objects.equals(this.fixedPrice, _that.getFixedPrice())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.paymentDates, _that.getPaymentDates())) {
                return false;
            }
            return Objects.equals(this.schedule, _that.getSchedule());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.fixedPrice != null ? this.fixedPrice.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.paymentDates != null ? this.paymentDates.hashCode() : 0);
            _result = 31 * _result + (this.schedule != null ? this.schedule.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FixedPricePayout {fixedPrice=" + this.fixedPrice + ", meta=" + this.meta + ", paymentDates=" + this.paymentDates + ", schedule=" + this.schedule + '}' + " " + super.toString();
        }
    }

    public static interface FixedPricePayoutBuilder
    extends FixedPricePayout,
    PayoutBase.PayoutBaseBuilder,
    RosettaModelObjectBuilder {
        public FixedPrice.FixedPriceBuilder getOrCreateFixedPrice();

        @Override
        public FixedPrice.FixedPriceBuilder getFixedPrice();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public PaymentDates.PaymentDatesBuilder getOrCreatePaymentDates();

        @Override
        public PaymentDates.PaymentDatesBuilder getPaymentDates();

        public CommoditySchedule.CommodityScheduleBuilder getOrCreateSchedule();

        @Override
        public CommoditySchedule.CommodityScheduleBuilder getSchedule();

        public FixedPricePayoutBuilder setFixedPrice(FixedPrice var1);

        public FixedPricePayoutBuilder setMeta(MetaFields var1);

        public FixedPricePayoutBuilder setPaymentDates(PaymentDates var1);

        public FixedPricePayoutBuilder setSchedule(CommoditySchedule var1);

        @Override
        public FixedPricePayoutBuilder setPayerReceiver(PayerReceiver var1);

        @Override
        public FixedPricePayoutBuilder setPriceQuantity(ResolvablePriceQuantity var1);

        @Override
        public FixedPricePayoutBuilder setPrincipalPayment(PrincipalPayments var1);

        @Override
        public FixedPricePayoutBuilder setSettlementTerms(SettlementTerms var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            PayoutBase.PayoutBaseBuilder.super.process(path, processor);
            this.processRosetta(path.newSubPath("fixedPrice"), processor, FixedPrice.FixedPriceBuilder.class, this.getFixedPrice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDates"), processor, PaymentDates.PaymentDatesBuilder.class, this.getPaymentDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("schedule"), processor, CommoditySchedule.CommodityScheduleBuilder.class, this.getSchedule(), new AttributeMeta[0]);
        }

        @Override
        public FixedPricePayoutBuilder prune();
    }
}

