/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.datetime.RelativeDateOffset;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.observable.asset.Money;
import cdm.observable.asset.metafields.ReferenceWithMetaMoney;
import cdm.product.template.meta.ExerciseFeeMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface ExerciseFee
extends PayerReceiver {
    public static final ExerciseFeeMeta metaData = new ExerciseFeeMeta();

    @Override
    public ExerciseFee build();

    @Override
    public ExerciseFeeBuilder toBuilder();

    public BigDecimal getFeeAmount();

    public RelativeDateOffset getFeePaymentDate();

    public BigDecimal getFeeRate();

    public ReferenceWithMetaMoney getNotionalReference();

    default public RosettaMetaData<? extends ExerciseFee> metaData() {
        return metaData;
    }

    public static ExerciseFeeBuilder builder() {
        return new ExerciseFeeBuilderImpl();
    }

    default public Class<? extends ExerciseFee> getType() {
        return ExerciseFee.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        PayerReceiver.super.process(path, processor);
        processor.processBasic(path.newSubPath("feeAmount"), BigDecimal.class, (Object)this.getFeeAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("feeRate"), BigDecimal.class, (Object)this.getFeeRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("feePaymentDate"), processor, RelativeDateOffset.class, this.getFeePaymentDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalReference"), processor, ReferenceWithMetaMoney.class, this.getNotionalReference(), new AttributeMeta[0]);
    }

    public static class ExerciseFeeBuilderImpl
    extends PayerReceiver.PayerReceiverBuilderImpl
    implements ExerciseFeeBuilder {
        protected BigDecimal feeAmount;
        protected RelativeDateOffset.RelativeDateOffsetBuilder feePaymentDate;
        protected BigDecimal feeRate;
        protected ReferenceWithMetaMoney.ReferenceWithMetaMoneyBuilder notionalReference;

        @Override
        public BigDecimal getFeeAmount() {
            return this.feeAmount;
        }

        @Override
        public RelativeDateOffset.RelativeDateOffsetBuilder getFeePaymentDate() {
            return this.feePaymentDate;
        }

        @Override
        public RelativeDateOffset.RelativeDateOffsetBuilder getOrCreateFeePaymentDate() {
            RelativeDateOffset.RelativeDateOffsetBuilder result = this.feePaymentDate != null ? this.feePaymentDate : (this.feePaymentDate = RelativeDateOffset.builder());
            return result;
        }

        @Override
        public BigDecimal getFeeRate() {
            return this.feeRate;
        }

        @Override
        public ReferenceWithMetaMoney.ReferenceWithMetaMoneyBuilder getNotionalReference() {
            return this.notionalReference;
        }

        @Override
        public ReferenceWithMetaMoney.ReferenceWithMetaMoneyBuilder getOrCreateNotionalReference() {
            ReferenceWithMetaMoney.ReferenceWithMetaMoneyBuilder result = this.notionalReference != null ? this.notionalReference : (this.notionalReference = ReferenceWithMetaMoney.builder());
            return result;
        }

        @Override
        public ExerciseFeeBuilder setFeeAmount(BigDecimal feeAmount) {
            this.feeAmount = feeAmount == null ? null : feeAmount;
            return this;
        }

        @Override
        public ExerciseFeeBuilder setFeePaymentDate(RelativeDateOffset feePaymentDate) {
            this.feePaymentDate = feePaymentDate == null ? null : feePaymentDate.toBuilder();
            return this;
        }

        @Override
        public ExerciseFeeBuilder setFeeRate(BigDecimal feeRate) {
            this.feeRate = feeRate == null ? null : feeRate;
            return this;
        }

        @Override
        public ExerciseFeeBuilder setNotionalReference(ReferenceWithMetaMoney notionalReference) {
            this.notionalReference = notionalReference == null ? null : notionalReference.toBuilder();
            return this;
        }

        @Override
        public ExerciseFeeBuilder setNotionalReferenceValue(Money notionalReference) {
            this.getOrCreateNotionalReference().setValue(notionalReference);
            return this;
        }

        @Override
        public ExerciseFeeBuilder setPayer(CounterpartyRoleEnum payer) {
            this.payer = payer == null ? null : payer;
            return this;
        }

        @Override
        public ExerciseFeeBuilder setReceiver(CounterpartyRoleEnum receiver) {
            this.receiver = receiver == null ? null : receiver;
            return this;
        }

        @Override
        public ExerciseFee build() {
            return new ExerciseFeeImpl(this);
        }

        @Override
        public ExerciseFeeBuilder toBuilder() {
            return this;
        }

        @Override
        public ExerciseFeeBuilder prune() {
            super.prune();
            if (this.feePaymentDate != null && !this.feePaymentDate.prune().hasData()) {
                this.feePaymentDate = null;
            }
            if (this.notionalReference != null && !this.notionalReference.prune().hasData()) {
                this.notionalReference = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getFeeAmount() != null) {
                return true;
            }
            if (this.getFeePaymentDate() != null && this.getFeePaymentDate().hasData()) {
                return true;
            }
            if (this.getFeeRate() != null) {
                return true;
            }
            return this.getNotionalReference() != null && this.getNotionalReference().hasData();
        }

        @Override
        public ExerciseFeeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ExerciseFeeBuilder o = (ExerciseFeeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFeePaymentDate(), (RosettaModelObjectBuilder)o.getFeePaymentDate(), this::setFeePaymentDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotionalReference(), (RosettaModelObjectBuilder)o.getNotionalReference(), this::setNotionalReference);
            merger.mergeBasic((Object)this.getFeeAmount(), (Object)o.getFeeAmount(), this::setFeeAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFeeRate(), (Object)o.getFeeRate(), this::setFeeRate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ExerciseFee _that = (ExerciseFee)this.getType().cast(o);
            if (!Objects.equals(this.feeAmount, _that.getFeeAmount())) {
                return false;
            }
            if (!Objects.equals(this.feePaymentDate, _that.getFeePaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.feeRate, _that.getFeeRate())) {
                return false;
            }
            return Objects.equals(this.notionalReference, _that.getNotionalReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.feeAmount != null ? this.feeAmount.hashCode() : 0);
            _result = 31 * _result + (this.feePaymentDate != null ? this.feePaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.feeRate != null ? this.feeRate.hashCode() : 0);
            _result = 31 * _result + (this.notionalReference != null ? this.notionalReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ExerciseFeeBuilder {feeAmount=" + this.feeAmount + ", feePaymentDate=" + this.feePaymentDate + ", feeRate=" + this.feeRate + ", notionalReference=" + this.notionalReference + '}' + " " + super.toString();
        }
    }

    public static class ExerciseFeeImpl
    extends PayerReceiver.PayerReceiverImpl
    implements ExerciseFee {
        private final BigDecimal feeAmount;
        private final RelativeDateOffset feePaymentDate;
        private final BigDecimal feeRate;
        private final ReferenceWithMetaMoney notionalReference;

        protected ExerciseFeeImpl(ExerciseFeeBuilder builder) {
            super(builder);
            this.feeAmount = builder.getFeeAmount();
            this.feePaymentDate = Optional.ofNullable(builder.getFeePaymentDate()).map(f -> f.build()).orElse(null);
            this.feeRate = builder.getFeeRate();
            this.notionalReference = Optional.ofNullable(builder.getNotionalReference()).map(f -> f.build()).orElse(null);
        }

        @Override
        public BigDecimal getFeeAmount() {
            return this.feeAmount;
        }

        @Override
        public RelativeDateOffset getFeePaymentDate() {
            return this.feePaymentDate;
        }

        @Override
        public BigDecimal getFeeRate() {
            return this.feeRate;
        }

        @Override
        public ReferenceWithMetaMoney getNotionalReference() {
            return this.notionalReference;
        }

        @Override
        public ExerciseFee build() {
            return this;
        }

        @Override
        public ExerciseFeeBuilder toBuilder() {
            ExerciseFeeBuilder builder = ExerciseFee.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ExerciseFeeBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getFeeAmount()).ifPresent(builder::setFeeAmount);
            Optional.ofNullable(this.getFeePaymentDate()).ifPresent(builder::setFeePaymentDate);
            Optional.ofNullable(this.getFeeRate()).ifPresent(builder::setFeeRate);
            Optional.ofNullable(this.getNotionalReference()).ifPresent(builder::setNotionalReference);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ExerciseFee _that = (ExerciseFee)this.getType().cast(o);
            if (!Objects.equals(this.feeAmount, _that.getFeeAmount())) {
                return false;
            }
            if (!Objects.equals(this.feePaymentDate, _that.getFeePaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.feeRate, _that.getFeeRate())) {
                return false;
            }
            return Objects.equals(this.notionalReference, _that.getNotionalReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.feeAmount != null ? this.feeAmount.hashCode() : 0);
            _result = 31 * _result + (this.feePaymentDate != null ? this.feePaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.feeRate != null ? this.feeRate.hashCode() : 0);
            _result = 31 * _result + (this.notionalReference != null ? this.notionalReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ExerciseFee {feeAmount=" + this.feeAmount + ", feePaymentDate=" + this.feePaymentDate + ", feeRate=" + this.feeRate + ", notionalReference=" + this.notionalReference + '}' + " " + super.toString();
        }
    }

    public static interface ExerciseFeeBuilder
    extends ExerciseFee,
    PayerReceiver.PayerReceiverBuilder,
    RosettaModelObjectBuilder {
        public RelativeDateOffset.RelativeDateOffsetBuilder getOrCreateFeePaymentDate();

        @Override
        public RelativeDateOffset.RelativeDateOffsetBuilder getFeePaymentDate();

        public ReferenceWithMetaMoney.ReferenceWithMetaMoneyBuilder getOrCreateNotionalReference();

        @Override
        public ReferenceWithMetaMoney.ReferenceWithMetaMoneyBuilder getNotionalReference();

        public ExerciseFeeBuilder setFeeAmount(BigDecimal var1);

        public ExerciseFeeBuilder setFeePaymentDate(RelativeDateOffset var1);

        public ExerciseFeeBuilder setFeeRate(BigDecimal var1);

        public ExerciseFeeBuilder setNotionalReference(ReferenceWithMetaMoney var1);

        public ExerciseFeeBuilder setNotionalReferenceValue(Money var1);

        @Override
        public ExerciseFeeBuilder setPayer(CounterpartyRoleEnum var1);

        @Override
        public ExerciseFeeBuilder setReceiver(CounterpartyRoleEnum var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            PayerReceiver.PayerReceiverBuilder.super.process(path, processor);
            processor.processBasic(path.newSubPath("feeAmount"), BigDecimal.class, (Object)this.getFeeAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("feeRate"), BigDecimal.class, (Object)this.getFeeRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("feePaymentDate"), processor, RelativeDateOffset.RelativeDateOffsetBuilder.class, this.getFeePaymentDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalReference"), processor, ReferenceWithMetaMoney.ReferenceWithMetaMoneyBuilder.class, this.getNotionalReference(), new AttributeMeta[0]);
        }

        @Override
        public ExerciseFeeBuilder prune();
    }
}

