/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.datetime.AdjustableRelativeOrPeriodicDates;
import cdm.base.datetime.RelativeDateOffset;
import cdm.base.staticdata.party.PartyRole;
import cdm.observable.asset.Price;
import cdm.product.template.meta.EvergreenProvisionMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface EvergreenProvision
extends RosettaModelObject {
    public static final EvergreenProvisionMeta metaData = new EvergreenProvisionMeta();

    public EvergreenProvision build();

    public EvergreenProvisionBuilder toBuilder();

    public AdjustableRelativeOrPeriodicDates getExtensionFrequency();

    public Price getFinalPeriodFeeAdjustment();

    public ZonedDateTime getNoticeDeadlineDateTime();

    public RelativeDateOffset getNoticeDeadlinePeriod();

    public RelativeDateOffset getNoticePeriod();

    public PartyRole getSinglePartyOption();

    default public RosettaMetaData<? extends EvergreenProvision> metaData() {
        return metaData;
    }

    public static EvergreenProvisionBuilder builder() {
        return new EvergreenProvisionBuilderImpl();
    }

    default public Class<? extends EvergreenProvision> getType() {
        return EvergreenProvision.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("noticeDeadlineDateTime"), ZonedDateTime.class, (Object)this.getNoticeDeadlineDateTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("extensionFrequency"), processor, AdjustableRelativeOrPeriodicDates.class, this.getExtensionFrequency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("finalPeriodFeeAdjustment"), processor, Price.class, this.getFinalPeriodFeeAdjustment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("noticeDeadlinePeriod"), processor, RelativeDateOffset.class, this.getNoticeDeadlinePeriod(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("noticePeriod"), processor, RelativeDateOffset.class, this.getNoticePeriod(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("singlePartyOption"), processor, PartyRole.class, this.getSinglePartyOption(), new AttributeMeta[0]);
    }

    public static class EvergreenProvisionBuilderImpl
    implements EvergreenProvisionBuilder {
        protected AdjustableRelativeOrPeriodicDates.AdjustableRelativeOrPeriodicDatesBuilder extensionFrequency;
        protected Price.PriceBuilder finalPeriodFeeAdjustment;
        protected ZonedDateTime noticeDeadlineDateTime;
        protected RelativeDateOffset.RelativeDateOffsetBuilder noticeDeadlinePeriod;
        protected RelativeDateOffset.RelativeDateOffsetBuilder noticePeriod;
        protected PartyRole.PartyRoleBuilder singlePartyOption;

        @Override
        public AdjustableRelativeOrPeriodicDates.AdjustableRelativeOrPeriodicDatesBuilder getExtensionFrequency() {
            return this.extensionFrequency;
        }

        @Override
        public AdjustableRelativeOrPeriodicDates.AdjustableRelativeOrPeriodicDatesBuilder getOrCreateExtensionFrequency() {
            AdjustableRelativeOrPeriodicDates.AdjustableRelativeOrPeriodicDatesBuilder result = this.extensionFrequency != null ? this.extensionFrequency : (this.extensionFrequency = AdjustableRelativeOrPeriodicDates.builder());
            return result;
        }

        @Override
        public Price.PriceBuilder getFinalPeriodFeeAdjustment() {
            return this.finalPeriodFeeAdjustment;
        }

        @Override
        public Price.PriceBuilder getOrCreateFinalPeriodFeeAdjustment() {
            Price.PriceBuilder result = this.finalPeriodFeeAdjustment != null ? this.finalPeriodFeeAdjustment : (this.finalPeriodFeeAdjustment = Price.builder());
            return result;
        }

        @Override
        public ZonedDateTime getNoticeDeadlineDateTime() {
            return this.noticeDeadlineDateTime;
        }

        @Override
        public RelativeDateOffset.RelativeDateOffsetBuilder getNoticeDeadlinePeriod() {
            return this.noticeDeadlinePeriod;
        }

        @Override
        public RelativeDateOffset.RelativeDateOffsetBuilder getOrCreateNoticeDeadlinePeriod() {
            RelativeDateOffset.RelativeDateOffsetBuilder result = this.noticeDeadlinePeriod != null ? this.noticeDeadlinePeriod : (this.noticeDeadlinePeriod = RelativeDateOffset.builder());
            return result;
        }

        @Override
        public RelativeDateOffset.RelativeDateOffsetBuilder getNoticePeriod() {
            return this.noticePeriod;
        }

        @Override
        public RelativeDateOffset.RelativeDateOffsetBuilder getOrCreateNoticePeriod() {
            RelativeDateOffset.RelativeDateOffsetBuilder result = this.noticePeriod != null ? this.noticePeriod : (this.noticePeriod = RelativeDateOffset.builder());
            return result;
        }

        @Override
        public PartyRole.PartyRoleBuilder getSinglePartyOption() {
            return this.singlePartyOption;
        }

        @Override
        public PartyRole.PartyRoleBuilder getOrCreateSinglePartyOption() {
            PartyRole.PartyRoleBuilder result = this.singlePartyOption != null ? this.singlePartyOption : (this.singlePartyOption = PartyRole.builder());
            return result;
        }

        @Override
        public EvergreenProvisionBuilder setExtensionFrequency(AdjustableRelativeOrPeriodicDates extensionFrequency) {
            this.extensionFrequency = extensionFrequency == null ? null : extensionFrequency.toBuilder();
            return this;
        }

        @Override
        public EvergreenProvisionBuilder setFinalPeriodFeeAdjustment(Price finalPeriodFeeAdjustment) {
            this.finalPeriodFeeAdjustment = finalPeriodFeeAdjustment == null ? null : finalPeriodFeeAdjustment.toBuilder();
            return this;
        }

        @Override
        public EvergreenProvisionBuilder setNoticeDeadlineDateTime(ZonedDateTime noticeDeadlineDateTime) {
            this.noticeDeadlineDateTime = noticeDeadlineDateTime == null ? null : noticeDeadlineDateTime;
            return this;
        }

        @Override
        public EvergreenProvisionBuilder setNoticeDeadlinePeriod(RelativeDateOffset noticeDeadlinePeriod) {
            this.noticeDeadlinePeriod = noticeDeadlinePeriod == null ? null : noticeDeadlinePeriod.toBuilder();
            return this;
        }

        @Override
        public EvergreenProvisionBuilder setNoticePeriod(RelativeDateOffset noticePeriod) {
            this.noticePeriod = noticePeriod == null ? null : noticePeriod.toBuilder();
            return this;
        }

        @Override
        public EvergreenProvisionBuilder setSinglePartyOption(PartyRole singlePartyOption) {
            this.singlePartyOption = singlePartyOption == null ? null : singlePartyOption.toBuilder();
            return this;
        }

        @Override
        public EvergreenProvision build() {
            return new EvergreenProvisionImpl(this);
        }

        @Override
        public EvergreenProvisionBuilder toBuilder() {
            return this;
        }

        @Override
        public EvergreenProvisionBuilder prune() {
            if (this.extensionFrequency != null && !this.extensionFrequency.prune().hasData()) {
                this.extensionFrequency = null;
            }
            if (this.finalPeriodFeeAdjustment != null && !this.finalPeriodFeeAdjustment.prune().hasData()) {
                this.finalPeriodFeeAdjustment = null;
            }
            if (this.noticeDeadlinePeriod != null && !this.noticeDeadlinePeriod.prune().hasData()) {
                this.noticeDeadlinePeriod = null;
            }
            if (this.noticePeriod != null && !this.noticePeriod.prune().hasData()) {
                this.noticePeriod = null;
            }
            if (this.singlePartyOption != null && !this.singlePartyOption.prune().hasData()) {
                this.singlePartyOption = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getExtensionFrequency() != null && this.getExtensionFrequency().hasData()) {
                return true;
            }
            if (this.getFinalPeriodFeeAdjustment() != null && this.getFinalPeriodFeeAdjustment().hasData()) {
                return true;
            }
            if (this.getNoticeDeadlineDateTime() != null) {
                return true;
            }
            if (this.getNoticeDeadlinePeriod() != null && this.getNoticeDeadlinePeriod().hasData()) {
                return true;
            }
            if (this.getNoticePeriod() != null && this.getNoticePeriod().hasData()) {
                return true;
            }
            return this.getSinglePartyOption() != null && this.getSinglePartyOption().hasData();
        }

        public EvergreenProvisionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            EvergreenProvisionBuilder o = (EvergreenProvisionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExtensionFrequency(), (RosettaModelObjectBuilder)o.getExtensionFrequency(), this::setExtensionFrequency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFinalPeriodFeeAdjustment(), (RosettaModelObjectBuilder)o.getFinalPeriodFeeAdjustment(), this::setFinalPeriodFeeAdjustment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNoticeDeadlinePeriod(), (RosettaModelObjectBuilder)o.getNoticeDeadlinePeriod(), this::setNoticeDeadlinePeriod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNoticePeriod(), (RosettaModelObjectBuilder)o.getNoticePeriod(), this::setNoticePeriod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSinglePartyOption(), (RosettaModelObjectBuilder)o.getSinglePartyOption(), this::setSinglePartyOption);
            merger.mergeBasic((Object)this.getNoticeDeadlineDateTime(), (Object)o.getNoticeDeadlineDateTime(), this::setNoticeDeadlineDateTime, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EvergreenProvision _that = this.getType().cast(o);
            if (!Objects.equals(this.extensionFrequency, _that.getExtensionFrequency())) {
                return false;
            }
            if (!Objects.equals(this.finalPeriodFeeAdjustment, _that.getFinalPeriodFeeAdjustment())) {
                return false;
            }
            if (!Objects.equals(this.noticeDeadlineDateTime, _that.getNoticeDeadlineDateTime())) {
                return false;
            }
            if (!Objects.equals(this.noticeDeadlinePeriod, _that.getNoticeDeadlinePeriod())) {
                return false;
            }
            if (!Objects.equals(this.noticePeriod, _that.getNoticePeriod())) {
                return false;
            }
            return Objects.equals(this.singlePartyOption, _that.getSinglePartyOption());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.extensionFrequency != null ? this.extensionFrequency.hashCode() : 0);
            _result = 31 * _result + (this.finalPeriodFeeAdjustment != null ? this.finalPeriodFeeAdjustment.hashCode() : 0);
            _result = 31 * _result + (this.noticeDeadlineDateTime != null ? this.noticeDeadlineDateTime.hashCode() : 0);
            _result = 31 * _result + (this.noticeDeadlinePeriod != null ? this.noticeDeadlinePeriod.hashCode() : 0);
            _result = 31 * _result + (this.noticePeriod != null ? this.noticePeriod.hashCode() : 0);
            _result = 31 * _result + (this.singlePartyOption != null ? this.singlePartyOption.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EvergreenProvisionBuilder {extensionFrequency=" + this.extensionFrequency + ", finalPeriodFeeAdjustment=" + this.finalPeriodFeeAdjustment + ", noticeDeadlineDateTime=" + this.noticeDeadlineDateTime + ", noticeDeadlinePeriod=" + this.noticeDeadlinePeriod + ", noticePeriod=" + this.noticePeriod + ", singlePartyOption=" + this.singlePartyOption + '}';
        }
    }

    public static class EvergreenProvisionImpl
    implements EvergreenProvision {
        private final AdjustableRelativeOrPeriodicDates extensionFrequency;
        private final Price finalPeriodFeeAdjustment;
        private final ZonedDateTime noticeDeadlineDateTime;
        private final RelativeDateOffset noticeDeadlinePeriod;
        private final RelativeDateOffset noticePeriod;
        private final PartyRole singlePartyOption;

        protected EvergreenProvisionImpl(EvergreenProvisionBuilder builder) {
            this.extensionFrequency = Optional.ofNullable(builder.getExtensionFrequency()).map(f -> f.build()).orElse(null);
            this.finalPeriodFeeAdjustment = Optional.ofNullable(builder.getFinalPeriodFeeAdjustment()).map(f -> f.build()).orElse(null);
            this.noticeDeadlineDateTime = builder.getNoticeDeadlineDateTime();
            this.noticeDeadlinePeriod = Optional.ofNullable(builder.getNoticeDeadlinePeriod()).map(f -> f.build()).orElse(null);
            this.noticePeriod = Optional.ofNullable(builder.getNoticePeriod()).map(f -> f.build()).orElse(null);
            this.singlePartyOption = Optional.ofNullable(builder.getSinglePartyOption()).map(f -> f.build()).orElse(null);
        }

        @Override
        public AdjustableRelativeOrPeriodicDates getExtensionFrequency() {
            return this.extensionFrequency;
        }

        @Override
        public Price getFinalPeriodFeeAdjustment() {
            return this.finalPeriodFeeAdjustment;
        }

        @Override
        public ZonedDateTime getNoticeDeadlineDateTime() {
            return this.noticeDeadlineDateTime;
        }

        @Override
        public RelativeDateOffset getNoticeDeadlinePeriod() {
            return this.noticeDeadlinePeriod;
        }

        @Override
        public RelativeDateOffset getNoticePeriod() {
            return this.noticePeriod;
        }

        @Override
        public PartyRole getSinglePartyOption() {
            return this.singlePartyOption;
        }

        @Override
        public EvergreenProvision build() {
            return this;
        }

        @Override
        public EvergreenProvisionBuilder toBuilder() {
            EvergreenProvisionBuilder builder = EvergreenProvision.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EvergreenProvisionBuilder builder) {
            Optional.ofNullable(this.getExtensionFrequency()).ifPresent(builder::setExtensionFrequency);
            Optional.ofNullable(this.getFinalPeriodFeeAdjustment()).ifPresent(builder::setFinalPeriodFeeAdjustment);
            Optional.ofNullable(this.getNoticeDeadlineDateTime()).ifPresent(builder::setNoticeDeadlineDateTime);
            Optional.ofNullable(this.getNoticeDeadlinePeriod()).ifPresent(builder::setNoticeDeadlinePeriod);
            Optional.ofNullable(this.getNoticePeriod()).ifPresent(builder::setNoticePeriod);
            Optional.ofNullable(this.getSinglePartyOption()).ifPresent(builder::setSinglePartyOption);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EvergreenProvision _that = this.getType().cast(o);
            if (!Objects.equals(this.extensionFrequency, _that.getExtensionFrequency())) {
                return false;
            }
            if (!Objects.equals(this.finalPeriodFeeAdjustment, _that.getFinalPeriodFeeAdjustment())) {
                return false;
            }
            if (!Objects.equals(this.noticeDeadlineDateTime, _that.getNoticeDeadlineDateTime())) {
                return false;
            }
            if (!Objects.equals(this.noticeDeadlinePeriod, _that.getNoticeDeadlinePeriod())) {
                return false;
            }
            if (!Objects.equals(this.noticePeriod, _that.getNoticePeriod())) {
                return false;
            }
            return Objects.equals(this.singlePartyOption, _that.getSinglePartyOption());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.extensionFrequency != null ? this.extensionFrequency.hashCode() : 0);
            _result = 31 * _result + (this.finalPeriodFeeAdjustment != null ? this.finalPeriodFeeAdjustment.hashCode() : 0);
            _result = 31 * _result + (this.noticeDeadlineDateTime != null ? this.noticeDeadlineDateTime.hashCode() : 0);
            _result = 31 * _result + (this.noticeDeadlinePeriod != null ? this.noticeDeadlinePeriod.hashCode() : 0);
            _result = 31 * _result + (this.noticePeriod != null ? this.noticePeriod.hashCode() : 0);
            _result = 31 * _result + (this.singlePartyOption != null ? this.singlePartyOption.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EvergreenProvision {extensionFrequency=" + this.extensionFrequency + ", finalPeriodFeeAdjustment=" + this.finalPeriodFeeAdjustment + ", noticeDeadlineDateTime=" + this.noticeDeadlineDateTime + ", noticeDeadlinePeriod=" + this.noticeDeadlinePeriod + ", noticePeriod=" + this.noticePeriod + ", singlePartyOption=" + this.singlePartyOption + '}';
        }
    }

    public static interface EvergreenProvisionBuilder
    extends EvergreenProvision,
    RosettaModelObjectBuilder {
        public AdjustableRelativeOrPeriodicDates.AdjustableRelativeOrPeriodicDatesBuilder getOrCreateExtensionFrequency();

        @Override
        public AdjustableRelativeOrPeriodicDates.AdjustableRelativeOrPeriodicDatesBuilder getExtensionFrequency();

        public Price.PriceBuilder getOrCreateFinalPeriodFeeAdjustment();

        @Override
        public Price.PriceBuilder getFinalPeriodFeeAdjustment();

        public RelativeDateOffset.RelativeDateOffsetBuilder getOrCreateNoticeDeadlinePeriod();

        @Override
        public RelativeDateOffset.RelativeDateOffsetBuilder getNoticeDeadlinePeriod();

        public RelativeDateOffset.RelativeDateOffsetBuilder getOrCreateNoticePeriod();

        @Override
        public RelativeDateOffset.RelativeDateOffsetBuilder getNoticePeriod();

        public PartyRole.PartyRoleBuilder getOrCreateSinglePartyOption();

        @Override
        public PartyRole.PartyRoleBuilder getSinglePartyOption();

        public EvergreenProvisionBuilder setExtensionFrequency(AdjustableRelativeOrPeriodicDates var1);

        public EvergreenProvisionBuilder setFinalPeriodFeeAdjustment(Price var1);

        public EvergreenProvisionBuilder setNoticeDeadlineDateTime(ZonedDateTime var1);

        public EvergreenProvisionBuilder setNoticeDeadlinePeriod(RelativeDateOffset var1);

        public EvergreenProvisionBuilder setNoticePeriod(RelativeDateOffset var1);

        public EvergreenProvisionBuilder setSinglePartyOption(PartyRole var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("noticeDeadlineDateTime"), ZonedDateTime.class, (Object)this.getNoticeDeadlineDateTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("extensionFrequency"), processor, AdjustableRelativeOrPeriodicDates.AdjustableRelativeOrPeriodicDatesBuilder.class, this.getExtensionFrequency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("finalPeriodFeeAdjustment"), processor, Price.PriceBuilder.class, this.getFinalPeriodFeeAdjustment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("noticeDeadlinePeriod"), processor, RelativeDateOffset.RelativeDateOffsetBuilder.class, this.getNoticeDeadlinePeriod(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("noticePeriod"), processor, RelativeDateOffset.RelativeDateOffsetBuilder.class, this.getNoticePeriod(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("singlePartyOption"), processor, PartyRole.PartyRoleBuilder.class, this.getSinglePartyOption(), new AttributeMeta[0]);
        }

        public EvergreenProvisionBuilder prune();
    }
}

