/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.base.datetime.AdjustableOrRelativeDates;
import cdm.base.datetime.BusinessCenterTime;
import cdm.product.template.ExerciseFee;
import cdm.product.template.ExpirationTimeTypeEnum;
import cdm.product.template.PartialExercise;
import cdm.product.template.meta.EuropeanExerciseMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface EuropeanExercise
extends RosettaModelObject,
GlobalKey {
    public static final EuropeanExerciseMeta metaData = new EuropeanExerciseMeta();

    public EuropeanExercise build();

    public EuropeanExerciseBuilder toBuilder();

    public BusinessCenterTime getEarliestExerciseTime();

    public ExerciseFee getExerciseFee();

    public List<? extends AdjustableOrRelativeDate> getExpirationDate();

    public BusinessCenterTime getExpirationTime();

    public ExpirationTimeTypeEnum getExpirationTimeType();

    public MetaFields getMeta();

    public PartialExercise getPartialExercise();

    public AdjustableOrRelativeDates getRelevantUnderlyingDate();

    default public RosettaMetaData<? extends EuropeanExercise> metaData() {
        return metaData;
    }

    public static EuropeanExerciseBuilder builder() {
        return new EuropeanExerciseBuilderImpl();
    }

    default public Class<? extends EuropeanExercise> getType() {
        return EuropeanExercise.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("expirationTimeType"), ExpirationTimeTypeEnum.class, (Object)this.getExpirationTimeType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("earliestExerciseTime"), processor, BusinessCenterTime.class, this.getEarliestExerciseTime(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseFee"), processor, ExerciseFee.class, this.getExerciseFee(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("expirationDate"), processor, AdjustableOrRelativeDate.class, this.getExpirationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("expirationTime"), processor, BusinessCenterTime.class, this.getExpirationTime(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partialExercise"), processor, PartialExercise.class, this.getPartialExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relevantUnderlyingDate"), processor, AdjustableOrRelativeDates.class, this.getRelevantUnderlyingDate(), new AttributeMeta[0]);
    }

    public static class EuropeanExerciseBuilderImpl
    implements EuropeanExerciseBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected BusinessCenterTime.BusinessCenterTimeBuilder earliestExerciseTime;
        protected ExerciseFee.ExerciseFeeBuilder exerciseFee;
        protected List<AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder> expirationDate = new ArrayList<AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder>();
        protected BusinessCenterTime.BusinessCenterTimeBuilder expirationTime;
        protected ExpirationTimeTypeEnum expirationTimeType;
        protected MetaFields.MetaFieldsBuilder meta;
        protected PartialExercise.PartialExerciseBuilder partialExercise;
        protected AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder relevantUnderlyingDate;

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getEarliestExerciseTime() {
            return this.earliestExerciseTime;
        }

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateEarliestExerciseTime() {
            BusinessCenterTime.BusinessCenterTimeBuilder result = this.earliestExerciseTime != null ? this.earliestExerciseTime : (this.earliestExerciseTime = BusinessCenterTime.builder());
            return result;
        }

        @Override
        public ExerciseFee.ExerciseFeeBuilder getExerciseFee() {
            return this.exerciseFee;
        }

        @Override
        public ExerciseFee.ExerciseFeeBuilder getOrCreateExerciseFee() {
            ExerciseFee.ExerciseFeeBuilder result = this.exerciseFee != null ? this.exerciseFee : (this.exerciseFee = ExerciseFee.builder());
            return result;
        }

        @Override
        public List<? extends AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder> getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateExpirationDate(int _index) {
            if (this.expirationDate == null) {
                this.expirationDate = new ArrayList<AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder>();
            }
            return (AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder)this.getIndex(this.expirationDate, _index, () -> {
                AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder newExpirationDate = AdjustableOrRelativeDate.builder();
                return newExpirationDate;
            });
        }

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getExpirationTime() {
            return this.expirationTime;
        }

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateExpirationTime() {
            BusinessCenterTime.BusinessCenterTimeBuilder result = this.expirationTime != null ? this.expirationTime : (this.expirationTime = BusinessCenterTime.builder());
            return result;
        }

        @Override
        public ExpirationTimeTypeEnum getExpirationTimeType() {
            return this.expirationTimeType;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public PartialExercise.PartialExerciseBuilder getPartialExercise() {
            return this.partialExercise;
        }

        @Override
        public PartialExercise.PartialExerciseBuilder getOrCreatePartialExercise() {
            PartialExercise.PartialExerciseBuilder result = this.partialExercise != null ? this.partialExercise : (this.partialExercise = PartialExercise.builder());
            return result;
        }

        @Override
        public AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder getRelevantUnderlyingDate() {
            return this.relevantUnderlyingDate;
        }

        @Override
        public AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder getOrCreateRelevantUnderlyingDate() {
            AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder result = this.relevantUnderlyingDate != null ? this.relevantUnderlyingDate : (this.relevantUnderlyingDate = AdjustableOrRelativeDates.builder());
            return result;
        }

        @Override
        public EuropeanExerciseBuilder setEarliestExerciseTime(BusinessCenterTime earliestExerciseTime) {
            this.earliestExerciseTime = earliestExerciseTime == null ? null : earliestExerciseTime.toBuilder();
            return this;
        }

        @Override
        public EuropeanExerciseBuilder setExerciseFee(ExerciseFee exerciseFee) {
            this.exerciseFee = exerciseFee == null ? null : exerciseFee.toBuilder();
            return this;
        }

        @Override
        public EuropeanExerciseBuilder addExpirationDate(AdjustableOrRelativeDate expirationDate) {
            if (expirationDate != null) {
                this.expirationDate.add(expirationDate.toBuilder());
            }
            return this;
        }

        @Override
        public EuropeanExerciseBuilder addExpirationDate(AdjustableOrRelativeDate expirationDate, int _idx) {
            this.getIndex(this.expirationDate, _idx, () -> expirationDate.toBuilder());
            return this;
        }

        @Override
        public EuropeanExerciseBuilder addExpirationDate(List<? extends AdjustableOrRelativeDate> expirationDates) {
            if (expirationDates != null) {
                for (AdjustableOrRelativeDate adjustableOrRelativeDate : expirationDates) {
                    this.expirationDate.add(adjustableOrRelativeDate.toBuilder());
                }
            }
            return this;
        }

        @Override
        public EuropeanExerciseBuilder setExpirationDate(List<? extends AdjustableOrRelativeDate> expirationDates) {
            this.expirationDate = expirationDates == null ? new ArrayList<AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder>() : (List)expirationDates.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public EuropeanExerciseBuilder setExpirationTime(BusinessCenterTime expirationTime) {
            this.expirationTime = expirationTime == null ? null : expirationTime.toBuilder();
            return this;
        }

        @Override
        public EuropeanExerciseBuilder setExpirationTimeType(ExpirationTimeTypeEnum expirationTimeType) {
            this.expirationTimeType = expirationTimeType == null ? null : expirationTimeType;
            return this;
        }

        @Override
        public EuropeanExerciseBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public EuropeanExerciseBuilder setPartialExercise(PartialExercise partialExercise) {
            this.partialExercise = partialExercise == null ? null : partialExercise.toBuilder();
            return this;
        }

        @Override
        public EuropeanExerciseBuilder setRelevantUnderlyingDate(AdjustableOrRelativeDates relevantUnderlyingDate) {
            this.relevantUnderlyingDate = relevantUnderlyingDate == null ? null : relevantUnderlyingDate.toBuilder();
            return this;
        }

        @Override
        public EuropeanExercise build() {
            return new EuropeanExerciseImpl(this);
        }

        @Override
        public EuropeanExerciseBuilder toBuilder() {
            return this;
        }

        @Override
        public EuropeanExerciseBuilder prune() {
            if (this.earliestExerciseTime != null && !this.earliestExerciseTime.prune().hasData()) {
                this.earliestExerciseTime = null;
            }
            if (this.exerciseFee != null && !this.exerciseFee.prune().hasData()) {
                this.exerciseFee = null;
            }
            this.expirationDate = this.expirationDate.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.expirationTime != null && !this.expirationTime.prune().hasData()) {
                this.expirationTime = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            if (this.partialExercise != null && !this.partialExercise.prune().hasData()) {
                this.partialExercise = null;
            }
            if (this.relevantUnderlyingDate != null && !this.relevantUnderlyingDate.prune().hasData()) {
                this.relevantUnderlyingDate = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getEarliestExerciseTime() != null && this.getEarliestExerciseTime().hasData()) {
                return true;
            }
            if (this.getExerciseFee() != null && this.getExerciseFee().hasData()) {
                return true;
            }
            if (this.getExpirationDate() != null && this.getExpirationDate().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getExpirationTime() != null && this.getExpirationTime().hasData()) {
                return true;
            }
            if (this.getExpirationTimeType() != null) {
                return true;
            }
            if (this.getPartialExercise() != null && this.getPartialExercise().hasData()) {
                return true;
            }
            return this.getRelevantUnderlyingDate() != null && this.getRelevantUnderlyingDate().hasData();
        }

        public EuropeanExerciseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            EuropeanExerciseBuilder o = (EuropeanExerciseBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEarliestExerciseTime(), (RosettaModelObjectBuilder)o.getEarliestExerciseTime(), this::setEarliestExerciseTime);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExerciseFee(), (RosettaModelObjectBuilder)o.getExerciseFee(), this::setExerciseFee);
            merger.mergeRosetta(this.getExpirationDate(), o.getExpirationDate(), this::getOrCreateExpirationDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExpirationTime(), (RosettaModelObjectBuilder)o.getExpirationTime(), this::setExpirationTime);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartialExercise(), (RosettaModelObjectBuilder)o.getPartialExercise(), this::setPartialExercise);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRelevantUnderlyingDate(), (RosettaModelObjectBuilder)o.getRelevantUnderlyingDate(), this::setRelevantUnderlyingDate);
            merger.mergeBasic((Object)this.getExpirationTimeType(), (Object)o.getExpirationTimeType(), this::setExpirationTimeType, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EuropeanExercise _that = this.getType().cast(o);
            if (!Objects.equals(this.earliestExerciseTime, _that.getEarliestExerciseTime())) {
                return false;
            }
            if (!Objects.equals(this.exerciseFee, _that.getExerciseFee())) {
                return false;
            }
            if (!ListEquals.listEquals(this.expirationDate, _that.getExpirationDate())) {
                return false;
            }
            if (!Objects.equals(this.expirationTime, _that.getExpirationTime())) {
                return false;
            }
            if (!Objects.equals((Object)this.expirationTimeType, (Object)_that.getExpirationTimeType())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.partialExercise, _that.getPartialExercise())) {
                return false;
            }
            return Objects.equals(this.relevantUnderlyingDate, _that.getRelevantUnderlyingDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.earliestExerciseTime != null ? this.earliestExerciseTime.hashCode() : 0);
            _result = 31 * _result + (this.exerciseFee != null ? this.exerciseFee.hashCode() : 0);
            _result = 31 * _result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            _result = 31 * _result + (this.expirationTime != null ? this.expirationTime.hashCode() : 0);
            _result = 31 * _result + (this.expirationTimeType != null ? ((Object)((Object)this.expirationTimeType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.partialExercise != null ? this.partialExercise.hashCode() : 0);
            _result = 31 * _result + (this.relevantUnderlyingDate != null ? this.relevantUnderlyingDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EuropeanExerciseBuilder {earliestExerciseTime=" + this.earliestExerciseTime + ", exerciseFee=" + this.exerciseFee + ", expirationDate=" + this.expirationDate + ", expirationTime=" + this.expirationTime + ", expirationTimeType=" + (Object)((Object)this.expirationTimeType) + ", meta=" + this.meta + ", partialExercise=" + this.partialExercise + ", relevantUnderlyingDate=" + this.relevantUnderlyingDate + '}';
        }
    }

    public static class EuropeanExerciseImpl
    implements EuropeanExercise {
        private final BusinessCenterTime earliestExerciseTime;
        private final ExerciseFee exerciseFee;
        private final List<? extends AdjustableOrRelativeDate> expirationDate;
        private final BusinessCenterTime expirationTime;
        private final ExpirationTimeTypeEnum expirationTimeType;
        private final MetaFields meta;
        private final PartialExercise partialExercise;
        private final AdjustableOrRelativeDates relevantUnderlyingDate;

        protected EuropeanExerciseImpl(EuropeanExerciseBuilder builder) {
            this.earliestExerciseTime = Optional.ofNullable(builder.getEarliestExerciseTime()).map(f -> f.build()).orElse(null);
            this.exerciseFee = Optional.ofNullable(builder.getExerciseFee()).map(f -> f.build()).orElse(null);
            this.expirationDate = Optional.ofNullable(builder.getExpirationDate()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.expirationTime = Optional.ofNullable(builder.getExpirationTime()).map(f -> f.build()).orElse(null);
            this.expirationTimeType = builder.getExpirationTimeType();
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
            this.partialExercise = Optional.ofNullable(builder.getPartialExercise()).map(f -> f.build()).orElse(null);
            this.relevantUnderlyingDate = Optional.ofNullable(builder.getRelevantUnderlyingDate()).map(f -> f.build()).orElse(null);
        }

        @Override
        public BusinessCenterTime getEarliestExerciseTime() {
            return this.earliestExerciseTime;
        }

        @Override
        public ExerciseFee getExerciseFee() {
            return this.exerciseFee;
        }

        @Override
        public List<? extends AdjustableOrRelativeDate> getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        public BusinessCenterTime getExpirationTime() {
            return this.expirationTime;
        }

        @Override
        public ExpirationTimeTypeEnum getExpirationTimeType() {
            return this.expirationTimeType;
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public PartialExercise getPartialExercise() {
            return this.partialExercise;
        }

        @Override
        public AdjustableOrRelativeDates getRelevantUnderlyingDate() {
            return this.relevantUnderlyingDate;
        }

        @Override
        public EuropeanExercise build() {
            return this;
        }

        @Override
        public EuropeanExerciseBuilder toBuilder() {
            EuropeanExerciseBuilder builder = EuropeanExercise.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EuropeanExerciseBuilder builder) {
            Optional.ofNullable(this.getEarliestExerciseTime()).ifPresent(builder::setEarliestExerciseTime);
            Optional.ofNullable(this.getExerciseFee()).ifPresent(builder::setExerciseFee);
            Optional.ofNullable(this.getExpirationDate()).ifPresent(builder::setExpirationDate);
            Optional.ofNullable(this.getExpirationTime()).ifPresent(builder::setExpirationTime);
            Optional.ofNullable(this.getExpirationTimeType()).ifPresent(builder::setExpirationTimeType);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
            Optional.ofNullable(this.getPartialExercise()).ifPresent(builder::setPartialExercise);
            Optional.ofNullable(this.getRelevantUnderlyingDate()).ifPresent(builder::setRelevantUnderlyingDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EuropeanExercise _that = this.getType().cast(o);
            if (!Objects.equals(this.earliestExerciseTime, _that.getEarliestExerciseTime())) {
                return false;
            }
            if (!Objects.equals(this.exerciseFee, _that.getExerciseFee())) {
                return false;
            }
            if (!ListEquals.listEquals(this.expirationDate, _that.getExpirationDate())) {
                return false;
            }
            if (!Objects.equals(this.expirationTime, _that.getExpirationTime())) {
                return false;
            }
            if (!Objects.equals((Object)this.expirationTimeType, (Object)_that.getExpirationTimeType())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.partialExercise, _that.getPartialExercise())) {
                return false;
            }
            return Objects.equals(this.relevantUnderlyingDate, _that.getRelevantUnderlyingDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.earliestExerciseTime != null ? this.earliestExerciseTime.hashCode() : 0);
            _result = 31 * _result + (this.exerciseFee != null ? this.exerciseFee.hashCode() : 0);
            _result = 31 * _result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            _result = 31 * _result + (this.expirationTime != null ? this.expirationTime.hashCode() : 0);
            _result = 31 * _result + (this.expirationTimeType != null ? ((Object)((Object)this.expirationTimeType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.partialExercise != null ? this.partialExercise.hashCode() : 0);
            _result = 31 * _result + (this.relevantUnderlyingDate != null ? this.relevantUnderlyingDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EuropeanExercise {earliestExerciseTime=" + this.earliestExerciseTime + ", exerciseFee=" + this.exerciseFee + ", expirationDate=" + this.expirationDate + ", expirationTime=" + this.expirationTime + ", expirationTimeType=" + (Object)((Object)this.expirationTimeType) + ", meta=" + this.meta + ", partialExercise=" + this.partialExercise + ", relevantUnderlyingDate=" + this.relevantUnderlyingDate + '}';
        }
    }

    public static interface EuropeanExerciseBuilder
    extends EuropeanExercise,
    RosettaModelObjectBuilder {
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateEarliestExerciseTime();

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getEarliestExerciseTime();

        public ExerciseFee.ExerciseFeeBuilder getOrCreateExerciseFee();

        @Override
        public ExerciseFee.ExerciseFeeBuilder getExerciseFee();

        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateExpirationDate(int var1);

        public List<? extends AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder> getExpirationDate();

        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateExpirationTime();

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getExpirationTime();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public PartialExercise.PartialExerciseBuilder getOrCreatePartialExercise();

        @Override
        public PartialExercise.PartialExerciseBuilder getPartialExercise();

        public AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder getOrCreateRelevantUnderlyingDate();

        @Override
        public AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder getRelevantUnderlyingDate();

        public EuropeanExerciseBuilder setEarliestExerciseTime(BusinessCenterTime var1);

        public EuropeanExerciseBuilder setExerciseFee(ExerciseFee var1);

        public EuropeanExerciseBuilder addExpirationDate(AdjustableOrRelativeDate var1);

        public EuropeanExerciseBuilder addExpirationDate(AdjustableOrRelativeDate var1, int var2);

        public EuropeanExerciseBuilder addExpirationDate(List<? extends AdjustableOrRelativeDate> var1);

        public EuropeanExerciseBuilder setExpirationDate(List<? extends AdjustableOrRelativeDate> var1);

        public EuropeanExerciseBuilder setExpirationTime(BusinessCenterTime var1);

        public EuropeanExerciseBuilder setExpirationTimeType(ExpirationTimeTypeEnum var1);

        public EuropeanExerciseBuilder setMeta(MetaFields var1);

        public EuropeanExerciseBuilder setPartialExercise(PartialExercise var1);

        public EuropeanExerciseBuilder setRelevantUnderlyingDate(AdjustableOrRelativeDates var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("expirationTimeType"), ExpirationTimeTypeEnum.class, (Object)this.getExpirationTimeType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("earliestExerciseTime"), processor, BusinessCenterTime.BusinessCenterTimeBuilder.class, this.getEarliestExerciseTime(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseFee"), processor, ExerciseFee.ExerciseFeeBuilder.class, this.getExerciseFee(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("expirationDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getExpirationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("expirationTime"), processor, BusinessCenterTime.BusinessCenterTimeBuilder.class, this.getExpirationTime(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partialExercise"), processor, PartialExercise.PartialExerciseBuilder.class, this.getPartialExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relevantUnderlyingDate"), processor, AdjustableOrRelativeDates.AdjustableOrRelativeDatesBuilder.class, this.getRelevantUnderlyingDate(), new AttributeMeta[0]);
        }

        public EuropeanExerciseBuilder prune();
    }
}

