/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.base.datetime.BusinessDayAdjustments;
import cdm.observable.asset.CalculationAgent;
import cdm.observable.event.ExtraordinaryEvents;
import cdm.product.collateral.Collateral;
import cdm.product.template.Payout;
import cdm.product.template.TerminationProvision;
import cdm.product.template.meta.EconomicTermsMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface EconomicTerms
extends RosettaModelObject {
    public static final EconomicTermsMeta metaData = new EconomicTermsMeta();

    public EconomicTerms build();

    public EconomicTermsBuilder toBuilder();

    public CalculationAgent getCalculationAgent();

    public Collateral getCollateral();

    public BusinessDayAdjustments getDateAdjustments();

    public AdjustableOrRelativeDate getEffectiveDate();

    public ExtraordinaryEvents getExtraordinaryEvents();

    public Boolean getNonStandardisedTerms();

    public Payout getPayout();

    public AdjustableOrRelativeDate getTerminationDate();

    public TerminationProvision getTerminationProvision();

    default public RosettaMetaData<? extends EconomicTerms> metaData() {
        return metaData;
    }

    public static EconomicTermsBuilder builder() {
        return new EconomicTermsBuilderImpl();
    }

    default public Class<? extends EconomicTerms> getType() {
        return EconomicTerms.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("nonStandardisedTerms"), Boolean.class, (Object)this.getNonStandardisedTerms(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("calculationAgent"), processor, CalculationAgent.class, this.getCalculationAgent(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateral"), processor, Collateral.class, this.getCollateral(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dateAdjustments"), processor, BusinessDayAdjustments.class, this.getDateAdjustments(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.class, this.getEffectiveDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("extraordinaryEvents"), processor, ExtraordinaryEvents.class, this.getExtraordinaryEvents(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payout"), processor, Payout.class, this.getPayout(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("terminationDate"), processor, AdjustableOrRelativeDate.class, this.getTerminationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("terminationProvision"), processor, TerminationProvision.class, this.getTerminationProvision(), new AttributeMeta[0]);
    }

    public static class EconomicTermsBuilderImpl
    implements EconomicTermsBuilder {
        protected CalculationAgent.CalculationAgentBuilder calculationAgent;
        protected Collateral.CollateralBuilder collateral;
        protected BusinessDayAdjustments.BusinessDayAdjustmentsBuilder dateAdjustments;
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder effectiveDate;
        protected ExtraordinaryEvents.ExtraordinaryEventsBuilder extraordinaryEvents;
        protected Boolean nonStandardisedTerms;
        protected Payout.PayoutBuilder payout;
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder terminationDate;
        protected TerminationProvision.TerminationProvisionBuilder terminationProvision;

        @Override
        public CalculationAgent.CalculationAgentBuilder getCalculationAgent() {
            return this.calculationAgent;
        }

        @Override
        public CalculationAgent.CalculationAgentBuilder getOrCreateCalculationAgent() {
            CalculationAgent.CalculationAgentBuilder result = this.calculationAgent != null ? this.calculationAgent : (this.calculationAgent = CalculationAgent.builder());
            return result;
        }

        @Override
        public Collateral.CollateralBuilder getCollateral() {
            return this.collateral;
        }

        @Override
        public Collateral.CollateralBuilder getOrCreateCollateral() {
            Collateral.CollateralBuilder result = this.collateral != null ? this.collateral : (this.collateral = Collateral.builder());
            return result;
        }

        @Override
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getDateAdjustments() {
            return this.dateAdjustments;
        }

        @Override
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getOrCreateDateAdjustments() {
            BusinessDayAdjustments.BusinessDayAdjustmentsBuilder result = this.dateAdjustments != null ? this.dateAdjustments : (this.dateAdjustments = BusinessDayAdjustments.builder());
            return result;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateEffectiveDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.effectiveDate != null ? this.effectiveDate : (this.effectiveDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        public ExtraordinaryEvents.ExtraordinaryEventsBuilder getExtraordinaryEvents() {
            return this.extraordinaryEvents;
        }

        @Override
        public ExtraordinaryEvents.ExtraordinaryEventsBuilder getOrCreateExtraordinaryEvents() {
            ExtraordinaryEvents.ExtraordinaryEventsBuilder result = this.extraordinaryEvents != null ? this.extraordinaryEvents : (this.extraordinaryEvents = ExtraordinaryEvents.builder());
            return result;
        }

        @Override
        public Boolean getNonStandardisedTerms() {
            return this.nonStandardisedTerms;
        }

        @Override
        public Payout.PayoutBuilder getPayout() {
            return this.payout;
        }

        @Override
        public Payout.PayoutBuilder getOrCreatePayout() {
            Payout.PayoutBuilder result = this.payout != null ? this.payout : (this.payout = Payout.builder());
            return result;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getTerminationDate() {
            return this.terminationDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateTerminationDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.terminationDate != null ? this.terminationDate : (this.terminationDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        public TerminationProvision.TerminationProvisionBuilder getTerminationProvision() {
            return this.terminationProvision;
        }

        @Override
        public TerminationProvision.TerminationProvisionBuilder getOrCreateTerminationProvision() {
            TerminationProvision.TerminationProvisionBuilder result = this.terminationProvision != null ? this.terminationProvision : (this.terminationProvision = TerminationProvision.builder());
            return result;
        }

        @Override
        public EconomicTermsBuilder setCalculationAgent(CalculationAgent calculationAgent) {
            this.calculationAgent = calculationAgent == null ? null : calculationAgent.toBuilder();
            return this;
        }

        @Override
        public EconomicTermsBuilder setCollateral(Collateral collateral) {
            this.collateral = collateral == null ? null : collateral.toBuilder();
            return this;
        }

        @Override
        public EconomicTermsBuilder setDateAdjustments(BusinessDayAdjustments dateAdjustments) {
            this.dateAdjustments = dateAdjustments == null ? null : dateAdjustments.toBuilder();
            return this;
        }

        @Override
        public EconomicTermsBuilder setEffectiveDate(AdjustableOrRelativeDate effectiveDate) {
            this.effectiveDate = effectiveDate == null ? null : effectiveDate.toBuilder();
            return this;
        }

        @Override
        public EconomicTermsBuilder setExtraordinaryEvents(ExtraordinaryEvents extraordinaryEvents) {
            this.extraordinaryEvents = extraordinaryEvents == null ? null : extraordinaryEvents.toBuilder();
            return this;
        }

        @Override
        public EconomicTermsBuilder setNonStandardisedTerms(Boolean nonStandardisedTerms) {
            this.nonStandardisedTerms = nonStandardisedTerms == null ? null : nonStandardisedTerms;
            return this;
        }

        @Override
        public EconomicTermsBuilder setPayout(Payout payout) {
            this.payout = payout == null ? null : payout.toBuilder();
            return this;
        }

        @Override
        public EconomicTermsBuilder setTerminationDate(AdjustableOrRelativeDate terminationDate) {
            this.terminationDate = terminationDate == null ? null : terminationDate.toBuilder();
            return this;
        }

        @Override
        public EconomicTermsBuilder setTerminationProvision(TerminationProvision terminationProvision) {
            this.terminationProvision = terminationProvision == null ? null : terminationProvision.toBuilder();
            return this;
        }

        @Override
        public EconomicTerms build() {
            return new EconomicTermsImpl(this);
        }

        @Override
        public EconomicTermsBuilder toBuilder() {
            return this;
        }

        @Override
        public EconomicTermsBuilder prune() {
            if (this.calculationAgent != null && !this.calculationAgent.prune().hasData()) {
                this.calculationAgent = null;
            }
            if (this.collateral != null && !this.collateral.prune().hasData()) {
                this.collateral = null;
            }
            if (this.dateAdjustments != null && !this.dateAdjustments.prune().hasData()) {
                this.dateAdjustments = null;
            }
            if (this.effectiveDate != null && !this.effectiveDate.prune().hasData()) {
                this.effectiveDate = null;
            }
            if (this.extraordinaryEvents != null && !this.extraordinaryEvents.prune().hasData()) {
                this.extraordinaryEvents = null;
            }
            if (this.payout != null && !this.payout.prune().hasData()) {
                this.payout = null;
            }
            if (this.terminationDate != null && !this.terminationDate.prune().hasData()) {
                this.terminationDate = null;
            }
            if (this.terminationProvision != null && !this.terminationProvision.prune().hasData()) {
                this.terminationProvision = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCalculationAgent() != null && this.getCalculationAgent().hasData()) {
                return true;
            }
            if (this.getCollateral() != null && this.getCollateral().hasData()) {
                return true;
            }
            if (this.getDateAdjustments() != null && this.getDateAdjustments().hasData()) {
                return true;
            }
            if (this.getEffectiveDate() != null && this.getEffectiveDate().hasData()) {
                return true;
            }
            if (this.getExtraordinaryEvents() != null && this.getExtraordinaryEvents().hasData()) {
                return true;
            }
            if (this.getNonStandardisedTerms() != null) {
                return true;
            }
            if (this.getPayout() != null && this.getPayout().hasData()) {
                return true;
            }
            if (this.getTerminationDate() != null && this.getTerminationDate().hasData()) {
                return true;
            }
            return this.getTerminationProvision() != null && this.getTerminationProvision().hasData();
        }

        public EconomicTermsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            EconomicTermsBuilder o = (EconomicTermsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCalculationAgent(), (RosettaModelObjectBuilder)o.getCalculationAgent(), this::setCalculationAgent);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCollateral(), (RosettaModelObjectBuilder)o.getCollateral(), this::setCollateral);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDateAdjustments(), (RosettaModelObjectBuilder)o.getDateAdjustments(), this::setDateAdjustments);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEffectiveDate(), (RosettaModelObjectBuilder)o.getEffectiveDate(), this::setEffectiveDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExtraordinaryEvents(), (RosettaModelObjectBuilder)o.getExtraordinaryEvents(), this::setExtraordinaryEvents);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPayout(), (RosettaModelObjectBuilder)o.getPayout(), this::setPayout);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTerminationDate(), (RosettaModelObjectBuilder)o.getTerminationDate(), this::setTerminationDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTerminationProvision(), (RosettaModelObjectBuilder)o.getTerminationProvision(), this::setTerminationProvision);
            merger.mergeBasic((Object)this.getNonStandardisedTerms(), (Object)o.getNonStandardisedTerms(), this::setNonStandardisedTerms, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EconomicTerms _that = this.getType().cast(o);
            if (!Objects.equals(this.calculationAgent, _that.getCalculationAgent())) {
                return false;
            }
            if (!Objects.equals(this.collateral, _that.getCollateral())) {
                return false;
            }
            if (!Objects.equals(this.dateAdjustments, _that.getDateAdjustments())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.extraordinaryEvents, _that.getExtraordinaryEvents())) {
                return false;
            }
            if (!Objects.equals(this.nonStandardisedTerms, _that.getNonStandardisedTerms())) {
                return false;
            }
            if (!Objects.equals(this.payout, _that.getPayout())) {
                return false;
            }
            if (!Objects.equals(this.terminationDate, _that.getTerminationDate())) {
                return false;
            }
            return Objects.equals(this.terminationProvision, _that.getTerminationProvision());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.calculationAgent != null ? this.calculationAgent.hashCode() : 0);
            _result = 31 * _result + (this.collateral != null ? this.collateral.hashCode() : 0);
            _result = 31 * _result + (this.dateAdjustments != null ? this.dateAdjustments.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.extraordinaryEvents != null ? this.extraordinaryEvents.hashCode() : 0);
            _result = 31 * _result + (this.nonStandardisedTerms != null ? this.nonStandardisedTerms.hashCode() : 0);
            _result = 31 * _result + (this.payout != null ? this.payout.hashCode() : 0);
            _result = 31 * _result + (this.terminationDate != null ? this.terminationDate.hashCode() : 0);
            _result = 31 * _result + (this.terminationProvision != null ? this.terminationProvision.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EconomicTermsBuilder {calculationAgent=" + this.calculationAgent + ", collateral=" + this.collateral + ", dateAdjustments=" + this.dateAdjustments + ", effectiveDate=" + this.effectiveDate + ", extraordinaryEvents=" + this.extraordinaryEvents + ", nonStandardisedTerms=" + this.nonStandardisedTerms + ", payout=" + this.payout + ", terminationDate=" + this.terminationDate + ", terminationProvision=" + this.terminationProvision + '}';
        }
    }

    public static class EconomicTermsImpl
    implements EconomicTerms {
        private final CalculationAgent calculationAgent;
        private final Collateral collateral;
        private final BusinessDayAdjustments dateAdjustments;
        private final AdjustableOrRelativeDate effectiveDate;
        private final ExtraordinaryEvents extraordinaryEvents;
        private final Boolean nonStandardisedTerms;
        private final Payout payout;
        private final AdjustableOrRelativeDate terminationDate;
        private final TerminationProvision terminationProvision;

        protected EconomicTermsImpl(EconomicTermsBuilder builder) {
            this.calculationAgent = Optional.ofNullable(builder.getCalculationAgent()).map(f -> f.build()).orElse(null);
            this.collateral = Optional.ofNullable(builder.getCollateral()).map(f -> f.build()).orElse(null);
            this.dateAdjustments = Optional.ofNullable(builder.getDateAdjustments()).map(f -> f.build()).orElse(null);
            this.effectiveDate = Optional.ofNullable(builder.getEffectiveDate()).map(f -> f.build()).orElse(null);
            this.extraordinaryEvents = Optional.ofNullable(builder.getExtraordinaryEvents()).map(f -> f.build()).orElse(null);
            this.nonStandardisedTerms = builder.getNonStandardisedTerms();
            this.payout = Optional.ofNullable(builder.getPayout()).map(f -> f.build()).orElse(null);
            this.terminationDate = Optional.ofNullable(builder.getTerminationDate()).map(f -> f.build()).orElse(null);
            this.terminationProvision = Optional.ofNullable(builder.getTerminationProvision()).map(f -> f.build()).orElse(null);
        }

        @Override
        public CalculationAgent getCalculationAgent() {
            return this.calculationAgent;
        }

        @Override
        public Collateral getCollateral() {
            return this.collateral;
        }

        @Override
        public BusinessDayAdjustments getDateAdjustments() {
            return this.dateAdjustments;
        }

        @Override
        public AdjustableOrRelativeDate getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        public ExtraordinaryEvents getExtraordinaryEvents() {
            return this.extraordinaryEvents;
        }

        @Override
        public Boolean getNonStandardisedTerms() {
            return this.nonStandardisedTerms;
        }

        @Override
        public Payout getPayout() {
            return this.payout;
        }

        @Override
        public AdjustableOrRelativeDate getTerminationDate() {
            return this.terminationDate;
        }

        @Override
        public TerminationProvision getTerminationProvision() {
            return this.terminationProvision;
        }

        @Override
        public EconomicTerms build() {
            return this;
        }

        @Override
        public EconomicTermsBuilder toBuilder() {
            EconomicTermsBuilder builder = EconomicTerms.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EconomicTermsBuilder builder) {
            Optional.ofNullable(this.getCalculationAgent()).ifPresent(builder::setCalculationAgent);
            Optional.ofNullable(this.getCollateral()).ifPresent(builder::setCollateral);
            Optional.ofNullable(this.getDateAdjustments()).ifPresent(builder::setDateAdjustments);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getExtraordinaryEvents()).ifPresent(builder::setExtraordinaryEvents);
            Optional.ofNullable(this.getNonStandardisedTerms()).ifPresent(builder::setNonStandardisedTerms);
            Optional.ofNullable(this.getPayout()).ifPresent(builder::setPayout);
            Optional.ofNullable(this.getTerminationDate()).ifPresent(builder::setTerminationDate);
            Optional.ofNullable(this.getTerminationProvision()).ifPresent(builder::setTerminationProvision);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EconomicTerms _that = this.getType().cast(o);
            if (!Objects.equals(this.calculationAgent, _that.getCalculationAgent())) {
                return false;
            }
            if (!Objects.equals(this.collateral, _that.getCollateral())) {
                return false;
            }
            if (!Objects.equals(this.dateAdjustments, _that.getDateAdjustments())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.extraordinaryEvents, _that.getExtraordinaryEvents())) {
                return false;
            }
            if (!Objects.equals(this.nonStandardisedTerms, _that.getNonStandardisedTerms())) {
                return false;
            }
            if (!Objects.equals(this.payout, _that.getPayout())) {
                return false;
            }
            if (!Objects.equals(this.terminationDate, _that.getTerminationDate())) {
                return false;
            }
            return Objects.equals(this.terminationProvision, _that.getTerminationProvision());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.calculationAgent != null ? this.calculationAgent.hashCode() : 0);
            _result = 31 * _result + (this.collateral != null ? this.collateral.hashCode() : 0);
            _result = 31 * _result + (this.dateAdjustments != null ? this.dateAdjustments.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.extraordinaryEvents != null ? this.extraordinaryEvents.hashCode() : 0);
            _result = 31 * _result + (this.nonStandardisedTerms != null ? this.nonStandardisedTerms.hashCode() : 0);
            _result = 31 * _result + (this.payout != null ? this.payout.hashCode() : 0);
            _result = 31 * _result + (this.terminationDate != null ? this.terminationDate.hashCode() : 0);
            _result = 31 * _result + (this.terminationProvision != null ? this.terminationProvision.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EconomicTerms {calculationAgent=" + this.calculationAgent + ", collateral=" + this.collateral + ", dateAdjustments=" + this.dateAdjustments + ", effectiveDate=" + this.effectiveDate + ", extraordinaryEvents=" + this.extraordinaryEvents + ", nonStandardisedTerms=" + this.nonStandardisedTerms + ", payout=" + this.payout + ", terminationDate=" + this.terminationDate + ", terminationProvision=" + this.terminationProvision + '}';
        }
    }

    public static interface EconomicTermsBuilder
    extends EconomicTerms,
    RosettaModelObjectBuilder {
        public CalculationAgent.CalculationAgentBuilder getOrCreateCalculationAgent();

        @Override
        public CalculationAgent.CalculationAgentBuilder getCalculationAgent();

        public Collateral.CollateralBuilder getOrCreateCollateral();

        @Override
        public Collateral.CollateralBuilder getCollateral();

        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getOrCreateDateAdjustments();

        @Override
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getDateAdjustments();

        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateEffectiveDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getEffectiveDate();

        public ExtraordinaryEvents.ExtraordinaryEventsBuilder getOrCreateExtraordinaryEvents();

        @Override
        public ExtraordinaryEvents.ExtraordinaryEventsBuilder getExtraordinaryEvents();

        public Payout.PayoutBuilder getOrCreatePayout();

        @Override
        public Payout.PayoutBuilder getPayout();

        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateTerminationDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getTerminationDate();

        public TerminationProvision.TerminationProvisionBuilder getOrCreateTerminationProvision();

        @Override
        public TerminationProvision.TerminationProvisionBuilder getTerminationProvision();

        public EconomicTermsBuilder setCalculationAgent(CalculationAgent var1);

        public EconomicTermsBuilder setCollateral(Collateral var1);

        public EconomicTermsBuilder setDateAdjustments(BusinessDayAdjustments var1);

        public EconomicTermsBuilder setEffectiveDate(AdjustableOrRelativeDate var1);

        public EconomicTermsBuilder setExtraordinaryEvents(ExtraordinaryEvents var1);

        public EconomicTermsBuilder setNonStandardisedTerms(Boolean var1);

        public EconomicTermsBuilder setPayout(Payout var1);

        public EconomicTermsBuilder setTerminationDate(AdjustableOrRelativeDate var1);

        public EconomicTermsBuilder setTerminationProvision(TerminationProvision var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("nonStandardisedTerms"), Boolean.class, (Object)this.getNonStandardisedTerms(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("calculationAgent"), processor, CalculationAgent.CalculationAgentBuilder.class, this.getCalculationAgent(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateral"), processor, Collateral.CollateralBuilder.class, this.getCollateral(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dateAdjustments"), processor, BusinessDayAdjustments.BusinessDayAdjustmentsBuilder.class, this.getDateAdjustments(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getEffectiveDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("extraordinaryEvents"), processor, ExtraordinaryEvents.ExtraordinaryEventsBuilder.class, this.getExtraordinaryEvents(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payout"), processor, Payout.PayoutBuilder.class, this.getPayout(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("terminationDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getTerminationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("terminationProvision"), processor, TerminationProvision.TerminationProvisionBuilder.class, this.getTerminationProvision(), new AttributeMeta[0]);
        }

        public EconomicTermsBuilder prune();
    }
}

