/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.observable.asset.Money;
import cdm.product.asset.DividendEntitlementEnum;
import cdm.product.asset.DividendPayoutRatio;
import cdm.product.template.meta.DividendTermsMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface DividendTerms
extends RosettaModelObject {
    public static final DividendTermsMeta metaData = new DividendTermsMeta();

    public DividendTerms build();

    public DividendTermsBuilder toBuilder();

    public DividendEntitlementEnum getDividendEntitlement();

    public DividendPayoutRatio getManufacturedIncomeRequirement();

    public Money getMinimumBillingAmount();

    default public RosettaMetaData<? extends DividendTerms> metaData() {
        return metaData;
    }

    public static DividendTermsBuilder builder() {
        return new DividendTermsBuilderImpl();
    }

    default public Class<? extends DividendTerms> getType() {
        return DividendTerms.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("dividendEntitlement"), DividendEntitlementEnum.class, (Object)this.getDividendEntitlement(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("manufacturedIncomeRequirement"), processor, DividendPayoutRatio.class, this.getManufacturedIncomeRequirement(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("minimumBillingAmount"), processor, Money.class, this.getMinimumBillingAmount(), new AttributeMeta[0]);
    }

    public static class DividendTermsBuilderImpl
    implements DividendTermsBuilder {
        protected DividendEntitlementEnum dividendEntitlement;
        protected DividendPayoutRatio.DividendPayoutRatioBuilder manufacturedIncomeRequirement;
        protected Money.MoneyBuilder minimumBillingAmount;

        @Override
        public DividendEntitlementEnum getDividendEntitlement() {
            return this.dividendEntitlement;
        }

        @Override
        public DividendPayoutRatio.DividendPayoutRatioBuilder getManufacturedIncomeRequirement() {
            return this.manufacturedIncomeRequirement;
        }

        @Override
        public DividendPayoutRatio.DividendPayoutRatioBuilder getOrCreateManufacturedIncomeRequirement() {
            DividendPayoutRatio.DividendPayoutRatioBuilder result = this.manufacturedIncomeRequirement != null ? this.manufacturedIncomeRequirement : (this.manufacturedIncomeRequirement = DividendPayoutRatio.builder());
            return result;
        }

        @Override
        public Money.MoneyBuilder getMinimumBillingAmount() {
            return this.minimumBillingAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateMinimumBillingAmount() {
            Money.MoneyBuilder result = this.minimumBillingAmount != null ? this.minimumBillingAmount : (this.minimumBillingAmount = Money.builder());
            return result;
        }

        @Override
        public DividendTermsBuilder setDividendEntitlement(DividendEntitlementEnum dividendEntitlement) {
            this.dividendEntitlement = dividendEntitlement == null ? null : dividendEntitlement;
            return this;
        }

        @Override
        public DividendTermsBuilder setManufacturedIncomeRequirement(DividendPayoutRatio manufacturedIncomeRequirement) {
            this.manufacturedIncomeRequirement = manufacturedIncomeRequirement == null ? null : manufacturedIncomeRequirement.toBuilder();
            return this;
        }

        @Override
        public DividendTermsBuilder setMinimumBillingAmount(Money minimumBillingAmount) {
            this.minimumBillingAmount = minimumBillingAmount == null ? null : minimumBillingAmount.toBuilder();
            return this;
        }

        @Override
        public DividendTerms build() {
            return new DividendTermsImpl(this);
        }

        @Override
        public DividendTermsBuilder toBuilder() {
            return this;
        }

        @Override
        public DividendTermsBuilder prune() {
            if (this.manufacturedIncomeRequirement != null && !this.manufacturedIncomeRequirement.prune().hasData()) {
                this.manufacturedIncomeRequirement = null;
            }
            if (this.minimumBillingAmount != null && !this.minimumBillingAmount.prune().hasData()) {
                this.minimumBillingAmount = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getDividendEntitlement() != null) {
                return true;
            }
            if (this.getManufacturedIncomeRequirement() != null && this.getManufacturedIncomeRequirement().hasData()) {
                return true;
            }
            return this.getMinimumBillingAmount() != null && this.getMinimumBillingAmount().hasData();
        }

        public DividendTermsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            DividendTermsBuilder o = (DividendTermsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getManufacturedIncomeRequirement(), (RosettaModelObjectBuilder)o.getManufacturedIncomeRequirement(), this::setManufacturedIncomeRequirement);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMinimumBillingAmount(), (RosettaModelObjectBuilder)o.getMinimumBillingAmount(), this::setMinimumBillingAmount);
            merger.mergeBasic((Object)this.getDividendEntitlement(), (Object)o.getDividendEntitlement(), this::setDividendEntitlement, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DividendTerms _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.dividendEntitlement, (Object)_that.getDividendEntitlement())) {
                return false;
            }
            if (!Objects.equals(this.manufacturedIncomeRequirement, _that.getManufacturedIncomeRequirement())) {
                return false;
            }
            return Objects.equals(this.minimumBillingAmount, _that.getMinimumBillingAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dividendEntitlement != null ? ((Object)((Object)this.dividendEntitlement)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.manufacturedIncomeRequirement != null ? this.manufacturedIncomeRequirement.hashCode() : 0);
            _result = 31 * _result + (this.minimumBillingAmount != null ? this.minimumBillingAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DividendTermsBuilder {dividendEntitlement=" + (Object)((Object)this.dividendEntitlement) + ", manufacturedIncomeRequirement=" + this.manufacturedIncomeRequirement + ", minimumBillingAmount=" + this.minimumBillingAmount + '}';
        }
    }

    public static class DividendTermsImpl
    implements DividendTerms {
        private final DividendEntitlementEnum dividendEntitlement;
        private final DividendPayoutRatio manufacturedIncomeRequirement;
        private final Money minimumBillingAmount;

        protected DividendTermsImpl(DividendTermsBuilder builder) {
            this.dividendEntitlement = builder.getDividendEntitlement();
            this.manufacturedIncomeRequirement = Optional.ofNullable(builder.getManufacturedIncomeRequirement()).map(f -> f.build()).orElse(null);
            this.minimumBillingAmount = Optional.ofNullable(builder.getMinimumBillingAmount()).map(f -> f.build()).orElse(null);
        }

        @Override
        public DividendEntitlementEnum getDividendEntitlement() {
            return this.dividendEntitlement;
        }

        @Override
        public DividendPayoutRatio getManufacturedIncomeRequirement() {
            return this.manufacturedIncomeRequirement;
        }

        @Override
        public Money getMinimumBillingAmount() {
            return this.minimumBillingAmount;
        }

        @Override
        public DividendTerms build() {
            return this;
        }

        @Override
        public DividendTermsBuilder toBuilder() {
            DividendTermsBuilder builder = DividendTerms.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DividendTermsBuilder builder) {
            Optional.ofNullable(this.getDividendEntitlement()).ifPresent(builder::setDividendEntitlement);
            Optional.ofNullable(this.getManufacturedIncomeRequirement()).ifPresent(builder::setManufacturedIncomeRequirement);
            Optional.ofNullable(this.getMinimumBillingAmount()).ifPresent(builder::setMinimumBillingAmount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DividendTerms _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.dividendEntitlement, (Object)_that.getDividendEntitlement())) {
                return false;
            }
            if (!Objects.equals(this.manufacturedIncomeRequirement, _that.getManufacturedIncomeRequirement())) {
                return false;
            }
            return Objects.equals(this.minimumBillingAmount, _that.getMinimumBillingAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dividendEntitlement != null ? ((Object)((Object)this.dividendEntitlement)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.manufacturedIncomeRequirement != null ? this.manufacturedIncomeRequirement.hashCode() : 0);
            _result = 31 * _result + (this.minimumBillingAmount != null ? this.minimumBillingAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DividendTerms {dividendEntitlement=" + (Object)((Object)this.dividendEntitlement) + ", manufacturedIncomeRequirement=" + this.manufacturedIncomeRequirement + ", minimumBillingAmount=" + this.minimumBillingAmount + '}';
        }
    }

    public static interface DividendTermsBuilder
    extends DividendTerms,
    RosettaModelObjectBuilder {
        public DividendPayoutRatio.DividendPayoutRatioBuilder getOrCreateManufacturedIncomeRequirement();

        @Override
        public DividendPayoutRatio.DividendPayoutRatioBuilder getManufacturedIncomeRequirement();

        public Money.MoneyBuilder getOrCreateMinimumBillingAmount();

        @Override
        public Money.MoneyBuilder getMinimumBillingAmount();

        public DividendTermsBuilder setDividendEntitlement(DividendEntitlementEnum var1);

        public DividendTermsBuilder setManufacturedIncomeRequirement(DividendPayoutRatio var1);

        public DividendTermsBuilder setMinimumBillingAmount(Money var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("dividendEntitlement"), DividendEntitlementEnum.class, (Object)this.getDividendEntitlement(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("manufacturedIncomeRequirement"), processor, DividendPayoutRatio.DividendPayoutRatioBuilder.class, this.getManufacturedIncomeRequirement(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("minimumBillingAmount"), processor, Money.MoneyBuilder.class, this.getMinimumBillingAmount(), new AttributeMeta[0]);
        }

        public DividendTermsBuilder prune();
    }
}

