/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.staticdata.party.PayerReceiver;
import cdm.observable.asset.Money;
import cdm.product.common.settlement.PayoutBase;
import cdm.product.common.settlement.PrincipalPayments;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.template.AssetLeg;
import cdm.product.template.DividendTerms;
import cdm.product.template.Duration;
import cdm.product.template.Product;
import cdm.product.template.meta.AssetPayoutMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface AssetPayout
extends PayoutBase,
GlobalKey {
    public static final AssetPayoutMeta metaData = new AssetPayoutMeta();

    @Override
    public AssetPayout build();

    @Override
    public AssetPayoutBuilder toBuilder();

    public List<? extends AssetLeg> getAssetLeg();

    public DividendTerms getDividendTerms();

    public Duration getDurationType();

    public MetaFields getMeta();

    public Money getMinimumFee();

    public Product getSecurityInformation();

    default public RosettaMetaData<? extends AssetPayout> metaData() {
        return metaData;
    }

    public static AssetPayoutBuilder builder() {
        return new AssetPayoutBuilderImpl();
    }

    default public Class<? extends AssetPayout> getType() {
        return AssetPayout.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        PayoutBase.super.process(path, processor);
        this.processRosetta(path.newSubPath("assetLeg"), processor, AssetLeg.class, this.getAssetLeg(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dividendTerms"), processor, DividendTerms.class, this.getDividendTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("durationType"), processor, Duration.class, this.getDurationType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("minimumFee"), processor, Money.class, this.getMinimumFee(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("securityInformation"), processor, Product.class, this.getSecurityInformation(), new AttributeMeta[0]);
    }

    public static class AssetPayoutBuilderImpl
    extends PayoutBase.PayoutBaseBuilderImpl
    implements AssetPayoutBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected List<AssetLeg.AssetLegBuilder> assetLeg = new ArrayList<AssetLeg.AssetLegBuilder>();
        protected DividendTerms.DividendTermsBuilder dividendTerms;
        protected Duration.DurationBuilder durationType;
        protected MetaFields.MetaFieldsBuilder meta;
        protected Money.MoneyBuilder minimumFee;
        protected Product.ProductBuilder securityInformation;

        @Override
        public List<? extends AssetLeg.AssetLegBuilder> getAssetLeg() {
            return this.assetLeg;
        }

        @Override
        public AssetLeg.AssetLegBuilder getOrCreateAssetLeg(int _index) {
            if (this.assetLeg == null) {
                this.assetLeg = new ArrayList<AssetLeg.AssetLegBuilder>();
            }
            return (AssetLeg.AssetLegBuilder)this.getIndex(this.assetLeg, _index, () -> {
                AssetLeg.AssetLegBuilder newAssetLeg = AssetLeg.builder();
                return newAssetLeg;
            });
        }

        @Override
        public DividendTerms.DividendTermsBuilder getDividendTerms() {
            return this.dividendTerms;
        }

        @Override
        public DividendTerms.DividendTermsBuilder getOrCreateDividendTerms() {
            DividendTerms.DividendTermsBuilder result = this.dividendTerms != null ? this.dividendTerms : (this.dividendTerms = DividendTerms.builder());
            return result;
        }

        @Override
        public Duration.DurationBuilder getDurationType() {
            return this.durationType;
        }

        @Override
        public Duration.DurationBuilder getOrCreateDurationType() {
            Duration.DurationBuilder result = this.durationType != null ? this.durationType : (this.durationType = Duration.builder());
            return result;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public Money.MoneyBuilder getMinimumFee() {
            return this.minimumFee;
        }

        @Override
        public Money.MoneyBuilder getOrCreateMinimumFee() {
            Money.MoneyBuilder result = this.minimumFee != null ? this.minimumFee : (this.minimumFee = Money.builder());
            return result;
        }

        @Override
        public Product.ProductBuilder getSecurityInformation() {
            return this.securityInformation;
        }

        @Override
        public Product.ProductBuilder getOrCreateSecurityInformation() {
            Product.ProductBuilder result = this.securityInformation != null ? this.securityInformation : (this.securityInformation = Product.builder());
            return result;
        }

        @Override
        public AssetPayoutBuilder addAssetLeg(AssetLeg assetLeg) {
            if (assetLeg != null) {
                this.assetLeg.add(assetLeg.toBuilder());
            }
            return this;
        }

        @Override
        public AssetPayoutBuilder addAssetLeg(AssetLeg assetLeg, int _idx) {
            this.getIndex(this.assetLeg, _idx, () -> assetLeg.toBuilder());
            return this;
        }

        @Override
        public AssetPayoutBuilder addAssetLeg(List<? extends AssetLeg> assetLegs) {
            if (assetLegs != null) {
                for (AssetLeg assetLeg : assetLegs) {
                    this.assetLeg.add(assetLeg.toBuilder());
                }
            }
            return this;
        }

        @Override
        public AssetPayoutBuilder setAssetLeg(List<? extends AssetLeg> assetLegs) {
            this.assetLeg = assetLegs == null ? new ArrayList<AssetLeg.AssetLegBuilder>() : (List)assetLegs.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AssetPayoutBuilder setDividendTerms(DividendTerms dividendTerms) {
            this.dividendTerms = dividendTerms == null ? null : dividendTerms.toBuilder();
            return this;
        }

        @Override
        public AssetPayoutBuilder setDurationType(Duration durationType) {
            this.durationType = durationType == null ? null : durationType.toBuilder();
            return this;
        }

        @Override
        public AssetPayoutBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public AssetPayoutBuilder setMinimumFee(Money minimumFee) {
            this.minimumFee = minimumFee == null ? null : minimumFee.toBuilder();
            return this;
        }

        @Override
        public AssetPayoutBuilder setSecurityInformation(Product securityInformation) {
            this.securityInformation = securityInformation == null ? null : securityInformation.toBuilder();
            return this;
        }

        @Override
        public AssetPayoutBuilder setPayerReceiver(PayerReceiver payerReceiver) {
            this.payerReceiver = payerReceiver == null ? null : payerReceiver.toBuilder();
            return this;
        }

        @Override
        public AssetPayoutBuilder setPriceQuantity(ResolvablePriceQuantity priceQuantity) {
            this.priceQuantity = priceQuantity == null ? null : priceQuantity.toBuilder();
            return this;
        }

        @Override
        public AssetPayoutBuilder setPrincipalPayment(PrincipalPayments principalPayment) {
            this.principalPayment = principalPayment == null ? null : principalPayment.toBuilder();
            return this;
        }

        @Override
        public AssetPayoutBuilder setSettlementTerms(SettlementTerms settlementTerms) {
            this.settlementTerms = settlementTerms == null ? null : settlementTerms.toBuilder();
            return this;
        }

        @Override
        public AssetPayout build() {
            return new AssetPayoutImpl(this);
        }

        @Override
        public AssetPayoutBuilder toBuilder() {
            return this;
        }

        @Override
        public AssetPayoutBuilder prune() {
            super.prune();
            this.assetLeg = this.assetLeg.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.dividendTerms != null && !this.dividendTerms.prune().hasData()) {
                this.dividendTerms = null;
            }
            if (this.durationType != null && !this.durationType.prune().hasData()) {
                this.durationType = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            if (this.minimumFee != null && !this.minimumFee.prune().hasData()) {
                this.minimumFee = null;
            }
            if (this.securityInformation != null && !this.securityInformation.prune().hasData()) {
                this.securityInformation = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getAssetLeg() != null && this.getAssetLeg().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getDividendTerms() != null && this.getDividendTerms().hasData()) {
                return true;
            }
            if (this.getDurationType() != null && this.getDurationType().hasData()) {
                return true;
            }
            if (this.getMinimumFee() != null && this.getMinimumFee().hasData()) {
                return true;
            }
            return this.getSecurityInformation() != null && this.getSecurityInformation().hasData();
        }

        @Override
        public AssetPayoutBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AssetPayoutBuilder o = (AssetPayoutBuilder)other;
            merger.mergeRosetta(this.getAssetLeg(), o.getAssetLeg(), this::getOrCreateAssetLeg);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDividendTerms(), (RosettaModelObjectBuilder)o.getDividendTerms(), this::setDividendTerms);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDurationType(), (RosettaModelObjectBuilder)o.getDurationType(), this::setDurationType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMinimumFee(), (RosettaModelObjectBuilder)o.getMinimumFee(), this::setMinimumFee);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSecurityInformation(), (RosettaModelObjectBuilder)o.getSecurityInformation(), this::setSecurityInformation);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AssetPayout _that = (AssetPayout)this.getType().cast(o);
            if (!ListEquals.listEquals(this.assetLeg, _that.getAssetLeg())) {
                return false;
            }
            if (!Objects.equals(this.dividendTerms, _that.getDividendTerms())) {
                return false;
            }
            if (!Objects.equals(this.durationType, _that.getDurationType())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.minimumFee, _that.getMinimumFee())) {
                return false;
            }
            return Objects.equals(this.securityInformation, _that.getSecurityInformation());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.assetLeg != null ? this.assetLeg.hashCode() : 0);
            _result = 31 * _result + (this.dividendTerms != null ? this.dividendTerms.hashCode() : 0);
            _result = 31 * _result + (this.durationType != null ? this.durationType.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.minimumFee != null ? this.minimumFee.hashCode() : 0);
            _result = 31 * _result + (this.securityInformation != null ? this.securityInformation.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AssetPayoutBuilder {assetLeg=" + this.assetLeg + ", dividendTerms=" + this.dividendTerms + ", durationType=" + this.durationType + ", meta=" + this.meta + ", minimumFee=" + this.minimumFee + ", securityInformation=" + this.securityInformation + '}' + " " + super.toString();
        }
    }

    public static class AssetPayoutImpl
    extends PayoutBase.PayoutBaseImpl
    implements AssetPayout {
        private final List<? extends AssetLeg> assetLeg;
        private final DividendTerms dividendTerms;
        private final Duration durationType;
        private final MetaFields meta;
        private final Money minimumFee;
        private final Product securityInformation;

        protected AssetPayoutImpl(AssetPayoutBuilder builder) {
            super(builder);
            this.assetLeg = Optional.ofNullable(builder.getAssetLeg()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.dividendTerms = Optional.ofNullable(builder.getDividendTerms()).map(f -> f.build()).orElse(null);
            this.durationType = Optional.ofNullable(builder.getDurationType()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
            this.minimumFee = Optional.ofNullable(builder.getMinimumFee()).map(f -> f.build()).orElse(null);
            this.securityInformation = Optional.ofNullable(builder.getSecurityInformation()).map(f -> f.build()).orElse(null);
        }

        @Override
        public List<? extends AssetLeg> getAssetLeg() {
            return this.assetLeg;
        }

        @Override
        public DividendTerms getDividendTerms() {
            return this.dividendTerms;
        }

        @Override
        public Duration getDurationType() {
            return this.durationType;
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public Money getMinimumFee() {
            return this.minimumFee;
        }

        @Override
        public Product getSecurityInformation() {
            return this.securityInformation;
        }

        @Override
        public AssetPayout build() {
            return this;
        }

        @Override
        public AssetPayoutBuilder toBuilder() {
            AssetPayoutBuilder builder = AssetPayout.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AssetPayoutBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getAssetLeg()).ifPresent(builder::setAssetLeg);
            Optional.ofNullable(this.getDividendTerms()).ifPresent(builder::setDividendTerms);
            Optional.ofNullable(this.getDurationType()).ifPresent(builder::setDurationType);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
            Optional.ofNullable(this.getMinimumFee()).ifPresent(builder::setMinimumFee);
            Optional.ofNullable(this.getSecurityInformation()).ifPresent(builder::setSecurityInformation);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AssetPayout _that = (AssetPayout)this.getType().cast(o);
            if (!ListEquals.listEquals(this.assetLeg, _that.getAssetLeg())) {
                return false;
            }
            if (!Objects.equals(this.dividendTerms, _that.getDividendTerms())) {
                return false;
            }
            if (!Objects.equals(this.durationType, _that.getDurationType())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.minimumFee, _that.getMinimumFee())) {
                return false;
            }
            return Objects.equals(this.securityInformation, _that.getSecurityInformation());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.assetLeg != null ? this.assetLeg.hashCode() : 0);
            _result = 31 * _result + (this.dividendTerms != null ? this.dividendTerms.hashCode() : 0);
            _result = 31 * _result + (this.durationType != null ? this.durationType.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.minimumFee != null ? this.minimumFee.hashCode() : 0);
            _result = 31 * _result + (this.securityInformation != null ? this.securityInformation.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AssetPayout {assetLeg=" + this.assetLeg + ", dividendTerms=" + this.dividendTerms + ", durationType=" + this.durationType + ", meta=" + this.meta + ", minimumFee=" + this.minimumFee + ", securityInformation=" + this.securityInformation + '}' + " " + super.toString();
        }
    }

    public static interface AssetPayoutBuilder
    extends AssetPayout,
    PayoutBase.PayoutBaseBuilder,
    RosettaModelObjectBuilder {
        public AssetLeg.AssetLegBuilder getOrCreateAssetLeg(int var1);

        public List<? extends AssetLeg.AssetLegBuilder> getAssetLeg();

        public DividendTerms.DividendTermsBuilder getOrCreateDividendTerms();

        @Override
        public DividendTerms.DividendTermsBuilder getDividendTerms();

        public Duration.DurationBuilder getOrCreateDurationType();

        @Override
        public Duration.DurationBuilder getDurationType();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public Money.MoneyBuilder getOrCreateMinimumFee();

        @Override
        public Money.MoneyBuilder getMinimumFee();

        public Product.ProductBuilder getOrCreateSecurityInformation();

        @Override
        public Product.ProductBuilder getSecurityInformation();

        public AssetPayoutBuilder addAssetLeg(AssetLeg var1);

        public AssetPayoutBuilder addAssetLeg(AssetLeg var1, int var2);

        public AssetPayoutBuilder addAssetLeg(List<? extends AssetLeg> var1);

        public AssetPayoutBuilder setAssetLeg(List<? extends AssetLeg> var1);

        public AssetPayoutBuilder setDividendTerms(DividendTerms var1);

        public AssetPayoutBuilder setDurationType(Duration var1);

        public AssetPayoutBuilder setMeta(MetaFields var1);

        public AssetPayoutBuilder setMinimumFee(Money var1);

        public AssetPayoutBuilder setSecurityInformation(Product var1);

        @Override
        public AssetPayoutBuilder setPayerReceiver(PayerReceiver var1);

        @Override
        public AssetPayoutBuilder setPriceQuantity(ResolvablePriceQuantity var1);

        @Override
        public AssetPayoutBuilder setPrincipalPayment(PrincipalPayments var1);

        @Override
        public AssetPayoutBuilder setSettlementTerms(SettlementTerms var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            PayoutBase.PayoutBaseBuilder.super.process(path, processor);
            this.processRosetta(path.newSubPath("assetLeg"), processor, AssetLeg.AssetLegBuilder.class, this.getAssetLeg(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dividendTerms"), processor, DividendTerms.DividendTermsBuilder.class, this.getDividendTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("durationType"), processor, Duration.DurationBuilder.class, this.getDurationType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("minimumFee"), processor, Money.MoneyBuilder.class, this.getMinimumFee(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("securityInformation"), processor, Product.ProductBuilder.class, this.getSecurityInformation(), new AttributeMeta[0]);
        }

        @Override
        public AssetPayoutBuilder prune();
    }
}

