/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement.validation.datarule;

import cdm.product.common.settlement.SettlementTerms;
import cdm.product.common.settlement.SettlementTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="SettlementTermsOptionSettlementChoice")
@ImplementedBy(value=Default.class)
public interface SettlementTermsOptionSettlementChoice
extends Validator<SettlementTerms> {
    public static final String NAME = "SettlementTermsOptionSettlementChoice";
    public static final String DEFINITION = "if cashSettlementTerms exists and physicalSettlementTerms exists then settlementType = SettlementTypeEnum -> Election or settlementType = SettlementTypeEnum -> CashOrPhysical";

    public ValidationResult<SettlementTerms> validate(RosettaPath var1, SettlementTerms var2);

    public static class NoOp
    implements SettlementTermsOptionSettlementChoice {
        @Override
        public ValidationResult<SettlementTerms> validate(RosettaPath path, SettlementTerms settlementTerms) {
            return ValidationResult.success((String)SettlementTermsOptionSettlementChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"SettlementTerms", (RosettaPath)path, (String)SettlementTermsOptionSettlementChoice.DEFINITION);
        }
    }

    public static class Default
    implements SettlementTermsOptionSettlementChoice {
        @Override
        public ValidationResult<SettlementTerms> validate(RosettaPath path, SettlementTerms settlementTerms) {
            ComparisonResult result = this.executeDataRule(settlementTerms);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)SettlementTermsOptionSettlementChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"SettlementTerms", (RosettaPath)path, (String)SettlementTermsOptionSettlementChoice.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition SettlementTermsOptionSettlementChoice failed.";
            }
            return ValidationResult.failure((String)SettlementTermsOptionSettlementChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"SettlementTerms", (RosettaPath)path, (String)SettlementTermsOptionSettlementChoice.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(SettlementTerms settlementTerms) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)settlementTerms).mapC("getCashSettlementTerms", _settlementTerms -> _settlementTerms.getCashSettlementTerms())).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)settlementTerms).map("getPhysicalSettlementTerms", _settlementTerms -> _settlementTerms.getPhysicalSettlementTerms()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)settlementTerms).map("getSettlementType", settlementBase -> settlementBase.getSettlementType()), (Mapper)MapperS.of((Object)((Object)SettlementTypeEnum.ELECTION)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)settlementTerms).map("getSettlementType", settlementBase -> settlementBase.getSettlementType()), (Mapper)MapperS.of((Object)((Object)SettlementTypeEnum.CASH_OR_PHYSICAL)), (CardinalityOperator)CardinalityOperator.All));
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

