/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement.validation.datarule;

import cdm.product.common.settlement.PrincipalPayment;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="PrincipalPaymentDiscountFactor")
@ImplementedBy(value=Default.class)
public interface PrincipalPaymentDiscountFactor
extends Validator<PrincipalPayment> {
    public static final String NAME = "PrincipalPaymentDiscountFactor";
    public static final String DEFINITION = "if presentValuePrincipalAmount exists then discountFactor exists";

    public ValidationResult<PrincipalPayment> validate(RosettaPath var1, PrincipalPayment var2);

    public static class NoOp
    implements PrincipalPaymentDiscountFactor {
        @Override
        public ValidationResult<PrincipalPayment> validate(RosettaPath path, PrincipalPayment principalPayment) {
            return ValidationResult.success((String)PrincipalPaymentDiscountFactor.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PrincipalPayment", (RosettaPath)path, (String)PrincipalPaymentDiscountFactor.DEFINITION);
        }
    }

    public static class Default
    implements PrincipalPaymentDiscountFactor {
        @Override
        public ValidationResult<PrincipalPayment> validate(RosettaPath path, PrincipalPayment principalPayment) {
            ComparisonResult result = this.executeDataRule(principalPayment);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)PrincipalPaymentDiscountFactor.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PrincipalPayment", (RosettaPath)path, (String)PrincipalPaymentDiscountFactor.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition PrincipalPaymentDiscountFactor failed.";
            }
            return ValidationResult.failure((String)PrincipalPaymentDiscountFactor.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PrincipalPayment", (RosettaPath)path, (String)PrincipalPaymentDiscountFactor.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(PrincipalPayment principalPayment) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)principalPayment).map("getPresentValuePrincipalAmount", _principalPayment -> _principalPayment.getPresentValuePrincipalAmount())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.exists((Mapper)MapperS.of((Object)principalPayment).map("getDiscountFactor", _principalPayment -> _principalPayment.getDiscountFactor()));
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

