/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement.validation.datarule;

import cdm.observable.asset.PriceTypeEnum;
import cdm.product.common.settlement.PriceQuantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="PriceQuantityRateOptionObservable")
@ImplementedBy(value=Default.class)
public interface PriceQuantityRateOptionObservable
extends Validator<PriceQuantity> {
    public static final String NAME = "PriceQuantityRateOptionObservable";
    public static final String DEFINITION = "if observable -> rateOption exists and price exists then price -> priceExpression -> priceType contains PriceTypeEnum -> InterestRate or price-> priceExpression -> priceType contains PriceTypeEnum -> MultiplierOfIndexValue";

    public ValidationResult<PriceQuantity> validate(RosettaPath var1, PriceQuantity var2);

    public static class NoOp
    implements PriceQuantityRateOptionObservable {
        @Override
        public ValidationResult<PriceQuantity> validate(RosettaPath path, PriceQuantity priceQuantity) {
            return ValidationResult.success((String)PriceQuantityRateOptionObservable.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceQuantity", (RosettaPath)path, (String)PriceQuantityRateOptionObservable.DEFINITION);
        }
    }

    public static class Default
    implements PriceQuantityRateOptionObservable {
        @Override
        public ValidationResult<PriceQuantity> validate(RosettaPath path, PriceQuantity priceQuantity) {
            ComparisonResult result = this.executeDataRule(priceQuantity);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)PriceQuantityRateOptionObservable.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceQuantity", (RosettaPath)path, (String)PriceQuantityRateOptionObservable.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition PriceQuantityRateOptionObservable failed.";
            }
            return ValidationResult.failure((String)PriceQuantityRateOptionObservable.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceQuantity", (RosettaPath)path, (String)PriceQuantityRateOptionObservable.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(PriceQuantity priceQuantity) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)priceQuantity).map("getObservable", _priceQuantity -> _priceQuantity.getObservable()).map("getRateOption", observable -> observable.getRateOption()).map("getValue", _f -> _f.getValue())).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)priceQuantity).mapC("getPrice", _priceQuantity -> _priceQuantity.getPrice()).map("getValue", _f -> _f.getValue()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.contains((Mapper)MapperS.of((Object)priceQuantity).mapC("getPrice", _priceQuantity -> _priceQuantity.getPrice()).map("getValue", _f -> _f.getValue()).map("getPriceExpression", priceSchedule -> priceSchedule.getPriceExpression()).map("getPriceType", priceExpression -> priceExpression.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.INTEREST_RATE))).or(ExpressionOperators.contains((Mapper)MapperS.of((Object)priceQuantity).mapC("getPrice", _priceQuantity -> _priceQuantity.getPrice()).map("getValue", _f -> _f.getValue()).map("getPriceExpression", priceSchedule -> priceSchedule.getPriceExpression()).map("getPriceType", priceExpression -> priceExpression.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.MULTIPLIER_OF_INDEX_VALUE))));
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

