/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement.validation.datarule;

import cdm.product.common.settlement.PriceQuantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="PriceQuantityActualSettlement")
@ImplementedBy(value=Default.class)
public interface PriceQuantityActualSettlement
extends Validator<PriceQuantity> {
    public static final String NAME = "PriceQuantityActualSettlement";
    public static final String DEFINITION = "if buyerSeller exists then settlementTerms exists";

    public ValidationResult<PriceQuantity> validate(RosettaPath var1, PriceQuantity var2);

    public static class NoOp
    implements PriceQuantityActualSettlement {
        @Override
        public ValidationResult<PriceQuantity> validate(RosettaPath path, PriceQuantity priceQuantity) {
            return ValidationResult.success((String)PriceQuantityActualSettlement.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceQuantity", (RosettaPath)path, (String)PriceQuantityActualSettlement.DEFINITION);
        }
    }

    public static class Default
    implements PriceQuantityActualSettlement {
        @Override
        public ValidationResult<PriceQuantity> validate(RosettaPath path, PriceQuantity priceQuantity) {
            ComparisonResult result = this.executeDataRule(priceQuantity);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)PriceQuantityActualSettlement.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceQuantity", (RosettaPath)path, (String)PriceQuantityActualSettlement.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition PriceQuantityActualSettlement failed.";
            }
            return ValidationResult.failure((String)PriceQuantityActualSettlement.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceQuantity", (RosettaPath)path, (String)PriceQuantityActualSettlement.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(PriceQuantity priceQuantity) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)priceQuantity).map("getBuyerSeller", _priceQuantity -> _priceQuantity.getBuyerSeller())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.exists((Mapper)MapperS.of((Object)priceQuantity).map("getSettlementTerms", _priceQuantity -> _priceQuantity.getSettlementTerms()));
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

