/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement.validation.datarule;

import cdm.product.common.settlement.FixedPrice;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;

@RosettaDataRule(value="FixedPriceNonNegativePrice_amount")
@ImplementedBy(value=Default.class)
public interface FixedPriceNonNegativePriceAmount
extends Validator<FixedPrice> {
    public static final String NAME = "FixedPriceNonNegativePrice_amount";
    public static final String DEFINITION = "if price -> value exists then price -> value >= 0.0 and if price -> datedValue exists then price -> datedValue -> value all >= 0.0";

    public ValidationResult<FixedPrice> validate(RosettaPath var1, FixedPrice var2);

    public static class NoOp
    implements FixedPriceNonNegativePriceAmount {
        @Override
        public ValidationResult<FixedPrice> validate(RosettaPath path, FixedPrice fixedPrice) {
            return ValidationResult.success((String)FixedPriceNonNegativePriceAmount.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"FixedPrice", (RosettaPath)path, (String)FixedPriceNonNegativePriceAmount.DEFINITION);
        }
    }

    public static class Default
    implements FixedPriceNonNegativePriceAmount {
        @Override
        public ValidationResult<FixedPrice> validate(RosettaPath path, FixedPrice fixedPrice) {
            ComparisonResult result = this.executeDataRule(fixedPrice);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)FixedPriceNonNegativePriceAmount.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"FixedPrice", (RosettaPath)path, (String)FixedPriceNonNegativePriceAmount.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition FixedPriceNonNegativePrice_amount failed.";
            }
            return ValidationResult.failure((String)FixedPriceNonNegativePriceAmount.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"FixedPrice", (RosettaPath)path, (String)FixedPriceNonNegativePriceAmount.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(FixedPrice fixedPrice) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)fixedPrice).map("getPrice", _fixedPrice -> _fixedPrice.getPrice()).map("getValue", _f -> _f.getValue()).map("getValue", measureBase -> measureBase.getValue())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)fixedPrice).map("getPrice", _fixedPrice -> _fixedPrice.getPrice()).map("getValue", _f -> _f.getValue()).map("getValue", measureBase -> measureBase.getValue()), (Mapper)MapperS.of((Object)new BigDecimal("0.0")), (CardinalityOperator)CardinalityOperator.All).and(MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)fixedPrice).map("getPrice", _fixedPrice -> _fixedPrice.getPrice()).map("getValue", _f -> _f.getValue()).mapC("getDatedValue", measureSchedule -> measureSchedule.getDatedValue())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                                return ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)fixedPrice).map("getPrice", _fixedPrice -> _fixedPrice.getPrice()).map("getValue", _f -> _f.getValue()).mapC("getDatedValue", measureSchedule -> measureSchedule.getDatedValue()).map("getValue", datedValue -> datedValue.getValue()), (Mapper)MapperS.of((Object)new BigDecimal("0.0")), (CardinalityOperator)CardinalityOperator.All);
                            }
                            return MapperS.ofNull();
                        })));
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

