/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement.validation.datarule;

import cdm.product.common.settlement.Cashflow;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;

@RosettaDataRule(value="CashflowCashflowAmount")
@ImplementedBy(value=Default.class)
public interface CashflowCashflowAmount
extends Validator<Cashflow> {
    public static final String NAME = "CashflowCashflowAmount";
    public static final String DEFINITION = "if priceQuantity exists then priceQuantity -> quantitySchedule -> value >= 0.0";

    public ValidationResult<Cashflow> validate(RosettaPath var1, Cashflow var2);

    public static class NoOp
    implements CashflowCashflowAmount {
        @Override
        public ValidationResult<Cashflow> validate(RosettaPath path, Cashflow cashflow) {
            return ValidationResult.success((String)CashflowCashflowAmount.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Cashflow", (RosettaPath)path, (String)CashflowCashflowAmount.DEFINITION);
        }
    }

    public static class Default
    implements CashflowCashflowAmount {
        @Override
        public ValidationResult<Cashflow> validate(RosettaPath path, Cashflow cashflow) {
            ComparisonResult result = this.executeDataRule(cashflow);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)CashflowCashflowAmount.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Cashflow", (RosettaPath)path, (String)CashflowCashflowAmount.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition CashflowCashflowAmount failed.";
            }
            return ValidationResult.failure((String)CashflowCashflowAmount.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Cashflow", (RosettaPath)path, (String)CashflowCashflowAmount.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Cashflow cashflow) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)cashflow).map("getPriceQuantity", payoutBase -> payoutBase.getPriceQuantity())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)cashflow).map("getPriceQuantity", payoutBase -> payoutBase.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("getValue", _f -> _f.getValue()).map("getValue", measureBase -> measureBase.getValue()), (Mapper)MapperS.of((Object)new BigDecimal("0.0")), (CardinalityOperator)CardinalityOperator.All);
                    }
                    return MapperS.ofNull();
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

