/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement.processor;

import cdm.base.math.DatedValue;
import cdm.base.math.UnitType;
import cdm.observable.asset.CapFloorEnum;
import cdm.observable.asset.PriceExpression;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import cdm.observable.asset.metafields.FieldWithMetaPriceSchedule;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.common.settlement.processor.PriceQuantityHelper;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.common.util.PathUtils;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.FieldWithMetaString;
import com.rosetta.model.metafields.MetaFields;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class PriceCollarMappingProcessor
extends MappingProcessor {
    public PriceCollarMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        super(modelPath, synonymPaths, context);
    }

    public void map(Path synonymPath, List<? extends RosettaModelObjectBuilder> builder, RosettaModelObjectBuilder parent) {
        MappingProcessorUtils.subPath((String)"capFloorStream", (Path)synonymPath).ifPresent(subPath -> {
            if (MappingProcessorUtils.getNonNullMapping((List)this.getMappings(), (RosettaPath)this.getModelPath(), (Path)subPath, (String[])new String[]{"capRateSchedule", "initialValue"}).isPresent()) {
                MappingProcessorUtils.getNonNullMapping((List)this.getMappings(), (RosettaPath)this.getModelPath(), (Path)subPath, (String[])new String[]{"floorRateSchedule", "initialValue"}).ifPresent(frm -> {
                    UnitType.UnitTypeBuilder unitType = this.toCurrencyUnitType((Path)subPath);
                    BigDecimal floorRate = new BigDecimal(String.valueOf(frm.getXmlValue()));
                    PriceExpression.PriceExpressionBuilder priceExpression = PriceExpression.builder().setPriceType(PriceTypeEnum.INTEREST_RATE).setCapFloor(CapFloorEnum.FLOOR);
                    FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder fieldWithPriceScheduleBuilder = PriceQuantityHelper.toReferencablePriceBuilder(floorRate, unitType, unitType, priceExpression);
                    PriceSchedule.PriceScheduleBuilder priceScheduleBuilder = fieldWithPriceScheduleBuilder.getValue();
                    Path amountModelPath = PriceQuantityHelper.incrementPathElementIndex(frm.getRosettaPath(), "price", 1);
                    this.updateMapping((Mapping)frm, amountModelPath);
                    priceScheduleBuilder.setDatedValue(this.getSteps(frm.getXmlPath().getParent(), amountModelPath.getParent()));
                    ((PriceQuantity.PriceQuantityBuilder)parent).addPrice(fieldWithPriceScheduleBuilder);
                });
            }
        });
    }

    private UnitType.UnitTypeBuilder toCurrencyUnitType(Path startsWithPath) {
        String currency = MappingProcessorUtils.getNonNullMappedValue((List)this.getMappings(), (Path)startsWithPath, (String[])new String[]{"notionalStepSchedule", "currency"}).orElse(null);
        String currencyScheme = MappingProcessorUtils.getNonNullMappedValue((List)this.getMappings(), (Path)startsWithPath, (String[])new String[]{"notionalStepSchedule", "currency", "currencyScheme"}).orElse(null);
        return UnitType.builder().setCurrency(FieldWithMetaString.builder().setValue(currency).setMeta(MetaFields.builder().setScheme(currencyScheme).build()));
    }

    private void updateMapping(Mapping mapping, Path modelPath) {
        mapping.setRosettaPath(modelPath);
        mapping.setError(null);
        mapping.setCondition(true);
        mapping.setDuplicate(false);
    }

    private List<DatedValue.DatedValueBuilder> getSteps(Path floorScheduleSynonymPath, Path priceScheduleModelPath) {
        Optional<DatedValue.DatedValueBuilder> step;
        ArrayList<DatedValue.DatedValueBuilder> steps = new ArrayList<DatedValue.DatedValueBuilder>();
        int index = 0;
        while ((step = this.getStep(floorScheduleSynonymPath, priceScheduleModelPath, index++)).isPresent()) {
            steps.add(step.get());
        }
        return steps;
    }

    private Optional<DatedValue.DatedValueBuilder> getStep(Path floorScheduleSynonymPath, Path priceScheduleModelPath, int index) {
        DatedValue.DatedValueBuilder stepBuilder = DatedValue.builder();
        Path synonymPath = floorScheduleSynonymPath.addElement("step", Integer.valueOf(index));
        Path modelPath = priceScheduleModelPath.addElement("step", Integer.valueOf(index));
        MappingProcessorUtils.setValueAndUpdateMappings((Path)synonymPath.addElement("stepValue"), xmlValue -> stepBuilder.setValue(new BigDecimal((String)xmlValue)), (List)this.getMappings(), (RosettaPath)PathUtils.toRosettaPath((Path)modelPath.addElement("stepValue")));
        MappingProcessorUtils.setValueAndUpdateMappings((Path)synonymPath.addElement("stepDate"), xmlValue -> stepBuilder.setDate(Date.parse((String)xmlValue)), (List)this.getMappings(), (RosettaPath)PathUtils.toRosettaPath((Path)modelPath.addElement("stepDate")));
        return stepBuilder.hasData() ? Optional.of(stepBuilder) : Optional.empty();
    }
}

