/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement.processor;

import cdm.base.math.UnitType;
import cdm.observable.asset.PriceExpression;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import cdm.observable.asset.SpreadTypeEnum;
import cdm.observable.asset.metafields.FieldWithMetaPriceSchedule;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.common.settlement.processor.PriceQuantityHelper;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.common.util.PathUtils;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.util.CollectionUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public class ExchangeRateMappingProcessor
extends MappingProcessor {
    public ExchangeRateMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        super(modelPath, synonymPaths, context);
    }

    public void map(Path synonymPath, List<? extends RosettaModelObjectBuilder> builders, RosettaModelObjectBuilder parent) {
        PriceQuantity.PriceQuantityBuilder priceQuantityBuilder = (PriceQuantity.PriceQuantityBuilder)parent;
        List priceBuilders = CollectionUtils.emptyIfNull(builders);
        UnitType.UnitTypeBuilder unitOfAmount = this.getUnit(priceBuilders);
        UnitType.UnitTypeBuilder perUnitOfAmount = this.getPerUnitOf(priceBuilders);
        AtomicInteger priceIndex = new AtomicInteger(priceBuilders.size());
        this.getBuilder(synonymPath.addElement("spotRate"), priceIndex, unitOfAmount, perUnitOfAmount, this.getPriceExpression(SpreadTypeEnum.BASE)).ifPresent(priceQuantityBuilder::addPrice);
        this.getBuilder(synonymPath.addElement("forwardPoints"), priceIndex, unitOfAmount, perUnitOfAmount, this.getPriceExpression(SpreadTypeEnum.SPREAD)).ifPresent(priceQuantityBuilder::addPrice);
        this.getBuilder(synonymPath.addElement("pointValue"), priceIndex, unitOfAmount, perUnitOfAmount, this.getPriceExpression(SpreadTypeEnum.SPREAD)).ifPresent(priceQuantityBuilder::addPrice);
    }

    private PriceExpression.PriceExpressionBuilder getPriceExpression(SpreadTypeEnum base) {
        return PriceExpression.builder().setPriceType(PriceTypeEnum.EXCHANGE_RATE).setSpreadType(base);
    }

    private Optional<FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder> getBuilder(Path synonymPath, AtomicInteger priceIndex, UnitType.UnitTypeBuilder unitOfAmount, UnitType.UnitTypeBuilder perUnitOfAmount, PriceExpression priceExpression) {
        return MappingProcessorUtils.getNonNullMapping((List)this.getMappings(), (Path)synonymPath).map(mapping -> {
            Path mappedModelPath = PathUtils.toPath((RosettaPath)this.getModelPath()).addElement("value");
            String amount = String.valueOf(mapping.getXmlValue());
            this.updateMappings(synonymPath, mappedModelPath, amount);
            return PriceQuantityHelper.toReferencablePriceBuilder(new BigDecimal(amount), unitOfAmount, perUnitOfAmount, priceExpression);
        });
    }

    private UnitType.UnitTypeBuilder getUnit(List<FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder> priceBuilders) {
        return this.getExchangeRatePrice(priceBuilders).map(p -> p.getUnit()).orElse(null);
    }

    private UnitType.UnitTypeBuilder getPerUnitOf(List<FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder> priceBuilders) {
        return this.getExchangeRatePrice(priceBuilders).map(p -> p.getPerUnitOf()).orElse(null);
    }

    private Optional<PriceSchedule.PriceScheduleBuilder> getExchangeRatePrice(List<FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder> priceBuilders) {
        return priceBuilders.stream().map(FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder::getValue).filter(p -> Optional.ofNullable(p).map(PriceSchedule::getPriceExpression).map(PriceExpression::getPriceType).map(PriceTypeEnum.EXCHANGE_RATE::equals).orElse(false)).findFirst();
    }

    private void updateMappings(Path xmlPath, Path mappedModelPath, String mappedValue) {
        MappingProcessorUtils.filterMappings((List)this.getMappings(), (Path)xmlPath).forEach(m -> {
            m.setRosettaPath(mappedModelPath);
            m.setRosettaValue((Object)mappedValue);
            m.setError(null);
            m.setCondition(true);
        });
    }
}

