/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement.functions;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.observable.asset.PriceSchedule;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.List;
import java.util.Optional;

@ImplementedBy(value=Create_ResolvablePriceQuantityDefault.class)
public abstract class Create_ResolvablePriceQuantity
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public ResolvablePriceQuantity evaluate(NonNegativeQuantitySchedule quantity, List<? extends PriceSchedule> price) {
        ResolvablePriceQuantity.ResolvablePriceQuantityBuilder priceQuantity = this.doEvaluate(quantity, price);
        if (priceQuantity != null) {
            this.objectValidator.validate(ResolvablePriceQuantity.class, (RosettaModelObject)priceQuantity);
        }
        return priceQuantity;
    }

    protected abstract ResolvablePriceQuantity.ResolvablePriceQuantityBuilder doEvaluate(NonNegativeQuantitySchedule var1, List<? extends PriceSchedule> var2);

    public static class Create_ResolvablePriceQuantityDefault
    extends Create_ResolvablePriceQuantity {
        @Override
        protected ResolvablePriceQuantity.ResolvablePriceQuantityBuilder doEvaluate(NonNegativeQuantitySchedule quantity, List<? extends PriceSchedule> price) {
            ResolvablePriceQuantity.ResolvablePriceQuantityBuilder priceQuantity = ResolvablePriceQuantity.builder();
            return this.assignOutput(priceQuantity, quantity, price);
        }

        protected ResolvablePriceQuantity.ResolvablePriceQuantityBuilder assignOutput(ResolvablePriceQuantity.ResolvablePriceQuantityBuilder priceQuantity, NonNegativeQuantitySchedule quantity, List<? extends PriceSchedule> price) {
            priceQuantity.setQuantityScheduleValue((NonNegativeQuantitySchedule)MapperS.of((Object)quantity).get());
            priceQuantity.setPriceScheduleValue(MapperC.of(price).getMulti());
            return Optional.ofNullable(priceQuantity).map(o -> o.prune()).orElse(null);
        }
    }
}

