/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement.functions;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.observable.asset.Observable;
import cdm.observable.asset.PriceSchedule;
import cdm.product.common.settlement.PriceQuantity;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.List;
import java.util.Optional;

@ImplementedBy(value=Create_PriceQuantityDefault.class)
public abstract class Create_PriceQuantity
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public PriceQuantity evaluate(List<? extends PriceSchedule> price, List<? extends NonNegativeQuantitySchedule> quantity, Observable observable) {
        PriceQuantity.PriceQuantityBuilder priceQuantity = this.doEvaluate(price, quantity, observable);
        if (priceQuantity != null) {
            this.objectValidator.validate(PriceQuantity.class, (RosettaModelObject)priceQuantity);
        }
        return priceQuantity;
    }

    protected abstract PriceQuantity.PriceQuantityBuilder doEvaluate(List<? extends PriceSchedule> var1, List<? extends NonNegativeQuantitySchedule> var2, Observable var3);

    public static class Create_PriceQuantityDefault
    extends Create_PriceQuantity {
        @Override
        protected PriceQuantity.PriceQuantityBuilder doEvaluate(List<? extends PriceSchedule> price, List<? extends NonNegativeQuantitySchedule> quantity, Observable observable) {
            PriceQuantity.PriceQuantityBuilder priceQuantity = PriceQuantity.builder();
            return this.assignOutput(priceQuantity, price, quantity, observable);
        }

        protected PriceQuantity.PriceQuantityBuilder assignOutput(PriceQuantity.PriceQuantityBuilder priceQuantity, List<? extends PriceSchedule> price, List<? extends NonNegativeQuantitySchedule> quantity, Observable observable) {
            priceQuantity.addPriceValue(MapperC.of(price).getMulti());
            priceQuantity.addQuantityValue(MapperC.of(quantity).getMulti());
            priceQuantity.setObservable((Observable)MapperS.of((Object)observable).get());
            return Optional.ofNullable(priceQuantity).map(o -> o.prune()).orElse(null);
        }
    }
}

