/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import cdm.base.datetime.AdjustableDates;
import cdm.base.datetime.RelativeDateOffset;
import cdm.observable.asset.MultipleValuationDates;
import cdm.observable.asset.SingleValuationDate;
import cdm.product.common.settlement.FxFixingDate;
import cdm.product.common.settlement.meta.ValuationDateMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface ValuationDate
extends RosettaModelObject {
    public static final ValuationDateMeta metaData = new ValuationDateMeta();

    public ValuationDate build();

    public ValuationDateBuilder toBuilder();

    public FxFixingDate getFxFixingDate();

    public AdjustableDates getFxFixingSchedule();

    public MultipleValuationDates getMultipleValuationDates();

    public SingleValuationDate getSingleValuationDate();

    public RelativeDateOffset getValuationDate();

    default public RosettaMetaData<? extends ValuationDate> metaData() {
        return metaData;
    }

    public static ValuationDateBuilder builder() {
        return new ValuationDateBuilderImpl();
    }

    default public Class<? extends ValuationDate> getType() {
        return ValuationDate.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("fxFixingDate"), processor, FxFixingDate.class, this.getFxFixingDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxFixingSchedule"), processor, AdjustableDates.class, this.getFxFixingSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("multipleValuationDates"), processor, MultipleValuationDates.class, this.getMultipleValuationDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("singleValuationDate"), processor, SingleValuationDate.class, this.getSingleValuationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valuationDate"), processor, RelativeDateOffset.class, this.getValuationDate(), new AttributeMeta[0]);
    }

    public static class ValuationDateBuilderImpl
    implements ValuationDateBuilder {
        protected FxFixingDate.FxFixingDateBuilder fxFixingDate;
        protected AdjustableDates.AdjustableDatesBuilder fxFixingSchedule;
        protected MultipleValuationDates.MultipleValuationDatesBuilder multipleValuationDates;
        protected SingleValuationDate.SingleValuationDateBuilder singleValuationDate;
        protected RelativeDateOffset.RelativeDateOffsetBuilder valuationDate;

        @Override
        public FxFixingDate.FxFixingDateBuilder getFxFixingDate() {
            return this.fxFixingDate;
        }

        @Override
        public FxFixingDate.FxFixingDateBuilder getOrCreateFxFixingDate() {
            FxFixingDate.FxFixingDateBuilder result = this.fxFixingDate != null ? this.fxFixingDate : (this.fxFixingDate = FxFixingDate.builder());
            return result;
        }

        @Override
        public AdjustableDates.AdjustableDatesBuilder getFxFixingSchedule() {
            return this.fxFixingSchedule;
        }

        @Override
        public AdjustableDates.AdjustableDatesBuilder getOrCreateFxFixingSchedule() {
            AdjustableDates.AdjustableDatesBuilder result = this.fxFixingSchedule != null ? this.fxFixingSchedule : (this.fxFixingSchedule = AdjustableDates.builder());
            return result;
        }

        @Override
        public MultipleValuationDates.MultipleValuationDatesBuilder getMultipleValuationDates() {
            return this.multipleValuationDates;
        }

        @Override
        public MultipleValuationDates.MultipleValuationDatesBuilder getOrCreateMultipleValuationDates() {
            MultipleValuationDates.MultipleValuationDatesBuilder result = this.multipleValuationDates != null ? this.multipleValuationDates : (this.multipleValuationDates = MultipleValuationDates.builder());
            return result;
        }

        @Override
        public SingleValuationDate.SingleValuationDateBuilder getSingleValuationDate() {
            return this.singleValuationDate;
        }

        @Override
        public SingleValuationDate.SingleValuationDateBuilder getOrCreateSingleValuationDate() {
            SingleValuationDate.SingleValuationDateBuilder result = this.singleValuationDate != null ? this.singleValuationDate : (this.singleValuationDate = SingleValuationDate.builder());
            return result;
        }

        @Override
        public RelativeDateOffset.RelativeDateOffsetBuilder getValuationDate() {
            return this.valuationDate;
        }

        @Override
        public RelativeDateOffset.RelativeDateOffsetBuilder getOrCreateValuationDate() {
            RelativeDateOffset.RelativeDateOffsetBuilder result = this.valuationDate != null ? this.valuationDate : (this.valuationDate = RelativeDateOffset.builder());
            return result;
        }

        @Override
        public ValuationDateBuilder setFxFixingDate(FxFixingDate fxFixingDate) {
            this.fxFixingDate = fxFixingDate == null ? null : fxFixingDate.toBuilder();
            return this;
        }

        @Override
        public ValuationDateBuilder setFxFixingSchedule(AdjustableDates fxFixingSchedule) {
            this.fxFixingSchedule = fxFixingSchedule == null ? null : fxFixingSchedule.toBuilder();
            return this;
        }

        @Override
        public ValuationDateBuilder setMultipleValuationDates(MultipleValuationDates multipleValuationDates) {
            this.multipleValuationDates = multipleValuationDates == null ? null : multipleValuationDates.toBuilder();
            return this;
        }

        @Override
        public ValuationDateBuilder setSingleValuationDate(SingleValuationDate singleValuationDate) {
            this.singleValuationDate = singleValuationDate == null ? null : singleValuationDate.toBuilder();
            return this;
        }

        @Override
        public ValuationDateBuilder setValuationDate(RelativeDateOffset valuationDate) {
            this.valuationDate = valuationDate == null ? null : valuationDate.toBuilder();
            return this;
        }

        @Override
        public ValuationDate build() {
            return new ValuationDateImpl(this);
        }

        @Override
        public ValuationDateBuilder toBuilder() {
            return this;
        }

        @Override
        public ValuationDateBuilder prune() {
            if (this.fxFixingDate != null && !this.fxFixingDate.prune().hasData()) {
                this.fxFixingDate = null;
            }
            if (this.fxFixingSchedule != null && !this.fxFixingSchedule.prune().hasData()) {
                this.fxFixingSchedule = null;
            }
            if (this.multipleValuationDates != null && !this.multipleValuationDates.prune().hasData()) {
                this.multipleValuationDates = null;
            }
            if (this.singleValuationDate != null && !this.singleValuationDate.prune().hasData()) {
                this.singleValuationDate = null;
            }
            if (this.valuationDate != null && !this.valuationDate.prune().hasData()) {
                this.valuationDate = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getFxFixingDate() != null && this.getFxFixingDate().hasData()) {
                return true;
            }
            if (this.getFxFixingSchedule() != null && this.getFxFixingSchedule().hasData()) {
                return true;
            }
            if (this.getMultipleValuationDates() != null && this.getMultipleValuationDates().hasData()) {
                return true;
            }
            if (this.getSingleValuationDate() != null && this.getSingleValuationDate().hasData()) {
                return true;
            }
            return this.getValuationDate() != null && this.getValuationDate().hasData();
        }

        public ValuationDateBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ValuationDateBuilder o = (ValuationDateBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxFixingDate(), (RosettaModelObjectBuilder)o.getFxFixingDate(), this::setFxFixingDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxFixingSchedule(), (RosettaModelObjectBuilder)o.getFxFixingSchedule(), this::setFxFixingSchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMultipleValuationDates(), (RosettaModelObjectBuilder)o.getMultipleValuationDates(), this::setMultipleValuationDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSingleValuationDate(), (RosettaModelObjectBuilder)o.getSingleValuationDate(), this::setSingleValuationDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getValuationDate(), (RosettaModelObjectBuilder)o.getValuationDate(), this::setValuationDate);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ValuationDate _that = this.getType().cast(o);
            if (!Objects.equals(this.fxFixingDate, _that.getFxFixingDate())) {
                return false;
            }
            if (!Objects.equals(this.fxFixingSchedule, _that.getFxFixingSchedule())) {
                return false;
            }
            if (!Objects.equals(this.multipleValuationDates, _that.getMultipleValuationDates())) {
                return false;
            }
            if (!Objects.equals(this.singleValuationDate, _that.getSingleValuationDate())) {
                return false;
            }
            return Objects.equals(this.valuationDate, _that.getValuationDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.fxFixingDate != null ? this.fxFixingDate.hashCode() : 0);
            _result = 31 * _result + (this.fxFixingSchedule != null ? this.fxFixingSchedule.hashCode() : 0);
            _result = 31 * _result + (this.multipleValuationDates != null ? this.multipleValuationDates.hashCode() : 0);
            _result = 31 * _result + (this.singleValuationDate != null ? this.singleValuationDate.hashCode() : 0);
            _result = 31 * _result + (this.valuationDate != null ? this.valuationDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ValuationDateBuilder {fxFixingDate=" + this.fxFixingDate + ", fxFixingSchedule=" + this.fxFixingSchedule + ", multipleValuationDates=" + this.multipleValuationDates + ", singleValuationDate=" + this.singleValuationDate + ", valuationDate=" + this.valuationDate + '}';
        }
    }

    public static class ValuationDateImpl
    implements ValuationDate {
        private final FxFixingDate fxFixingDate;
        private final AdjustableDates fxFixingSchedule;
        private final MultipleValuationDates multipleValuationDates;
        private final SingleValuationDate singleValuationDate;
        private final RelativeDateOffset valuationDate;

        protected ValuationDateImpl(ValuationDateBuilder builder) {
            this.fxFixingDate = Optional.ofNullable(builder.getFxFixingDate()).map(f -> f.build()).orElse(null);
            this.fxFixingSchedule = Optional.ofNullable(builder.getFxFixingSchedule()).map(f -> f.build()).orElse(null);
            this.multipleValuationDates = Optional.ofNullable(builder.getMultipleValuationDates()).map(f -> f.build()).orElse(null);
            this.singleValuationDate = Optional.ofNullable(builder.getSingleValuationDate()).map(f -> f.build()).orElse(null);
            this.valuationDate = Optional.ofNullable(builder.getValuationDate()).map(f -> f.build()).orElse(null);
        }

        @Override
        public FxFixingDate getFxFixingDate() {
            return this.fxFixingDate;
        }

        @Override
        public AdjustableDates getFxFixingSchedule() {
            return this.fxFixingSchedule;
        }

        @Override
        public MultipleValuationDates getMultipleValuationDates() {
            return this.multipleValuationDates;
        }

        @Override
        public SingleValuationDate getSingleValuationDate() {
            return this.singleValuationDate;
        }

        @Override
        public RelativeDateOffset getValuationDate() {
            return this.valuationDate;
        }

        @Override
        public ValuationDate build() {
            return this;
        }

        @Override
        public ValuationDateBuilder toBuilder() {
            ValuationDateBuilder builder = ValuationDate.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ValuationDateBuilder builder) {
            Optional.ofNullable(this.getFxFixingDate()).ifPresent(builder::setFxFixingDate);
            Optional.ofNullable(this.getFxFixingSchedule()).ifPresent(builder::setFxFixingSchedule);
            Optional.ofNullable(this.getMultipleValuationDates()).ifPresent(builder::setMultipleValuationDates);
            Optional.ofNullable(this.getSingleValuationDate()).ifPresent(builder::setSingleValuationDate);
            Optional.ofNullable(this.getValuationDate()).ifPresent(builder::setValuationDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ValuationDate _that = this.getType().cast(o);
            if (!Objects.equals(this.fxFixingDate, _that.getFxFixingDate())) {
                return false;
            }
            if (!Objects.equals(this.fxFixingSchedule, _that.getFxFixingSchedule())) {
                return false;
            }
            if (!Objects.equals(this.multipleValuationDates, _that.getMultipleValuationDates())) {
                return false;
            }
            if (!Objects.equals(this.singleValuationDate, _that.getSingleValuationDate())) {
                return false;
            }
            return Objects.equals(this.valuationDate, _that.getValuationDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.fxFixingDate != null ? this.fxFixingDate.hashCode() : 0);
            _result = 31 * _result + (this.fxFixingSchedule != null ? this.fxFixingSchedule.hashCode() : 0);
            _result = 31 * _result + (this.multipleValuationDates != null ? this.multipleValuationDates.hashCode() : 0);
            _result = 31 * _result + (this.singleValuationDate != null ? this.singleValuationDate.hashCode() : 0);
            _result = 31 * _result + (this.valuationDate != null ? this.valuationDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ValuationDate {fxFixingDate=" + this.fxFixingDate + ", fxFixingSchedule=" + this.fxFixingSchedule + ", multipleValuationDates=" + this.multipleValuationDates + ", singleValuationDate=" + this.singleValuationDate + ", valuationDate=" + this.valuationDate + '}';
        }
    }

    public static interface ValuationDateBuilder
    extends ValuationDate,
    RosettaModelObjectBuilder {
        public FxFixingDate.FxFixingDateBuilder getOrCreateFxFixingDate();

        @Override
        public FxFixingDate.FxFixingDateBuilder getFxFixingDate();

        public AdjustableDates.AdjustableDatesBuilder getOrCreateFxFixingSchedule();

        @Override
        public AdjustableDates.AdjustableDatesBuilder getFxFixingSchedule();

        public MultipleValuationDates.MultipleValuationDatesBuilder getOrCreateMultipleValuationDates();

        @Override
        public MultipleValuationDates.MultipleValuationDatesBuilder getMultipleValuationDates();

        public SingleValuationDate.SingleValuationDateBuilder getOrCreateSingleValuationDate();

        @Override
        public SingleValuationDate.SingleValuationDateBuilder getSingleValuationDate();

        public RelativeDateOffset.RelativeDateOffsetBuilder getOrCreateValuationDate();

        @Override
        public RelativeDateOffset.RelativeDateOffsetBuilder getValuationDate();

        public ValuationDateBuilder setFxFixingDate(FxFixingDate var1);

        public ValuationDateBuilder setFxFixingSchedule(AdjustableDates var1);

        public ValuationDateBuilder setMultipleValuationDates(MultipleValuationDates var1);

        public ValuationDateBuilder setSingleValuationDate(SingleValuationDate var1);

        public ValuationDateBuilder setValuationDate(RelativeDateOffset var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("fxFixingDate"), processor, FxFixingDate.FxFixingDateBuilder.class, this.getFxFixingDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxFixingSchedule"), processor, AdjustableDates.AdjustableDatesBuilder.class, this.getFxFixingSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("multipleValuationDates"), processor, MultipleValuationDates.MultipleValuationDatesBuilder.class, this.getMultipleValuationDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("singleValuationDate"), processor, SingleValuationDate.SingleValuationDateBuilder.class, this.getSingleValuationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valuationDate"), processor, RelativeDateOffset.RelativeDateOffsetBuilder.class, this.getValuationDate(), new AttributeMeta[0]);
        }

        public ValuationDateBuilder prune();
    }
}

