/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import cdm.base.datetime.AdjustableDates;
import cdm.base.datetime.AdjustableOrAdjustedOrRelativeDate;
import cdm.base.datetime.BusinessDateRange;
import cdm.product.common.settlement.meta.SettlementDateMeta;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.MetaFields;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface SettlementDate
extends RosettaModelObject,
GlobalKey {
    public static final SettlementDateMeta metaData = new SettlementDateMeta();

    public SettlementDate build();

    public SettlementDateBuilder toBuilder();

    public AdjustableDates getAdjustableDates();

    public AdjustableOrAdjustedOrRelativeDate getAdjustableOrRelativeDate();

    public BusinessDateRange getBusinessDateRange();

    public Integer getCashSettlementBusinessDays();

    public MetaFields getMeta();

    public Boolean getPaymentDelay();

    public Date getValueDate();

    default public RosettaMetaData<? extends SettlementDate> metaData() {
        return metaData;
    }

    public static SettlementDateBuilder builder() {
        return new SettlementDateBuilderImpl();
    }

    default public Class<? extends SettlementDate> getType() {
        return SettlementDate.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("cashSettlementBusinessDays"), Integer.class, (Object)this.getCashSettlementBusinessDays(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("paymentDelay"), Boolean.class, (Object)this.getPaymentDelay(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valueDate"), Date.class, (Object)this.getValueDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("adjustableDates"), processor, AdjustableDates.class, this.getAdjustableDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("adjustableOrRelativeDate"), processor, AdjustableOrAdjustedOrRelativeDate.class, this.getAdjustableOrRelativeDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessDateRange"), processor, BusinessDateRange.class, this.getBusinessDateRange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
    }

    public static class SettlementDateBuilderImpl
    implements SettlementDateBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected AdjustableDates.AdjustableDatesBuilder adjustableDates;
        protected AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDateBuilder adjustableOrRelativeDate;
        protected BusinessDateRange.BusinessDateRangeBuilder businessDateRange;
        protected Integer cashSettlementBusinessDays;
        protected MetaFields.MetaFieldsBuilder meta;
        protected Boolean paymentDelay;
        protected Date valueDate;

        @Override
        public AdjustableDates.AdjustableDatesBuilder getAdjustableDates() {
            return this.adjustableDates;
        }

        @Override
        public AdjustableDates.AdjustableDatesBuilder getOrCreateAdjustableDates() {
            AdjustableDates.AdjustableDatesBuilder result = this.adjustableDates != null ? this.adjustableDates : (this.adjustableDates = AdjustableDates.builder());
            return result;
        }

        @Override
        public AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDateBuilder getAdjustableOrRelativeDate() {
            return this.adjustableOrRelativeDate;
        }

        @Override
        public AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDateBuilder getOrCreateAdjustableOrRelativeDate() {
            AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDateBuilder result = this.adjustableOrRelativeDate != null ? this.adjustableOrRelativeDate : (this.adjustableOrRelativeDate = AdjustableOrAdjustedOrRelativeDate.builder());
            return result;
        }

        @Override
        public BusinessDateRange.BusinessDateRangeBuilder getBusinessDateRange() {
            return this.businessDateRange;
        }

        @Override
        public BusinessDateRange.BusinessDateRangeBuilder getOrCreateBusinessDateRange() {
            BusinessDateRange.BusinessDateRangeBuilder result = this.businessDateRange != null ? this.businessDateRange : (this.businessDateRange = BusinessDateRange.builder());
            return result;
        }

        @Override
        public Integer getCashSettlementBusinessDays() {
            return this.cashSettlementBusinessDays;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public Boolean getPaymentDelay() {
            return this.paymentDelay;
        }

        @Override
        public Date getValueDate() {
            return this.valueDate;
        }

        @Override
        public SettlementDateBuilder setAdjustableDates(AdjustableDates adjustableDates) {
            this.adjustableDates = adjustableDates == null ? null : adjustableDates.toBuilder();
            return this;
        }

        @Override
        public SettlementDateBuilder setAdjustableOrRelativeDate(AdjustableOrAdjustedOrRelativeDate adjustableOrRelativeDate) {
            this.adjustableOrRelativeDate = adjustableOrRelativeDate == null ? null : adjustableOrRelativeDate.toBuilder();
            return this;
        }

        @Override
        public SettlementDateBuilder setBusinessDateRange(BusinessDateRange businessDateRange) {
            this.businessDateRange = businessDateRange == null ? null : businessDateRange.toBuilder();
            return this;
        }

        @Override
        public SettlementDateBuilder setCashSettlementBusinessDays(Integer cashSettlementBusinessDays) {
            this.cashSettlementBusinessDays = cashSettlementBusinessDays == null ? null : cashSettlementBusinessDays;
            return this;
        }

        @Override
        public SettlementDateBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public SettlementDateBuilder setPaymentDelay(Boolean paymentDelay) {
            this.paymentDelay = paymentDelay == null ? null : paymentDelay;
            return this;
        }

        @Override
        public SettlementDateBuilder setValueDate(Date valueDate) {
            this.valueDate = valueDate == null ? null : valueDate;
            return this;
        }

        @Override
        public SettlementDate build() {
            return new SettlementDateImpl(this);
        }

        @Override
        public SettlementDateBuilder toBuilder() {
            return this;
        }

        @Override
        public SettlementDateBuilder prune() {
            if (this.adjustableDates != null && !this.adjustableDates.prune().hasData()) {
                this.adjustableDates = null;
            }
            if (this.adjustableOrRelativeDate != null && !this.adjustableOrRelativeDate.prune().hasData()) {
                this.adjustableOrRelativeDate = null;
            }
            if (this.businessDateRange != null && !this.businessDateRange.prune().hasData()) {
                this.businessDateRange = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAdjustableDates() != null && this.getAdjustableDates().hasData()) {
                return true;
            }
            if (this.getAdjustableOrRelativeDate() != null && this.getAdjustableOrRelativeDate().hasData()) {
                return true;
            }
            if (this.getBusinessDateRange() != null && this.getBusinessDateRange().hasData()) {
                return true;
            }
            if (this.getCashSettlementBusinessDays() != null) {
                return true;
            }
            if (this.getPaymentDelay() != null) {
                return true;
            }
            return this.getValueDate() != null;
        }

        public SettlementDateBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            SettlementDateBuilder o = (SettlementDateBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAdjustableDates(), (RosettaModelObjectBuilder)o.getAdjustableDates(), this::setAdjustableDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAdjustableOrRelativeDate(), (RosettaModelObjectBuilder)o.getAdjustableOrRelativeDate(), this::setAdjustableOrRelativeDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBusinessDateRange(), (RosettaModelObjectBuilder)o.getBusinessDateRange(), this::setBusinessDateRange);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeBasic((Object)this.getCashSettlementBusinessDays(), (Object)o.getCashSettlementBusinessDays(), this::setCashSettlementBusinessDays, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPaymentDelay(), (Object)o.getPaymentDelay(), this::setPaymentDelay, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValueDate(), (Object)o.getValueDate(), this::setValueDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SettlementDate _that = this.getType().cast(o);
            if (!Objects.equals(this.adjustableDates, _that.getAdjustableDates())) {
                return false;
            }
            if (!Objects.equals(this.adjustableOrRelativeDate, _that.getAdjustableOrRelativeDate())) {
                return false;
            }
            if (!Objects.equals(this.businessDateRange, _that.getBusinessDateRange())) {
                return false;
            }
            if (!Objects.equals(this.cashSettlementBusinessDays, _that.getCashSettlementBusinessDays())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.paymentDelay, _that.getPaymentDelay())) {
                return false;
            }
            return Objects.equals(this.valueDate, _that.getValueDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.adjustableDates != null ? this.adjustableDates.hashCode() : 0);
            _result = 31 * _result + (this.adjustableOrRelativeDate != null ? this.adjustableOrRelativeDate.hashCode() : 0);
            _result = 31 * _result + (this.businessDateRange != null ? this.businessDateRange.hashCode() : 0);
            _result = 31 * _result + (this.cashSettlementBusinessDays != null ? this.cashSettlementBusinessDays.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.paymentDelay != null ? this.paymentDelay.hashCode() : 0);
            _result = 31 * _result + (this.valueDate != null ? this.valueDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SettlementDateBuilder {adjustableDates=" + this.adjustableDates + ", adjustableOrRelativeDate=" + this.adjustableOrRelativeDate + ", businessDateRange=" + this.businessDateRange + ", cashSettlementBusinessDays=" + this.cashSettlementBusinessDays + ", meta=" + this.meta + ", paymentDelay=" + this.paymentDelay + ", valueDate=" + this.valueDate + '}';
        }
    }

    public static class SettlementDateImpl
    implements SettlementDate {
        private final AdjustableDates adjustableDates;
        private final AdjustableOrAdjustedOrRelativeDate adjustableOrRelativeDate;
        private final BusinessDateRange businessDateRange;
        private final Integer cashSettlementBusinessDays;
        private final MetaFields meta;
        private final Boolean paymentDelay;
        private final Date valueDate;

        protected SettlementDateImpl(SettlementDateBuilder builder) {
            this.adjustableDates = Optional.ofNullable(builder.getAdjustableDates()).map(f -> f.build()).orElse(null);
            this.adjustableOrRelativeDate = Optional.ofNullable(builder.getAdjustableOrRelativeDate()).map(f -> f.build()).orElse(null);
            this.businessDateRange = Optional.ofNullable(builder.getBusinessDateRange()).map(f -> f.build()).orElse(null);
            this.cashSettlementBusinessDays = builder.getCashSettlementBusinessDays();
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
            this.paymentDelay = builder.getPaymentDelay();
            this.valueDate = builder.getValueDate();
        }

        @Override
        public AdjustableDates getAdjustableDates() {
            return this.adjustableDates;
        }

        @Override
        public AdjustableOrAdjustedOrRelativeDate getAdjustableOrRelativeDate() {
            return this.adjustableOrRelativeDate;
        }

        @Override
        public BusinessDateRange getBusinessDateRange() {
            return this.businessDateRange;
        }

        @Override
        public Integer getCashSettlementBusinessDays() {
            return this.cashSettlementBusinessDays;
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public Boolean getPaymentDelay() {
            return this.paymentDelay;
        }

        @Override
        public Date getValueDate() {
            return this.valueDate;
        }

        @Override
        public SettlementDate build() {
            return this;
        }

        @Override
        public SettlementDateBuilder toBuilder() {
            SettlementDateBuilder builder = SettlementDate.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SettlementDateBuilder builder) {
            Optional.ofNullable(this.getAdjustableDates()).ifPresent(builder::setAdjustableDates);
            Optional.ofNullable(this.getAdjustableOrRelativeDate()).ifPresent(builder::setAdjustableOrRelativeDate);
            Optional.ofNullable(this.getBusinessDateRange()).ifPresent(builder::setBusinessDateRange);
            Optional.ofNullable(this.getCashSettlementBusinessDays()).ifPresent(builder::setCashSettlementBusinessDays);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
            Optional.ofNullable(this.getPaymentDelay()).ifPresent(builder::setPaymentDelay);
            Optional.ofNullable(this.getValueDate()).ifPresent(builder::setValueDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SettlementDate _that = this.getType().cast(o);
            if (!Objects.equals(this.adjustableDates, _that.getAdjustableDates())) {
                return false;
            }
            if (!Objects.equals(this.adjustableOrRelativeDate, _that.getAdjustableOrRelativeDate())) {
                return false;
            }
            if (!Objects.equals(this.businessDateRange, _that.getBusinessDateRange())) {
                return false;
            }
            if (!Objects.equals(this.cashSettlementBusinessDays, _that.getCashSettlementBusinessDays())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.paymentDelay, _that.getPaymentDelay())) {
                return false;
            }
            return Objects.equals(this.valueDate, _that.getValueDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.adjustableDates != null ? this.adjustableDates.hashCode() : 0);
            _result = 31 * _result + (this.adjustableOrRelativeDate != null ? this.adjustableOrRelativeDate.hashCode() : 0);
            _result = 31 * _result + (this.businessDateRange != null ? this.businessDateRange.hashCode() : 0);
            _result = 31 * _result + (this.cashSettlementBusinessDays != null ? this.cashSettlementBusinessDays.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.paymentDelay != null ? this.paymentDelay.hashCode() : 0);
            _result = 31 * _result + (this.valueDate != null ? this.valueDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SettlementDate {adjustableDates=" + this.adjustableDates + ", adjustableOrRelativeDate=" + this.adjustableOrRelativeDate + ", businessDateRange=" + this.businessDateRange + ", cashSettlementBusinessDays=" + this.cashSettlementBusinessDays + ", meta=" + this.meta + ", paymentDelay=" + this.paymentDelay + ", valueDate=" + this.valueDate + '}';
        }
    }

    public static interface SettlementDateBuilder
    extends SettlementDate,
    RosettaModelObjectBuilder {
        public AdjustableDates.AdjustableDatesBuilder getOrCreateAdjustableDates();

        @Override
        public AdjustableDates.AdjustableDatesBuilder getAdjustableDates();

        public AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDateBuilder getOrCreateAdjustableOrRelativeDate();

        @Override
        public AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDateBuilder getAdjustableOrRelativeDate();

        public BusinessDateRange.BusinessDateRangeBuilder getOrCreateBusinessDateRange();

        @Override
        public BusinessDateRange.BusinessDateRangeBuilder getBusinessDateRange();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public SettlementDateBuilder setAdjustableDates(AdjustableDates var1);

        public SettlementDateBuilder setAdjustableOrRelativeDate(AdjustableOrAdjustedOrRelativeDate var1);

        public SettlementDateBuilder setBusinessDateRange(BusinessDateRange var1);

        public SettlementDateBuilder setCashSettlementBusinessDays(Integer var1);

        public SettlementDateBuilder setMeta(MetaFields var1);

        public SettlementDateBuilder setPaymentDelay(Boolean var1);

        public SettlementDateBuilder setValueDate(Date var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("cashSettlementBusinessDays"), Integer.class, (Object)this.getCashSettlementBusinessDays(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("paymentDelay"), Boolean.class, (Object)this.getPaymentDelay(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valueDate"), Date.class, (Object)this.getValueDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("adjustableDates"), processor, AdjustableDates.AdjustableDatesBuilder.class, this.getAdjustableDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("adjustableOrRelativeDate"), processor, AdjustableOrAdjustedOrRelativeDate.AdjustableOrAdjustedOrRelativeDateBuilder.class, this.getAdjustableOrRelativeDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessDateRange"), processor, BusinessDateRange.BusinessDateRangeBuilder.class, this.getBusinessDateRange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
        }

        public SettlementDateBuilder prune();
    }
}

