/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import cdm.product.common.settlement.SettlementCentreEnum;
import cdm.product.common.settlement.SettlementDate;
import cdm.product.common.settlement.SettlementProvision;
import cdm.product.common.settlement.SettlementTypeEnum;
import cdm.product.common.settlement.StandardSettlementStyleEnum;
import cdm.product.common.settlement.TransferSettlementEnum;
import cdm.product.common.settlement.meta.SettlementBaseMeta;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import com.rosetta.model.metafields.MetaFields;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface SettlementBase
extends RosettaModelObject,
GlobalKey {
    public static final SettlementBaseMeta metaData = new SettlementBaseMeta();

    public SettlementBase build();

    public SettlementBaseBuilder toBuilder();

    public MetaFields getMeta();

    public SettlementCentreEnum getSettlementCentre();

    public FieldWithMetaString getSettlementCurrency();

    public SettlementDate getSettlementDate();

    public SettlementProvision getSettlementProvision();

    public SettlementTypeEnum getSettlementType();

    public StandardSettlementStyleEnum getStandardSettlementStyle();

    public TransferSettlementEnum getTransferSettlementType();

    default public RosettaMetaData<? extends SettlementBase> metaData() {
        return metaData;
    }

    public static SettlementBaseBuilder builder() {
        return new SettlementBaseBuilderImpl();
    }

    default public Class<? extends SettlementBase> getType() {
        return SettlementBase.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("settlementCentre"), SettlementCentreEnum.class, (Object)this.getSettlementCentre(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementType"), SettlementTypeEnum.class, (Object)this.getSettlementType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("standardSettlementStyle"), StandardSettlementStyleEnum.class, (Object)this.getStandardSettlementStyle(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("transferSettlementType"), TransferSettlementEnum.class, (Object)this.getTransferSettlementType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementCurrency"), processor, FieldWithMetaString.class, this.getSettlementCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementDate"), processor, SettlementDate.class, this.getSettlementDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementProvision"), processor, SettlementProvision.class, this.getSettlementProvision(), new AttributeMeta[0]);
    }

    public static class SettlementBaseBuilderImpl
    implements SettlementBaseBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected MetaFields.MetaFieldsBuilder meta;
        protected SettlementCentreEnum settlementCentre;
        protected FieldWithMetaString.FieldWithMetaStringBuilder settlementCurrency;
        protected SettlementDate.SettlementDateBuilder settlementDate;
        protected SettlementProvision.SettlementProvisionBuilder settlementProvision;
        protected SettlementTypeEnum settlementType;
        protected StandardSettlementStyleEnum standardSettlementStyle;
        protected TransferSettlementEnum transferSettlementType;

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public SettlementCentreEnum getSettlementCentre() {
            return this.settlementCentre;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getSettlementCurrency() {
            return this.settlementCurrency;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateSettlementCurrency() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.settlementCurrency != null ? this.settlementCurrency : (this.settlementCurrency = FieldWithMetaString.builder());
            return result;
        }

        @Override
        public SettlementDate.SettlementDateBuilder getSettlementDate() {
            return this.settlementDate;
        }

        @Override
        public SettlementDate.SettlementDateBuilder getOrCreateSettlementDate() {
            SettlementDate.SettlementDateBuilder result = this.settlementDate != null ? this.settlementDate : (this.settlementDate = SettlementDate.builder());
            return result;
        }

        @Override
        public SettlementProvision.SettlementProvisionBuilder getSettlementProvision() {
            return this.settlementProvision;
        }

        @Override
        public SettlementProvision.SettlementProvisionBuilder getOrCreateSettlementProvision() {
            SettlementProvision.SettlementProvisionBuilder result = this.settlementProvision != null ? this.settlementProvision : (this.settlementProvision = SettlementProvision.builder());
            return result;
        }

        @Override
        public SettlementTypeEnum getSettlementType() {
            return this.settlementType;
        }

        @Override
        public StandardSettlementStyleEnum getStandardSettlementStyle() {
            return this.standardSettlementStyle;
        }

        @Override
        public TransferSettlementEnum getTransferSettlementType() {
            return this.transferSettlementType;
        }

        @Override
        public SettlementBaseBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public SettlementBaseBuilder setSettlementCentre(SettlementCentreEnum settlementCentre) {
            this.settlementCentre = settlementCentre == null ? null : settlementCentre;
            return this;
        }

        @Override
        public SettlementBaseBuilder setSettlementCurrency(FieldWithMetaString settlementCurrency) {
            this.settlementCurrency = settlementCurrency == null ? null : settlementCurrency.toBuilder();
            return this;
        }

        @Override
        public SettlementBaseBuilder setSettlementCurrencyValue(String settlementCurrency) {
            this.getOrCreateSettlementCurrency().setValue(settlementCurrency);
            return this;
        }

        @Override
        public SettlementBaseBuilder setSettlementDate(SettlementDate settlementDate) {
            this.settlementDate = settlementDate == null ? null : settlementDate.toBuilder();
            return this;
        }

        @Override
        public SettlementBaseBuilder setSettlementProvision(SettlementProvision settlementProvision) {
            this.settlementProvision = settlementProvision == null ? null : settlementProvision.toBuilder();
            return this;
        }

        @Override
        public SettlementBaseBuilder setSettlementType(SettlementTypeEnum settlementType) {
            this.settlementType = settlementType == null ? null : settlementType;
            return this;
        }

        @Override
        public SettlementBaseBuilder setStandardSettlementStyle(StandardSettlementStyleEnum standardSettlementStyle) {
            this.standardSettlementStyle = standardSettlementStyle == null ? null : standardSettlementStyle;
            return this;
        }

        @Override
        public SettlementBaseBuilder setTransferSettlementType(TransferSettlementEnum transferSettlementType) {
            this.transferSettlementType = transferSettlementType == null ? null : transferSettlementType;
            return this;
        }

        @Override
        public SettlementBase build() {
            return new SettlementBaseImpl(this);
        }

        @Override
        public SettlementBaseBuilder toBuilder() {
            return this;
        }

        @Override
        public SettlementBaseBuilder prune() {
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            if (this.settlementCurrency != null && !this.settlementCurrency.prune().hasData()) {
                this.settlementCurrency = null;
            }
            if (this.settlementDate != null && !this.settlementDate.prune().hasData()) {
                this.settlementDate = null;
            }
            if (this.settlementProvision != null && !this.settlementProvision.prune().hasData()) {
                this.settlementProvision = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getSettlementCentre() != null) {
                return true;
            }
            if (this.getSettlementCurrency() != null) {
                return true;
            }
            if (this.getSettlementDate() != null && this.getSettlementDate().hasData()) {
                return true;
            }
            if (this.getSettlementProvision() != null && this.getSettlementProvision().hasData()) {
                return true;
            }
            if (this.getSettlementType() != null) {
                return true;
            }
            if (this.getStandardSettlementStyle() != null) {
                return true;
            }
            return this.getTransferSettlementType() != null;
        }

        public SettlementBaseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            SettlementBaseBuilder o = (SettlementBaseBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementCurrency(), (RosettaModelObjectBuilder)o.getSettlementCurrency(), this::setSettlementCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementDate(), (RosettaModelObjectBuilder)o.getSettlementDate(), this::setSettlementDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementProvision(), (RosettaModelObjectBuilder)o.getSettlementProvision(), this::setSettlementProvision);
            merger.mergeBasic((Object)this.getSettlementCentre(), (Object)o.getSettlementCentre(), this::setSettlementCentre, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSettlementType(), (Object)o.getSettlementType(), this::setSettlementType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getStandardSettlementStyle(), (Object)o.getStandardSettlementStyle(), this::setStandardSettlementStyle, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTransferSettlementType(), (Object)o.getTransferSettlementType(), this::setTransferSettlementType, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SettlementBase _that = this.getType().cast(o);
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals((Object)this.settlementCentre, (Object)_that.getSettlementCentre())) {
                return false;
            }
            if (!Objects.equals(this.settlementCurrency, _that.getSettlementCurrency())) {
                return false;
            }
            if (!Objects.equals(this.settlementDate, _that.getSettlementDate())) {
                return false;
            }
            if (!Objects.equals(this.settlementProvision, _that.getSettlementProvision())) {
                return false;
            }
            if (!Objects.equals((Object)this.settlementType, (Object)_that.getSettlementType())) {
                return false;
            }
            if (!Objects.equals((Object)this.standardSettlementStyle, (Object)_that.getStandardSettlementStyle())) {
                return false;
            }
            return Objects.equals((Object)this.transferSettlementType, (Object)_that.getTransferSettlementType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.settlementCentre != null ? ((Object)((Object)this.settlementCentre)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.settlementCurrency != null ? this.settlementCurrency.hashCode() : 0);
            _result = 31 * _result + (this.settlementDate != null ? this.settlementDate.hashCode() : 0);
            _result = 31 * _result + (this.settlementProvision != null ? this.settlementProvision.hashCode() : 0);
            _result = 31 * _result + (this.settlementType != null ? ((Object)((Object)this.settlementType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.standardSettlementStyle != null ? ((Object)((Object)this.standardSettlementStyle)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.transferSettlementType != null ? ((Object)((Object)this.transferSettlementType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SettlementBaseBuilder {meta=" + this.meta + ", settlementCentre=" + (Object)((Object)this.settlementCentre) + ", settlementCurrency=" + this.settlementCurrency + ", settlementDate=" + this.settlementDate + ", settlementProvision=" + this.settlementProvision + ", settlementType=" + (Object)((Object)this.settlementType) + ", standardSettlementStyle=" + (Object)((Object)this.standardSettlementStyle) + ", transferSettlementType=" + (Object)((Object)this.transferSettlementType) + '}';
        }
    }

    public static class SettlementBaseImpl
    implements SettlementBase {
        private final MetaFields meta;
        private final SettlementCentreEnum settlementCentre;
        private final FieldWithMetaString settlementCurrency;
        private final SettlementDate settlementDate;
        private final SettlementProvision settlementProvision;
        private final SettlementTypeEnum settlementType;
        private final StandardSettlementStyleEnum standardSettlementStyle;
        private final TransferSettlementEnum transferSettlementType;

        protected SettlementBaseImpl(SettlementBaseBuilder builder) {
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
            this.settlementCentre = builder.getSettlementCentre();
            this.settlementCurrency = Optional.ofNullable(builder.getSettlementCurrency()).map(f -> f.build()).orElse(null);
            this.settlementDate = Optional.ofNullable(builder.getSettlementDate()).map(f -> f.build()).orElse(null);
            this.settlementProvision = Optional.ofNullable(builder.getSettlementProvision()).map(f -> f.build()).orElse(null);
            this.settlementType = builder.getSettlementType();
            this.standardSettlementStyle = builder.getStandardSettlementStyle();
            this.transferSettlementType = builder.getTransferSettlementType();
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public SettlementCentreEnum getSettlementCentre() {
            return this.settlementCentre;
        }

        @Override
        public FieldWithMetaString getSettlementCurrency() {
            return this.settlementCurrency;
        }

        @Override
        public SettlementDate getSettlementDate() {
            return this.settlementDate;
        }

        @Override
        public SettlementProvision getSettlementProvision() {
            return this.settlementProvision;
        }

        @Override
        public SettlementTypeEnum getSettlementType() {
            return this.settlementType;
        }

        @Override
        public StandardSettlementStyleEnum getStandardSettlementStyle() {
            return this.standardSettlementStyle;
        }

        @Override
        public TransferSettlementEnum getTransferSettlementType() {
            return this.transferSettlementType;
        }

        @Override
        public SettlementBase build() {
            return this;
        }

        @Override
        public SettlementBaseBuilder toBuilder() {
            SettlementBaseBuilder builder = SettlementBase.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SettlementBaseBuilder builder) {
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
            Optional.ofNullable(this.getSettlementCentre()).ifPresent(builder::setSettlementCentre);
            Optional.ofNullable(this.getSettlementCurrency()).ifPresent(builder::setSettlementCurrency);
            Optional.ofNullable(this.getSettlementDate()).ifPresent(builder::setSettlementDate);
            Optional.ofNullable(this.getSettlementProvision()).ifPresent(builder::setSettlementProvision);
            Optional.ofNullable(this.getSettlementType()).ifPresent(builder::setSettlementType);
            Optional.ofNullable(this.getStandardSettlementStyle()).ifPresent(builder::setStandardSettlementStyle);
            Optional.ofNullable(this.getTransferSettlementType()).ifPresent(builder::setTransferSettlementType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SettlementBase _that = this.getType().cast(o);
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals((Object)this.settlementCentre, (Object)_that.getSettlementCentre())) {
                return false;
            }
            if (!Objects.equals(this.settlementCurrency, _that.getSettlementCurrency())) {
                return false;
            }
            if (!Objects.equals(this.settlementDate, _that.getSettlementDate())) {
                return false;
            }
            if (!Objects.equals(this.settlementProvision, _that.getSettlementProvision())) {
                return false;
            }
            if (!Objects.equals((Object)this.settlementType, (Object)_that.getSettlementType())) {
                return false;
            }
            if (!Objects.equals((Object)this.standardSettlementStyle, (Object)_that.getStandardSettlementStyle())) {
                return false;
            }
            return Objects.equals((Object)this.transferSettlementType, (Object)_that.getTransferSettlementType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.settlementCentre != null ? ((Object)((Object)this.settlementCentre)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.settlementCurrency != null ? this.settlementCurrency.hashCode() : 0);
            _result = 31 * _result + (this.settlementDate != null ? this.settlementDate.hashCode() : 0);
            _result = 31 * _result + (this.settlementProvision != null ? this.settlementProvision.hashCode() : 0);
            _result = 31 * _result + (this.settlementType != null ? ((Object)((Object)this.settlementType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.standardSettlementStyle != null ? ((Object)((Object)this.standardSettlementStyle)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.transferSettlementType != null ? ((Object)((Object)this.transferSettlementType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SettlementBase {meta=" + this.meta + ", settlementCentre=" + (Object)((Object)this.settlementCentre) + ", settlementCurrency=" + this.settlementCurrency + ", settlementDate=" + this.settlementDate + ", settlementProvision=" + this.settlementProvision + ", settlementType=" + (Object)((Object)this.settlementType) + ", standardSettlementStyle=" + (Object)((Object)this.standardSettlementStyle) + ", transferSettlementType=" + (Object)((Object)this.transferSettlementType) + '}';
        }
    }

    public static interface SettlementBaseBuilder
    extends SettlementBase,
    RosettaModelObjectBuilder {
        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateSettlementCurrency();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getSettlementCurrency();

        public SettlementDate.SettlementDateBuilder getOrCreateSettlementDate();

        @Override
        public SettlementDate.SettlementDateBuilder getSettlementDate();

        public SettlementProvision.SettlementProvisionBuilder getOrCreateSettlementProvision();

        @Override
        public SettlementProvision.SettlementProvisionBuilder getSettlementProvision();

        public SettlementBaseBuilder setMeta(MetaFields var1);

        public SettlementBaseBuilder setSettlementCentre(SettlementCentreEnum var1);

        public SettlementBaseBuilder setSettlementCurrency(FieldWithMetaString var1);

        public SettlementBaseBuilder setSettlementCurrencyValue(String var1);

        public SettlementBaseBuilder setSettlementDate(SettlementDate var1);

        public SettlementBaseBuilder setSettlementProvision(SettlementProvision var1);

        public SettlementBaseBuilder setSettlementType(SettlementTypeEnum var1);

        public SettlementBaseBuilder setStandardSettlementStyle(StandardSettlementStyleEnum var1);

        public SettlementBaseBuilder setTransferSettlementType(TransferSettlementEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("settlementCentre"), SettlementCentreEnum.class, (Object)this.getSettlementCentre(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementType"), SettlementTypeEnum.class, (Object)this.getSettlementType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("standardSettlementStyle"), StandardSettlementStyleEnum.class, (Object)this.getStandardSettlementStyle(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("transferSettlementType"), TransferSettlementEnum.class, (Object)this.getTransferSettlementType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementCurrency"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getSettlementCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementDate"), processor, SettlementDate.SettlementDateBuilder.class, this.getSettlementDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementProvision"), processor, SettlementProvision.SettlementProvisionBuilder.class, this.getSettlementProvision(), new AttributeMeta[0]);
        }

        public SettlementBaseBuilder prune();
    }
}

