/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum ScheduledTransferEnum {
    CORPORATE_ACTION,
    COUPON,
    CREDIT_EVENT,
    DIVIDEND_RETURN,
    EXERCISE,
    FIXED_RATE_RETURN,
    FLOATING_RATE_RETURN,
    FRACTIONAL_AMOUNT,
    INTEREST_RETURN,
    NET_INTEREST,
    PERFORMANCE,
    PRINCIPAL_PAYMENT;

    private static Map<String, ScheduledTransferEnum> values;
    private final String displayName;

    private ScheduledTransferEnum() {
        this(null);
    }

    private ScheduledTransferEnum(String displayName) {
        this.displayName = displayName;
    }

    public static ScheduledTransferEnum fromDisplayName(String name) {
        ScheduledTransferEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.displayName != null ? this.displayName : this.name();
    }

    static {
        ConcurrentHashMap<String, ScheduledTransferEnum> map = new ConcurrentHashMap<String, ScheduledTransferEnum>();
        for (ScheduledTransferEnum instance : ScheduledTransferEnum.values()) {
            map.put(instance.toString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

