/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import cdm.base.datetime.Offset;
import cdm.product.asset.RollSourceCalendarEnum;
import cdm.product.common.settlement.meta.RollFeatureMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface RollFeature
extends RosettaModelObject {
    public static final RollFeatureMeta metaData = new RollFeatureMeta();

    public RollFeature build();

    public RollFeatureBuilder toBuilder();

    public Offset getDeliveryDateRollConvention();

    public RollSourceCalendarEnum getRollSourceCalendar();

    default public RosettaMetaData<? extends RollFeature> metaData() {
        return metaData;
    }

    public static RollFeatureBuilder builder() {
        return new RollFeatureBuilderImpl();
    }

    default public Class<? extends RollFeature> getType() {
        return RollFeature.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("rollSourceCalendar"), RollSourceCalendarEnum.class, (Object)this.getRollSourceCalendar(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryDateRollConvention"), processor, Offset.class, this.getDeliveryDateRollConvention(), new AttributeMeta[0]);
    }

    public static class RollFeatureBuilderImpl
    implements RollFeatureBuilder {
        protected Offset.OffsetBuilder deliveryDateRollConvention;
        protected RollSourceCalendarEnum rollSourceCalendar;

        @Override
        public Offset.OffsetBuilder getDeliveryDateRollConvention() {
            return this.deliveryDateRollConvention;
        }

        @Override
        public Offset.OffsetBuilder getOrCreateDeliveryDateRollConvention() {
            Offset.OffsetBuilder result = this.deliveryDateRollConvention != null ? this.deliveryDateRollConvention : (this.deliveryDateRollConvention = Offset.builder());
            return result;
        }

        @Override
        public RollSourceCalendarEnum getRollSourceCalendar() {
            return this.rollSourceCalendar;
        }

        @Override
        public RollFeatureBuilder setDeliveryDateRollConvention(Offset deliveryDateRollConvention) {
            this.deliveryDateRollConvention = deliveryDateRollConvention == null ? null : deliveryDateRollConvention.toBuilder();
            return this;
        }

        @Override
        public RollFeatureBuilder setRollSourceCalendar(RollSourceCalendarEnum rollSourceCalendar) {
            this.rollSourceCalendar = rollSourceCalendar == null ? null : rollSourceCalendar;
            return this;
        }

        @Override
        public RollFeature build() {
            return new RollFeatureImpl(this);
        }

        @Override
        public RollFeatureBuilder toBuilder() {
            return this;
        }

        @Override
        public RollFeatureBuilder prune() {
            if (this.deliveryDateRollConvention != null && !this.deliveryDateRollConvention.prune().hasData()) {
                this.deliveryDateRollConvention = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getDeliveryDateRollConvention() != null && this.getDeliveryDateRollConvention().hasData()) {
                return true;
            }
            return this.getRollSourceCalendar() != null;
        }

        public RollFeatureBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            RollFeatureBuilder o = (RollFeatureBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryDateRollConvention(), (RosettaModelObjectBuilder)o.getDeliveryDateRollConvention(), this::setDeliveryDateRollConvention);
            merger.mergeBasic((Object)this.getRollSourceCalendar(), (Object)o.getRollSourceCalendar(), this::setRollSourceCalendar, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RollFeature _that = this.getType().cast(o);
            if (!Objects.equals(this.deliveryDateRollConvention, _that.getDeliveryDateRollConvention())) {
                return false;
            }
            return Objects.equals((Object)this.rollSourceCalendar, (Object)_that.getRollSourceCalendar());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.deliveryDateRollConvention != null ? this.deliveryDateRollConvention.hashCode() : 0);
            _result = 31 * _result + (this.rollSourceCalendar != null ? ((Object)((Object)this.rollSourceCalendar)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RollFeatureBuilder {deliveryDateRollConvention=" + this.deliveryDateRollConvention + ", rollSourceCalendar=" + (Object)((Object)this.rollSourceCalendar) + '}';
        }
    }

    public static class RollFeatureImpl
    implements RollFeature {
        private final Offset deliveryDateRollConvention;
        private final RollSourceCalendarEnum rollSourceCalendar;

        protected RollFeatureImpl(RollFeatureBuilder builder) {
            this.deliveryDateRollConvention = Optional.ofNullable(builder.getDeliveryDateRollConvention()).map(f -> f.build()).orElse(null);
            this.rollSourceCalendar = builder.getRollSourceCalendar();
        }

        @Override
        public Offset getDeliveryDateRollConvention() {
            return this.deliveryDateRollConvention;
        }

        @Override
        public RollSourceCalendarEnum getRollSourceCalendar() {
            return this.rollSourceCalendar;
        }

        @Override
        public RollFeature build() {
            return this;
        }

        @Override
        public RollFeatureBuilder toBuilder() {
            RollFeatureBuilder builder = RollFeature.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RollFeatureBuilder builder) {
            Optional.ofNullable(this.getDeliveryDateRollConvention()).ifPresent(builder::setDeliveryDateRollConvention);
            Optional.ofNullable(this.getRollSourceCalendar()).ifPresent(builder::setRollSourceCalendar);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RollFeature _that = this.getType().cast(o);
            if (!Objects.equals(this.deliveryDateRollConvention, _that.getDeliveryDateRollConvention())) {
                return false;
            }
            return Objects.equals((Object)this.rollSourceCalendar, (Object)_that.getRollSourceCalendar());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.deliveryDateRollConvention != null ? this.deliveryDateRollConvention.hashCode() : 0);
            _result = 31 * _result + (this.rollSourceCalendar != null ? ((Object)((Object)this.rollSourceCalendar)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RollFeature {deliveryDateRollConvention=" + this.deliveryDateRollConvention + ", rollSourceCalendar=" + (Object)((Object)this.rollSourceCalendar) + '}';
        }
    }

    public static interface RollFeatureBuilder
    extends RollFeature,
    RosettaModelObjectBuilder {
        public Offset.OffsetBuilder getOrCreateDeliveryDateRollConvention();

        @Override
        public Offset.OffsetBuilder getDeliveryDateRollConvention();

        public RollFeatureBuilder setDeliveryDateRollConvention(Offset var1);

        public RollFeatureBuilder setRollSourceCalendar(RollSourceCalendarEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("rollSourceCalendar"), RollSourceCalendarEnum.class, (Object)this.getRollSourceCalendar(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryDateRollConvention"), processor, Offset.OffsetBuilder.class, this.getDeliveryDateRollConvention(), new AttributeMeta[0]);
        }

        public RollFeatureBuilder prune();
    }
}

