/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import cdm.product.common.settlement.PrincipalPaymentSchedule;
import cdm.product.common.settlement.meta.PrincipalPaymentsMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface PrincipalPayments
extends RosettaModelObject,
GlobalKey {
    public static final PrincipalPaymentsMeta metaData = new PrincipalPaymentsMeta();

    public PrincipalPayments build();

    public PrincipalPaymentsBuilder toBuilder();

    public Boolean getFinalPayment();

    public Boolean getInitialPayment();

    public Boolean getIntermediatePayment();

    public MetaFields getMeta();

    public PrincipalPaymentSchedule getPrincipalPaymentSchedule();

    public List<String> getVaryingLegNotionalCurrency();

    default public RosettaMetaData<? extends PrincipalPayments> metaData() {
        return metaData;
    }

    public static PrincipalPaymentsBuilder builder() {
        return new PrincipalPaymentsBuilderImpl();
    }

    default public Class<? extends PrincipalPayments> getType() {
        return PrincipalPayments.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("finalPayment"), Boolean.class, (Object)this.getFinalPayment(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialPayment"), Boolean.class, (Object)this.getInitialPayment(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("intermediatePayment"), Boolean.class, (Object)this.getIntermediatePayment(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("varyingLegNotionalCurrency"), String.class, this.getVaryingLegNotionalCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("principalPaymentSchedule"), processor, PrincipalPaymentSchedule.class, this.getPrincipalPaymentSchedule(), new AttributeMeta[0]);
    }

    public static class PrincipalPaymentsBuilderImpl
    implements PrincipalPaymentsBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected Boolean finalPayment;
        protected Boolean initialPayment;
        protected Boolean intermediatePayment;
        protected MetaFields.MetaFieldsBuilder meta;
        protected PrincipalPaymentSchedule.PrincipalPaymentScheduleBuilder principalPaymentSchedule;
        protected List<String> varyingLegNotionalCurrency = new ArrayList<String>();

        @Override
        public Boolean getFinalPayment() {
            return this.finalPayment;
        }

        @Override
        public Boolean getInitialPayment() {
            return this.initialPayment;
        }

        @Override
        public Boolean getIntermediatePayment() {
            return this.intermediatePayment;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public PrincipalPaymentSchedule.PrincipalPaymentScheduleBuilder getPrincipalPaymentSchedule() {
            return this.principalPaymentSchedule;
        }

        @Override
        public PrincipalPaymentSchedule.PrincipalPaymentScheduleBuilder getOrCreatePrincipalPaymentSchedule() {
            PrincipalPaymentSchedule.PrincipalPaymentScheduleBuilder result = this.principalPaymentSchedule != null ? this.principalPaymentSchedule : (this.principalPaymentSchedule = PrincipalPaymentSchedule.builder());
            return result;
        }

        @Override
        public List<String> getVaryingLegNotionalCurrency() {
            return this.varyingLegNotionalCurrency;
        }

        @Override
        public PrincipalPaymentsBuilder setFinalPayment(Boolean finalPayment) {
            this.finalPayment = finalPayment == null ? null : finalPayment;
            return this;
        }

        @Override
        public PrincipalPaymentsBuilder setInitialPayment(Boolean initialPayment) {
            this.initialPayment = initialPayment == null ? null : initialPayment;
            return this;
        }

        @Override
        public PrincipalPaymentsBuilder setIntermediatePayment(Boolean intermediatePayment) {
            this.intermediatePayment = intermediatePayment == null ? null : intermediatePayment;
            return this;
        }

        @Override
        public PrincipalPaymentsBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public PrincipalPaymentsBuilder setPrincipalPaymentSchedule(PrincipalPaymentSchedule principalPaymentSchedule) {
            this.principalPaymentSchedule = principalPaymentSchedule == null ? null : principalPaymentSchedule.toBuilder();
            return this;
        }

        @Override
        public PrincipalPaymentsBuilder addVaryingLegNotionalCurrency(String varyingLegNotionalCurrency) {
            if (varyingLegNotionalCurrency != null) {
                this.varyingLegNotionalCurrency.add(varyingLegNotionalCurrency);
            }
            return this;
        }

        @Override
        public PrincipalPaymentsBuilder addVaryingLegNotionalCurrency(String varyingLegNotionalCurrency, int _idx) {
            this.getIndex(this.varyingLegNotionalCurrency, _idx, () -> varyingLegNotionalCurrency);
            return this;
        }

        @Override
        public PrincipalPaymentsBuilder addVaryingLegNotionalCurrency(List<? extends String> varyingLegNotionalCurrencys) {
            if (varyingLegNotionalCurrencys != null) {
                for (String string : varyingLegNotionalCurrencys) {
                    this.varyingLegNotionalCurrency.add(string);
                }
            }
            return this;
        }

        @Override
        public PrincipalPaymentsBuilder setVaryingLegNotionalCurrency(List<? extends String> varyingLegNotionalCurrencys) {
            this.varyingLegNotionalCurrency = varyingLegNotionalCurrencys == null ? new ArrayList<String>() : (List)varyingLegNotionalCurrencys.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PrincipalPayments build() {
            return new PrincipalPaymentsImpl(this);
        }

        @Override
        public PrincipalPaymentsBuilder toBuilder() {
            return this;
        }

        @Override
        public PrincipalPaymentsBuilder prune() {
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            if (this.principalPaymentSchedule != null && !this.principalPaymentSchedule.prune().hasData()) {
                this.principalPaymentSchedule = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getFinalPayment() != null) {
                return true;
            }
            if (this.getInitialPayment() != null) {
                return true;
            }
            if (this.getIntermediatePayment() != null) {
                return true;
            }
            if (this.getPrincipalPaymentSchedule() != null && this.getPrincipalPaymentSchedule().hasData()) {
                return true;
            }
            return this.getVaryingLegNotionalCurrency() != null && !this.getVaryingLegNotionalCurrency().isEmpty();
        }

        public PrincipalPaymentsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PrincipalPaymentsBuilder o = (PrincipalPaymentsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrincipalPaymentSchedule(), (RosettaModelObjectBuilder)o.getPrincipalPaymentSchedule(), this::setPrincipalPaymentSchedule);
            merger.mergeBasic((Object)this.getFinalPayment(), (Object)o.getFinalPayment(), this::setFinalPayment, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInitialPayment(), (Object)o.getInitialPayment(), this::setInitialPayment, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIntermediatePayment(), (Object)o.getIntermediatePayment(), this::setIntermediatePayment, new AttributeMeta[0]);
            merger.mergeBasic(this.getVaryingLegNotionalCurrency(), o.getVaryingLegNotionalCurrency(), this::addVaryingLegNotionalCurrency);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PrincipalPayments _that = this.getType().cast(o);
            if (!Objects.equals(this.finalPayment, _that.getFinalPayment())) {
                return false;
            }
            if (!Objects.equals(this.initialPayment, _that.getInitialPayment())) {
                return false;
            }
            if (!Objects.equals(this.intermediatePayment, _that.getIntermediatePayment())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.principalPaymentSchedule, _that.getPrincipalPaymentSchedule())) {
                return false;
            }
            return ListEquals.listEquals(this.varyingLegNotionalCurrency, _that.getVaryingLegNotionalCurrency());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.finalPayment != null ? this.finalPayment.hashCode() : 0);
            _result = 31 * _result + (this.initialPayment != null ? this.initialPayment.hashCode() : 0);
            _result = 31 * _result + (this.intermediatePayment != null ? this.intermediatePayment.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.principalPaymentSchedule != null ? this.principalPaymentSchedule.hashCode() : 0);
            _result = 31 * _result + (this.varyingLegNotionalCurrency != null ? this.varyingLegNotionalCurrency.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PrincipalPaymentsBuilder {finalPayment=" + this.finalPayment + ", initialPayment=" + this.initialPayment + ", intermediatePayment=" + this.intermediatePayment + ", meta=" + this.meta + ", principalPaymentSchedule=" + this.principalPaymentSchedule + ", varyingLegNotionalCurrency=" + this.varyingLegNotionalCurrency + '}';
        }
    }

    public static class PrincipalPaymentsImpl
    implements PrincipalPayments {
        private final Boolean finalPayment;
        private final Boolean initialPayment;
        private final Boolean intermediatePayment;
        private final MetaFields meta;
        private final PrincipalPaymentSchedule principalPaymentSchedule;
        private final List<String> varyingLegNotionalCurrency;

        protected PrincipalPaymentsImpl(PrincipalPaymentsBuilder builder) {
            this.finalPayment = builder.getFinalPayment();
            this.initialPayment = builder.getInitialPayment();
            this.intermediatePayment = builder.getIntermediatePayment();
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
            this.principalPaymentSchedule = Optional.ofNullable(builder.getPrincipalPaymentSchedule()).map(f -> f.build()).orElse(null);
            this.varyingLegNotionalCurrency = Optional.ofNullable(builder.getVaryingLegNotionalCurrency()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
        }

        @Override
        public Boolean getFinalPayment() {
            return this.finalPayment;
        }

        @Override
        public Boolean getInitialPayment() {
            return this.initialPayment;
        }

        @Override
        public Boolean getIntermediatePayment() {
            return this.intermediatePayment;
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public PrincipalPaymentSchedule getPrincipalPaymentSchedule() {
            return this.principalPaymentSchedule;
        }

        @Override
        public List<String> getVaryingLegNotionalCurrency() {
            return this.varyingLegNotionalCurrency;
        }

        @Override
        public PrincipalPayments build() {
            return this;
        }

        @Override
        public PrincipalPaymentsBuilder toBuilder() {
            PrincipalPaymentsBuilder builder = PrincipalPayments.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PrincipalPaymentsBuilder builder) {
            Optional.ofNullable(this.getFinalPayment()).ifPresent(builder::setFinalPayment);
            Optional.ofNullable(this.getInitialPayment()).ifPresent(builder::setInitialPayment);
            Optional.ofNullable(this.getIntermediatePayment()).ifPresent(builder::setIntermediatePayment);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
            Optional.ofNullable(this.getPrincipalPaymentSchedule()).ifPresent(builder::setPrincipalPaymentSchedule);
            Optional.ofNullable(this.getVaryingLegNotionalCurrency()).ifPresent(builder::setVaryingLegNotionalCurrency);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PrincipalPayments _that = this.getType().cast(o);
            if (!Objects.equals(this.finalPayment, _that.getFinalPayment())) {
                return false;
            }
            if (!Objects.equals(this.initialPayment, _that.getInitialPayment())) {
                return false;
            }
            if (!Objects.equals(this.intermediatePayment, _that.getIntermediatePayment())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.principalPaymentSchedule, _that.getPrincipalPaymentSchedule())) {
                return false;
            }
            return ListEquals.listEquals(this.varyingLegNotionalCurrency, _that.getVaryingLegNotionalCurrency());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.finalPayment != null ? this.finalPayment.hashCode() : 0);
            _result = 31 * _result + (this.initialPayment != null ? this.initialPayment.hashCode() : 0);
            _result = 31 * _result + (this.intermediatePayment != null ? this.intermediatePayment.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.principalPaymentSchedule != null ? this.principalPaymentSchedule.hashCode() : 0);
            _result = 31 * _result + (this.varyingLegNotionalCurrency != null ? this.varyingLegNotionalCurrency.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PrincipalPayments {finalPayment=" + this.finalPayment + ", initialPayment=" + this.initialPayment + ", intermediatePayment=" + this.intermediatePayment + ", meta=" + this.meta + ", principalPaymentSchedule=" + this.principalPaymentSchedule + ", varyingLegNotionalCurrency=" + this.varyingLegNotionalCurrency + '}';
        }
    }

    public static interface PrincipalPaymentsBuilder
    extends PrincipalPayments,
    RosettaModelObjectBuilder {
        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public PrincipalPaymentSchedule.PrincipalPaymentScheduleBuilder getOrCreatePrincipalPaymentSchedule();

        @Override
        public PrincipalPaymentSchedule.PrincipalPaymentScheduleBuilder getPrincipalPaymentSchedule();

        public PrincipalPaymentsBuilder setFinalPayment(Boolean var1);

        public PrincipalPaymentsBuilder setInitialPayment(Boolean var1);

        public PrincipalPaymentsBuilder setIntermediatePayment(Boolean var1);

        public PrincipalPaymentsBuilder setMeta(MetaFields var1);

        public PrincipalPaymentsBuilder setPrincipalPaymentSchedule(PrincipalPaymentSchedule var1);

        public PrincipalPaymentsBuilder addVaryingLegNotionalCurrency(String var1);

        public PrincipalPaymentsBuilder addVaryingLegNotionalCurrency(String var1, int var2);

        public PrincipalPaymentsBuilder addVaryingLegNotionalCurrency(List<? extends String> var1);

        public PrincipalPaymentsBuilder setVaryingLegNotionalCurrency(List<? extends String> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("finalPayment"), Boolean.class, (Object)this.getFinalPayment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialPayment"), Boolean.class, (Object)this.getInitialPayment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("intermediatePayment"), Boolean.class, (Object)this.getIntermediatePayment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("varyingLegNotionalCurrency"), String.class, this.getVaryingLegNotionalCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("principalPaymentSchedule"), processor, PrincipalPaymentSchedule.PrincipalPaymentScheduleBuilder.class, this.getPrincipalPaymentSchedule(), new AttributeMeta[0]);
        }

        public PrincipalPaymentsBuilder prune();
    }
}

