/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import cdm.base.datetime.AdjustableDate;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.observable.asset.Money;
import cdm.product.common.settlement.meta.PrincipalPaymentMeta;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface PrincipalPayment
extends RosettaModelObject,
GlobalKey {
    public static final PrincipalPaymentMeta metaData = new PrincipalPaymentMeta();

    public PrincipalPayment build();

    public PrincipalPaymentBuilder toBuilder();

    public BigDecimal getDiscountFactor();

    public MetaFields getMeta();

    public PayerReceiver getPayerReceiver();

    public Money getPresentValuePrincipalAmount();

    public Money getPrincipalAmount();

    public AdjustableDate getPrincipalPaymentDate();

    default public RosettaMetaData<? extends PrincipalPayment> metaData() {
        return metaData;
    }

    public static PrincipalPaymentBuilder builder() {
        return new PrincipalPaymentBuilderImpl();
    }

    default public Class<? extends PrincipalPayment> getType() {
        return PrincipalPayment.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("discountFactor"), BigDecimal.class, (Object)this.getDiscountFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiver"), processor, PayerReceiver.class, this.getPayerReceiver(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("presentValuePrincipalAmount"), processor, Money.class, this.getPresentValuePrincipalAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("principalAmount"), processor, Money.class, this.getPrincipalAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("principalPaymentDate"), processor, AdjustableDate.class, this.getPrincipalPaymentDate(), new AttributeMeta[0]);
    }

    public static class PrincipalPaymentBuilderImpl
    implements PrincipalPaymentBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected BigDecimal discountFactor;
        protected MetaFields.MetaFieldsBuilder meta;
        protected PayerReceiver.PayerReceiverBuilder payerReceiver;
        protected Money.MoneyBuilder presentValuePrincipalAmount;
        protected Money.MoneyBuilder principalAmount;
        protected AdjustableDate.AdjustableDateBuilder principalPaymentDate;

        @Override
        public BigDecimal getDiscountFactor() {
            return this.discountFactor;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public PayerReceiver.PayerReceiverBuilder getPayerReceiver() {
            return this.payerReceiver;
        }

        @Override
        public PayerReceiver.PayerReceiverBuilder getOrCreatePayerReceiver() {
            PayerReceiver.PayerReceiverBuilder result = this.payerReceiver != null ? this.payerReceiver : (this.payerReceiver = PayerReceiver.builder());
            return result;
        }

        @Override
        public Money.MoneyBuilder getPresentValuePrincipalAmount() {
            return this.presentValuePrincipalAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreatePresentValuePrincipalAmount() {
            Money.MoneyBuilder result = this.presentValuePrincipalAmount != null ? this.presentValuePrincipalAmount : (this.presentValuePrincipalAmount = Money.builder());
            return result;
        }

        @Override
        public Money.MoneyBuilder getPrincipalAmount() {
            return this.principalAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreatePrincipalAmount() {
            Money.MoneyBuilder result = this.principalAmount != null ? this.principalAmount : (this.principalAmount = Money.builder());
            return result;
        }

        @Override
        public AdjustableDate.AdjustableDateBuilder getPrincipalPaymentDate() {
            return this.principalPaymentDate;
        }

        @Override
        public AdjustableDate.AdjustableDateBuilder getOrCreatePrincipalPaymentDate() {
            AdjustableDate.AdjustableDateBuilder result = this.principalPaymentDate != null ? this.principalPaymentDate : (this.principalPaymentDate = AdjustableDate.builder());
            return result;
        }

        @Override
        public PrincipalPaymentBuilder setDiscountFactor(BigDecimal discountFactor) {
            this.discountFactor = discountFactor == null ? null : discountFactor;
            return this;
        }

        @Override
        public PrincipalPaymentBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public PrincipalPaymentBuilder setPayerReceiver(PayerReceiver payerReceiver) {
            this.payerReceiver = payerReceiver == null ? null : payerReceiver.toBuilder();
            return this;
        }

        @Override
        public PrincipalPaymentBuilder setPresentValuePrincipalAmount(Money presentValuePrincipalAmount) {
            this.presentValuePrincipalAmount = presentValuePrincipalAmount == null ? null : presentValuePrincipalAmount.toBuilder();
            return this;
        }

        @Override
        public PrincipalPaymentBuilder setPrincipalAmount(Money principalAmount) {
            this.principalAmount = principalAmount == null ? null : principalAmount.toBuilder();
            return this;
        }

        @Override
        public PrincipalPaymentBuilder setPrincipalPaymentDate(AdjustableDate principalPaymentDate) {
            this.principalPaymentDate = principalPaymentDate == null ? null : principalPaymentDate.toBuilder();
            return this;
        }

        @Override
        public PrincipalPayment build() {
            return new PrincipalPaymentImpl(this);
        }

        @Override
        public PrincipalPaymentBuilder toBuilder() {
            return this;
        }

        @Override
        public PrincipalPaymentBuilder prune() {
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            if (this.payerReceiver != null && !this.payerReceiver.prune().hasData()) {
                this.payerReceiver = null;
            }
            if (this.presentValuePrincipalAmount != null && !this.presentValuePrincipalAmount.prune().hasData()) {
                this.presentValuePrincipalAmount = null;
            }
            if (this.principalAmount != null && !this.principalAmount.prune().hasData()) {
                this.principalAmount = null;
            }
            if (this.principalPaymentDate != null && !this.principalPaymentDate.prune().hasData()) {
                this.principalPaymentDate = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getDiscountFactor() != null) {
                return true;
            }
            if (this.getPayerReceiver() != null && this.getPayerReceiver().hasData()) {
                return true;
            }
            if (this.getPresentValuePrincipalAmount() != null && this.getPresentValuePrincipalAmount().hasData()) {
                return true;
            }
            if (this.getPrincipalAmount() != null && this.getPrincipalAmount().hasData()) {
                return true;
            }
            return this.getPrincipalPaymentDate() != null && this.getPrincipalPaymentDate().hasData();
        }

        public PrincipalPaymentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PrincipalPaymentBuilder o = (PrincipalPaymentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPayerReceiver(), (RosettaModelObjectBuilder)o.getPayerReceiver(), this::setPayerReceiver);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPresentValuePrincipalAmount(), (RosettaModelObjectBuilder)o.getPresentValuePrincipalAmount(), this::setPresentValuePrincipalAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrincipalAmount(), (RosettaModelObjectBuilder)o.getPrincipalAmount(), this::setPrincipalAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrincipalPaymentDate(), (RosettaModelObjectBuilder)o.getPrincipalPaymentDate(), this::setPrincipalPaymentDate);
            merger.mergeBasic((Object)this.getDiscountFactor(), (Object)o.getDiscountFactor(), this::setDiscountFactor, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PrincipalPayment _that = this.getType().cast(o);
            if (!Objects.equals(this.discountFactor, _that.getDiscountFactor())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.payerReceiver, _that.getPayerReceiver())) {
                return false;
            }
            if (!Objects.equals(this.presentValuePrincipalAmount, _that.getPresentValuePrincipalAmount())) {
                return false;
            }
            if (!Objects.equals(this.principalAmount, _that.getPrincipalAmount())) {
                return false;
            }
            return Objects.equals(this.principalPaymentDate, _that.getPrincipalPaymentDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.discountFactor != null ? this.discountFactor.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.payerReceiver != null ? this.payerReceiver.hashCode() : 0);
            _result = 31 * _result + (this.presentValuePrincipalAmount != null ? this.presentValuePrincipalAmount.hashCode() : 0);
            _result = 31 * _result + (this.principalAmount != null ? this.principalAmount.hashCode() : 0);
            _result = 31 * _result + (this.principalPaymentDate != null ? this.principalPaymentDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PrincipalPaymentBuilder {discountFactor=" + this.discountFactor + ", meta=" + this.meta + ", payerReceiver=" + this.payerReceiver + ", presentValuePrincipalAmount=" + this.presentValuePrincipalAmount + ", principalAmount=" + this.principalAmount + ", principalPaymentDate=" + this.principalPaymentDate + '}';
        }
    }

    public static class PrincipalPaymentImpl
    implements PrincipalPayment {
        private final BigDecimal discountFactor;
        private final MetaFields meta;
        private final PayerReceiver payerReceiver;
        private final Money presentValuePrincipalAmount;
        private final Money principalAmount;
        private final AdjustableDate principalPaymentDate;

        protected PrincipalPaymentImpl(PrincipalPaymentBuilder builder) {
            this.discountFactor = builder.getDiscountFactor();
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
            this.payerReceiver = Optional.ofNullable(builder.getPayerReceiver()).map(f -> f.build()).orElse(null);
            this.presentValuePrincipalAmount = Optional.ofNullable(builder.getPresentValuePrincipalAmount()).map(f -> f.build()).orElse(null);
            this.principalAmount = Optional.ofNullable(builder.getPrincipalAmount()).map(f -> f.build()).orElse(null);
            this.principalPaymentDate = Optional.ofNullable(builder.getPrincipalPaymentDate()).map(f -> f.build()).orElse(null);
        }

        @Override
        public BigDecimal getDiscountFactor() {
            return this.discountFactor;
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public PayerReceiver getPayerReceiver() {
            return this.payerReceiver;
        }

        @Override
        public Money getPresentValuePrincipalAmount() {
            return this.presentValuePrincipalAmount;
        }

        @Override
        public Money getPrincipalAmount() {
            return this.principalAmount;
        }

        @Override
        public AdjustableDate getPrincipalPaymentDate() {
            return this.principalPaymentDate;
        }

        @Override
        public PrincipalPayment build() {
            return this;
        }

        @Override
        public PrincipalPaymentBuilder toBuilder() {
            PrincipalPaymentBuilder builder = PrincipalPayment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PrincipalPaymentBuilder builder) {
            Optional.ofNullable(this.getDiscountFactor()).ifPresent(builder::setDiscountFactor);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
            Optional.ofNullable(this.getPayerReceiver()).ifPresent(builder::setPayerReceiver);
            Optional.ofNullable(this.getPresentValuePrincipalAmount()).ifPresent(builder::setPresentValuePrincipalAmount);
            Optional.ofNullable(this.getPrincipalAmount()).ifPresent(builder::setPrincipalAmount);
            Optional.ofNullable(this.getPrincipalPaymentDate()).ifPresent(builder::setPrincipalPaymentDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PrincipalPayment _that = this.getType().cast(o);
            if (!Objects.equals(this.discountFactor, _that.getDiscountFactor())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.payerReceiver, _that.getPayerReceiver())) {
                return false;
            }
            if (!Objects.equals(this.presentValuePrincipalAmount, _that.getPresentValuePrincipalAmount())) {
                return false;
            }
            if (!Objects.equals(this.principalAmount, _that.getPrincipalAmount())) {
                return false;
            }
            return Objects.equals(this.principalPaymentDate, _that.getPrincipalPaymentDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.discountFactor != null ? this.discountFactor.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.payerReceiver != null ? this.payerReceiver.hashCode() : 0);
            _result = 31 * _result + (this.presentValuePrincipalAmount != null ? this.presentValuePrincipalAmount.hashCode() : 0);
            _result = 31 * _result + (this.principalAmount != null ? this.principalAmount.hashCode() : 0);
            _result = 31 * _result + (this.principalPaymentDate != null ? this.principalPaymentDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PrincipalPayment {discountFactor=" + this.discountFactor + ", meta=" + this.meta + ", payerReceiver=" + this.payerReceiver + ", presentValuePrincipalAmount=" + this.presentValuePrincipalAmount + ", principalAmount=" + this.principalAmount + ", principalPaymentDate=" + this.principalPaymentDate + '}';
        }
    }

    public static interface PrincipalPaymentBuilder
    extends PrincipalPayment,
    RosettaModelObjectBuilder {
        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public PayerReceiver.PayerReceiverBuilder getOrCreatePayerReceiver();

        @Override
        public PayerReceiver.PayerReceiverBuilder getPayerReceiver();

        public Money.MoneyBuilder getOrCreatePresentValuePrincipalAmount();

        @Override
        public Money.MoneyBuilder getPresentValuePrincipalAmount();

        public Money.MoneyBuilder getOrCreatePrincipalAmount();

        @Override
        public Money.MoneyBuilder getPrincipalAmount();

        public AdjustableDate.AdjustableDateBuilder getOrCreatePrincipalPaymentDate();

        @Override
        public AdjustableDate.AdjustableDateBuilder getPrincipalPaymentDate();

        public PrincipalPaymentBuilder setDiscountFactor(BigDecimal var1);

        public PrincipalPaymentBuilder setMeta(MetaFields var1);

        public PrincipalPaymentBuilder setPayerReceiver(PayerReceiver var1);

        public PrincipalPaymentBuilder setPresentValuePrincipalAmount(Money var1);

        public PrincipalPaymentBuilder setPrincipalAmount(Money var1);

        public PrincipalPaymentBuilder setPrincipalPaymentDate(AdjustableDate var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("discountFactor"), BigDecimal.class, (Object)this.getDiscountFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiver"), processor, PayerReceiver.PayerReceiverBuilder.class, this.getPayerReceiver(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("presentValuePrincipalAmount"), processor, Money.MoneyBuilder.class, this.getPresentValuePrincipalAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("principalAmount"), processor, Money.MoneyBuilder.class, this.getPrincipalAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("principalPaymentDate"), processor, AdjustableDate.AdjustableDateBuilder.class, this.getPrincipalPaymentDate(), new AttributeMeta[0]);
        }

        public PrincipalPaymentBuilder prune();
    }
}

