/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.base.staticdata.party.BuyerSeller;
import cdm.observable.asset.Observable;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.FieldWithMetaPriceSchedule;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.common.settlement.meta.PriceQuantityMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.Key;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface PriceQuantity
extends RosettaModelObject,
GlobalKey {
    public static final PriceQuantityMeta metaData = new PriceQuantityMeta();

    public PriceQuantity build();

    public PriceQuantityBuilder toBuilder();

    public BuyerSeller getBuyerSeller();

    public AdjustableOrRelativeDate getEffectiveDate();

    public MetaFields getMeta();

    public Observable getObservable();

    public List<? extends FieldWithMetaPriceSchedule> getPrice();

    public List<? extends FieldWithMetaNonNegativeQuantitySchedule> getQuantity();

    public SettlementTerms getSettlementTerms();

    default public RosettaMetaData<? extends PriceQuantity> metaData() {
        return metaData;
    }

    public static PriceQuantityBuilder builder() {
        return new PriceQuantityBuilderImpl();
    }

    default public Class<? extends PriceQuantity> getType() {
        return PriceQuantity.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("buyerSeller"), processor, BuyerSeller.class, this.getBuyerSeller(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.class, this.getEffectiveDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("observable"), processor, Observable.class, this.getObservable(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("price"), processor, FieldWithMetaPriceSchedule.class, this.getPrice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quantity"), processor, FieldWithMetaNonNegativeQuantitySchedule.class, this.getQuantity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementTerms"), processor, SettlementTerms.class, this.getSettlementTerms(), new AttributeMeta[0]);
    }

    public static class PriceQuantityBuilderImpl
    implements PriceQuantityBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected BuyerSeller.BuyerSellerBuilder buyerSeller;
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder effectiveDate;
        protected MetaFields.MetaFieldsBuilder meta;
        protected Observable.ObservableBuilder observable;
        protected List<FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder> price = new ArrayList<FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder>();
        protected List<FieldWithMetaNonNegativeQuantitySchedule.FieldWithMetaNonNegativeQuantityScheduleBuilder> quantity = new ArrayList<FieldWithMetaNonNegativeQuantitySchedule.FieldWithMetaNonNegativeQuantityScheduleBuilder>();
        protected SettlementTerms.SettlementTermsBuilder settlementTerms;

        @Override
        public BuyerSeller.BuyerSellerBuilder getBuyerSeller() {
            return this.buyerSeller;
        }

        @Override
        public BuyerSeller.BuyerSellerBuilder getOrCreateBuyerSeller() {
            BuyerSeller.BuyerSellerBuilder result = this.buyerSeller != null ? this.buyerSeller : (this.buyerSeller = BuyerSeller.builder());
            return result;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateEffectiveDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.effectiveDate != null ? this.effectiveDate : (this.effectiveDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public Observable.ObservableBuilder getObservable() {
            return this.observable;
        }

        @Override
        public Observable.ObservableBuilder getOrCreateObservable() {
            Observable.ObservableBuilder result = this.observable != null ? this.observable : (this.observable = Observable.builder());
            return result;
        }

        @Override
        public List<? extends FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder> getPrice() {
            return this.price;
        }

        @Override
        public FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder getOrCreatePrice(int _index) {
            if (this.price == null) {
                this.price = new ArrayList<FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder>();
            }
            return (FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder)this.getIndex(this.price, _index, () -> {
                FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder newPrice = FieldWithMetaPriceSchedule.builder();
                newPrice.getOrCreateMeta().addKey((Key)Key.builder().setScope("DOCUMENT"));
                return newPrice;
            });
        }

        @Override
        public List<? extends FieldWithMetaNonNegativeQuantitySchedule.FieldWithMetaNonNegativeQuantityScheduleBuilder> getQuantity() {
            return this.quantity;
        }

        @Override
        public FieldWithMetaNonNegativeQuantitySchedule.FieldWithMetaNonNegativeQuantityScheduleBuilder getOrCreateQuantity(int _index) {
            if (this.quantity == null) {
                this.quantity = new ArrayList<FieldWithMetaNonNegativeQuantitySchedule.FieldWithMetaNonNegativeQuantityScheduleBuilder>();
            }
            return (FieldWithMetaNonNegativeQuantitySchedule.FieldWithMetaNonNegativeQuantityScheduleBuilder)this.getIndex(this.quantity, _index, () -> {
                FieldWithMetaNonNegativeQuantitySchedule.FieldWithMetaNonNegativeQuantityScheduleBuilder newQuantity = FieldWithMetaNonNegativeQuantitySchedule.builder();
                newQuantity.getOrCreateMeta().addKey((Key)Key.builder().setScope("DOCUMENT"));
                return newQuantity;
            });
        }

        @Override
        public SettlementTerms.SettlementTermsBuilder getSettlementTerms() {
            return this.settlementTerms;
        }

        @Override
        public SettlementTerms.SettlementTermsBuilder getOrCreateSettlementTerms() {
            SettlementTerms.SettlementTermsBuilder result = this.settlementTerms != null ? this.settlementTerms : (this.settlementTerms = SettlementTerms.builder());
            return result;
        }

        @Override
        public PriceQuantityBuilder setBuyerSeller(BuyerSeller buyerSeller) {
            this.buyerSeller = buyerSeller == null ? null : buyerSeller.toBuilder();
            return this;
        }

        @Override
        public PriceQuantityBuilder setEffectiveDate(AdjustableOrRelativeDate effectiveDate) {
            this.effectiveDate = effectiveDate == null ? null : effectiveDate.toBuilder();
            return this;
        }

        @Override
        public PriceQuantityBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public PriceQuantityBuilder setObservable(Observable observable) {
            this.observable = observable == null ? null : observable.toBuilder();
            return this;
        }

        @Override
        public PriceQuantityBuilder addPrice(FieldWithMetaPriceSchedule price) {
            if (price != null) {
                this.price.add(price.toBuilder());
            }
            return this;
        }

        @Override
        public PriceQuantityBuilder addPrice(FieldWithMetaPriceSchedule price, int _idx) {
            this.getIndex(this.price, _idx, () -> price.toBuilder());
            return this;
        }

        @Override
        public PriceQuantityBuilder addPriceValue(PriceSchedule price) {
            this.getOrCreatePrice(-1).setValue(price.toBuilder());
            return this;
        }

        @Override
        public PriceQuantityBuilder addPriceValue(PriceSchedule price, int _idx) {
            this.getOrCreatePrice(_idx).setValue(price.toBuilder());
            return this;
        }

        @Override
        public PriceQuantityBuilder addPrice(List<? extends FieldWithMetaPriceSchedule> prices) {
            if (prices != null) {
                for (FieldWithMetaPriceSchedule fieldWithMetaPriceSchedule : prices) {
                    this.price.add(fieldWithMetaPriceSchedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        public PriceQuantityBuilder setPrice(List<? extends FieldWithMetaPriceSchedule> prices) {
            this.price = prices == null ? new ArrayList<FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder>() : (List)prices.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PriceQuantityBuilder addPriceValue(List<? extends PriceSchedule> prices) {
            if (prices != null) {
                for (PriceSchedule priceSchedule : prices) {
                    this.addPriceValue(priceSchedule);
                }
            }
            return this;
        }

        @Override
        public PriceQuantityBuilder setPriceValue(List<? extends PriceSchedule> prices) {
            this.price.clear();
            if (prices != null) {
                prices.forEach(this::addPriceValue);
            }
            return this;
        }

        @Override
        public PriceQuantityBuilder addQuantity(FieldWithMetaNonNegativeQuantitySchedule quantity) {
            if (quantity != null) {
                this.quantity.add(quantity.toBuilder());
            }
            return this;
        }

        @Override
        public PriceQuantityBuilder addQuantity(FieldWithMetaNonNegativeQuantitySchedule quantity, int _idx) {
            this.getIndex(this.quantity, _idx, () -> quantity.toBuilder());
            return this;
        }

        @Override
        public PriceQuantityBuilder addQuantityValue(NonNegativeQuantitySchedule quantity) {
            this.getOrCreateQuantity(-1).setValue(quantity.toBuilder());
            return this;
        }

        @Override
        public PriceQuantityBuilder addQuantityValue(NonNegativeQuantitySchedule quantity, int _idx) {
            this.getOrCreateQuantity(_idx).setValue(quantity.toBuilder());
            return this;
        }

        @Override
        public PriceQuantityBuilder addQuantity(List<? extends FieldWithMetaNonNegativeQuantitySchedule> quantitys) {
            if (quantitys != null) {
                for (FieldWithMetaNonNegativeQuantitySchedule fieldWithMetaNonNegativeQuantitySchedule : quantitys) {
                    this.quantity.add(fieldWithMetaNonNegativeQuantitySchedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        public PriceQuantityBuilder setQuantity(List<? extends FieldWithMetaNonNegativeQuantitySchedule> quantitys) {
            this.quantity = quantitys == null ? new ArrayList<FieldWithMetaNonNegativeQuantitySchedule.FieldWithMetaNonNegativeQuantityScheduleBuilder>() : (List)quantitys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PriceQuantityBuilder addQuantityValue(List<? extends NonNegativeQuantitySchedule> quantitys) {
            if (quantitys != null) {
                for (NonNegativeQuantitySchedule nonNegativeQuantitySchedule : quantitys) {
                    this.addQuantityValue(nonNegativeQuantitySchedule);
                }
            }
            return this;
        }

        @Override
        public PriceQuantityBuilder setQuantityValue(List<? extends NonNegativeQuantitySchedule> quantitys) {
            this.quantity.clear();
            if (quantitys != null) {
                quantitys.forEach(this::addQuantityValue);
            }
            return this;
        }

        @Override
        public PriceQuantityBuilder setSettlementTerms(SettlementTerms settlementTerms) {
            this.settlementTerms = settlementTerms == null ? null : settlementTerms.toBuilder();
            return this;
        }

        @Override
        public PriceQuantity build() {
            return new PriceQuantityImpl(this);
        }

        @Override
        public PriceQuantityBuilder toBuilder() {
            return this;
        }

        @Override
        public PriceQuantityBuilder prune() {
            if (this.buyerSeller != null && !this.buyerSeller.prune().hasData()) {
                this.buyerSeller = null;
            }
            if (this.effectiveDate != null && !this.effectiveDate.prune().hasData()) {
                this.effectiveDate = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            if (this.observable != null && !this.observable.prune().hasData()) {
                this.observable = null;
            }
            this.price = this.price.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.quantity = this.quantity.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.settlementTerms != null && !this.settlementTerms.prune().hasData()) {
                this.settlementTerms = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getBuyerSeller() != null && this.getBuyerSeller().hasData()) {
                return true;
            }
            if (this.getEffectiveDate() != null && this.getEffectiveDate().hasData()) {
                return true;
            }
            if (this.getObservable() != null && this.getObservable().hasData()) {
                return true;
            }
            if (this.getPrice() != null && this.getPrice().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getQuantity() != null && this.getQuantity().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getSettlementTerms() != null && this.getSettlementTerms().hasData();
        }

        public PriceQuantityBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PriceQuantityBuilder o = (PriceQuantityBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBuyerSeller(), (RosettaModelObjectBuilder)o.getBuyerSeller(), this::setBuyerSeller);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEffectiveDate(), (RosettaModelObjectBuilder)o.getEffectiveDate(), this::setEffectiveDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getObservable(), (RosettaModelObjectBuilder)o.getObservable(), this::setObservable);
            merger.mergeRosetta(this.getPrice(), o.getPrice(), this::getOrCreatePrice);
            merger.mergeRosetta(this.getQuantity(), o.getQuantity(), this::getOrCreateQuantity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementTerms(), (RosettaModelObjectBuilder)o.getSettlementTerms(), this::setSettlementTerms);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PriceQuantity _that = this.getType().cast(o);
            if (!Objects.equals(this.buyerSeller, _that.getBuyerSeller())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.observable, _that.getObservable())) {
                return false;
            }
            if (!ListEquals.listEquals(this.price, _that.getPrice())) {
                return false;
            }
            if (!ListEquals.listEquals(this.quantity, _that.getQuantity())) {
                return false;
            }
            return Objects.equals(this.settlementTerms, _that.getSettlementTerms());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.buyerSeller != null ? this.buyerSeller.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.observable != null ? this.observable.hashCode() : 0);
            _result = 31 * _result + (this.price != null ? this.price.hashCode() : 0);
            _result = 31 * _result + (this.quantity != null ? this.quantity.hashCode() : 0);
            _result = 31 * _result + (this.settlementTerms != null ? this.settlementTerms.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PriceQuantityBuilder {buyerSeller=" + this.buyerSeller + ", effectiveDate=" + this.effectiveDate + ", meta=" + this.meta + ", observable=" + this.observable + ", price=" + this.price + ", quantity=" + this.quantity + ", settlementTerms=" + this.settlementTerms + '}';
        }
    }

    public static class PriceQuantityImpl
    implements PriceQuantity {
        private final BuyerSeller buyerSeller;
        private final AdjustableOrRelativeDate effectiveDate;
        private final MetaFields meta;
        private final Observable observable;
        private final List<? extends FieldWithMetaPriceSchedule> price;
        private final List<? extends FieldWithMetaNonNegativeQuantitySchedule> quantity;
        private final SettlementTerms settlementTerms;

        protected PriceQuantityImpl(PriceQuantityBuilder builder) {
            this.buyerSeller = Optional.ofNullable(builder.getBuyerSeller()).map(f -> f.build()).orElse(null);
            this.effectiveDate = Optional.ofNullable(builder.getEffectiveDate()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
            this.observable = Optional.ofNullable(builder.getObservable()).map(f -> f.build()).orElse(null);
            this.price = Optional.ofNullable(builder.getPrice()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.quantity = Optional.ofNullable(builder.getQuantity()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.settlementTerms = Optional.ofNullable(builder.getSettlementTerms()).map(f -> f.build()).orElse(null);
        }

        @Override
        public BuyerSeller getBuyerSeller() {
            return this.buyerSeller;
        }

        @Override
        public AdjustableOrRelativeDate getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public Observable getObservable() {
            return this.observable;
        }

        @Override
        public List<? extends FieldWithMetaPriceSchedule> getPrice() {
            return this.price;
        }

        @Override
        public List<? extends FieldWithMetaNonNegativeQuantitySchedule> getQuantity() {
            return this.quantity;
        }

        @Override
        public SettlementTerms getSettlementTerms() {
            return this.settlementTerms;
        }

        @Override
        public PriceQuantity build() {
            return this;
        }

        @Override
        public PriceQuantityBuilder toBuilder() {
            PriceQuantityBuilder builder = PriceQuantity.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PriceQuantityBuilder builder) {
            Optional.ofNullable(this.getBuyerSeller()).ifPresent(builder::setBuyerSeller);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
            Optional.ofNullable(this.getObservable()).ifPresent(builder::setObservable);
            Optional.ofNullable(this.getPrice()).ifPresent(builder::setPrice);
            Optional.ofNullable(this.getQuantity()).ifPresent(builder::setQuantity);
            Optional.ofNullable(this.getSettlementTerms()).ifPresent(builder::setSettlementTerms);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PriceQuantity _that = this.getType().cast(o);
            if (!Objects.equals(this.buyerSeller, _that.getBuyerSeller())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.observable, _that.getObservable())) {
                return false;
            }
            if (!ListEquals.listEquals(this.price, _that.getPrice())) {
                return false;
            }
            if (!ListEquals.listEquals(this.quantity, _that.getQuantity())) {
                return false;
            }
            return Objects.equals(this.settlementTerms, _that.getSettlementTerms());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.buyerSeller != null ? this.buyerSeller.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.observable != null ? this.observable.hashCode() : 0);
            _result = 31 * _result + (this.price != null ? this.price.hashCode() : 0);
            _result = 31 * _result + (this.quantity != null ? this.quantity.hashCode() : 0);
            _result = 31 * _result + (this.settlementTerms != null ? this.settlementTerms.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PriceQuantity {buyerSeller=" + this.buyerSeller + ", effectiveDate=" + this.effectiveDate + ", meta=" + this.meta + ", observable=" + this.observable + ", price=" + this.price + ", quantity=" + this.quantity + ", settlementTerms=" + this.settlementTerms + '}';
        }
    }

    public static interface PriceQuantityBuilder
    extends PriceQuantity,
    RosettaModelObjectBuilder {
        public BuyerSeller.BuyerSellerBuilder getOrCreateBuyerSeller();

        @Override
        public BuyerSeller.BuyerSellerBuilder getBuyerSeller();

        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateEffectiveDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getEffectiveDate();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public Observable.ObservableBuilder getOrCreateObservable();

        @Override
        public Observable.ObservableBuilder getObservable();

        public FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder getOrCreatePrice(int var1);

        public List<? extends FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder> getPrice();

        public FieldWithMetaNonNegativeQuantitySchedule.FieldWithMetaNonNegativeQuantityScheduleBuilder getOrCreateQuantity(int var1);

        public List<? extends FieldWithMetaNonNegativeQuantitySchedule.FieldWithMetaNonNegativeQuantityScheduleBuilder> getQuantity();

        public SettlementTerms.SettlementTermsBuilder getOrCreateSettlementTerms();

        @Override
        public SettlementTerms.SettlementTermsBuilder getSettlementTerms();

        public PriceQuantityBuilder setBuyerSeller(BuyerSeller var1);

        public PriceQuantityBuilder setEffectiveDate(AdjustableOrRelativeDate var1);

        public PriceQuantityBuilder setMeta(MetaFields var1);

        public PriceQuantityBuilder setObservable(Observable var1);

        public PriceQuantityBuilder addPrice(FieldWithMetaPriceSchedule var1);

        public PriceQuantityBuilder addPrice(FieldWithMetaPriceSchedule var1, int var2);

        public PriceQuantityBuilder addPriceValue(PriceSchedule var1);

        public PriceQuantityBuilder addPriceValue(PriceSchedule var1, int var2);

        public PriceQuantityBuilder addPrice(List<? extends FieldWithMetaPriceSchedule> var1);

        public PriceQuantityBuilder setPrice(List<? extends FieldWithMetaPriceSchedule> var1);

        public PriceQuantityBuilder addPriceValue(List<? extends PriceSchedule> var1);

        public PriceQuantityBuilder setPriceValue(List<? extends PriceSchedule> var1);

        public PriceQuantityBuilder addQuantity(FieldWithMetaNonNegativeQuantitySchedule var1);

        public PriceQuantityBuilder addQuantity(FieldWithMetaNonNegativeQuantitySchedule var1, int var2);

        public PriceQuantityBuilder addQuantityValue(NonNegativeQuantitySchedule var1);

        public PriceQuantityBuilder addQuantityValue(NonNegativeQuantitySchedule var1, int var2);

        public PriceQuantityBuilder addQuantity(List<? extends FieldWithMetaNonNegativeQuantitySchedule> var1);

        public PriceQuantityBuilder setQuantity(List<? extends FieldWithMetaNonNegativeQuantitySchedule> var1);

        public PriceQuantityBuilder addQuantityValue(List<? extends NonNegativeQuantitySchedule> var1);

        public PriceQuantityBuilder setQuantityValue(List<? extends NonNegativeQuantitySchedule> var1);

        public PriceQuantityBuilder setSettlementTerms(SettlementTerms var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("buyerSeller"), processor, BuyerSeller.BuyerSellerBuilder.class, this.getBuyerSeller(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getEffectiveDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("observable"), processor, Observable.ObservableBuilder.class, this.getObservable(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("price"), processor, FieldWithMetaPriceSchedule.FieldWithMetaPriceScheduleBuilder.class, this.getPrice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quantity"), processor, FieldWithMetaNonNegativeQuantitySchedule.FieldWithMetaNonNegativeQuantityScheduleBuilder.class, this.getQuantity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementTerms"), processor, SettlementTerms.SettlementTermsBuilder.class, this.getSettlementTerms(), new AttributeMeta[0]);
        }

        public PriceQuantityBuilder prune();
    }
}

