/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import cdm.observable.asset.Money;
import cdm.observable.asset.metafields.ReferenceWithMetaMoney;
import cdm.product.common.settlement.meta.PercentageRuleMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface PercentageRule
extends RosettaModelObject {
    public static final PercentageRuleMeta metaData = new PercentageRuleMeta();

    public PercentageRule build();

    public PercentageRuleBuilder toBuilder();

    public ReferenceWithMetaMoney getNotionalAmountReference();

    public BigDecimal getPaymentPercent();

    default public RosettaMetaData<? extends PercentageRule> metaData() {
        return metaData;
    }

    public static PercentageRuleBuilder builder() {
        return new PercentageRuleBuilderImpl();
    }

    default public Class<? extends PercentageRule> getType() {
        return PercentageRule.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("paymentPercent"), BigDecimal.class, (Object)this.getPaymentPercent(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalAmountReference"), processor, ReferenceWithMetaMoney.class, this.getNotionalAmountReference(), new AttributeMeta[0]);
    }

    public static class PercentageRuleBuilderImpl
    implements PercentageRuleBuilder {
        protected ReferenceWithMetaMoney.ReferenceWithMetaMoneyBuilder notionalAmountReference;
        protected BigDecimal paymentPercent;

        @Override
        public ReferenceWithMetaMoney.ReferenceWithMetaMoneyBuilder getNotionalAmountReference() {
            return this.notionalAmountReference;
        }

        @Override
        public ReferenceWithMetaMoney.ReferenceWithMetaMoneyBuilder getOrCreateNotionalAmountReference() {
            ReferenceWithMetaMoney.ReferenceWithMetaMoneyBuilder result = this.notionalAmountReference != null ? this.notionalAmountReference : (this.notionalAmountReference = ReferenceWithMetaMoney.builder());
            return result;
        }

        @Override
        public BigDecimal getPaymentPercent() {
            return this.paymentPercent;
        }

        @Override
        public PercentageRuleBuilder setNotionalAmountReference(ReferenceWithMetaMoney notionalAmountReference) {
            this.notionalAmountReference = notionalAmountReference == null ? null : notionalAmountReference.toBuilder();
            return this;
        }

        @Override
        public PercentageRuleBuilder setNotionalAmountReferenceValue(Money notionalAmountReference) {
            this.getOrCreateNotionalAmountReference().setValue(notionalAmountReference);
            return this;
        }

        @Override
        public PercentageRuleBuilder setPaymentPercent(BigDecimal paymentPercent) {
            this.paymentPercent = paymentPercent == null ? null : paymentPercent;
            return this;
        }

        @Override
        public PercentageRule build() {
            return new PercentageRuleImpl(this);
        }

        @Override
        public PercentageRuleBuilder toBuilder() {
            return this;
        }

        @Override
        public PercentageRuleBuilder prune() {
            if (this.notionalAmountReference != null && !this.notionalAmountReference.prune().hasData()) {
                this.notionalAmountReference = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getNotionalAmountReference() != null && this.getNotionalAmountReference().hasData()) {
                return true;
            }
            return this.getPaymentPercent() != null;
        }

        public PercentageRuleBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PercentageRuleBuilder o = (PercentageRuleBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotionalAmountReference(), (RosettaModelObjectBuilder)o.getNotionalAmountReference(), this::setNotionalAmountReference);
            merger.mergeBasic((Object)this.getPaymentPercent(), (Object)o.getPaymentPercent(), this::setPaymentPercent, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PercentageRule _that = this.getType().cast(o);
            if (!Objects.equals(this.notionalAmountReference, _that.getNotionalAmountReference())) {
                return false;
            }
            return Objects.equals(this.paymentPercent, _that.getPaymentPercent());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.notionalAmountReference != null ? this.notionalAmountReference.hashCode() : 0);
            _result = 31 * _result + (this.paymentPercent != null ? this.paymentPercent.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PercentageRuleBuilder {notionalAmountReference=" + this.notionalAmountReference + ", paymentPercent=" + this.paymentPercent + '}';
        }
    }

    public static class PercentageRuleImpl
    implements PercentageRule {
        private final ReferenceWithMetaMoney notionalAmountReference;
        private final BigDecimal paymentPercent;

        protected PercentageRuleImpl(PercentageRuleBuilder builder) {
            this.notionalAmountReference = Optional.ofNullable(builder.getNotionalAmountReference()).map(f -> f.build()).orElse(null);
            this.paymentPercent = builder.getPaymentPercent();
        }

        @Override
        public ReferenceWithMetaMoney getNotionalAmountReference() {
            return this.notionalAmountReference;
        }

        @Override
        public BigDecimal getPaymentPercent() {
            return this.paymentPercent;
        }

        @Override
        public PercentageRule build() {
            return this;
        }

        @Override
        public PercentageRuleBuilder toBuilder() {
            PercentageRuleBuilder builder = PercentageRule.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PercentageRuleBuilder builder) {
            Optional.ofNullable(this.getNotionalAmountReference()).ifPresent(builder::setNotionalAmountReference);
            Optional.ofNullable(this.getPaymentPercent()).ifPresent(builder::setPaymentPercent);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PercentageRule _that = this.getType().cast(o);
            if (!Objects.equals(this.notionalAmountReference, _that.getNotionalAmountReference())) {
                return false;
            }
            return Objects.equals(this.paymentPercent, _that.getPaymentPercent());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.notionalAmountReference != null ? this.notionalAmountReference.hashCode() : 0);
            _result = 31 * _result + (this.paymentPercent != null ? this.paymentPercent.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PercentageRule {notionalAmountReference=" + this.notionalAmountReference + ", paymentPercent=" + this.paymentPercent + '}';
        }
    }

    public static interface PercentageRuleBuilder
    extends PercentageRule,
    RosettaModelObjectBuilder {
        public ReferenceWithMetaMoney.ReferenceWithMetaMoneyBuilder getOrCreateNotionalAmountReference();

        @Override
        public ReferenceWithMetaMoney.ReferenceWithMetaMoneyBuilder getNotionalAmountReference();

        public PercentageRuleBuilder setNotionalAmountReference(ReferenceWithMetaMoney var1);

        public PercentageRuleBuilder setNotionalAmountReferenceValue(Money var1);

        public PercentageRuleBuilder setPaymentPercent(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("paymentPercent"), BigDecimal.class, (Object)this.getPaymentPercent(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalAmountReference"), processor, ReferenceWithMetaMoney.ReferenceWithMetaMoneyBuilder.class, this.getNotionalAmountReference(), new AttributeMeta[0]);
        }

        public PercentageRuleBuilder prune();
    }
}

