/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import cdm.base.datetime.Period;
import cdm.base.staticdata.asset.credit.NotDomesticCurrency;
import cdm.base.staticdata.asset.credit.ObligationCategoryEnum;
import cdm.base.staticdata.asset.credit.SpecifiedCurrency;
import cdm.product.common.settlement.LoanParticipation;
import cdm.product.common.settlement.PCDeliverableObligationCharac;
import cdm.product.common.settlement.meta.DeliverableObligationsMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface DeliverableObligations
extends RosettaModelObject {
    public static final DeliverableObligationsMeta metaData = new DeliverableObligationsMeta();

    public DeliverableObligations build();

    public DeliverableObligationsBuilder toBuilder();

    public Boolean getAcceleratedOrMatured();

    public Boolean getAccruedInterest();

    public PCDeliverableObligationCharac getAssignableLoan();

    public ObligationCategoryEnum getCategory();

    public PCDeliverableObligationCharac getConsentRequiredLoan();

    public LoanParticipation getDirectLoanParticipation();

    public String getExcluded();

    public Boolean getFullFaithAndCreditObLiability();

    public Boolean getGeneralFundObligationLiability();

    public LoanParticipation getIndirectLoanParticipation();

    public Boolean getListed();

    public Period getMaximumMaturity();

    public Boolean getNotBearer();

    public Boolean getNotContingent();

    public NotDomesticCurrency getNotDomesticCurrency();

    public Boolean getNotDomesticIssuance();

    public Boolean getNotDomesticLaw();

    public Boolean getNotSovereignLender();

    public Boolean getNotSubordinated();

    public String getOthReferenceEntityObligations();

    public Boolean getRevenueObligationLiability();

    public SpecifiedCurrency getSpecifiedCurrency();

    public Boolean getTransferable();

    default public RosettaMetaData<? extends DeliverableObligations> metaData() {
        return metaData;
    }

    public static DeliverableObligationsBuilder builder() {
        return new DeliverableObligationsBuilderImpl();
    }

    default public Class<? extends DeliverableObligations> getType() {
        return DeliverableObligations.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("acceleratedOrMatured"), Boolean.class, (Object)this.getAcceleratedOrMatured(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("accruedInterest"), Boolean.class, (Object)this.getAccruedInterest(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("category"), ObligationCategoryEnum.class, (Object)this.getCategory(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("excluded"), String.class, (Object)this.getExcluded(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fullFaithAndCreditObLiability"), Boolean.class, (Object)this.getFullFaithAndCreditObLiability(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("generalFundObligationLiability"), Boolean.class, (Object)this.getGeneralFundObligationLiability(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("listed"), Boolean.class, (Object)this.getListed(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notBearer"), Boolean.class, (Object)this.getNotBearer(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notContingent"), Boolean.class, (Object)this.getNotContingent(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notDomesticIssuance"), Boolean.class, (Object)this.getNotDomesticIssuance(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notDomesticLaw"), Boolean.class, (Object)this.getNotDomesticLaw(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notSovereignLender"), Boolean.class, (Object)this.getNotSovereignLender(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notSubordinated"), Boolean.class, (Object)this.getNotSubordinated(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("othReferenceEntityObligations"), String.class, (Object)this.getOthReferenceEntityObligations(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("revenueObligationLiability"), Boolean.class, (Object)this.getRevenueObligationLiability(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("transferable"), Boolean.class, (Object)this.getTransferable(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("assignableLoan"), processor, PCDeliverableObligationCharac.class, this.getAssignableLoan(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("consentRequiredLoan"), processor, PCDeliverableObligationCharac.class, this.getConsentRequiredLoan(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("directLoanParticipation"), processor, LoanParticipation.class, this.getDirectLoanParticipation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("indirectLoanParticipation"), processor, LoanParticipation.class, this.getIndirectLoanParticipation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("maximumMaturity"), processor, Period.class, this.getMaximumMaturity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notDomesticCurrency"), processor, NotDomesticCurrency.class, this.getNotDomesticCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("specifiedCurrency"), processor, SpecifiedCurrency.class, this.getSpecifiedCurrency(), new AttributeMeta[0]);
    }

    public static class DeliverableObligationsBuilderImpl
    implements DeliverableObligationsBuilder {
        protected Boolean acceleratedOrMatured;
        protected Boolean accruedInterest;
        protected PCDeliverableObligationCharac.PCDeliverableObligationCharacBuilder assignableLoan;
        protected ObligationCategoryEnum category;
        protected PCDeliverableObligationCharac.PCDeliverableObligationCharacBuilder consentRequiredLoan;
        protected LoanParticipation.LoanParticipationBuilder directLoanParticipation;
        protected String excluded;
        protected Boolean fullFaithAndCreditObLiability;
        protected Boolean generalFundObligationLiability;
        protected LoanParticipation.LoanParticipationBuilder indirectLoanParticipation;
        protected Boolean listed;
        protected Period.PeriodBuilder maximumMaturity;
        protected Boolean notBearer;
        protected Boolean notContingent;
        protected NotDomesticCurrency.NotDomesticCurrencyBuilder notDomesticCurrency;
        protected Boolean notDomesticIssuance;
        protected Boolean notDomesticLaw;
        protected Boolean notSovereignLender;
        protected Boolean notSubordinated;
        protected String othReferenceEntityObligations;
        protected Boolean revenueObligationLiability;
        protected SpecifiedCurrency.SpecifiedCurrencyBuilder specifiedCurrency;
        protected Boolean transferable;

        @Override
        public Boolean getAcceleratedOrMatured() {
            return this.acceleratedOrMatured;
        }

        @Override
        public Boolean getAccruedInterest() {
            return this.accruedInterest;
        }

        @Override
        public PCDeliverableObligationCharac.PCDeliverableObligationCharacBuilder getAssignableLoan() {
            return this.assignableLoan;
        }

        @Override
        public PCDeliverableObligationCharac.PCDeliverableObligationCharacBuilder getOrCreateAssignableLoan() {
            PCDeliverableObligationCharac.PCDeliverableObligationCharacBuilder result = this.assignableLoan != null ? this.assignableLoan : (this.assignableLoan = PCDeliverableObligationCharac.builder());
            return result;
        }

        @Override
        public ObligationCategoryEnum getCategory() {
            return this.category;
        }

        @Override
        public PCDeliverableObligationCharac.PCDeliverableObligationCharacBuilder getConsentRequiredLoan() {
            return this.consentRequiredLoan;
        }

        @Override
        public PCDeliverableObligationCharac.PCDeliverableObligationCharacBuilder getOrCreateConsentRequiredLoan() {
            PCDeliverableObligationCharac.PCDeliverableObligationCharacBuilder result = this.consentRequiredLoan != null ? this.consentRequiredLoan : (this.consentRequiredLoan = PCDeliverableObligationCharac.builder());
            return result;
        }

        @Override
        public LoanParticipation.LoanParticipationBuilder getDirectLoanParticipation() {
            return this.directLoanParticipation;
        }

        @Override
        public LoanParticipation.LoanParticipationBuilder getOrCreateDirectLoanParticipation() {
            LoanParticipation.LoanParticipationBuilder result = this.directLoanParticipation != null ? this.directLoanParticipation : (this.directLoanParticipation = LoanParticipation.builder());
            return result;
        }

        @Override
        public String getExcluded() {
            return this.excluded;
        }

        @Override
        public Boolean getFullFaithAndCreditObLiability() {
            return this.fullFaithAndCreditObLiability;
        }

        @Override
        public Boolean getGeneralFundObligationLiability() {
            return this.generalFundObligationLiability;
        }

        @Override
        public LoanParticipation.LoanParticipationBuilder getIndirectLoanParticipation() {
            return this.indirectLoanParticipation;
        }

        @Override
        public LoanParticipation.LoanParticipationBuilder getOrCreateIndirectLoanParticipation() {
            LoanParticipation.LoanParticipationBuilder result = this.indirectLoanParticipation != null ? this.indirectLoanParticipation : (this.indirectLoanParticipation = LoanParticipation.builder());
            return result;
        }

        @Override
        public Boolean getListed() {
            return this.listed;
        }

        @Override
        public Period.PeriodBuilder getMaximumMaturity() {
            return this.maximumMaturity;
        }

        @Override
        public Period.PeriodBuilder getOrCreateMaximumMaturity() {
            Period.PeriodBuilder result = this.maximumMaturity != null ? this.maximumMaturity : (this.maximumMaturity = Period.builder());
            return result;
        }

        @Override
        public Boolean getNotBearer() {
            return this.notBearer;
        }

        @Override
        public Boolean getNotContingent() {
            return this.notContingent;
        }

        @Override
        public NotDomesticCurrency.NotDomesticCurrencyBuilder getNotDomesticCurrency() {
            return this.notDomesticCurrency;
        }

        @Override
        public NotDomesticCurrency.NotDomesticCurrencyBuilder getOrCreateNotDomesticCurrency() {
            NotDomesticCurrency.NotDomesticCurrencyBuilder result = this.notDomesticCurrency != null ? this.notDomesticCurrency : (this.notDomesticCurrency = NotDomesticCurrency.builder());
            return result;
        }

        @Override
        public Boolean getNotDomesticIssuance() {
            return this.notDomesticIssuance;
        }

        @Override
        public Boolean getNotDomesticLaw() {
            return this.notDomesticLaw;
        }

        @Override
        public Boolean getNotSovereignLender() {
            return this.notSovereignLender;
        }

        @Override
        public Boolean getNotSubordinated() {
            return this.notSubordinated;
        }

        @Override
        public String getOthReferenceEntityObligations() {
            return this.othReferenceEntityObligations;
        }

        @Override
        public Boolean getRevenueObligationLiability() {
            return this.revenueObligationLiability;
        }

        @Override
        public SpecifiedCurrency.SpecifiedCurrencyBuilder getSpecifiedCurrency() {
            return this.specifiedCurrency;
        }

        @Override
        public SpecifiedCurrency.SpecifiedCurrencyBuilder getOrCreateSpecifiedCurrency() {
            SpecifiedCurrency.SpecifiedCurrencyBuilder result = this.specifiedCurrency != null ? this.specifiedCurrency : (this.specifiedCurrency = SpecifiedCurrency.builder());
            return result;
        }

        @Override
        public Boolean getTransferable() {
            return this.transferable;
        }

        @Override
        public DeliverableObligationsBuilder setAcceleratedOrMatured(Boolean acceleratedOrMatured) {
            this.acceleratedOrMatured = acceleratedOrMatured == null ? null : acceleratedOrMatured;
            return this;
        }

        @Override
        public DeliverableObligationsBuilder setAccruedInterest(Boolean accruedInterest) {
            this.accruedInterest = accruedInterest == null ? null : accruedInterest;
            return this;
        }

        @Override
        public DeliverableObligationsBuilder setAssignableLoan(PCDeliverableObligationCharac assignableLoan) {
            this.assignableLoan = assignableLoan == null ? null : assignableLoan.toBuilder();
            return this;
        }

        @Override
        public DeliverableObligationsBuilder setCategory(ObligationCategoryEnum category) {
            this.category = category == null ? null : category;
            return this;
        }

        @Override
        public DeliverableObligationsBuilder setConsentRequiredLoan(PCDeliverableObligationCharac consentRequiredLoan) {
            this.consentRequiredLoan = consentRequiredLoan == null ? null : consentRequiredLoan.toBuilder();
            return this;
        }

        @Override
        public DeliverableObligationsBuilder setDirectLoanParticipation(LoanParticipation directLoanParticipation) {
            this.directLoanParticipation = directLoanParticipation == null ? null : directLoanParticipation.toBuilder();
            return this;
        }

        @Override
        public DeliverableObligationsBuilder setExcluded(String excluded) {
            this.excluded = excluded == null ? null : excluded;
            return this;
        }

        @Override
        public DeliverableObligationsBuilder setFullFaithAndCreditObLiability(Boolean fullFaithAndCreditObLiability) {
            this.fullFaithAndCreditObLiability = fullFaithAndCreditObLiability == null ? null : fullFaithAndCreditObLiability;
            return this;
        }

        @Override
        public DeliverableObligationsBuilder setGeneralFundObligationLiability(Boolean generalFundObligationLiability) {
            this.generalFundObligationLiability = generalFundObligationLiability == null ? null : generalFundObligationLiability;
            return this;
        }

        @Override
        public DeliverableObligationsBuilder setIndirectLoanParticipation(LoanParticipation indirectLoanParticipation) {
            this.indirectLoanParticipation = indirectLoanParticipation == null ? null : indirectLoanParticipation.toBuilder();
            return this;
        }

        @Override
        public DeliverableObligationsBuilder setListed(Boolean listed) {
            this.listed = listed == null ? null : listed;
            return this;
        }

        @Override
        public DeliverableObligationsBuilder setMaximumMaturity(Period maximumMaturity) {
            this.maximumMaturity = maximumMaturity == null ? null : maximumMaturity.toBuilder();
            return this;
        }

        @Override
        public DeliverableObligationsBuilder setNotBearer(Boolean notBearer) {
            this.notBearer = notBearer == null ? null : notBearer;
            return this;
        }

        @Override
        public DeliverableObligationsBuilder setNotContingent(Boolean notContingent) {
            this.notContingent = notContingent == null ? null : notContingent;
            return this;
        }

        @Override
        public DeliverableObligationsBuilder setNotDomesticCurrency(NotDomesticCurrency notDomesticCurrency) {
            this.notDomesticCurrency = notDomesticCurrency == null ? null : notDomesticCurrency.toBuilder();
            return this;
        }

        @Override
        public DeliverableObligationsBuilder setNotDomesticIssuance(Boolean notDomesticIssuance) {
            this.notDomesticIssuance = notDomesticIssuance == null ? null : notDomesticIssuance;
            return this;
        }

        @Override
        public DeliverableObligationsBuilder setNotDomesticLaw(Boolean notDomesticLaw) {
            this.notDomesticLaw = notDomesticLaw == null ? null : notDomesticLaw;
            return this;
        }

        @Override
        public DeliverableObligationsBuilder setNotSovereignLender(Boolean notSovereignLender) {
            this.notSovereignLender = notSovereignLender == null ? null : notSovereignLender;
            return this;
        }

        @Override
        public DeliverableObligationsBuilder setNotSubordinated(Boolean notSubordinated) {
            this.notSubordinated = notSubordinated == null ? null : notSubordinated;
            return this;
        }

        @Override
        public DeliverableObligationsBuilder setOthReferenceEntityObligations(String othReferenceEntityObligations) {
            this.othReferenceEntityObligations = othReferenceEntityObligations == null ? null : othReferenceEntityObligations;
            return this;
        }

        @Override
        public DeliverableObligationsBuilder setRevenueObligationLiability(Boolean revenueObligationLiability) {
            this.revenueObligationLiability = revenueObligationLiability == null ? null : revenueObligationLiability;
            return this;
        }

        @Override
        public DeliverableObligationsBuilder setSpecifiedCurrency(SpecifiedCurrency specifiedCurrency) {
            this.specifiedCurrency = specifiedCurrency == null ? null : specifiedCurrency.toBuilder();
            return this;
        }

        @Override
        public DeliverableObligationsBuilder setTransferable(Boolean transferable) {
            this.transferable = transferable == null ? null : transferable;
            return this;
        }

        @Override
        public DeliverableObligations build() {
            return new DeliverableObligationsImpl(this);
        }

        @Override
        public DeliverableObligationsBuilder toBuilder() {
            return this;
        }

        @Override
        public DeliverableObligationsBuilder prune() {
            if (this.assignableLoan != null && !this.assignableLoan.prune().hasData()) {
                this.assignableLoan = null;
            }
            if (this.consentRequiredLoan != null && !this.consentRequiredLoan.prune().hasData()) {
                this.consentRequiredLoan = null;
            }
            if (this.directLoanParticipation != null && !this.directLoanParticipation.prune().hasData()) {
                this.directLoanParticipation = null;
            }
            if (this.indirectLoanParticipation != null && !this.indirectLoanParticipation.prune().hasData()) {
                this.indirectLoanParticipation = null;
            }
            if (this.maximumMaturity != null && !this.maximumMaturity.prune().hasData()) {
                this.maximumMaturity = null;
            }
            if (this.notDomesticCurrency != null && !this.notDomesticCurrency.prune().hasData()) {
                this.notDomesticCurrency = null;
            }
            if (this.specifiedCurrency != null && !this.specifiedCurrency.prune().hasData()) {
                this.specifiedCurrency = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAcceleratedOrMatured() != null) {
                return true;
            }
            if (this.getAccruedInterest() != null) {
                return true;
            }
            if (this.getAssignableLoan() != null && this.getAssignableLoan().hasData()) {
                return true;
            }
            if (this.getCategory() != null) {
                return true;
            }
            if (this.getConsentRequiredLoan() != null && this.getConsentRequiredLoan().hasData()) {
                return true;
            }
            if (this.getDirectLoanParticipation() != null && this.getDirectLoanParticipation().hasData()) {
                return true;
            }
            if (this.getExcluded() != null) {
                return true;
            }
            if (this.getFullFaithAndCreditObLiability() != null) {
                return true;
            }
            if (this.getGeneralFundObligationLiability() != null) {
                return true;
            }
            if (this.getIndirectLoanParticipation() != null && this.getIndirectLoanParticipation().hasData()) {
                return true;
            }
            if (this.getListed() != null) {
                return true;
            }
            if (this.getMaximumMaturity() != null && this.getMaximumMaturity().hasData()) {
                return true;
            }
            if (this.getNotBearer() != null) {
                return true;
            }
            if (this.getNotContingent() != null) {
                return true;
            }
            if (this.getNotDomesticCurrency() != null && this.getNotDomesticCurrency().hasData()) {
                return true;
            }
            if (this.getNotDomesticIssuance() != null) {
                return true;
            }
            if (this.getNotDomesticLaw() != null) {
                return true;
            }
            if (this.getNotSovereignLender() != null) {
                return true;
            }
            if (this.getNotSubordinated() != null) {
                return true;
            }
            if (this.getOthReferenceEntityObligations() != null) {
                return true;
            }
            if (this.getRevenueObligationLiability() != null) {
                return true;
            }
            if (this.getSpecifiedCurrency() != null && this.getSpecifiedCurrency().hasData()) {
                return true;
            }
            return this.getTransferable() != null;
        }

        public DeliverableObligationsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            DeliverableObligationsBuilder o = (DeliverableObligationsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAssignableLoan(), (RosettaModelObjectBuilder)o.getAssignableLoan(), this::setAssignableLoan);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getConsentRequiredLoan(), (RosettaModelObjectBuilder)o.getConsentRequiredLoan(), this::setConsentRequiredLoan);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDirectLoanParticipation(), (RosettaModelObjectBuilder)o.getDirectLoanParticipation(), this::setDirectLoanParticipation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIndirectLoanParticipation(), (RosettaModelObjectBuilder)o.getIndirectLoanParticipation(), this::setIndirectLoanParticipation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMaximumMaturity(), (RosettaModelObjectBuilder)o.getMaximumMaturity(), this::setMaximumMaturity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotDomesticCurrency(), (RosettaModelObjectBuilder)o.getNotDomesticCurrency(), this::setNotDomesticCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSpecifiedCurrency(), (RosettaModelObjectBuilder)o.getSpecifiedCurrency(), this::setSpecifiedCurrency);
            merger.mergeBasic((Object)this.getAcceleratedOrMatured(), (Object)o.getAcceleratedOrMatured(), this::setAcceleratedOrMatured, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAccruedInterest(), (Object)o.getAccruedInterest(), this::setAccruedInterest, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCategory(), (Object)o.getCategory(), this::setCategory, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExcluded(), (Object)o.getExcluded(), this::setExcluded, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFullFaithAndCreditObLiability(), (Object)o.getFullFaithAndCreditObLiability(), this::setFullFaithAndCreditObLiability, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getGeneralFundObligationLiability(), (Object)o.getGeneralFundObligationLiability(), this::setGeneralFundObligationLiability, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getListed(), (Object)o.getListed(), this::setListed, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotBearer(), (Object)o.getNotBearer(), this::setNotBearer, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotContingent(), (Object)o.getNotContingent(), this::setNotContingent, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotDomesticIssuance(), (Object)o.getNotDomesticIssuance(), this::setNotDomesticIssuance, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotDomesticLaw(), (Object)o.getNotDomesticLaw(), this::setNotDomesticLaw, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotSovereignLender(), (Object)o.getNotSovereignLender(), this::setNotSovereignLender, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotSubordinated(), (Object)o.getNotSubordinated(), this::setNotSubordinated, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOthReferenceEntityObligations(), (Object)o.getOthReferenceEntityObligations(), this::setOthReferenceEntityObligations, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRevenueObligationLiability(), (Object)o.getRevenueObligationLiability(), this::setRevenueObligationLiability, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTransferable(), (Object)o.getTransferable(), this::setTransferable, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DeliverableObligations _that = this.getType().cast(o);
            if (!Objects.equals(this.acceleratedOrMatured, _that.getAcceleratedOrMatured())) {
                return false;
            }
            if (!Objects.equals(this.accruedInterest, _that.getAccruedInterest())) {
                return false;
            }
            if (!Objects.equals(this.assignableLoan, _that.getAssignableLoan())) {
                return false;
            }
            if (!Objects.equals((Object)this.category, (Object)_that.getCategory())) {
                return false;
            }
            if (!Objects.equals(this.consentRequiredLoan, _that.getConsentRequiredLoan())) {
                return false;
            }
            if (!Objects.equals(this.directLoanParticipation, _that.getDirectLoanParticipation())) {
                return false;
            }
            if (!Objects.equals(this.excluded, _that.getExcluded())) {
                return false;
            }
            if (!Objects.equals(this.fullFaithAndCreditObLiability, _that.getFullFaithAndCreditObLiability())) {
                return false;
            }
            if (!Objects.equals(this.generalFundObligationLiability, _that.getGeneralFundObligationLiability())) {
                return false;
            }
            if (!Objects.equals(this.indirectLoanParticipation, _that.getIndirectLoanParticipation())) {
                return false;
            }
            if (!Objects.equals(this.listed, _that.getListed())) {
                return false;
            }
            if (!Objects.equals(this.maximumMaturity, _that.getMaximumMaturity())) {
                return false;
            }
            if (!Objects.equals(this.notBearer, _that.getNotBearer())) {
                return false;
            }
            if (!Objects.equals(this.notContingent, _that.getNotContingent())) {
                return false;
            }
            if (!Objects.equals(this.notDomesticCurrency, _that.getNotDomesticCurrency())) {
                return false;
            }
            if (!Objects.equals(this.notDomesticIssuance, _that.getNotDomesticIssuance())) {
                return false;
            }
            if (!Objects.equals(this.notDomesticLaw, _that.getNotDomesticLaw())) {
                return false;
            }
            if (!Objects.equals(this.notSovereignLender, _that.getNotSovereignLender())) {
                return false;
            }
            if (!Objects.equals(this.notSubordinated, _that.getNotSubordinated())) {
                return false;
            }
            if (!Objects.equals(this.othReferenceEntityObligations, _that.getOthReferenceEntityObligations())) {
                return false;
            }
            if (!Objects.equals(this.revenueObligationLiability, _that.getRevenueObligationLiability())) {
                return false;
            }
            if (!Objects.equals(this.specifiedCurrency, _that.getSpecifiedCurrency())) {
                return false;
            }
            return Objects.equals(this.transferable, _that.getTransferable());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.acceleratedOrMatured != null ? this.acceleratedOrMatured.hashCode() : 0);
            _result = 31 * _result + (this.accruedInterest != null ? this.accruedInterest.hashCode() : 0);
            _result = 31 * _result + (this.assignableLoan != null ? this.assignableLoan.hashCode() : 0);
            _result = 31 * _result + (this.category != null ? ((Object)((Object)this.category)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.consentRequiredLoan != null ? this.consentRequiredLoan.hashCode() : 0);
            _result = 31 * _result + (this.directLoanParticipation != null ? this.directLoanParticipation.hashCode() : 0);
            _result = 31 * _result + (this.excluded != null ? this.excluded.hashCode() : 0);
            _result = 31 * _result + (this.fullFaithAndCreditObLiability != null ? this.fullFaithAndCreditObLiability.hashCode() : 0);
            _result = 31 * _result + (this.generalFundObligationLiability != null ? this.generalFundObligationLiability.hashCode() : 0);
            _result = 31 * _result + (this.indirectLoanParticipation != null ? this.indirectLoanParticipation.hashCode() : 0);
            _result = 31 * _result + (this.listed != null ? this.listed.hashCode() : 0);
            _result = 31 * _result + (this.maximumMaturity != null ? this.maximumMaturity.hashCode() : 0);
            _result = 31 * _result + (this.notBearer != null ? this.notBearer.hashCode() : 0);
            _result = 31 * _result + (this.notContingent != null ? this.notContingent.hashCode() : 0);
            _result = 31 * _result + (this.notDomesticCurrency != null ? this.notDomesticCurrency.hashCode() : 0);
            _result = 31 * _result + (this.notDomesticIssuance != null ? this.notDomesticIssuance.hashCode() : 0);
            _result = 31 * _result + (this.notDomesticLaw != null ? this.notDomesticLaw.hashCode() : 0);
            _result = 31 * _result + (this.notSovereignLender != null ? this.notSovereignLender.hashCode() : 0);
            _result = 31 * _result + (this.notSubordinated != null ? this.notSubordinated.hashCode() : 0);
            _result = 31 * _result + (this.othReferenceEntityObligations != null ? this.othReferenceEntityObligations.hashCode() : 0);
            _result = 31 * _result + (this.revenueObligationLiability != null ? this.revenueObligationLiability.hashCode() : 0);
            _result = 31 * _result + (this.specifiedCurrency != null ? this.specifiedCurrency.hashCode() : 0);
            _result = 31 * _result + (this.transferable != null ? this.transferable.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DeliverableObligationsBuilder {acceleratedOrMatured=" + this.acceleratedOrMatured + ", accruedInterest=" + this.accruedInterest + ", assignableLoan=" + this.assignableLoan + ", category=" + (Object)((Object)this.category) + ", consentRequiredLoan=" + this.consentRequiredLoan + ", directLoanParticipation=" + this.directLoanParticipation + ", excluded=" + this.excluded + ", fullFaithAndCreditObLiability=" + this.fullFaithAndCreditObLiability + ", generalFundObligationLiability=" + this.generalFundObligationLiability + ", indirectLoanParticipation=" + this.indirectLoanParticipation + ", listed=" + this.listed + ", maximumMaturity=" + this.maximumMaturity + ", notBearer=" + this.notBearer + ", notContingent=" + this.notContingent + ", notDomesticCurrency=" + this.notDomesticCurrency + ", notDomesticIssuance=" + this.notDomesticIssuance + ", notDomesticLaw=" + this.notDomesticLaw + ", notSovereignLender=" + this.notSovereignLender + ", notSubordinated=" + this.notSubordinated + ", othReferenceEntityObligations=" + this.othReferenceEntityObligations + ", revenueObligationLiability=" + this.revenueObligationLiability + ", specifiedCurrency=" + this.specifiedCurrency + ", transferable=" + this.transferable + '}';
        }
    }

    public static class DeliverableObligationsImpl
    implements DeliverableObligations {
        private final Boolean acceleratedOrMatured;
        private final Boolean accruedInterest;
        private final PCDeliverableObligationCharac assignableLoan;
        private final ObligationCategoryEnum category;
        private final PCDeliverableObligationCharac consentRequiredLoan;
        private final LoanParticipation directLoanParticipation;
        private final String excluded;
        private final Boolean fullFaithAndCreditObLiability;
        private final Boolean generalFundObligationLiability;
        private final LoanParticipation indirectLoanParticipation;
        private final Boolean listed;
        private final Period maximumMaturity;
        private final Boolean notBearer;
        private final Boolean notContingent;
        private final NotDomesticCurrency notDomesticCurrency;
        private final Boolean notDomesticIssuance;
        private final Boolean notDomesticLaw;
        private final Boolean notSovereignLender;
        private final Boolean notSubordinated;
        private final String othReferenceEntityObligations;
        private final Boolean revenueObligationLiability;
        private final SpecifiedCurrency specifiedCurrency;
        private final Boolean transferable;

        protected DeliverableObligationsImpl(DeliverableObligationsBuilder builder) {
            this.acceleratedOrMatured = builder.getAcceleratedOrMatured();
            this.accruedInterest = builder.getAccruedInterest();
            this.assignableLoan = Optional.ofNullable(builder.getAssignableLoan()).map(f -> f.build()).orElse(null);
            this.category = builder.getCategory();
            this.consentRequiredLoan = Optional.ofNullable(builder.getConsentRequiredLoan()).map(f -> f.build()).orElse(null);
            this.directLoanParticipation = Optional.ofNullable(builder.getDirectLoanParticipation()).map(f -> f.build()).orElse(null);
            this.excluded = builder.getExcluded();
            this.fullFaithAndCreditObLiability = builder.getFullFaithAndCreditObLiability();
            this.generalFundObligationLiability = builder.getGeneralFundObligationLiability();
            this.indirectLoanParticipation = Optional.ofNullable(builder.getIndirectLoanParticipation()).map(f -> f.build()).orElse(null);
            this.listed = builder.getListed();
            this.maximumMaturity = Optional.ofNullable(builder.getMaximumMaturity()).map(f -> f.build()).orElse(null);
            this.notBearer = builder.getNotBearer();
            this.notContingent = builder.getNotContingent();
            this.notDomesticCurrency = Optional.ofNullable(builder.getNotDomesticCurrency()).map(f -> f.build()).orElse(null);
            this.notDomesticIssuance = builder.getNotDomesticIssuance();
            this.notDomesticLaw = builder.getNotDomesticLaw();
            this.notSovereignLender = builder.getNotSovereignLender();
            this.notSubordinated = builder.getNotSubordinated();
            this.othReferenceEntityObligations = builder.getOthReferenceEntityObligations();
            this.revenueObligationLiability = builder.getRevenueObligationLiability();
            this.specifiedCurrency = Optional.ofNullable(builder.getSpecifiedCurrency()).map(f -> f.build()).orElse(null);
            this.transferable = builder.getTransferable();
        }

        @Override
        public Boolean getAcceleratedOrMatured() {
            return this.acceleratedOrMatured;
        }

        @Override
        public Boolean getAccruedInterest() {
            return this.accruedInterest;
        }

        @Override
        public PCDeliverableObligationCharac getAssignableLoan() {
            return this.assignableLoan;
        }

        @Override
        public ObligationCategoryEnum getCategory() {
            return this.category;
        }

        @Override
        public PCDeliverableObligationCharac getConsentRequiredLoan() {
            return this.consentRequiredLoan;
        }

        @Override
        public LoanParticipation getDirectLoanParticipation() {
            return this.directLoanParticipation;
        }

        @Override
        public String getExcluded() {
            return this.excluded;
        }

        @Override
        public Boolean getFullFaithAndCreditObLiability() {
            return this.fullFaithAndCreditObLiability;
        }

        @Override
        public Boolean getGeneralFundObligationLiability() {
            return this.generalFundObligationLiability;
        }

        @Override
        public LoanParticipation getIndirectLoanParticipation() {
            return this.indirectLoanParticipation;
        }

        @Override
        public Boolean getListed() {
            return this.listed;
        }

        @Override
        public Period getMaximumMaturity() {
            return this.maximumMaturity;
        }

        @Override
        public Boolean getNotBearer() {
            return this.notBearer;
        }

        @Override
        public Boolean getNotContingent() {
            return this.notContingent;
        }

        @Override
        public NotDomesticCurrency getNotDomesticCurrency() {
            return this.notDomesticCurrency;
        }

        @Override
        public Boolean getNotDomesticIssuance() {
            return this.notDomesticIssuance;
        }

        @Override
        public Boolean getNotDomesticLaw() {
            return this.notDomesticLaw;
        }

        @Override
        public Boolean getNotSovereignLender() {
            return this.notSovereignLender;
        }

        @Override
        public Boolean getNotSubordinated() {
            return this.notSubordinated;
        }

        @Override
        public String getOthReferenceEntityObligations() {
            return this.othReferenceEntityObligations;
        }

        @Override
        public Boolean getRevenueObligationLiability() {
            return this.revenueObligationLiability;
        }

        @Override
        public SpecifiedCurrency getSpecifiedCurrency() {
            return this.specifiedCurrency;
        }

        @Override
        public Boolean getTransferable() {
            return this.transferable;
        }

        @Override
        public DeliverableObligations build() {
            return this;
        }

        @Override
        public DeliverableObligationsBuilder toBuilder() {
            DeliverableObligationsBuilder builder = DeliverableObligations.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DeliverableObligationsBuilder builder) {
            Optional.ofNullable(this.getAcceleratedOrMatured()).ifPresent(builder::setAcceleratedOrMatured);
            Optional.ofNullable(this.getAccruedInterest()).ifPresent(builder::setAccruedInterest);
            Optional.ofNullable(this.getAssignableLoan()).ifPresent(builder::setAssignableLoan);
            Optional.ofNullable(this.getCategory()).ifPresent(builder::setCategory);
            Optional.ofNullable(this.getConsentRequiredLoan()).ifPresent(builder::setConsentRequiredLoan);
            Optional.ofNullable(this.getDirectLoanParticipation()).ifPresent(builder::setDirectLoanParticipation);
            Optional.ofNullable(this.getExcluded()).ifPresent(builder::setExcluded);
            Optional.ofNullable(this.getFullFaithAndCreditObLiability()).ifPresent(builder::setFullFaithAndCreditObLiability);
            Optional.ofNullable(this.getGeneralFundObligationLiability()).ifPresent(builder::setGeneralFundObligationLiability);
            Optional.ofNullable(this.getIndirectLoanParticipation()).ifPresent(builder::setIndirectLoanParticipation);
            Optional.ofNullable(this.getListed()).ifPresent(builder::setListed);
            Optional.ofNullable(this.getMaximumMaturity()).ifPresent(builder::setMaximumMaturity);
            Optional.ofNullable(this.getNotBearer()).ifPresent(builder::setNotBearer);
            Optional.ofNullable(this.getNotContingent()).ifPresent(builder::setNotContingent);
            Optional.ofNullable(this.getNotDomesticCurrency()).ifPresent(builder::setNotDomesticCurrency);
            Optional.ofNullable(this.getNotDomesticIssuance()).ifPresent(builder::setNotDomesticIssuance);
            Optional.ofNullable(this.getNotDomesticLaw()).ifPresent(builder::setNotDomesticLaw);
            Optional.ofNullable(this.getNotSovereignLender()).ifPresent(builder::setNotSovereignLender);
            Optional.ofNullable(this.getNotSubordinated()).ifPresent(builder::setNotSubordinated);
            Optional.ofNullable(this.getOthReferenceEntityObligations()).ifPresent(builder::setOthReferenceEntityObligations);
            Optional.ofNullable(this.getRevenueObligationLiability()).ifPresent(builder::setRevenueObligationLiability);
            Optional.ofNullable(this.getSpecifiedCurrency()).ifPresent(builder::setSpecifiedCurrency);
            Optional.ofNullable(this.getTransferable()).ifPresent(builder::setTransferable);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DeliverableObligations _that = this.getType().cast(o);
            if (!Objects.equals(this.acceleratedOrMatured, _that.getAcceleratedOrMatured())) {
                return false;
            }
            if (!Objects.equals(this.accruedInterest, _that.getAccruedInterest())) {
                return false;
            }
            if (!Objects.equals(this.assignableLoan, _that.getAssignableLoan())) {
                return false;
            }
            if (!Objects.equals((Object)this.category, (Object)_that.getCategory())) {
                return false;
            }
            if (!Objects.equals(this.consentRequiredLoan, _that.getConsentRequiredLoan())) {
                return false;
            }
            if (!Objects.equals(this.directLoanParticipation, _that.getDirectLoanParticipation())) {
                return false;
            }
            if (!Objects.equals(this.excluded, _that.getExcluded())) {
                return false;
            }
            if (!Objects.equals(this.fullFaithAndCreditObLiability, _that.getFullFaithAndCreditObLiability())) {
                return false;
            }
            if (!Objects.equals(this.generalFundObligationLiability, _that.getGeneralFundObligationLiability())) {
                return false;
            }
            if (!Objects.equals(this.indirectLoanParticipation, _that.getIndirectLoanParticipation())) {
                return false;
            }
            if (!Objects.equals(this.listed, _that.getListed())) {
                return false;
            }
            if (!Objects.equals(this.maximumMaturity, _that.getMaximumMaturity())) {
                return false;
            }
            if (!Objects.equals(this.notBearer, _that.getNotBearer())) {
                return false;
            }
            if (!Objects.equals(this.notContingent, _that.getNotContingent())) {
                return false;
            }
            if (!Objects.equals(this.notDomesticCurrency, _that.getNotDomesticCurrency())) {
                return false;
            }
            if (!Objects.equals(this.notDomesticIssuance, _that.getNotDomesticIssuance())) {
                return false;
            }
            if (!Objects.equals(this.notDomesticLaw, _that.getNotDomesticLaw())) {
                return false;
            }
            if (!Objects.equals(this.notSovereignLender, _that.getNotSovereignLender())) {
                return false;
            }
            if (!Objects.equals(this.notSubordinated, _that.getNotSubordinated())) {
                return false;
            }
            if (!Objects.equals(this.othReferenceEntityObligations, _that.getOthReferenceEntityObligations())) {
                return false;
            }
            if (!Objects.equals(this.revenueObligationLiability, _that.getRevenueObligationLiability())) {
                return false;
            }
            if (!Objects.equals(this.specifiedCurrency, _that.getSpecifiedCurrency())) {
                return false;
            }
            return Objects.equals(this.transferable, _that.getTransferable());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.acceleratedOrMatured != null ? this.acceleratedOrMatured.hashCode() : 0);
            _result = 31 * _result + (this.accruedInterest != null ? this.accruedInterest.hashCode() : 0);
            _result = 31 * _result + (this.assignableLoan != null ? this.assignableLoan.hashCode() : 0);
            _result = 31 * _result + (this.category != null ? ((Object)((Object)this.category)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.consentRequiredLoan != null ? this.consentRequiredLoan.hashCode() : 0);
            _result = 31 * _result + (this.directLoanParticipation != null ? this.directLoanParticipation.hashCode() : 0);
            _result = 31 * _result + (this.excluded != null ? this.excluded.hashCode() : 0);
            _result = 31 * _result + (this.fullFaithAndCreditObLiability != null ? this.fullFaithAndCreditObLiability.hashCode() : 0);
            _result = 31 * _result + (this.generalFundObligationLiability != null ? this.generalFundObligationLiability.hashCode() : 0);
            _result = 31 * _result + (this.indirectLoanParticipation != null ? this.indirectLoanParticipation.hashCode() : 0);
            _result = 31 * _result + (this.listed != null ? this.listed.hashCode() : 0);
            _result = 31 * _result + (this.maximumMaturity != null ? this.maximumMaturity.hashCode() : 0);
            _result = 31 * _result + (this.notBearer != null ? this.notBearer.hashCode() : 0);
            _result = 31 * _result + (this.notContingent != null ? this.notContingent.hashCode() : 0);
            _result = 31 * _result + (this.notDomesticCurrency != null ? this.notDomesticCurrency.hashCode() : 0);
            _result = 31 * _result + (this.notDomesticIssuance != null ? this.notDomesticIssuance.hashCode() : 0);
            _result = 31 * _result + (this.notDomesticLaw != null ? this.notDomesticLaw.hashCode() : 0);
            _result = 31 * _result + (this.notSovereignLender != null ? this.notSovereignLender.hashCode() : 0);
            _result = 31 * _result + (this.notSubordinated != null ? this.notSubordinated.hashCode() : 0);
            _result = 31 * _result + (this.othReferenceEntityObligations != null ? this.othReferenceEntityObligations.hashCode() : 0);
            _result = 31 * _result + (this.revenueObligationLiability != null ? this.revenueObligationLiability.hashCode() : 0);
            _result = 31 * _result + (this.specifiedCurrency != null ? this.specifiedCurrency.hashCode() : 0);
            _result = 31 * _result + (this.transferable != null ? this.transferable.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DeliverableObligations {acceleratedOrMatured=" + this.acceleratedOrMatured + ", accruedInterest=" + this.accruedInterest + ", assignableLoan=" + this.assignableLoan + ", category=" + (Object)((Object)this.category) + ", consentRequiredLoan=" + this.consentRequiredLoan + ", directLoanParticipation=" + this.directLoanParticipation + ", excluded=" + this.excluded + ", fullFaithAndCreditObLiability=" + this.fullFaithAndCreditObLiability + ", generalFundObligationLiability=" + this.generalFundObligationLiability + ", indirectLoanParticipation=" + this.indirectLoanParticipation + ", listed=" + this.listed + ", maximumMaturity=" + this.maximumMaturity + ", notBearer=" + this.notBearer + ", notContingent=" + this.notContingent + ", notDomesticCurrency=" + this.notDomesticCurrency + ", notDomesticIssuance=" + this.notDomesticIssuance + ", notDomesticLaw=" + this.notDomesticLaw + ", notSovereignLender=" + this.notSovereignLender + ", notSubordinated=" + this.notSubordinated + ", othReferenceEntityObligations=" + this.othReferenceEntityObligations + ", revenueObligationLiability=" + this.revenueObligationLiability + ", specifiedCurrency=" + this.specifiedCurrency + ", transferable=" + this.transferable + '}';
        }
    }

    public static interface DeliverableObligationsBuilder
    extends DeliverableObligations,
    RosettaModelObjectBuilder {
        public PCDeliverableObligationCharac.PCDeliverableObligationCharacBuilder getOrCreateAssignableLoan();

        @Override
        public PCDeliverableObligationCharac.PCDeliverableObligationCharacBuilder getAssignableLoan();

        public PCDeliverableObligationCharac.PCDeliverableObligationCharacBuilder getOrCreateConsentRequiredLoan();

        @Override
        public PCDeliverableObligationCharac.PCDeliverableObligationCharacBuilder getConsentRequiredLoan();

        public LoanParticipation.LoanParticipationBuilder getOrCreateDirectLoanParticipation();

        @Override
        public LoanParticipation.LoanParticipationBuilder getDirectLoanParticipation();

        public LoanParticipation.LoanParticipationBuilder getOrCreateIndirectLoanParticipation();

        @Override
        public LoanParticipation.LoanParticipationBuilder getIndirectLoanParticipation();

        public Period.PeriodBuilder getOrCreateMaximumMaturity();

        @Override
        public Period.PeriodBuilder getMaximumMaturity();

        public NotDomesticCurrency.NotDomesticCurrencyBuilder getOrCreateNotDomesticCurrency();

        @Override
        public NotDomesticCurrency.NotDomesticCurrencyBuilder getNotDomesticCurrency();

        public SpecifiedCurrency.SpecifiedCurrencyBuilder getOrCreateSpecifiedCurrency();

        @Override
        public SpecifiedCurrency.SpecifiedCurrencyBuilder getSpecifiedCurrency();

        public DeliverableObligationsBuilder setAcceleratedOrMatured(Boolean var1);

        public DeliverableObligationsBuilder setAccruedInterest(Boolean var1);

        public DeliverableObligationsBuilder setAssignableLoan(PCDeliverableObligationCharac var1);

        public DeliverableObligationsBuilder setCategory(ObligationCategoryEnum var1);

        public DeliverableObligationsBuilder setConsentRequiredLoan(PCDeliverableObligationCharac var1);

        public DeliverableObligationsBuilder setDirectLoanParticipation(LoanParticipation var1);

        public DeliverableObligationsBuilder setExcluded(String var1);

        public DeliverableObligationsBuilder setFullFaithAndCreditObLiability(Boolean var1);

        public DeliverableObligationsBuilder setGeneralFundObligationLiability(Boolean var1);

        public DeliverableObligationsBuilder setIndirectLoanParticipation(LoanParticipation var1);

        public DeliverableObligationsBuilder setListed(Boolean var1);

        public DeliverableObligationsBuilder setMaximumMaturity(Period var1);

        public DeliverableObligationsBuilder setNotBearer(Boolean var1);

        public DeliverableObligationsBuilder setNotContingent(Boolean var1);

        public DeliverableObligationsBuilder setNotDomesticCurrency(NotDomesticCurrency var1);

        public DeliverableObligationsBuilder setNotDomesticIssuance(Boolean var1);

        public DeliverableObligationsBuilder setNotDomesticLaw(Boolean var1);

        public DeliverableObligationsBuilder setNotSovereignLender(Boolean var1);

        public DeliverableObligationsBuilder setNotSubordinated(Boolean var1);

        public DeliverableObligationsBuilder setOthReferenceEntityObligations(String var1);

        public DeliverableObligationsBuilder setRevenueObligationLiability(Boolean var1);

        public DeliverableObligationsBuilder setSpecifiedCurrency(SpecifiedCurrency var1);

        public DeliverableObligationsBuilder setTransferable(Boolean var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("acceleratedOrMatured"), Boolean.class, (Object)this.getAcceleratedOrMatured(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("accruedInterest"), Boolean.class, (Object)this.getAccruedInterest(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("category"), ObligationCategoryEnum.class, (Object)this.getCategory(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("excluded"), String.class, (Object)this.getExcluded(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fullFaithAndCreditObLiability"), Boolean.class, (Object)this.getFullFaithAndCreditObLiability(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("generalFundObligationLiability"), Boolean.class, (Object)this.getGeneralFundObligationLiability(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("listed"), Boolean.class, (Object)this.getListed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notBearer"), Boolean.class, (Object)this.getNotBearer(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notContingent"), Boolean.class, (Object)this.getNotContingent(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notDomesticIssuance"), Boolean.class, (Object)this.getNotDomesticIssuance(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notDomesticLaw"), Boolean.class, (Object)this.getNotDomesticLaw(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notSovereignLender"), Boolean.class, (Object)this.getNotSovereignLender(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notSubordinated"), Boolean.class, (Object)this.getNotSubordinated(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("othReferenceEntityObligations"), String.class, (Object)this.getOthReferenceEntityObligations(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("revenueObligationLiability"), Boolean.class, (Object)this.getRevenueObligationLiability(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("transferable"), Boolean.class, (Object)this.getTransferable(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("assignableLoan"), processor, PCDeliverableObligationCharac.PCDeliverableObligationCharacBuilder.class, this.getAssignableLoan(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("consentRequiredLoan"), processor, PCDeliverableObligationCharac.PCDeliverableObligationCharacBuilder.class, this.getConsentRequiredLoan(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("directLoanParticipation"), processor, LoanParticipation.LoanParticipationBuilder.class, this.getDirectLoanParticipation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("indirectLoanParticipation"), processor, LoanParticipation.LoanParticipationBuilder.class, this.getIndirectLoanParticipation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("maximumMaturity"), processor, Period.PeriodBuilder.class, this.getMaximumMaturity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notDomesticCurrency"), processor, NotDomesticCurrency.NotDomesticCurrencyBuilder.class, this.getNotDomesticCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("specifiedCurrency"), processor, SpecifiedCurrency.SpecifiedCurrencyBuilder.class, this.getSpecifiedCurrency(), new AttributeMeta[0]);
        }

        public DeliverableObligationsBuilder prune();
    }
}

