/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import cdm.product.common.settlement.meta.ComputedAmountMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface ComputedAmount
extends RosettaModelObject {
    public static final ComputedAmountMeta metaData = new ComputedAmountMeta();

    public ComputedAmount build();

    public ComputedAmountBuilder toBuilder();

    public BigDecimal getAmount();

    public String getCallFunction();

    public FieldWithMetaString getCurrency();

    default public RosettaMetaData<? extends ComputedAmount> metaData() {
        return metaData;
    }

    public static ComputedAmountBuilder builder() {
        return new ComputedAmountBuilderImpl();
    }

    default public Class<? extends ComputedAmount> getType() {
        return ComputedAmount.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("amount"), BigDecimal.class, (Object)this.getAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("callFunction"), String.class, (Object)this.getCallFunction(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, FieldWithMetaString.class, this.getCurrency(), new AttributeMeta[0]);
    }

    public static class ComputedAmountBuilderImpl
    implements ComputedAmountBuilder {
        protected BigDecimal amount;
        protected String callFunction;
        protected FieldWithMetaString.FieldWithMetaStringBuilder currency;

        @Override
        public BigDecimal getAmount() {
            return this.amount;
        }

        @Override
        public String getCallFunction() {
            return this.callFunction;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getCurrency() {
            return this.currency;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateCurrency() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.currency != null ? this.currency : (this.currency = FieldWithMetaString.builder());
            return result;
        }

        @Override
        public ComputedAmountBuilder setAmount(BigDecimal amount) {
            this.amount = amount == null ? null : amount;
            return this;
        }

        @Override
        public ComputedAmountBuilder setCallFunction(String callFunction) {
            this.callFunction = callFunction == null ? null : callFunction;
            return this;
        }

        @Override
        public ComputedAmountBuilder setCurrency(FieldWithMetaString currency) {
            this.currency = currency == null ? null : currency.toBuilder();
            return this;
        }

        @Override
        public ComputedAmountBuilder setCurrencyValue(String currency) {
            this.getOrCreateCurrency().setValue(currency);
            return this;
        }

        @Override
        public ComputedAmount build() {
            return new ComputedAmountImpl(this);
        }

        @Override
        public ComputedAmountBuilder toBuilder() {
            return this;
        }

        @Override
        public ComputedAmountBuilder prune() {
            if (this.currency != null && !this.currency.prune().hasData()) {
                this.currency = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAmount() != null) {
                return true;
            }
            if (this.getCallFunction() != null) {
                return true;
            }
            return this.getCurrency() != null;
        }

        public ComputedAmountBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ComputedAmountBuilder o = (ComputedAmountBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurrency(), (RosettaModelObjectBuilder)o.getCurrency(), this::setCurrency);
            merger.mergeBasic((Object)this.getAmount(), (Object)o.getAmount(), this::setAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCallFunction(), (Object)o.getCallFunction(), this::setCallFunction, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ComputedAmount _that = this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            if (!Objects.equals(this.callFunction, _that.getCallFunction())) {
                return false;
            }
            return Objects.equals(this.currency, _that.getCurrency());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.callFunction != null ? this.callFunction.hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ComputedAmountBuilder {amount=" + this.amount + ", callFunction=" + this.callFunction + ", currency=" + this.currency + '}';
        }
    }

    public static class ComputedAmountImpl
    implements ComputedAmount {
        private final BigDecimal amount;
        private final String callFunction;
        private final FieldWithMetaString currency;

        protected ComputedAmountImpl(ComputedAmountBuilder builder) {
            this.amount = builder.getAmount();
            this.callFunction = builder.getCallFunction();
            this.currency = Optional.ofNullable(builder.getCurrency()).map(f -> f.build()).orElse(null);
        }

        @Override
        public BigDecimal getAmount() {
            return this.amount;
        }

        @Override
        public String getCallFunction() {
            return this.callFunction;
        }

        @Override
        public FieldWithMetaString getCurrency() {
            return this.currency;
        }

        @Override
        public ComputedAmount build() {
            return this;
        }

        @Override
        public ComputedAmountBuilder toBuilder() {
            ComputedAmountBuilder builder = ComputedAmount.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ComputedAmountBuilder builder) {
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getCallFunction()).ifPresent(builder::setCallFunction);
            Optional.ofNullable(this.getCurrency()).ifPresent(builder::setCurrency);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ComputedAmount _that = this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            if (!Objects.equals(this.callFunction, _that.getCallFunction())) {
                return false;
            }
            return Objects.equals(this.currency, _that.getCurrency());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.callFunction != null ? this.callFunction.hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ComputedAmount {amount=" + this.amount + ", callFunction=" + this.callFunction + ", currency=" + this.currency + '}';
        }
    }

    public static interface ComputedAmountBuilder
    extends ComputedAmount,
    RosettaModelObjectBuilder {
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateCurrency();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getCurrency();

        public ComputedAmountBuilder setAmount(BigDecimal var1);

        public ComputedAmountBuilder setCallFunction(String var1);

        public ComputedAmountBuilder setCurrency(FieldWithMetaString var1);

        public ComputedAmountBuilder setCurrencyValue(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("amount"), BigDecimal.class, (Object)this.getAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("callFunction"), String.class, (Object)this.getCallFunction(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getCurrency(), new AttributeMeta[0]);
        }

        public ComputedAmountBuilder prune();
    }
}

