/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import cdm.base.math.Rounding;
import cdm.product.asset.SpreadSchedule;
import cdm.product.common.settlement.RollFeature;
import cdm.product.common.settlement.meta.CommodityPriceReturnTermsMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface CommodityPriceReturnTerms
extends RosettaModelObject {
    public static final CommodityPriceReturnTermsMeta metaData = new CommodityPriceReturnTermsMeta();

    public CommodityPriceReturnTerms build();

    public CommodityPriceReturnTermsBuilder toBuilder();

    public BigDecimal getConversionFactor();

    public RollFeature getRollFeature();

    public Rounding getRounding();

    public SpreadSchedule getSpread();

    default public RosettaMetaData<? extends CommodityPriceReturnTerms> metaData() {
        return metaData;
    }

    public static CommodityPriceReturnTermsBuilder builder() {
        return new CommodityPriceReturnTermsBuilderImpl();
    }

    default public Class<? extends CommodityPriceReturnTerms> getType() {
        return CommodityPriceReturnTerms.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("conversionFactor"), BigDecimal.class, (Object)this.getConversionFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rollFeature"), processor, RollFeature.class, this.getRollFeature(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rounding"), processor, Rounding.class, this.getRounding(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("spread"), processor, SpreadSchedule.class, this.getSpread(), new AttributeMeta[0]);
    }

    public static class CommodityPriceReturnTermsBuilderImpl
    implements CommodityPriceReturnTermsBuilder {
        protected BigDecimal conversionFactor;
        protected RollFeature.RollFeatureBuilder rollFeature;
        protected Rounding.RoundingBuilder rounding;
        protected SpreadSchedule.SpreadScheduleBuilder spread;

        @Override
        public BigDecimal getConversionFactor() {
            return this.conversionFactor;
        }

        @Override
        public RollFeature.RollFeatureBuilder getRollFeature() {
            return this.rollFeature;
        }

        @Override
        public RollFeature.RollFeatureBuilder getOrCreateRollFeature() {
            RollFeature.RollFeatureBuilder result = this.rollFeature != null ? this.rollFeature : (this.rollFeature = RollFeature.builder());
            return result;
        }

        @Override
        public Rounding.RoundingBuilder getRounding() {
            return this.rounding;
        }

        @Override
        public Rounding.RoundingBuilder getOrCreateRounding() {
            Rounding.RoundingBuilder result = this.rounding != null ? this.rounding : (this.rounding = Rounding.builder());
            return result;
        }

        @Override
        public SpreadSchedule.SpreadScheduleBuilder getSpread() {
            return this.spread;
        }

        @Override
        public SpreadSchedule.SpreadScheduleBuilder getOrCreateSpread() {
            SpreadSchedule.SpreadScheduleBuilder result = this.spread != null ? this.spread : (this.spread = SpreadSchedule.builder());
            return result;
        }

        @Override
        public CommodityPriceReturnTermsBuilder setConversionFactor(BigDecimal conversionFactor) {
            this.conversionFactor = conversionFactor == null ? null : conversionFactor;
            return this;
        }

        @Override
        public CommodityPriceReturnTermsBuilder setRollFeature(RollFeature rollFeature) {
            this.rollFeature = rollFeature == null ? null : rollFeature.toBuilder();
            return this;
        }

        @Override
        public CommodityPriceReturnTermsBuilder setRounding(Rounding rounding) {
            this.rounding = rounding == null ? null : rounding.toBuilder();
            return this;
        }

        @Override
        public CommodityPriceReturnTermsBuilder setSpread(SpreadSchedule spread) {
            this.spread = spread == null ? null : spread.toBuilder();
            return this;
        }

        @Override
        public CommodityPriceReturnTerms build() {
            return new CommodityPriceReturnTermsImpl(this);
        }

        @Override
        public CommodityPriceReturnTermsBuilder toBuilder() {
            return this;
        }

        @Override
        public CommodityPriceReturnTermsBuilder prune() {
            if (this.rollFeature != null && !this.rollFeature.prune().hasData()) {
                this.rollFeature = null;
            }
            if (this.rounding != null && !this.rounding.prune().hasData()) {
                this.rounding = null;
            }
            if (this.spread != null && !this.spread.prune().hasData()) {
                this.spread = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getConversionFactor() != null) {
                return true;
            }
            if (this.getRollFeature() != null && this.getRollFeature().hasData()) {
                return true;
            }
            if (this.getRounding() != null && this.getRounding().hasData()) {
                return true;
            }
            return this.getSpread() != null && this.getSpread().hasData();
        }

        public CommodityPriceReturnTermsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CommodityPriceReturnTermsBuilder o = (CommodityPriceReturnTermsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRollFeature(), (RosettaModelObjectBuilder)o.getRollFeature(), this::setRollFeature);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRounding(), (RosettaModelObjectBuilder)o.getRounding(), this::setRounding);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSpread(), (RosettaModelObjectBuilder)o.getSpread(), this::setSpread);
            merger.mergeBasic((Object)this.getConversionFactor(), (Object)o.getConversionFactor(), this::setConversionFactor, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityPriceReturnTerms _that = this.getType().cast(o);
            if (!Objects.equals(this.conversionFactor, _that.getConversionFactor())) {
                return false;
            }
            if (!Objects.equals(this.rollFeature, _that.getRollFeature())) {
                return false;
            }
            if (!Objects.equals(this.rounding, _that.getRounding())) {
                return false;
            }
            return Objects.equals(this.spread, _that.getSpread());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.conversionFactor != null ? this.conversionFactor.hashCode() : 0);
            _result = 31 * _result + (this.rollFeature != null ? this.rollFeature.hashCode() : 0);
            _result = 31 * _result + (this.rounding != null ? this.rounding.hashCode() : 0);
            _result = 31 * _result + (this.spread != null ? this.spread.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityPriceReturnTermsBuilder {conversionFactor=" + this.conversionFactor + ", rollFeature=" + this.rollFeature + ", rounding=" + this.rounding + ", spread=" + this.spread + '}';
        }
    }

    public static class CommodityPriceReturnTermsImpl
    implements CommodityPriceReturnTerms {
        private final BigDecimal conversionFactor;
        private final RollFeature rollFeature;
        private final Rounding rounding;
        private final SpreadSchedule spread;

        protected CommodityPriceReturnTermsImpl(CommodityPriceReturnTermsBuilder builder) {
            this.conversionFactor = builder.getConversionFactor();
            this.rollFeature = Optional.ofNullable(builder.getRollFeature()).map(f -> f.build()).orElse(null);
            this.rounding = Optional.ofNullable(builder.getRounding()).map(f -> f.build()).orElse(null);
            this.spread = Optional.ofNullable(builder.getSpread()).map(f -> f.build()).orElse(null);
        }

        @Override
        public BigDecimal getConversionFactor() {
            return this.conversionFactor;
        }

        @Override
        public RollFeature getRollFeature() {
            return this.rollFeature;
        }

        @Override
        public Rounding getRounding() {
            return this.rounding;
        }

        @Override
        public SpreadSchedule getSpread() {
            return this.spread;
        }

        @Override
        public CommodityPriceReturnTerms build() {
            return this;
        }

        @Override
        public CommodityPriceReturnTermsBuilder toBuilder() {
            CommodityPriceReturnTermsBuilder builder = CommodityPriceReturnTerms.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommodityPriceReturnTermsBuilder builder) {
            Optional.ofNullable(this.getConversionFactor()).ifPresent(builder::setConversionFactor);
            Optional.ofNullable(this.getRollFeature()).ifPresent(builder::setRollFeature);
            Optional.ofNullable(this.getRounding()).ifPresent(builder::setRounding);
            Optional.ofNullable(this.getSpread()).ifPresent(builder::setSpread);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityPriceReturnTerms _that = this.getType().cast(o);
            if (!Objects.equals(this.conversionFactor, _that.getConversionFactor())) {
                return false;
            }
            if (!Objects.equals(this.rollFeature, _that.getRollFeature())) {
                return false;
            }
            if (!Objects.equals(this.rounding, _that.getRounding())) {
                return false;
            }
            return Objects.equals(this.spread, _that.getSpread());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.conversionFactor != null ? this.conversionFactor.hashCode() : 0);
            _result = 31 * _result + (this.rollFeature != null ? this.rollFeature.hashCode() : 0);
            _result = 31 * _result + (this.rounding != null ? this.rounding.hashCode() : 0);
            _result = 31 * _result + (this.spread != null ? this.spread.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityPriceReturnTerms {conversionFactor=" + this.conversionFactor + ", rollFeature=" + this.rollFeature + ", rounding=" + this.rounding + ", spread=" + this.spread + '}';
        }
    }

    public static interface CommodityPriceReturnTermsBuilder
    extends CommodityPriceReturnTerms,
    RosettaModelObjectBuilder {
        public RollFeature.RollFeatureBuilder getOrCreateRollFeature();

        @Override
        public RollFeature.RollFeatureBuilder getRollFeature();

        public Rounding.RoundingBuilder getOrCreateRounding();

        @Override
        public Rounding.RoundingBuilder getRounding();

        public SpreadSchedule.SpreadScheduleBuilder getOrCreateSpread();

        @Override
        public SpreadSchedule.SpreadScheduleBuilder getSpread();

        public CommodityPriceReturnTermsBuilder setConversionFactor(BigDecimal var1);

        public CommodityPriceReturnTermsBuilder setRollFeature(RollFeature var1);

        public CommodityPriceReturnTermsBuilder setRounding(Rounding var1);

        public CommodityPriceReturnTermsBuilder setSpread(SpreadSchedule var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("conversionFactor"), BigDecimal.class, (Object)this.getConversionFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rollFeature"), processor, RollFeature.RollFeatureBuilder.class, this.getRollFeature(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rounding"), processor, Rounding.RoundingBuilder.class, this.getRounding(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("spread"), processor, SpreadSchedule.SpreadScheduleBuilder.class, this.getSpread(), new AttributeMeta[0]);
        }

        public CommodityPriceReturnTermsBuilder prune();
    }
}

