/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import cdm.observable.asset.CashPrice;
import cdm.observable.asset.GrossOrNetEnum;
import cdm.observable.asset.PriceExpressionEnum;
import cdm.product.common.settlement.ScheduledTransferEnum;
import cdm.product.common.settlement.meta.CashflowTypeMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface CashflowType
extends RosettaModelObject {
    public static final CashflowTypeMeta metaData = new CashflowTypeMeta();

    public CashflowType build();

    public CashflowTypeBuilder toBuilder();

    public CashPrice getCashPrice();

    public ScheduledTransferEnum getCashflowType();

    public GrossOrNetEnum getGrossOrNet();

    public PriceExpressionEnum getPriceExpression();

    default public RosettaMetaData<? extends CashflowType> metaData() {
        return metaData;
    }

    public static CashflowTypeBuilder builder() {
        return new CashflowTypeBuilderImpl();
    }

    default public Class<? extends CashflowType> getType() {
        return CashflowType.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("cashflowType"), ScheduledTransferEnum.class, (Object)this.getCashflowType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("grossOrNet"), GrossOrNetEnum.class, (Object)this.getGrossOrNet(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceExpression"), PriceExpressionEnum.class, (Object)this.getPriceExpression(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cashPrice"), processor, CashPrice.class, this.getCashPrice(), new AttributeMeta[0]);
    }

    public static class CashflowTypeBuilderImpl
    implements CashflowTypeBuilder {
        protected CashPrice.CashPriceBuilder cashPrice;
        protected ScheduledTransferEnum cashflowType;
        protected GrossOrNetEnum grossOrNet;
        protected PriceExpressionEnum priceExpression;

        @Override
        public CashPrice.CashPriceBuilder getCashPrice() {
            return this.cashPrice;
        }

        @Override
        public CashPrice.CashPriceBuilder getOrCreateCashPrice() {
            CashPrice.CashPriceBuilder result = this.cashPrice != null ? this.cashPrice : (this.cashPrice = CashPrice.builder());
            return result;
        }

        @Override
        public ScheduledTransferEnum getCashflowType() {
            return this.cashflowType;
        }

        @Override
        public GrossOrNetEnum getGrossOrNet() {
            return this.grossOrNet;
        }

        @Override
        public PriceExpressionEnum getPriceExpression() {
            return this.priceExpression;
        }

        @Override
        public CashflowTypeBuilder setCashPrice(CashPrice cashPrice) {
            this.cashPrice = cashPrice == null ? null : cashPrice.toBuilder();
            return this;
        }

        @Override
        public CashflowTypeBuilder setCashflowType(ScheduledTransferEnum cashflowType) {
            this.cashflowType = cashflowType == null ? null : cashflowType;
            return this;
        }

        @Override
        public CashflowTypeBuilder setGrossOrNet(GrossOrNetEnum grossOrNet) {
            this.grossOrNet = grossOrNet == null ? null : grossOrNet;
            return this;
        }

        @Override
        public CashflowTypeBuilder setPriceExpression(PriceExpressionEnum priceExpression) {
            this.priceExpression = priceExpression == null ? null : priceExpression;
            return this;
        }

        @Override
        public CashflowType build() {
            return new CashflowTypeImpl(this);
        }

        @Override
        public CashflowTypeBuilder toBuilder() {
            return this;
        }

        @Override
        public CashflowTypeBuilder prune() {
            if (this.cashPrice != null && !this.cashPrice.prune().hasData()) {
                this.cashPrice = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCashPrice() != null && this.getCashPrice().hasData()) {
                return true;
            }
            if (this.getCashflowType() != null) {
                return true;
            }
            if (this.getGrossOrNet() != null) {
                return true;
            }
            return this.getPriceExpression() != null;
        }

        public CashflowTypeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CashflowTypeBuilder o = (CashflowTypeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCashPrice(), (RosettaModelObjectBuilder)o.getCashPrice(), this::setCashPrice);
            merger.mergeBasic((Object)this.getCashflowType(), (Object)o.getCashflowType(), this::setCashflowType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getGrossOrNet(), (Object)o.getGrossOrNet(), this::setGrossOrNet, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriceExpression(), (Object)o.getPriceExpression(), this::setPriceExpression, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CashflowType _that = this.getType().cast(o);
            if (!Objects.equals(this.cashPrice, _that.getCashPrice())) {
                return false;
            }
            if (!Objects.equals((Object)this.cashflowType, (Object)_that.getCashflowType())) {
                return false;
            }
            if (!Objects.equals((Object)this.grossOrNet, (Object)_that.getGrossOrNet())) {
                return false;
            }
            return Objects.equals((Object)this.priceExpression, (Object)_that.getPriceExpression());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.cashPrice != null ? this.cashPrice.hashCode() : 0);
            _result = 31 * _result + (this.cashflowType != null ? ((Object)((Object)this.cashflowType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.grossOrNet != null ? ((Object)((Object)this.grossOrNet)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.priceExpression != null ? ((Object)((Object)this.priceExpression)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CashflowTypeBuilder {cashPrice=" + this.cashPrice + ", cashflowType=" + (Object)((Object)this.cashflowType) + ", grossOrNet=" + (Object)((Object)this.grossOrNet) + ", priceExpression=" + (Object)((Object)this.priceExpression) + '}';
        }
    }

    public static class CashflowTypeImpl
    implements CashflowType {
        private final CashPrice cashPrice;
        private final ScheduledTransferEnum cashflowType;
        private final GrossOrNetEnum grossOrNet;
        private final PriceExpressionEnum priceExpression;

        protected CashflowTypeImpl(CashflowTypeBuilder builder) {
            this.cashPrice = Optional.ofNullable(builder.getCashPrice()).map(f -> f.build()).orElse(null);
            this.cashflowType = builder.getCashflowType();
            this.grossOrNet = builder.getGrossOrNet();
            this.priceExpression = builder.getPriceExpression();
        }

        @Override
        public CashPrice getCashPrice() {
            return this.cashPrice;
        }

        @Override
        public ScheduledTransferEnum getCashflowType() {
            return this.cashflowType;
        }

        @Override
        public GrossOrNetEnum getGrossOrNet() {
            return this.grossOrNet;
        }

        @Override
        public PriceExpressionEnum getPriceExpression() {
            return this.priceExpression;
        }

        @Override
        public CashflowType build() {
            return this;
        }

        @Override
        public CashflowTypeBuilder toBuilder() {
            CashflowTypeBuilder builder = CashflowType.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CashflowTypeBuilder builder) {
            Optional.ofNullable(this.getCashPrice()).ifPresent(builder::setCashPrice);
            Optional.ofNullable(this.getCashflowType()).ifPresent(builder::setCashflowType);
            Optional.ofNullable(this.getGrossOrNet()).ifPresent(builder::setGrossOrNet);
            Optional.ofNullable(this.getPriceExpression()).ifPresent(builder::setPriceExpression);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CashflowType _that = this.getType().cast(o);
            if (!Objects.equals(this.cashPrice, _that.getCashPrice())) {
                return false;
            }
            if (!Objects.equals((Object)this.cashflowType, (Object)_that.getCashflowType())) {
                return false;
            }
            if (!Objects.equals((Object)this.grossOrNet, (Object)_that.getGrossOrNet())) {
                return false;
            }
            return Objects.equals((Object)this.priceExpression, (Object)_that.getPriceExpression());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.cashPrice != null ? this.cashPrice.hashCode() : 0);
            _result = 31 * _result + (this.cashflowType != null ? ((Object)((Object)this.cashflowType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.grossOrNet != null ? ((Object)((Object)this.grossOrNet)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.priceExpression != null ? ((Object)((Object)this.priceExpression)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CashflowType {cashPrice=" + this.cashPrice + ", cashflowType=" + (Object)((Object)this.cashflowType) + ", grossOrNet=" + (Object)((Object)this.grossOrNet) + ", priceExpression=" + (Object)((Object)this.priceExpression) + '}';
        }
    }

    public static interface CashflowTypeBuilder
    extends CashflowType,
    RosettaModelObjectBuilder {
        public CashPrice.CashPriceBuilder getOrCreateCashPrice();

        @Override
        public CashPrice.CashPriceBuilder getCashPrice();

        public CashflowTypeBuilder setCashPrice(CashPrice var1);

        public CashflowTypeBuilder setCashflowType(ScheduledTransferEnum var1);

        public CashflowTypeBuilder setGrossOrNet(GrossOrNetEnum var1);

        public CashflowTypeBuilder setPriceExpression(PriceExpressionEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("cashflowType"), ScheduledTransferEnum.class, (Object)this.getCashflowType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("grossOrNet"), GrossOrNetEnum.class, (Object)this.getGrossOrNet(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceExpression"), PriceExpressionEnum.class, (Object)this.getPriceExpression(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cashPrice"), processor, CashPrice.CashPriceBuilder.class, this.getCashPrice(), new AttributeMeta[0]);
        }

        public CashflowTypeBuilder prune();
    }
}

