/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import cdm.base.staticdata.party.PayerReceiver;
import cdm.product.common.settlement.CashflowType;
import cdm.product.common.settlement.PaymentDiscounting;
import cdm.product.common.settlement.PayoutBase;
import cdm.product.common.settlement.PrincipalPayments;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.common.settlement.meta.CashflowMeta;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface Cashflow
extends PayoutBase,
GlobalKey {
    public static final CashflowMeta metaData = new CashflowMeta();

    @Override
    public Cashflow build();

    @Override
    public CashflowBuilder toBuilder();

    public CashflowType getCashflowType();

    public MetaFields getMeta();

    public PaymentDiscounting getPaymentDiscounting();

    default public RosettaMetaData<? extends Cashflow> metaData() {
        return metaData;
    }

    public static CashflowBuilder builder() {
        return new CashflowBuilderImpl();
    }

    default public Class<? extends Cashflow> getType() {
        return Cashflow.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        PayoutBase.super.process(path, processor);
        this.processRosetta(path.newSubPath("cashflowType"), processor, CashflowType.class, this.getCashflowType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDiscounting"), processor, PaymentDiscounting.class, this.getPaymentDiscounting(), new AttributeMeta[0]);
    }

    public static class CashflowBuilderImpl
    extends PayoutBase.PayoutBaseBuilderImpl
    implements CashflowBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected CashflowType.CashflowTypeBuilder cashflowType;
        protected MetaFields.MetaFieldsBuilder meta;
        protected PaymentDiscounting.PaymentDiscountingBuilder paymentDiscounting;

        @Override
        public CashflowType.CashflowTypeBuilder getCashflowType() {
            return this.cashflowType;
        }

        @Override
        public CashflowType.CashflowTypeBuilder getOrCreateCashflowType() {
            CashflowType.CashflowTypeBuilder result = this.cashflowType != null ? this.cashflowType : (this.cashflowType = CashflowType.builder());
            return result;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public PaymentDiscounting.PaymentDiscountingBuilder getPaymentDiscounting() {
            return this.paymentDiscounting;
        }

        @Override
        public PaymentDiscounting.PaymentDiscountingBuilder getOrCreatePaymentDiscounting() {
            PaymentDiscounting.PaymentDiscountingBuilder result = this.paymentDiscounting != null ? this.paymentDiscounting : (this.paymentDiscounting = PaymentDiscounting.builder());
            return result;
        }

        @Override
        public CashflowBuilder setCashflowType(CashflowType cashflowType) {
            this.cashflowType = cashflowType == null ? null : cashflowType.toBuilder();
            return this;
        }

        @Override
        public CashflowBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public CashflowBuilder setPaymentDiscounting(PaymentDiscounting paymentDiscounting) {
            this.paymentDiscounting = paymentDiscounting == null ? null : paymentDiscounting.toBuilder();
            return this;
        }

        @Override
        public CashflowBuilder setPayerReceiver(PayerReceiver payerReceiver) {
            this.payerReceiver = payerReceiver == null ? null : payerReceiver.toBuilder();
            return this;
        }

        @Override
        public CashflowBuilder setPriceQuantity(ResolvablePriceQuantity priceQuantity) {
            this.priceQuantity = priceQuantity == null ? null : priceQuantity.toBuilder();
            return this;
        }

        @Override
        public CashflowBuilder setPrincipalPayment(PrincipalPayments principalPayment) {
            this.principalPayment = principalPayment == null ? null : principalPayment.toBuilder();
            return this;
        }

        @Override
        public CashflowBuilder setSettlementTerms(SettlementTerms settlementTerms) {
            this.settlementTerms = settlementTerms == null ? null : settlementTerms.toBuilder();
            return this;
        }

        @Override
        public Cashflow build() {
            return new CashflowImpl(this);
        }

        @Override
        public CashflowBuilder toBuilder() {
            return this;
        }

        @Override
        public CashflowBuilder prune() {
            super.prune();
            if (this.cashflowType != null && !this.cashflowType.prune().hasData()) {
                this.cashflowType = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            if (this.paymentDiscounting != null && !this.paymentDiscounting.prune().hasData()) {
                this.paymentDiscounting = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCashflowType() != null && this.getCashflowType().hasData()) {
                return true;
            }
            return this.getPaymentDiscounting() != null && this.getPaymentDiscounting().hasData();
        }

        @Override
        public CashflowBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CashflowBuilder o = (CashflowBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCashflowType(), (RosettaModelObjectBuilder)o.getCashflowType(), this::setCashflowType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentDiscounting(), (RosettaModelObjectBuilder)o.getPaymentDiscounting(), this::setPaymentDiscounting);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Cashflow _that = (Cashflow)this.getType().cast(o);
            if (!Objects.equals(this.cashflowType, _that.getCashflowType())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            return Objects.equals(this.paymentDiscounting, _that.getPaymentDiscounting());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.cashflowType != null ? this.cashflowType.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.paymentDiscounting != null ? this.paymentDiscounting.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CashflowBuilder {cashflowType=" + this.cashflowType + ", meta=" + this.meta + ", paymentDiscounting=" + this.paymentDiscounting + '}' + " " + super.toString();
        }
    }

    public static class CashflowImpl
    extends PayoutBase.PayoutBaseImpl
    implements Cashflow {
        private final CashflowType cashflowType;
        private final MetaFields meta;
        private final PaymentDiscounting paymentDiscounting;

        protected CashflowImpl(CashflowBuilder builder) {
            super(builder);
            this.cashflowType = Optional.ofNullable(builder.getCashflowType()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
            this.paymentDiscounting = Optional.ofNullable(builder.getPaymentDiscounting()).map(f -> f.build()).orElse(null);
        }

        @Override
        public CashflowType getCashflowType() {
            return this.cashflowType;
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public PaymentDiscounting getPaymentDiscounting() {
            return this.paymentDiscounting;
        }

        @Override
        public Cashflow build() {
            return this;
        }

        @Override
        public CashflowBuilder toBuilder() {
            CashflowBuilder builder = Cashflow.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CashflowBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCashflowType()).ifPresent(builder::setCashflowType);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
            Optional.ofNullable(this.getPaymentDiscounting()).ifPresent(builder::setPaymentDiscounting);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Cashflow _that = (Cashflow)this.getType().cast(o);
            if (!Objects.equals(this.cashflowType, _that.getCashflowType())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            return Objects.equals(this.paymentDiscounting, _that.getPaymentDiscounting());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.cashflowType != null ? this.cashflowType.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.paymentDiscounting != null ? this.paymentDiscounting.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Cashflow {cashflowType=" + this.cashflowType + ", meta=" + this.meta + ", paymentDiscounting=" + this.paymentDiscounting + '}' + " " + super.toString();
        }
    }

    public static interface CashflowBuilder
    extends Cashflow,
    PayoutBase.PayoutBaseBuilder,
    RosettaModelObjectBuilder {
        public CashflowType.CashflowTypeBuilder getOrCreateCashflowType();

        @Override
        public CashflowType.CashflowTypeBuilder getCashflowType();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public PaymentDiscounting.PaymentDiscountingBuilder getOrCreatePaymentDiscounting();

        @Override
        public PaymentDiscounting.PaymentDiscountingBuilder getPaymentDiscounting();

        public CashflowBuilder setCashflowType(CashflowType var1);

        public CashflowBuilder setMeta(MetaFields var1);

        public CashflowBuilder setPaymentDiscounting(PaymentDiscounting var1);

        @Override
        public CashflowBuilder setPayerReceiver(PayerReceiver var1);

        @Override
        public CashflowBuilder setPriceQuantity(ResolvablePriceQuantity var1);

        @Override
        public CashflowBuilder setPrincipalPayment(PrincipalPayments var1);

        @Override
        public CashflowBuilder setSettlementTerms(SettlementTerms var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            PayoutBase.PayoutBaseBuilder.super.process(path, processor);
            this.processRosetta(path.newSubPath("cashflowType"), processor, CashflowType.CashflowTypeBuilder.class, this.getCashflowType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDiscounting"), processor, PaymentDiscounting.PaymentDiscountingBuilder.class, this.getPaymentDiscounting(), new AttributeMeta[0]);
        }

        @Override
        public CashflowBuilder prune();
    }
}

