/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum CashSettlementMethodEnum {
    CASH_PRICE_METHOD,
    CASH_PRICE_ALTERNATE_METHOD,
    PAR_YIELD_CURVE_ADJUSTED_METHOD,
    ZERO_COUPON_YIELD_ADJUSTED_METHOD,
    PAR_YIELD_CURVE_UNADJUSTED_METHOD,
    CROSS_CURRENCY_METHOD,
    COLLATERALIZED_CASH_PRICE_METHOD,
    MID_MARKET_INDICATIVE_QUOTATIONS,
    MID_MARKET_INDICATIVE_QUOTATIONS_ALTERNATE,
    MID_MARKET_CALCULATION_AGENT_DETERMINATION,
    REPLACEMENT_VALUE_FIRM_QUOTATIONS,
    REPLACEMENT_VALUE_CALCULATION_AGENT_DETERMINATION;

    private static Map<String, CashSettlementMethodEnum> values;
    private final String displayName;

    private CashSettlementMethodEnum() {
        this(null);
    }

    private CashSettlementMethodEnum(String displayName) {
        this.displayName = displayName;
    }

    public static CashSettlementMethodEnum fromDisplayName(String name) {
        CashSettlementMethodEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.displayName != null ? this.displayName : this.name();
    }

    static {
        ConcurrentHashMap<String, CashSettlementMethodEnum> map = new ConcurrentHashMap<String, CashSettlementMethodEnum>();
        for (CashSettlementMethodEnum instance : CashSettlementMethodEnum.values()) {
            map.put(instance.toString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

