/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.schedule;

import cdm.base.datetime.BusinessDayAdjustments;
import cdm.base.datetime.Frequency;
import cdm.base.datetime.Offset;
import cdm.product.common.schedule.PayRelativeToEnum;
import cdm.product.common.schedule.PaymentDateSchedule;
import cdm.product.common.schedule.meta.PaymentDatesMeta;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.MetaFields;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface PaymentDates
extends RosettaModelObject,
GlobalKey {
    public static final PaymentDatesMeta metaData = new PaymentDatesMeta();

    public PaymentDates build();

    public PaymentDatesBuilder toBuilder();

    public Date getFirstPaymentDate();

    public Date getLastRegularPaymentDate();

    public MetaFields getMeta();

    public PayRelativeToEnum getPayRelativeTo();

    public PaymentDateSchedule getPaymentDateSchedule();

    public BusinessDayAdjustments getPaymentDatesAdjustments();

    public Offset getPaymentDaysOffset();

    public Frequency getPaymentFrequency();

    default public RosettaMetaData<? extends PaymentDates> metaData() {
        return metaData;
    }

    public static PaymentDatesBuilder builder() {
        return new PaymentDatesBuilderImpl();
    }

    default public Class<? extends PaymentDates> getType() {
        return PaymentDates.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("firstPaymentDate"), Date.class, (Object)this.getFirstPaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("lastRegularPaymentDate"), Date.class, (Object)this.getLastRegularPaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("payRelativeTo"), PayRelativeToEnum.class, (Object)this.getPayRelativeTo(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDateSchedule"), processor, PaymentDateSchedule.class, this.getPaymentDateSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDatesAdjustments"), processor, BusinessDayAdjustments.class, this.getPaymentDatesAdjustments(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDaysOffset"), processor, Offset.class, this.getPaymentDaysOffset(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentFrequency"), processor, Frequency.class, this.getPaymentFrequency(), new AttributeMeta[0]);
    }

    public static class PaymentDatesBuilderImpl
    implements PaymentDatesBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected Date firstPaymentDate;
        protected Date lastRegularPaymentDate;
        protected MetaFields.MetaFieldsBuilder meta;
        protected PayRelativeToEnum payRelativeTo;
        protected PaymentDateSchedule.PaymentDateScheduleBuilder paymentDateSchedule;
        protected BusinessDayAdjustments.BusinessDayAdjustmentsBuilder paymentDatesAdjustments;
        protected Offset.OffsetBuilder paymentDaysOffset;
        protected Frequency.FrequencyBuilder paymentFrequency;

        @Override
        public Date getFirstPaymentDate() {
            return this.firstPaymentDate;
        }

        @Override
        public Date getLastRegularPaymentDate() {
            return this.lastRegularPaymentDate;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public PayRelativeToEnum getPayRelativeTo() {
            return this.payRelativeTo;
        }

        @Override
        public PaymentDateSchedule.PaymentDateScheduleBuilder getPaymentDateSchedule() {
            return this.paymentDateSchedule;
        }

        @Override
        public PaymentDateSchedule.PaymentDateScheduleBuilder getOrCreatePaymentDateSchedule() {
            PaymentDateSchedule.PaymentDateScheduleBuilder result = this.paymentDateSchedule != null ? this.paymentDateSchedule : (this.paymentDateSchedule = PaymentDateSchedule.builder());
            return result;
        }

        @Override
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getPaymentDatesAdjustments() {
            return this.paymentDatesAdjustments;
        }

        @Override
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getOrCreatePaymentDatesAdjustments() {
            BusinessDayAdjustments.BusinessDayAdjustmentsBuilder result = this.paymentDatesAdjustments != null ? this.paymentDatesAdjustments : (this.paymentDatesAdjustments = BusinessDayAdjustments.builder());
            return result;
        }

        @Override
        public Offset.OffsetBuilder getPaymentDaysOffset() {
            return this.paymentDaysOffset;
        }

        @Override
        public Offset.OffsetBuilder getOrCreatePaymentDaysOffset() {
            Offset.OffsetBuilder result = this.paymentDaysOffset != null ? this.paymentDaysOffset : (this.paymentDaysOffset = Offset.builder());
            return result;
        }

        @Override
        public Frequency.FrequencyBuilder getPaymentFrequency() {
            return this.paymentFrequency;
        }

        @Override
        public Frequency.FrequencyBuilder getOrCreatePaymentFrequency() {
            Frequency.FrequencyBuilder result = this.paymentFrequency != null ? this.paymentFrequency : (this.paymentFrequency = Frequency.builder());
            return result;
        }

        @Override
        public PaymentDatesBuilder setFirstPaymentDate(Date firstPaymentDate) {
            this.firstPaymentDate = firstPaymentDate == null ? null : firstPaymentDate;
            return this;
        }

        @Override
        public PaymentDatesBuilder setLastRegularPaymentDate(Date lastRegularPaymentDate) {
            this.lastRegularPaymentDate = lastRegularPaymentDate == null ? null : lastRegularPaymentDate;
            return this;
        }

        @Override
        public PaymentDatesBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public PaymentDatesBuilder setPayRelativeTo(PayRelativeToEnum payRelativeTo) {
            this.payRelativeTo = payRelativeTo == null ? null : payRelativeTo;
            return this;
        }

        @Override
        public PaymentDatesBuilder setPaymentDateSchedule(PaymentDateSchedule paymentDateSchedule) {
            this.paymentDateSchedule = paymentDateSchedule == null ? null : paymentDateSchedule.toBuilder();
            return this;
        }

        @Override
        public PaymentDatesBuilder setPaymentDatesAdjustments(BusinessDayAdjustments paymentDatesAdjustments) {
            this.paymentDatesAdjustments = paymentDatesAdjustments == null ? null : paymentDatesAdjustments.toBuilder();
            return this;
        }

        @Override
        public PaymentDatesBuilder setPaymentDaysOffset(Offset paymentDaysOffset) {
            this.paymentDaysOffset = paymentDaysOffset == null ? null : paymentDaysOffset.toBuilder();
            return this;
        }

        @Override
        public PaymentDatesBuilder setPaymentFrequency(Frequency paymentFrequency) {
            this.paymentFrequency = paymentFrequency == null ? null : paymentFrequency.toBuilder();
            return this;
        }

        @Override
        public PaymentDates build() {
            return new PaymentDatesImpl(this);
        }

        @Override
        public PaymentDatesBuilder toBuilder() {
            return this;
        }

        @Override
        public PaymentDatesBuilder prune() {
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            if (this.paymentDateSchedule != null && !this.paymentDateSchedule.prune().hasData()) {
                this.paymentDateSchedule = null;
            }
            if (this.paymentDatesAdjustments != null && !this.paymentDatesAdjustments.prune().hasData()) {
                this.paymentDatesAdjustments = null;
            }
            if (this.paymentDaysOffset != null && !this.paymentDaysOffset.prune().hasData()) {
                this.paymentDaysOffset = null;
            }
            if (this.paymentFrequency != null && !this.paymentFrequency.prune().hasData()) {
                this.paymentFrequency = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getFirstPaymentDate() != null) {
                return true;
            }
            if (this.getLastRegularPaymentDate() != null) {
                return true;
            }
            if (this.getPayRelativeTo() != null) {
                return true;
            }
            if (this.getPaymentDateSchedule() != null && this.getPaymentDateSchedule().hasData()) {
                return true;
            }
            if (this.getPaymentDatesAdjustments() != null && this.getPaymentDatesAdjustments().hasData()) {
                return true;
            }
            if (this.getPaymentDaysOffset() != null && this.getPaymentDaysOffset().hasData()) {
                return true;
            }
            return this.getPaymentFrequency() != null && this.getPaymentFrequency().hasData();
        }

        public PaymentDatesBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PaymentDatesBuilder o = (PaymentDatesBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentDateSchedule(), (RosettaModelObjectBuilder)o.getPaymentDateSchedule(), this::setPaymentDateSchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentDatesAdjustments(), (RosettaModelObjectBuilder)o.getPaymentDatesAdjustments(), this::setPaymentDatesAdjustments);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentDaysOffset(), (RosettaModelObjectBuilder)o.getPaymentDaysOffset(), this::setPaymentDaysOffset);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentFrequency(), (RosettaModelObjectBuilder)o.getPaymentFrequency(), this::setPaymentFrequency);
            merger.mergeBasic((Object)this.getFirstPaymentDate(), (Object)o.getFirstPaymentDate(), this::setFirstPaymentDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLastRegularPaymentDate(), (Object)o.getLastRegularPaymentDate(), this::setLastRegularPaymentDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPayRelativeTo(), (Object)o.getPayRelativeTo(), this::setPayRelativeTo, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PaymentDates _that = this.getType().cast(o);
            if (!Objects.equals(this.firstPaymentDate, _that.getFirstPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.lastRegularPaymentDate, _that.getLastRegularPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals((Object)this.payRelativeTo, (Object)_that.getPayRelativeTo())) {
                return false;
            }
            if (!Objects.equals(this.paymentDateSchedule, _that.getPaymentDateSchedule())) {
                return false;
            }
            if (!Objects.equals(this.paymentDatesAdjustments, _that.getPaymentDatesAdjustments())) {
                return false;
            }
            if (!Objects.equals(this.paymentDaysOffset, _that.getPaymentDaysOffset())) {
                return false;
            }
            return Objects.equals(this.paymentFrequency, _that.getPaymentFrequency());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.firstPaymentDate != null ? this.firstPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.lastRegularPaymentDate != null ? this.lastRegularPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.payRelativeTo != null ? ((Object)((Object)this.payRelativeTo)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.paymentDateSchedule != null ? this.paymentDateSchedule.hashCode() : 0);
            _result = 31 * _result + (this.paymentDatesAdjustments != null ? this.paymentDatesAdjustments.hashCode() : 0);
            _result = 31 * _result + (this.paymentDaysOffset != null ? this.paymentDaysOffset.hashCode() : 0);
            _result = 31 * _result + (this.paymentFrequency != null ? this.paymentFrequency.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PaymentDatesBuilder {firstPaymentDate=" + this.firstPaymentDate + ", lastRegularPaymentDate=" + this.lastRegularPaymentDate + ", meta=" + this.meta + ", payRelativeTo=" + (Object)((Object)this.payRelativeTo) + ", paymentDateSchedule=" + this.paymentDateSchedule + ", paymentDatesAdjustments=" + this.paymentDatesAdjustments + ", paymentDaysOffset=" + this.paymentDaysOffset + ", paymentFrequency=" + this.paymentFrequency + '}';
        }
    }

    public static class PaymentDatesImpl
    implements PaymentDates {
        private final Date firstPaymentDate;
        private final Date lastRegularPaymentDate;
        private final MetaFields meta;
        private final PayRelativeToEnum payRelativeTo;
        private final PaymentDateSchedule paymentDateSchedule;
        private final BusinessDayAdjustments paymentDatesAdjustments;
        private final Offset paymentDaysOffset;
        private final Frequency paymentFrequency;

        protected PaymentDatesImpl(PaymentDatesBuilder builder) {
            this.firstPaymentDate = builder.getFirstPaymentDate();
            this.lastRegularPaymentDate = builder.getLastRegularPaymentDate();
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
            this.payRelativeTo = builder.getPayRelativeTo();
            this.paymentDateSchedule = Optional.ofNullable(builder.getPaymentDateSchedule()).map(f -> f.build()).orElse(null);
            this.paymentDatesAdjustments = Optional.ofNullable(builder.getPaymentDatesAdjustments()).map(f -> f.build()).orElse(null);
            this.paymentDaysOffset = Optional.ofNullable(builder.getPaymentDaysOffset()).map(f -> f.build()).orElse(null);
            this.paymentFrequency = Optional.ofNullable(builder.getPaymentFrequency()).map(f -> f.build()).orElse(null);
        }

        @Override
        public Date getFirstPaymentDate() {
            return this.firstPaymentDate;
        }

        @Override
        public Date getLastRegularPaymentDate() {
            return this.lastRegularPaymentDate;
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public PayRelativeToEnum getPayRelativeTo() {
            return this.payRelativeTo;
        }

        @Override
        public PaymentDateSchedule getPaymentDateSchedule() {
            return this.paymentDateSchedule;
        }

        @Override
        public BusinessDayAdjustments getPaymentDatesAdjustments() {
            return this.paymentDatesAdjustments;
        }

        @Override
        public Offset getPaymentDaysOffset() {
            return this.paymentDaysOffset;
        }

        @Override
        public Frequency getPaymentFrequency() {
            return this.paymentFrequency;
        }

        @Override
        public PaymentDates build() {
            return this;
        }

        @Override
        public PaymentDatesBuilder toBuilder() {
            PaymentDatesBuilder builder = PaymentDates.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PaymentDatesBuilder builder) {
            Optional.ofNullable(this.getFirstPaymentDate()).ifPresent(builder::setFirstPaymentDate);
            Optional.ofNullable(this.getLastRegularPaymentDate()).ifPresent(builder::setLastRegularPaymentDate);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
            Optional.ofNullable(this.getPayRelativeTo()).ifPresent(builder::setPayRelativeTo);
            Optional.ofNullable(this.getPaymentDateSchedule()).ifPresent(builder::setPaymentDateSchedule);
            Optional.ofNullable(this.getPaymentDatesAdjustments()).ifPresent(builder::setPaymentDatesAdjustments);
            Optional.ofNullable(this.getPaymentDaysOffset()).ifPresent(builder::setPaymentDaysOffset);
            Optional.ofNullable(this.getPaymentFrequency()).ifPresent(builder::setPaymentFrequency);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PaymentDates _that = this.getType().cast(o);
            if (!Objects.equals(this.firstPaymentDate, _that.getFirstPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.lastRegularPaymentDate, _that.getLastRegularPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals((Object)this.payRelativeTo, (Object)_that.getPayRelativeTo())) {
                return false;
            }
            if (!Objects.equals(this.paymentDateSchedule, _that.getPaymentDateSchedule())) {
                return false;
            }
            if (!Objects.equals(this.paymentDatesAdjustments, _that.getPaymentDatesAdjustments())) {
                return false;
            }
            if (!Objects.equals(this.paymentDaysOffset, _that.getPaymentDaysOffset())) {
                return false;
            }
            return Objects.equals(this.paymentFrequency, _that.getPaymentFrequency());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.firstPaymentDate != null ? this.firstPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.lastRegularPaymentDate != null ? this.lastRegularPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.payRelativeTo != null ? ((Object)((Object)this.payRelativeTo)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.paymentDateSchedule != null ? this.paymentDateSchedule.hashCode() : 0);
            _result = 31 * _result + (this.paymentDatesAdjustments != null ? this.paymentDatesAdjustments.hashCode() : 0);
            _result = 31 * _result + (this.paymentDaysOffset != null ? this.paymentDaysOffset.hashCode() : 0);
            _result = 31 * _result + (this.paymentFrequency != null ? this.paymentFrequency.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PaymentDates {firstPaymentDate=" + this.firstPaymentDate + ", lastRegularPaymentDate=" + this.lastRegularPaymentDate + ", meta=" + this.meta + ", payRelativeTo=" + (Object)((Object)this.payRelativeTo) + ", paymentDateSchedule=" + this.paymentDateSchedule + ", paymentDatesAdjustments=" + this.paymentDatesAdjustments + ", paymentDaysOffset=" + this.paymentDaysOffset + ", paymentFrequency=" + this.paymentFrequency + '}';
        }
    }

    public static interface PaymentDatesBuilder
    extends PaymentDates,
    RosettaModelObjectBuilder {
        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public PaymentDateSchedule.PaymentDateScheduleBuilder getOrCreatePaymentDateSchedule();

        @Override
        public PaymentDateSchedule.PaymentDateScheduleBuilder getPaymentDateSchedule();

        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getOrCreatePaymentDatesAdjustments();

        @Override
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getPaymentDatesAdjustments();

        public Offset.OffsetBuilder getOrCreatePaymentDaysOffset();

        @Override
        public Offset.OffsetBuilder getPaymentDaysOffset();

        public Frequency.FrequencyBuilder getOrCreatePaymentFrequency();

        @Override
        public Frequency.FrequencyBuilder getPaymentFrequency();

        public PaymentDatesBuilder setFirstPaymentDate(Date var1);

        public PaymentDatesBuilder setLastRegularPaymentDate(Date var1);

        public PaymentDatesBuilder setMeta(MetaFields var1);

        public PaymentDatesBuilder setPayRelativeTo(PayRelativeToEnum var1);

        public PaymentDatesBuilder setPaymentDateSchedule(PaymentDateSchedule var1);

        public PaymentDatesBuilder setPaymentDatesAdjustments(BusinessDayAdjustments var1);

        public PaymentDatesBuilder setPaymentDaysOffset(Offset var1);

        public PaymentDatesBuilder setPaymentFrequency(Frequency var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("firstPaymentDate"), Date.class, (Object)this.getFirstPaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("lastRegularPaymentDate"), Date.class, (Object)this.getLastRegularPaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("payRelativeTo"), PayRelativeToEnum.class, (Object)this.getPayRelativeTo(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDateSchedule"), processor, PaymentDateSchedule.PaymentDateScheduleBuilder.class, this.getPaymentDateSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDatesAdjustments"), processor, BusinessDayAdjustments.BusinessDayAdjustmentsBuilder.class, this.getPaymentDatesAdjustments(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDaysOffset"), processor, Offset.OffsetBuilder.class, this.getPaymentDaysOffset(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentFrequency"), processor, Frequency.FrequencyBuilder.class, this.getPaymentFrequency(), new AttributeMeta[0]);
        }

        public PaymentDatesBuilder prune();
    }
}

