/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.schedule;

import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.base.datetime.AdjustableRelativeOrPeriodicDates;
import cdm.product.common.schedule.meta.PaymentDateScheduleMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface PaymentDateSchedule
extends RosettaModelObject {
    public static final PaymentDateScheduleMeta metaData = new PaymentDateScheduleMeta();

    public PaymentDateSchedule build();

    public PaymentDateScheduleBuilder toBuilder();

    public AdjustableOrRelativeDate getFinalPaymentDate();

    public List<? extends AdjustableRelativeOrPeriodicDates> getInterimPaymentDates();

    default public RosettaMetaData<? extends PaymentDateSchedule> metaData() {
        return metaData;
    }

    public static PaymentDateScheduleBuilder builder() {
        return new PaymentDateScheduleBuilderImpl();
    }

    default public Class<? extends PaymentDateSchedule> getType() {
        return PaymentDateSchedule.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("finalPaymentDate"), processor, AdjustableOrRelativeDate.class, this.getFinalPaymentDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("interimPaymentDates"), processor, AdjustableRelativeOrPeriodicDates.class, this.getInterimPaymentDates(), new AttributeMeta[0]);
    }

    public static class PaymentDateScheduleBuilderImpl
    implements PaymentDateScheduleBuilder {
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder finalPaymentDate;
        protected List<AdjustableRelativeOrPeriodicDates.AdjustableRelativeOrPeriodicDatesBuilder> interimPaymentDates = new ArrayList<AdjustableRelativeOrPeriodicDates.AdjustableRelativeOrPeriodicDatesBuilder>();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getFinalPaymentDate() {
            return this.finalPaymentDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateFinalPaymentDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.finalPaymentDate != null ? this.finalPaymentDate : (this.finalPaymentDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        public List<? extends AdjustableRelativeOrPeriodicDates.AdjustableRelativeOrPeriodicDatesBuilder> getInterimPaymentDates() {
            return this.interimPaymentDates;
        }

        @Override
        public AdjustableRelativeOrPeriodicDates.AdjustableRelativeOrPeriodicDatesBuilder getOrCreateInterimPaymentDates(int _index) {
            if (this.interimPaymentDates == null) {
                this.interimPaymentDates = new ArrayList<AdjustableRelativeOrPeriodicDates.AdjustableRelativeOrPeriodicDatesBuilder>();
            }
            return (AdjustableRelativeOrPeriodicDates.AdjustableRelativeOrPeriodicDatesBuilder)this.getIndex(this.interimPaymentDates, _index, () -> {
                AdjustableRelativeOrPeriodicDates.AdjustableRelativeOrPeriodicDatesBuilder newInterimPaymentDates = AdjustableRelativeOrPeriodicDates.builder();
                return newInterimPaymentDates;
            });
        }

        @Override
        public PaymentDateScheduleBuilder setFinalPaymentDate(AdjustableOrRelativeDate finalPaymentDate) {
            this.finalPaymentDate = finalPaymentDate == null ? null : finalPaymentDate.toBuilder();
            return this;
        }

        @Override
        public PaymentDateScheduleBuilder addInterimPaymentDates(AdjustableRelativeOrPeriodicDates interimPaymentDates) {
            if (interimPaymentDates != null) {
                this.interimPaymentDates.add(interimPaymentDates.toBuilder());
            }
            return this;
        }

        @Override
        public PaymentDateScheduleBuilder addInterimPaymentDates(AdjustableRelativeOrPeriodicDates interimPaymentDates, int _idx) {
            this.getIndex(this.interimPaymentDates, _idx, () -> interimPaymentDates.toBuilder());
            return this;
        }

        @Override
        public PaymentDateScheduleBuilder addInterimPaymentDates(List<? extends AdjustableRelativeOrPeriodicDates> interimPaymentDatess) {
            if (interimPaymentDatess != null) {
                for (AdjustableRelativeOrPeriodicDates adjustableRelativeOrPeriodicDates : interimPaymentDatess) {
                    this.interimPaymentDates.add(adjustableRelativeOrPeriodicDates.toBuilder());
                }
            }
            return this;
        }

        @Override
        public PaymentDateScheduleBuilder setInterimPaymentDates(List<? extends AdjustableRelativeOrPeriodicDates> interimPaymentDatess) {
            this.interimPaymentDates = interimPaymentDatess == null ? new ArrayList<AdjustableRelativeOrPeriodicDates.AdjustableRelativeOrPeriodicDatesBuilder>() : (List)interimPaymentDatess.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PaymentDateSchedule build() {
            return new PaymentDateScheduleImpl(this);
        }

        @Override
        public PaymentDateScheduleBuilder toBuilder() {
            return this;
        }

        @Override
        public PaymentDateScheduleBuilder prune() {
            if (this.finalPaymentDate != null && !this.finalPaymentDate.prune().hasData()) {
                this.finalPaymentDate = null;
            }
            this.interimPaymentDates = this.interimPaymentDates.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getFinalPaymentDate() != null && this.getFinalPaymentDate().hasData()) {
                return true;
            }
            return this.getInterimPaymentDates() != null && this.getInterimPaymentDates().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public PaymentDateScheduleBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PaymentDateScheduleBuilder o = (PaymentDateScheduleBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFinalPaymentDate(), (RosettaModelObjectBuilder)o.getFinalPaymentDate(), this::setFinalPaymentDate);
            merger.mergeRosetta(this.getInterimPaymentDates(), o.getInterimPaymentDates(), this::getOrCreateInterimPaymentDates);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PaymentDateSchedule _that = this.getType().cast(o);
            if (!Objects.equals(this.finalPaymentDate, _that.getFinalPaymentDate())) {
                return false;
            }
            return ListEquals.listEquals(this.interimPaymentDates, _that.getInterimPaymentDates());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.finalPaymentDate != null ? this.finalPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.interimPaymentDates != null ? this.interimPaymentDates.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PaymentDateScheduleBuilder {finalPaymentDate=" + this.finalPaymentDate + ", interimPaymentDates=" + this.interimPaymentDates + '}';
        }
    }

    public static class PaymentDateScheduleImpl
    implements PaymentDateSchedule {
        private final AdjustableOrRelativeDate finalPaymentDate;
        private final List<? extends AdjustableRelativeOrPeriodicDates> interimPaymentDates;

        protected PaymentDateScheduleImpl(PaymentDateScheduleBuilder builder) {
            this.finalPaymentDate = Optional.ofNullable(builder.getFinalPaymentDate()).map(f -> f.build()).orElse(null);
            this.interimPaymentDates = Optional.ofNullable(builder.getInterimPaymentDates()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        public AdjustableOrRelativeDate getFinalPaymentDate() {
            return this.finalPaymentDate;
        }

        @Override
        public List<? extends AdjustableRelativeOrPeriodicDates> getInterimPaymentDates() {
            return this.interimPaymentDates;
        }

        @Override
        public PaymentDateSchedule build() {
            return this;
        }

        @Override
        public PaymentDateScheduleBuilder toBuilder() {
            PaymentDateScheduleBuilder builder = PaymentDateSchedule.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PaymentDateScheduleBuilder builder) {
            Optional.ofNullable(this.getFinalPaymentDate()).ifPresent(builder::setFinalPaymentDate);
            Optional.ofNullable(this.getInterimPaymentDates()).ifPresent(builder::setInterimPaymentDates);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PaymentDateSchedule _that = this.getType().cast(o);
            if (!Objects.equals(this.finalPaymentDate, _that.getFinalPaymentDate())) {
                return false;
            }
            return ListEquals.listEquals(this.interimPaymentDates, _that.getInterimPaymentDates());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.finalPaymentDate != null ? this.finalPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.interimPaymentDates != null ? this.interimPaymentDates.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PaymentDateSchedule {finalPaymentDate=" + this.finalPaymentDate + ", interimPaymentDates=" + this.interimPaymentDates + '}';
        }
    }

    public static interface PaymentDateScheduleBuilder
    extends PaymentDateSchedule,
    RosettaModelObjectBuilder {
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateFinalPaymentDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getFinalPaymentDate();

        public AdjustableRelativeOrPeriodicDates.AdjustableRelativeOrPeriodicDatesBuilder getOrCreateInterimPaymentDates(int var1);

        public List<? extends AdjustableRelativeOrPeriodicDates.AdjustableRelativeOrPeriodicDatesBuilder> getInterimPaymentDates();

        public PaymentDateScheduleBuilder setFinalPaymentDate(AdjustableOrRelativeDate var1);

        public PaymentDateScheduleBuilder addInterimPaymentDates(AdjustableRelativeOrPeriodicDates var1);

        public PaymentDateScheduleBuilder addInterimPaymentDates(AdjustableRelativeOrPeriodicDates var1, int var2);

        public PaymentDateScheduleBuilder addInterimPaymentDates(List<? extends AdjustableRelativeOrPeriodicDates> var1);

        public PaymentDateScheduleBuilder setInterimPaymentDates(List<? extends AdjustableRelativeOrPeriodicDates> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("finalPaymentDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getFinalPaymentDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("interimPaymentDates"), processor, AdjustableRelativeOrPeriodicDates.AdjustableRelativeOrPeriodicDatesBuilder.class, this.getInterimPaymentDates(), new AttributeMeta[0]);
        }

        public PaymentDateScheduleBuilder prune();
    }
}

