/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.schedule;

import cdm.observable.asset.Money;
import cdm.product.common.schedule.CalculationPeriod;
import cdm.product.common.schedule.meta.PaymentCalculationPeriodMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface PaymentCalculationPeriod
extends RosettaModelObject,
GlobalKey {
    public static final PaymentCalculationPeriodMeta metaData = new PaymentCalculationPeriodMeta();

    public PaymentCalculationPeriod build();

    public PaymentCalculationPeriodBuilder toBuilder();

    public Date getAdjustedPaymentDate();

    public List<? extends CalculationPeriod> getCalculationPeriod();

    public BigDecimal getDiscountFactor();

    public Money getFixedPaymentAmount();

    public Money getForecastPaymentAmount();

    public MetaFields getMeta();

    public Money getPresentValueAmount();

    public Date getUnadjustedPaymentDate();

    default public RosettaMetaData<? extends PaymentCalculationPeriod> metaData() {
        return metaData;
    }

    public static PaymentCalculationPeriodBuilder builder() {
        return new PaymentCalculationPeriodBuilderImpl();
    }

    default public Class<? extends PaymentCalculationPeriod> getType() {
        return PaymentCalculationPeriod.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("adjustedPaymentDate"), Date.class, (Object)this.getAdjustedPaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("discountFactor"), BigDecimal.class, (Object)this.getDiscountFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("unadjustedPaymentDate"), Date.class, (Object)this.getUnadjustedPaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("calculationPeriod"), processor, CalculationPeriod.class, this.getCalculationPeriod(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixedPaymentAmount"), processor, Money.class, this.getFixedPaymentAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("forecastPaymentAmount"), processor, Money.class, this.getForecastPaymentAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("presentValueAmount"), processor, Money.class, this.getPresentValueAmount(), new AttributeMeta[0]);
    }

    public static class PaymentCalculationPeriodBuilderImpl
    implements PaymentCalculationPeriodBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected Date adjustedPaymentDate;
        protected List<CalculationPeriod.CalculationPeriodBuilder> calculationPeriod = new ArrayList<CalculationPeriod.CalculationPeriodBuilder>();
        protected BigDecimal discountFactor;
        protected Money.MoneyBuilder fixedPaymentAmount;
        protected Money.MoneyBuilder forecastPaymentAmount;
        protected MetaFields.MetaFieldsBuilder meta;
        protected Money.MoneyBuilder presentValueAmount;
        protected Date unadjustedPaymentDate;

        @Override
        public Date getAdjustedPaymentDate() {
            return this.adjustedPaymentDate;
        }

        @Override
        public List<? extends CalculationPeriod.CalculationPeriodBuilder> getCalculationPeriod() {
            return this.calculationPeriod;
        }

        @Override
        public CalculationPeriod.CalculationPeriodBuilder getOrCreateCalculationPeriod(int _index) {
            if (this.calculationPeriod == null) {
                this.calculationPeriod = new ArrayList<CalculationPeriod.CalculationPeriodBuilder>();
            }
            return (CalculationPeriod.CalculationPeriodBuilder)this.getIndex(this.calculationPeriod, _index, () -> {
                CalculationPeriod.CalculationPeriodBuilder newCalculationPeriod = CalculationPeriod.builder();
                return newCalculationPeriod;
            });
        }

        @Override
        public BigDecimal getDiscountFactor() {
            return this.discountFactor;
        }

        @Override
        public Money.MoneyBuilder getFixedPaymentAmount() {
            return this.fixedPaymentAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateFixedPaymentAmount() {
            Money.MoneyBuilder result = this.fixedPaymentAmount != null ? this.fixedPaymentAmount : (this.fixedPaymentAmount = Money.builder());
            return result;
        }

        @Override
        public Money.MoneyBuilder getForecastPaymentAmount() {
            return this.forecastPaymentAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateForecastPaymentAmount() {
            Money.MoneyBuilder result = this.forecastPaymentAmount != null ? this.forecastPaymentAmount : (this.forecastPaymentAmount = Money.builder());
            return result;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public Money.MoneyBuilder getPresentValueAmount() {
            return this.presentValueAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreatePresentValueAmount() {
            Money.MoneyBuilder result = this.presentValueAmount != null ? this.presentValueAmount : (this.presentValueAmount = Money.builder());
            return result;
        }

        @Override
        public Date getUnadjustedPaymentDate() {
            return this.unadjustedPaymentDate;
        }

        @Override
        public PaymentCalculationPeriodBuilder setAdjustedPaymentDate(Date adjustedPaymentDate) {
            this.adjustedPaymentDate = adjustedPaymentDate == null ? null : adjustedPaymentDate;
            return this;
        }

        @Override
        public PaymentCalculationPeriodBuilder addCalculationPeriod(CalculationPeriod calculationPeriod) {
            if (calculationPeriod != null) {
                this.calculationPeriod.add(calculationPeriod.toBuilder());
            }
            return this;
        }

        @Override
        public PaymentCalculationPeriodBuilder addCalculationPeriod(CalculationPeriod calculationPeriod, int _idx) {
            this.getIndex(this.calculationPeriod, _idx, () -> calculationPeriod.toBuilder());
            return this;
        }

        @Override
        public PaymentCalculationPeriodBuilder addCalculationPeriod(List<? extends CalculationPeriod> calculationPeriods) {
            if (calculationPeriods != null) {
                for (CalculationPeriod calculationPeriod : calculationPeriods) {
                    this.calculationPeriod.add(calculationPeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        public PaymentCalculationPeriodBuilder setCalculationPeriod(List<? extends CalculationPeriod> calculationPeriods) {
            this.calculationPeriod = calculationPeriods == null ? new ArrayList<CalculationPeriod.CalculationPeriodBuilder>() : (List)calculationPeriods.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PaymentCalculationPeriodBuilder setDiscountFactor(BigDecimal discountFactor) {
            this.discountFactor = discountFactor == null ? null : discountFactor;
            return this;
        }

        @Override
        public PaymentCalculationPeriodBuilder setFixedPaymentAmount(Money fixedPaymentAmount) {
            this.fixedPaymentAmount = fixedPaymentAmount == null ? null : fixedPaymentAmount.toBuilder();
            return this;
        }

        @Override
        public PaymentCalculationPeriodBuilder setForecastPaymentAmount(Money forecastPaymentAmount) {
            this.forecastPaymentAmount = forecastPaymentAmount == null ? null : forecastPaymentAmount.toBuilder();
            return this;
        }

        @Override
        public PaymentCalculationPeriodBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public PaymentCalculationPeriodBuilder setPresentValueAmount(Money presentValueAmount) {
            this.presentValueAmount = presentValueAmount == null ? null : presentValueAmount.toBuilder();
            return this;
        }

        @Override
        public PaymentCalculationPeriodBuilder setUnadjustedPaymentDate(Date unadjustedPaymentDate) {
            this.unadjustedPaymentDate = unadjustedPaymentDate == null ? null : unadjustedPaymentDate;
            return this;
        }

        @Override
        public PaymentCalculationPeriod build() {
            return new PaymentCalculationPeriodImpl(this);
        }

        @Override
        public PaymentCalculationPeriodBuilder toBuilder() {
            return this;
        }

        @Override
        public PaymentCalculationPeriodBuilder prune() {
            this.calculationPeriod = this.calculationPeriod.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.fixedPaymentAmount != null && !this.fixedPaymentAmount.prune().hasData()) {
                this.fixedPaymentAmount = null;
            }
            if (this.forecastPaymentAmount != null && !this.forecastPaymentAmount.prune().hasData()) {
                this.forecastPaymentAmount = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            if (this.presentValueAmount != null && !this.presentValueAmount.prune().hasData()) {
                this.presentValueAmount = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAdjustedPaymentDate() != null) {
                return true;
            }
            if (this.getCalculationPeriod() != null && this.getCalculationPeriod().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getDiscountFactor() != null) {
                return true;
            }
            if (this.getFixedPaymentAmount() != null && this.getFixedPaymentAmount().hasData()) {
                return true;
            }
            if (this.getForecastPaymentAmount() != null && this.getForecastPaymentAmount().hasData()) {
                return true;
            }
            if (this.getPresentValueAmount() != null && this.getPresentValueAmount().hasData()) {
                return true;
            }
            return this.getUnadjustedPaymentDate() != null;
        }

        public PaymentCalculationPeriodBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PaymentCalculationPeriodBuilder o = (PaymentCalculationPeriodBuilder)other;
            merger.mergeRosetta(this.getCalculationPeriod(), o.getCalculationPeriod(), this::getOrCreateCalculationPeriod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixedPaymentAmount(), (RosettaModelObjectBuilder)o.getFixedPaymentAmount(), this::setFixedPaymentAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getForecastPaymentAmount(), (RosettaModelObjectBuilder)o.getForecastPaymentAmount(), this::setForecastPaymentAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPresentValueAmount(), (RosettaModelObjectBuilder)o.getPresentValueAmount(), this::setPresentValueAmount);
            merger.mergeBasic((Object)this.getAdjustedPaymentDate(), (Object)o.getAdjustedPaymentDate(), this::setAdjustedPaymentDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDiscountFactor(), (Object)o.getDiscountFactor(), this::setDiscountFactor, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnadjustedPaymentDate(), (Object)o.getUnadjustedPaymentDate(), this::setUnadjustedPaymentDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PaymentCalculationPeriod _that = this.getType().cast(o);
            if (!Objects.equals(this.adjustedPaymentDate, _that.getAdjustedPaymentDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.calculationPeriod, _that.getCalculationPeriod())) {
                return false;
            }
            if (!Objects.equals(this.discountFactor, _that.getDiscountFactor())) {
                return false;
            }
            if (!Objects.equals(this.fixedPaymentAmount, _that.getFixedPaymentAmount())) {
                return false;
            }
            if (!Objects.equals(this.forecastPaymentAmount, _that.getForecastPaymentAmount())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.presentValueAmount, _that.getPresentValueAmount())) {
                return false;
            }
            return Objects.equals(this.unadjustedPaymentDate, _that.getUnadjustedPaymentDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.adjustedPaymentDate != null ? this.adjustedPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.calculationPeriod != null ? this.calculationPeriod.hashCode() : 0);
            _result = 31 * _result + (this.discountFactor != null ? this.discountFactor.hashCode() : 0);
            _result = 31 * _result + (this.fixedPaymentAmount != null ? this.fixedPaymentAmount.hashCode() : 0);
            _result = 31 * _result + (this.forecastPaymentAmount != null ? this.forecastPaymentAmount.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.presentValueAmount != null ? this.presentValueAmount.hashCode() : 0);
            _result = 31 * _result + (this.unadjustedPaymentDate != null ? this.unadjustedPaymentDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PaymentCalculationPeriodBuilder {adjustedPaymentDate=" + this.adjustedPaymentDate + ", calculationPeriod=" + this.calculationPeriod + ", discountFactor=" + this.discountFactor + ", fixedPaymentAmount=" + this.fixedPaymentAmount + ", forecastPaymentAmount=" + this.forecastPaymentAmount + ", meta=" + this.meta + ", presentValueAmount=" + this.presentValueAmount + ", unadjustedPaymentDate=" + this.unadjustedPaymentDate + '}';
        }
    }

    public static class PaymentCalculationPeriodImpl
    implements PaymentCalculationPeriod {
        private final Date adjustedPaymentDate;
        private final List<? extends CalculationPeriod> calculationPeriod;
        private final BigDecimal discountFactor;
        private final Money fixedPaymentAmount;
        private final Money forecastPaymentAmount;
        private final MetaFields meta;
        private final Money presentValueAmount;
        private final Date unadjustedPaymentDate;

        protected PaymentCalculationPeriodImpl(PaymentCalculationPeriodBuilder builder) {
            this.adjustedPaymentDate = builder.getAdjustedPaymentDate();
            this.calculationPeriod = Optional.ofNullable(builder.getCalculationPeriod()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.discountFactor = builder.getDiscountFactor();
            this.fixedPaymentAmount = Optional.ofNullable(builder.getFixedPaymentAmount()).map(f -> f.build()).orElse(null);
            this.forecastPaymentAmount = Optional.ofNullable(builder.getForecastPaymentAmount()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
            this.presentValueAmount = Optional.ofNullable(builder.getPresentValueAmount()).map(f -> f.build()).orElse(null);
            this.unadjustedPaymentDate = builder.getUnadjustedPaymentDate();
        }

        @Override
        public Date getAdjustedPaymentDate() {
            return this.adjustedPaymentDate;
        }

        @Override
        public List<? extends CalculationPeriod> getCalculationPeriod() {
            return this.calculationPeriod;
        }

        @Override
        public BigDecimal getDiscountFactor() {
            return this.discountFactor;
        }

        @Override
        public Money getFixedPaymentAmount() {
            return this.fixedPaymentAmount;
        }

        @Override
        public Money getForecastPaymentAmount() {
            return this.forecastPaymentAmount;
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public Money getPresentValueAmount() {
            return this.presentValueAmount;
        }

        @Override
        public Date getUnadjustedPaymentDate() {
            return this.unadjustedPaymentDate;
        }

        @Override
        public PaymentCalculationPeriod build() {
            return this;
        }

        @Override
        public PaymentCalculationPeriodBuilder toBuilder() {
            PaymentCalculationPeriodBuilder builder = PaymentCalculationPeriod.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PaymentCalculationPeriodBuilder builder) {
            Optional.ofNullable(this.getAdjustedPaymentDate()).ifPresent(builder::setAdjustedPaymentDate);
            Optional.ofNullable(this.getCalculationPeriod()).ifPresent(builder::setCalculationPeriod);
            Optional.ofNullable(this.getDiscountFactor()).ifPresent(builder::setDiscountFactor);
            Optional.ofNullable(this.getFixedPaymentAmount()).ifPresent(builder::setFixedPaymentAmount);
            Optional.ofNullable(this.getForecastPaymentAmount()).ifPresent(builder::setForecastPaymentAmount);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
            Optional.ofNullable(this.getPresentValueAmount()).ifPresent(builder::setPresentValueAmount);
            Optional.ofNullable(this.getUnadjustedPaymentDate()).ifPresent(builder::setUnadjustedPaymentDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PaymentCalculationPeriod _that = this.getType().cast(o);
            if (!Objects.equals(this.adjustedPaymentDate, _that.getAdjustedPaymentDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.calculationPeriod, _that.getCalculationPeriod())) {
                return false;
            }
            if (!Objects.equals(this.discountFactor, _that.getDiscountFactor())) {
                return false;
            }
            if (!Objects.equals(this.fixedPaymentAmount, _that.getFixedPaymentAmount())) {
                return false;
            }
            if (!Objects.equals(this.forecastPaymentAmount, _that.getForecastPaymentAmount())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.presentValueAmount, _that.getPresentValueAmount())) {
                return false;
            }
            return Objects.equals(this.unadjustedPaymentDate, _that.getUnadjustedPaymentDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.adjustedPaymentDate != null ? this.adjustedPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.calculationPeriod != null ? this.calculationPeriod.hashCode() : 0);
            _result = 31 * _result + (this.discountFactor != null ? this.discountFactor.hashCode() : 0);
            _result = 31 * _result + (this.fixedPaymentAmount != null ? this.fixedPaymentAmount.hashCode() : 0);
            _result = 31 * _result + (this.forecastPaymentAmount != null ? this.forecastPaymentAmount.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.presentValueAmount != null ? this.presentValueAmount.hashCode() : 0);
            _result = 31 * _result + (this.unadjustedPaymentDate != null ? this.unadjustedPaymentDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PaymentCalculationPeriod {adjustedPaymentDate=" + this.adjustedPaymentDate + ", calculationPeriod=" + this.calculationPeriod + ", discountFactor=" + this.discountFactor + ", fixedPaymentAmount=" + this.fixedPaymentAmount + ", forecastPaymentAmount=" + this.forecastPaymentAmount + ", meta=" + this.meta + ", presentValueAmount=" + this.presentValueAmount + ", unadjustedPaymentDate=" + this.unadjustedPaymentDate + '}';
        }
    }

    public static interface PaymentCalculationPeriodBuilder
    extends PaymentCalculationPeriod,
    RosettaModelObjectBuilder {
        public CalculationPeriod.CalculationPeriodBuilder getOrCreateCalculationPeriod(int var1);

        public List<? extends CalculationPeriod.CalculationPeriodBuilder> getCalculationPeriod();

        public Money.MoneyBuilder getOrCreateFixedPaymentAmount();

        @Override
        public Money.MoneyBuilder getFixedPaymentAmount();

        public Money.MoneyBuilder getOrCreateForecastPaymentAmount();

        @Override
        public Money.MoneyBuilder getForecastPaymentAmount();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public Money.MoneyBuilder getOrCreatePresentValueAmount();

        @Override
        public Money.MoneyBuilder getPresentValueAmount();

        public PaymentCalculationPeriodBuilder setAdjustedPaymentDate(Date var1);

        public PaymentCalculationPeriodBuilder addCalculationPeriod(CalculationPeriod var1);

        public PaymentCalculationPeriodBuilder addCalculationPeriod(CalculationPeriod var1, int var2);

        public PaymentCalculationPeriodBuilder addCalculationPeriod(List<? extends CalculationPeriod> var1);

        public PaymentCalculationPeriodBuilder setCalculationPeriod(List<? extends CalculationPeriod> var1);

        public PaymentCalculationPeriodBuilder setDiscountFactor(BigDecimal var1);

        public PaymentCalculationPeriodBuilder setFixedPaymentAmount(Money var1);

        public PaymentCalculationPeriodBuilder setForecastPaymentAmount(Money var1);

        public PaymentCalculationPeriodBuilder setMeta(MetaFields var1);

        public PaymentCalculationPeriodBuilder setPresentValueAmount(Money var1);

        public PaymentCalculationPeriodBuilder setUnadjustedPaymentDate(Date var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("adjustedPaymentDate"), Date.class, (Object)this.getAdjustedPaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("discountFactor"), BigDecimal.class, (Object)this.getDiscountFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("unadjustedPaymentDate"), Date.class, (Object)this.getUnadjustedPaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("calculationPeriod"), processor, CalculationPeriod.CalculationPeriodBuilder.class, this.getCalculationPeriod(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixedPaymentAmount"), processor, Money.MoneyBuilder.class, this.getFixedPaymentAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("forecastPaymentAmount"), processor, Money.MoneyBuilder.class, this.getForecastPaymentAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("presentValueAmount"), processor, Money.MoneyBuilder.class, this.getPresentValueAmount(), new AttributeMeta[0]);
        }

        public PaymentCalculationPeriodBuilder prune();
    }
}

