/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.schedule;

import cdm.base.datetime.BusinessCenters;
import cdm.base.datetime.DayOfWeekEnum;
import cdm.base.datetime.DayTypeEnum;
import cdm.product.asset.DayDistributionEnum;
import cdm.product.common.schedule.Lag;
import cdm.product.common.schedule.meta.ParametricDatesMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface ParametricDates
extends RosettaModelObject {
    public static final ParametricDatesMeta metaData = new ParametricDatesMeta();

    public ParametricDates build();

    public ParametricDatesBuilder toBuilder();

    public BusinessCenters getBusinessCenters();

    public DayDistributionEnum getDayDistribution();

    public BigDecimal getDayFrequency();

    public List<DayOfWeekEnum> getDayOfWeek();

    public DayTypeEnum getDayType();

    public Lag getLag();

    default public RosettaMetaData<? extends ParametricDates> metaData() {
        return metaData;
    }

    public static ParametricDatesBuilder builder() {
        return new ParametricDatesBuilderImpl();
    }

    default public Class<? extends ParametricDates> getType() {
        return ParametricDates.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("dayDistribution"), DayDistributionEnum.class, (Object)this.getDayDistribution(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("dayFrequency"), BigDecimal.class, (Object)this.getDayFrequency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("dayOfWeek"), DayOfWeekEnum.class, this.getDayOfWeek(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("dayType"), DayTypeEnum.class, (Object)this.getDayType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessCenters"), processor, BusinessCenters.class, this.getBusinessCenters(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lag"), processor, Lag.class, this.getLag(), new AttributeMeta[0]);
    }

    public static class ParametricDatesBuilderImpl
    implements ParametricDatesBuilder {
        protected BusinessCenters.BusinessCentersBuilder businessCenters;
        protected DayDistributionEnum dayDistribution;
        protected BigDecimal dayFrequency;
        protected List<DayOfWeekEnum> dayOfWeek = new ArrayList<DayOfWeekEnum>();
        protected DayTypeEnum dayType;
        protected Lag.LagBuilder lag;

        @Override
        public BusinessCenters.BusinessCentersBuilder getBusinessCenters() {
            return this.businessCenters;
        }

        @Override
        public BusinessCenters.BusinessCentersBuilder getOrCreateBusinessCenters() {
            BusinessCenters.BusinessCentersBuilder result = this.businessCenters != null ? this.businessCenters : (this.businessCenters = BusinessCenters.builder());
            return result;
        }

        @Override
        public DayDistributionEnum getDayDistribution() {
            return this.dayDistribution;
        }

        @Override
        public BigDecimal getDayFrequency() {
            return this.dayFrequency;
        }

        @Override
        public List<DayOfWeekEnum> getDayOfWeek() {
            return this.dayOfWeek;
        }

        @Override
        public DayTypeEnum getDayType() {
            return this.dayType;
        }

        @Override
        public Lag.LagBuilder getLag() {
            return this.lag;
        }

        @Override
        public Lag.LagBuilder getOrCreateLag() {
            Lag.LagBuilder result = this.lag != null ? this.lag : (this.lag = Lag.builder());
            return result;
        }

        @Override
        public ParametricDatesBuilder setBusinessCenters(BusinessCenters businessCenters) {
            this.businessCenters = businessCenters == null ? null : businessCenters.toBuilder();
            return this;
        }

        @Override
        public ParametricDatesBuilder setDayDistribution(DayDistributionEnum dayDistribution) {
            this.dayDistribution = dayDistribution == null ? null : dayDistribution;
            return this;
        }

        @Override
        public ParametricDatesBuilder setDayFrequency(BigDecimal dayFrequency) {
            this.dayFrequency = dayFrequency == null ? null : dayFrequency;
            return this;
        }

        @Override
        public ParametricDatesBuilder addDayOfWeek(DayOfWeekEnum dayOfWeek) {
            if (dayOfWeek != null) {
                this.dayOfWeek.add(dayOfWeek);
            }
            return this;
        }

        @Override
        public ParametricDatesBuilder addDayOfWeek(DayOfWeekEnum dayOfWeek, int _idx) {
            this.getIndex(this.dayOfWeek, _idx, () -> dayOfWeek);
            return this;
        }

        @Override
        public ParametricDatesBuilder addDayOfWeek(List<? extends DayOfWeekEnum> dayOfWeeks) {
            if (dayOfWeeks != null) {
                for (DayOfWeekEnum dayOfWeekEnum : dayOfWeeks) {
                    this.dayOfWeek.add(dayOfWeekEnum);
                }
            }
            return this;
        }

        @Override
        public ParametricDatesBuilder setDayOfWeek(List<? extends DayOfWeekEnum> dayOfWeeks) {
            this.dayOfWeek = dayOfWeeks == null ? new ArrayList<DayOfWeekEnum>() : (List)dayOfWeeks.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ParametricDatesBuilder setDayType(DayTypeEnum dayType) {
            this.dayType = dayType == null ? null : dayType;
            return this;
        }

        @Override
        public ParametricDatesBuilder setLag(Lag lag) {
            this.lag = lag == null ? null : lag.toBuilder();
            return this;
        }

        @Override
        public ParametricDates build() {
            return new ParametricDatesImpl(this);
        }

        @Override
        public ParametricDatesBuilder toBuilder() {
            return this;
        }

        @Override
        public ParametricDatesBuilder prune() {
            if (this.businessCenters != null && !this.businessCenters.prune().hasData()) {
                this.businessCenters = null;
            }
            if (this.lag != null && !this.lag.prune().hasData()) {
                this.lag = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getBusinessCenters() != null && this.getBusinessCenters().hasData()) {
                return true;
            }
            if (this.getDayDistribution() != null) {
                return true;
            }
            if (this.getDayFrequency() != null) {
                return true;
            }
            if (this.getDayOfWeek() != null && !this.getDayOfWeek().isEmpty()) {
                return true;
            }
            if (this.getDayType() != null) {
                return true;
            }
            return this.getLag() != null && this.getLag().hasData();
        }

        public ParametricDatesBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ParametricDatesBuilder o = (ParametricDatesBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBusinessCenters(), (RosettaModelObjectBuilder)o.getBusinessCenters(), this::setBusinessCenters);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLag(), (RosettaModelObjectBuilder)o.getLag(), this::setLag);
            merger.mergeBasic((Object)this.getDayDistribution(), (Object)o.getDayDistribution(), this::setDayDistribution, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDayFrequency(), (Object)o.getDayFrequency(), this::setDayFrequency, new AttributeMeta[0]);
            merger.mergeBasic(this.getDayOfWeek(), o.getDayOfWeek(), this::addDayOfWeek);
            merger.mergeBasic((Object)this.getDayType(), (Object)o.getDayType(), this::setDayType, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ParametricDates _that = this.getType().cast(o);
            if (!Objects.equals(this.businessCenters, _that.getBusinessCenters())) {
                return false;
            }
            if (!Objects.equals((Object)this.dayDistribution, (Object)_that.getDayDistribution())) {
                return false;
            }
            if (!Objects.equals(this.dayFrequency, _that.getDayFrequency())) {
                return false;
            }
            if (!ListEquals.listEquals(this.dayOfWeek, _that.getDayOfWeek())) {
                return false;
            }
            if (!Objects.equals((Object)this.dayType, (Object)_that.getDayType())) {
                return false;
            }
            return Objects.equals(this.lag, _that.getLag());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.businessCenters != null ? this.businessCenters.hashCode() : 0);
            _result = 31 * _result + (this.dayDistribution != null ? ((Object)((Object)this.dayDistribution)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.dayFrequency != null ? this.dayFrequency.hashCode() : 0);
            _result = 31 * _result + (this.dayOfWeek != null ? this.dayOfWeek.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.dayType != null ? ((Object)((Object)this.dayType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.lag != null ? this.lag.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ParametricDatesBuilder {businessCenters=" + this.businessCenters + ", dayDistribution=" + (Object)((Object)this.dayDistribution) + ", dayFrequency=" + this.dayFrequency + ", dayOfWeek=" + this.dayOfWeek + ", dayType=" + (Object)((Object)this.dayType) + ", lag=" + this.lag + '}';
        }
    }

    public static class ParametricDatesImpl
    implements ParametricDates {
        private final BusinessCenters businessCenters;
        private final DayDistributionEnum dayDistribution;
        private final BigDecimal dayFrequency;
        private final List<DayOfWeekEnum> dayOfWeek;
        private final DayTypeEnum dayType;
        private final Lag lag;

        protected ParametricDatesImpl(ParametricDatesBuilder builder) {
            this.businessCenters = Optional.ofNullable(builder.getBusinessCenters()).map(f -> f.build()).orElse(null);
            this.dayDistribution = builder.getDayDistribution();
            this.dayFrequency = builder.getDayFrequency();
            this.dayOfWeek = Optional.ofNullable(builder.getDayOfWeek()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.dayType = builder.getDayType();
            this.lag = Optional.ofNullable(builder.getLag()).map(f -> f.build()).orElse(null);
        }

        @Override
        public BusinessCenters getBusinessCenters() {
            return this.businessCenters;
        }

        @Override
        public DayDistributionEnum getDayDistribution() {
            return this.dayDistribution;
        }

        @Override
        public BigDecimal getDayFrequency() {
            return this.dayFrequency;
        }

        @Override
        public List<DayOfWeekEnum> getDayOfWeek() {
            return this.dayOfWeek;
        }

        @Override
        public DayTypeEnum getDayType() {
            return this.dayType;
        }

        @Override
        public Lag getLag() {
            return this.lag;
        }

        @Override
        public ParametricDates build() {
            return this;
        }

        @Override
        public ParametricDatesBuilder toBuilder() {
            ParametricDatesBuilder builder = ParametricDates.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ParametricDatesBuilder builder) {
            Optional.ofNullable(this.getBusinessCenters()).ifPresent(builder::setBusinessCenters);
            Optional.ofNullable(this.getDayDistribution()).ifPresent(builder::setDayDistribution);
            Optional.ofNullable(this.getDayFrequency()).ifPresent(builder::setDayFrequency);
            Optional.ofNullable(this.getDayOfWeek()).ifPresent(builder::setDayOfWeek);
            Optional.ofNullable(this.getDayType()).ifPresent(builder::setDayType);
            Optional.ofNullable(this.getLag()).ifPresent(builder::setLag);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ParametricDates _that = this.getType().cast(o);
            if (!Objects.equals(this.businessCenters, _that.getBusinessCenters())) {
                return false;
            }
            if (!Objects.equals((Object)this.dayDistribution, (Object)_that.getDayDistribution())) {
                return false;
            }
            if (!Objects.equals(this.dayFrequency, _that.getDayFrequency())) {
                return false;
            }
            if (!ListEquals.listEquals(this.dayOfWeek, _that.getDayOfWeek())) {
                return false;
            }
            if (!Objects.equals((Object)this.dayType, (Object)_that.getDayType())) {
                return false;
            }
            return Objects.equals(this.lag, _that.getLag());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.businessCenters != null ? this.businessCenters.hashCode() : 0);
            _result = 31 * _result + (this.dayDistribution != null ? ((Object)((Object)this.dayDistribution)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.dayFrequency != null ? this.dayFrequency.hashCode() : 0);
            _result = 31 * _result + (this.dayOfWeek != null ? this.dayOfWeek.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.dayType != null ? ((Object)((Object)this.dayType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.lag != null ? this.lag.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ParametricDates {businessCenters=" + this.businessCenters + ", dayDistribution=" + (Object)((Object)this.dayDistribution) + ", dayFrequency=" + this.dayFrequency + ", dayOfWeek=" + this.dayOfWeek + ", dayType=" + (Object)((Object)this.dayType) + ", lag=" + this.lag + '}';
        }
    }

    public static interface ParametricDatesBuilder
    extends ParametricDates,
    RosettaModelObjectBuilder {
        public BusinessCenters.BusinessCentersBuilder getOrCreateBusinessCenters();

        @Override
        public BusinessCenters.BusinessCentersBuilder getBusinessCenters();

        public Lag.LagBuilder getOrCreateLag();

        @Override
        public Lag.LagBuilder getLag();

        public ParametricDatesBuilder setBusinessCenters(BusinessCenters var1);

        public ParametricDatesBuilder setDayDistribution(DayDistributionEnum var1);

        public ParametricDatesBuilder setDayFrequency(BigDecimal var1);

        public ParametricDatesBuilder addDayOfWeek(DayOfWeekEnum var1);

        public ParametricDatesBuilder addDayOfWeek(DayOfWeekEnum var1, int var2);

        public ParametricDatesBuilder addDayOfWeek(List<? extends DayOfWeekEnum> var1);

        public ParametricDatesBuilder setDayOfWeek(List<? extends DayOfWeekEnum> var1);

        public ParametricDatesBuilder setDayType(DayTypeEnum var1);

        public ParametricDatesBuilder setLag(Lag var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("dayDistribution"), DayDistributionEnum.class, (Object)this.getDayDistribution(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("dayFrequency"), BigDecimal.class, (Object)this.getDayFrequency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("dayOfWeek"), DayOfWeekEnum.class, this.getDayOfWeek(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("dayType"), DayTypeEnum.class, (Object)this.getDayType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessCenters"), processor, BusinessCenters.BusinessCentersBuilder.class, this.getBusinessCenters(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lag"), processor, Lag.LagBuilder.class, this.getLag(), new AttributeMeta[0]);
        }

        public ParametricDatesBuilder prune();
    }
}

