/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.schedule;

import cdm.base.datetime.BusinessDayAdjustments;
import cdm.product.common.schedule.ObservationDate;
import cdm.product.common.schedule.meta.ObservationScheduleMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface ObservationSchedule
extends RosettaModelObject {
    public static final ObservationScheduleMeta metaData = new ObservationScheduleMeta();

    public ObservationSchedule build();

    public ObservationScheduleBuilder toBuilder();

    public BusinessDayAdjustments getDateAdjustments();

    public List<? extends ObservationDate> getObservationDate();

    default public RosettaMetaData<? extends ObservationSchedule> metaData() {
        return metaData;
    }

    public static ObservationScheduleBuilder builder() {
        return new ObservationScheduleBuilderImpl();
    }

    default public Class<? extends ObservationSchedule> getType() {
        return ObservationSchedule.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("dateAdjustments"), processor, BusinessDayAdjustments.class, this.getDateAdjustments(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("observationDate"), processor, ObservationDate.class, this.getObservationDate(), new AttributeMeta[0]);
    }

    public static class ObservationScheduleBuilderImpl
    implements ObservationScheduleBuilder {
        protected BusinessDayAdjustments.BusinessDayAdjustmentsBuilder dateAdjustments;
        protected List<ObservationDate.ObservationDateBuilder> observationDate = new ArrayList<ObservationDate.ObservationDateBuilder>();

        @Override
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getDateAdjustments() {
            return this.dateAdjustments;
        }

        @Override
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getOrCreateDateAdjustments() {
            BusinessDayAdjustments.BusinessDayAdjustmentsBuilder result = this.dateAdjustments != null ? this.dateAdjustments : (this.dateAdjustments = BusinessDayAdjustments.builder());
            return result;
        }

        @Override
        public List<? extends ObservationDate.ObservationDateBuilder> getObservationDate() {
            return this.observationDate;
        }

        @Override
        public ObservationDate.ObservationDateBuilder getOrCreateObservationDate(int _index) {
            if (this.observationDate == null) {
                this.observationDate = new ArrayList<ObservationDate.ObservationDateBuilder>();
            }
            return (ObservationDate.ObservationDateBuilder)this.getIndex(this.observationDate, _index, () -> {
                ObservationDate.ObservationDateBuilder newObservationDate = ObservationDate.builder();
                return newObservationDate;
            });
        }

        @Override
        public ObservationScheduleBuilder setDateAdjustments(BusinessDayAdjustments dateAdjustments) {
            this.dateAdjustments = dateAdjustments == null ? null : dateAdjustments.toBuilder();
            return this;
        }

        @Override
        public ObservationScheduleBuilder addObservationDate(ObservationDate observationDate) {
            if (observationDate != null) {
                this.observationDate.add(observationDate.toBuilder());
            }
            return this;
        }

        @Override
        public ObservationScheduleBuilder addObservationDate(ObservationDate observationDate, int _idx) {
            this.getIndex(this.observationDate, _idx, () -> observationDate.toBuilder());
            return this;
        }

        @Override
        public ObservationScheduleBuilder addObservationDate(List<? extends ObservationDate> observationDates) {
            if (observationDates != null) {
                for (ObservationDate observationDate : observationDates) {
                    this.observationDate.add(observationDate.toBuilder());
                }
            }
            return this;
        }

        @Override
        public ObservationScheduleBuilder setObservationDate(List<? extends ObservationDate> observationDates) {
            this.observationDate = observationDates == null ? new ArrayList<ObservationDate.ObservationDateBuilder>() : (List)observationDates.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ObservationSchedule build() {
            return new ObservationScheduleImpl(this);
        }

        @Override
        public ObservationScheduleBuilder toBuilder() {
            return this;
        }

        @Override
        public ObservationScheduleBuilder prune() {
            if (this.dateAdjustments != null && !this.dateAdjustments.prune().hasData()) {
                this.dateAdjustments = null;
            }
            this.observationDate = this.observationDate.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getDateAdjustments() != null && this.getDateAdjustments().hasData()) {
                return true;
            }
            return this.getObservationDate() != null && this.getObservationDate().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public ObservationScheduleBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ObservationScheduleBuilder o = (ObservationScheduleBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDateAdjustments(), (RosettaModelObjectBuilder)o.getDateAdjustments(), this::setDateAdjustments);
            merger.mergeRosetta(this.getObservationDate(), o.getObservationDate(), this::getOrCreateObservationDate);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ObservationSchedule _that = this.getType().cast(o);
            if (!Objects.equals(this.dateAdjustments, _that.getDateAdjustments())) {
                return false;
            }
            return ListEquals.listEquals(this.observationDate, _that.getObservationDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dateAdjustments != null ? this.dateAdjustments.hashCode() : 0);
            _result = 31 * _result + (this.observationDate != null ? this.observationDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ObservationScheduleBuilder {dateAdjustments=" + this.dateAdjustments + ", observationDate=" + this.observationDate + '}';
        }
    }

    public static class ObservationScheduleImpl
    implements ObservationSchedule {
        private final BusinessDayAdjustments dateAdjustments;
        private final List<? extends ObservationDate> observationDate;

        protected ObservationScheduleImpl(ObservationScheduleBuilder builder) {
            this.dateAdjustments = Optional.ofNullable(builder.getDateAdjustments()).map(f -> f.build()).orElse(null);
            this.observationDate = Optional.ofNullable(builder.getObservationDate()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        public BusinessDayAdjustments getDateAdjustments() {
            return this.dateAdjustments;
        }

        @Override
        public List<? extends ObservationDate> getObservationDate() {
            return this.observationDate;
        }

        @Override
        public ObservationSchedule build() {
            return this;
        }

        @Override
        public ObservationScheduleBuilder toBuilder() {
            ObservationScheduleBuilder builder = ObservationSchedule.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ObservationScheduleBuilder builder) {
            Optional.ofNullable(this.getDateAdjustments()).ifPresent(builder::setDateAdjustments);
            Optional.ofNullable(this.getObservationDate()).ifPresent(builder::setObservationDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ObservationSchedule _that = this.getType().cast(o);
            if (!Objects.equals(this.dateAdjustments, _that.getDateAdjustments())) {
                return false;
            }
            return ListEquals.listEquals(this.observationDate, _that.getObservationDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dateAdjustments != null ? this.dateAdjustments.hashCode() : 0);
            _result = 31 * _result + (this.observationDate != null ? this.observationDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ObservationSchedule {dateAdjustments=" + this.dateAdjustments + ", observationDate=" + this.observationDate + '}';
        }
    }

    public static interface ObservationScheduleBuilder
    extends ObservationSchedule,
    RosettaModelObjectBuilder {
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getOrCreateDateAdjustments();

        @Override
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getDateAdjustments();

        public ObservationDate.ObservationDateBuilder getOrCreateObservationDate(int var1);

        public List<? extends ObservationDate.ObservationDateBuilder> getObservationDate();

        public ObservationScheduleBuilder setDateAdjustments(BusinessDayAdjustments var1);

        public ObservationScheduleBuilder addObservationDate(ObservationDate var1);

        public ObservationScheduleBuilder addObservationDate(ObservationDate var1, int var2);

        public ObservationScheduleBuilder addObservationDate(List<? extends ObservationDate> var1);

        public ObservationScheduleBuilder setObservationDate(List<? extends ObservationDate> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("dateAdjustments"), processor, BusinessDayAdjustments.BusinessDayAdjustmentsBuilder.class, this.getDateAdjustments(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("observationDate"), processor, ObservationDate.ObservationDateBuilder.class, this.getObservationDate(), new AttributeMeta[0]);
        }

        public ObservationScheduleBuilder prune();
    }
}

