/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.schedule;

import cdm.product.common.schedule.meta.ObservationDateMeta;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.MetaFields;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface ObservationDate
extends RosettaModelObject,
GlobalKey {
    public static final ObservationDateMeta metaData = new ObservationDateMeta();

    public ObservationDate build();

    public ObservationDateBuilder toBuilder();

    public Date getAdjustedDate();

    public MetaFields getMeta();

    public String getObservationReference();

    public Date getUnadjustedDate();

    public BigDecimal getWeight();

    default public RosettaMetaData<? extends ObservationDate> metaData() {
        return metaData;
    }

    public static ObservationDateBuilder builder() {
        return new ObservationDateBuilderImpl();
    }

    default public Class<? extends ObservationDate> getType() {
        return ObservationDate.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("adjustedDate"), Date.class, (Object)this.getAdjustedDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("observationReference"), String.class, (Object)this.getObservationReference(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("unadjustedDate"), Date.class, (Object)this.getUnadjustedDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("weight"), BigDecimal.class, (Object)this.getWeight(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
    }

    public static class ObservationDateBuilderImpl
    implements ObservationDateBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected Date adjustedDate;
        protected MetaFields.MetaFieldsBuilder meta;
        protected String observationReference;
        protected Date unadjustedDate;
        protected BigDecimal weight;

        @Override
        public Date getAdjustedDate() {
            return this.adjustedDate;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        public String getObservationReference() {
            return this.observationReference;
        }

        @Override
        public Date getUnadjustedDate() {
            return this.unadjustedDate;
        }

        @Override
        public BigDecimal getWeight() {
            return this.weight;
        }

        @Override
        public ObservationDateBuilder setAdjustedDate(Date adjustedDate) {
            this.adjustedDate = adjustedDate == null ? null : adjustedDate;
            return this;
        }

        @Override
        public ObservationDateBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public ObservationDateBuilder setObservationReference(String observationReference) {
            this.observationReference = observationReference == null ? null : observationReference;
            return this;
        }

        @Override
        public ObservationDateBuilder setUnadjustedDate(Date unadjustedDate) {
            this.unadjustedDate = unadjustedDate == null ? null : unadjustedDate;
            return this;
        }

        @Override
        public ObservationDateBuilder setWeight(BigDecimal weight) {
            this.weight = weight == null ? null : weight;
            return this;
        }

        @Override
        public ObservationDate build() {
            return new ObservationDateImpl(this);
        }

        @Override
        public ObservationDateBuilder toBuilder() {
            return this;
        }

        @Override
        public ObservationDateBuilder prune() {
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAdjustedDate() != null) {
                return true;
            }
            if (this.getObservationReference() != null) {
                return true;
            }
            if (this.getUnadjustedDate() != null) {
                return true;
            }
            return this.getWeight() != null;
        }

        public ObservationDateBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ObservationDateBuilder o = (ObservationDateBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeBasic((Object)this.getAdjustedDate(), (Object)o.getAdjustedDate(), this::setAdjustedDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getObservationReference(), (Object)o.getObservationReference(), this::setObservationReference, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnadjustedDate(), (Object)o.getUnadjustedDate(), this::setUnadjustedDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getWeight(), (Object)o.getWeight(), this::setWeight, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ObservationDate _that = this.getType().cast(o);
            if (!Objects.equals(this.adjustedDate, _that.getAdjustedDate())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.observationReference, _that.getObservationReference())) {
                return false;
            }
            if (!Objects.equals(this.unadjustedDate, _that.getUnadjustedDate())) {
                return false;
            }
            return Objects.equals(this.weight, _that.getWeight());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.adjustedDate != null ? this.adjustedDate.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.observationReference != null ? this.observationReference.hashCode() : 0);
            _result = 31 * _result + (this.unadjustedDate != null ? this.unadjustedDate.hashCode() : 0);
            _result = 31 * _result + (this.weight != null ? this.weight.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ObservationDateBuilder {adjustedDate=" + this.adjustedDate + ", meta=" + this.meta + ", observationReference=" + this.observationReference + ", unadjustedDate=" + this.unadjustedDate + ", weight=" + this.weight + '}';
        }
    }

    public static class ObservationDateImpl
    implements ObservationDate {
        private final Date adjustedDate;
        private final MetaFields meta;
        private final String observationReference;
        private final Date unadjustedDate;
        private final BigDecimal weight;

        protected ObservationDateImpl(ObservationDateBuilder builder) {
            this.adjustedDate = builder.getAdjustedDate();
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
            this.observationReference = builder.getObservationReference();
            this.unadjustedDate = builder.getUnadjustedDate();
            this.weight = builder.getWeight();
        }

        @Override
        public Date getAdjustedDate() {
            return this.adjustedDate;
        }

        @Override
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public String getObservationReference() {
            return this.observationReference;
        }

        @Override
        public Date getUnadjustedDate() {
            return this.unadjustedDate;
        }

        @Override
        public BigDecimal getWeight() {
            return this.weight;
        }

        @Override
        public ObservationDate build() {
            return this;
        }

        @Override
        public ObservationDateBuilder toBuilder() {
            ObservationDateBuilder builder = ObservationDate.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ObservationDateBuilder builder) {
            Optional.ofNullable(this.getAdjustedDate()).ifPresent(builder::setAdjustedDate);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
            Optional.ofNullable(this.getObservationReference()).ifPresent(builder::setObservationReference);
            Optional.ofNullable(this.getUnadjustedDate()).ifPresent(builder::setUnadjustedDate);
            Optional.ofNullable(this.getWeight()).ifPresent(builder::setWeight);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ObservationDate _that = this.getType().cast(o);
            if (!Objects.equals(this.adjustedDate, _that.getAdjustedDate())) {
                return false;
            }
            if (!Objects.equals(this.meta, _that.getMeta())) {
                return false;
            }
            if (!Objects.equals(this.observationReference, _that.getObservationReference())) {
                return false;
            }
            if (!Objects.equals(this.unadjustedDate, _that.getUnadjustedDate())) {
                return false;
            }
            return Objects.equals(this.weight, _that.getWeight());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.adjustedDate != null ? this.adjustedDate.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            _result = 31 * _result + (this.observationReference != null ? this.observationReference.hashCode() : 0);
            _result = 31 * _result + (this.unadjustedDate != null ? this.unadjustedDate.hashCode() : 0);
            _result = 31 * _result + (this.weight != null ? this.weight.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ObservationDate {adjustedDate=" + this.adjustedDate + ", meta=" + this.meta + ", observationReference=" + this.observationReference + ", unadjustedDate=" + this.unadjustedDate + ", weight=" + this.weight + '}';
        }
    }

    public static interface ObservationDateBuilder
    extends ObservationDate,
    RosettaModelObjectBuilder {
        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public ObservationDateBuilder setAdjustedDate(Date var1);

        public ObservationDateBuilder setMeta(MetaFields var1);

        public ObservationDateBuilder setObservationReference(String var1);

        public ObservationDateBuilder setUnadjustedDate(Date var1);

        public ObservationDateBuilder setWeight(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("adjustedDate"), Date.class, (Object)this.getAdjustedDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("observationReference"), String.class, (Object)this.getObservationReference(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("unadjustedDate"), Date.class, (Object)this.getUnadjustedDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("weight"), BigDecimal.class, (Object)this.getWeight(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
        }

        public ObservationDateBuilder prune();
    }
}

