/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.schedule;

import cdm.observable.asset.Money;
import cdm.product.asset.FloatingRateDefinition;
import cdm.product.common.schedule.CalculationPeriodBase;
import cdm.product.common.schedule.FxLinkedNotionalAmount;
import cdm.product.common.schedule.meta.CalculationPeriodMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.MetaFields;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaClass
public interface CalculationPeriod
extends CalculationPeriodBase {
    public static final CalculationPeriodMeta metaData = new CalculationPeriodMeta();

    @Override
    public CalculationPeriod build();

    @Override
    public CalculationPeriodBuilder toBuilder();

    public Integer getCalculationPeriodNumberOfDays();

    public BigDecimal getDayCountYearFraction();

    public BigDecimal getFixedRate();

    public FloatingRateDefinition getFloatingRateDefinition();

    public Money getForecastAmount();

    public BigDecimal getForecastRate();

    public FxLinkedNotionalAmount getFxLinkedNotionalAmount();

    public BigDecimal getNotionalAmount();

    public Date getUnadjustedEndDate();

    public Date getUnadjustedStartDate();

    default public RosettaMetaData<? extends CalculationPeriod> metaData() {
        return metaData;
    }

    public static CalculationPeriodBuilder builder() {
        return new CalculationPeriodBuilderImpl();
    }

    default public Class<? extends CalculationPeriod> getType() {
        return CalculationPeriod.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        CalculationPeriodBase.super.process(path, processor);
        processor.processBasic(path.newSubPath("calculationPeriodNumberOfDays"), Integer.class, (Object)this.getCalculationPeriodNumberOfDays(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("dayCountYearFraction"), BigDecimal.class, (Object)this.getDayCountYearFraction(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRate"), BigDecimal.class, (Object)this.getFixedRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("forecastRate"), BigDecimal.class, (Object)this.getForecastRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalAmount"), BigDecimal.class, (Object)this.getNotionalAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("unadjustedEndDate"), Date.class, (Object)this.getUnadjustedEndDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("unadjustedStartDate"), Date.class, (Object)this.getUnadjustedStartDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("floatingRateDefinition"), processor, FloatingRateDefinition.class, this.getFloatingRateDefinition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("forecastAmount"), processor, Money.class, this.getForecastAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxLinkedNotionalAmount"), processor, FxLinkedNotionalAmount.class, this.getFxLinkedNotionalAmount(), new AttributeMeta[0]);
    }

    public static class CalculationPeriodBuilderImpl
    extends CalculationPeriodBase.CalculationPeriodBaseBuilderImpl
    implements CalculationPeriodBuilder {
        protected Integer calculationPeriodNumberOfDays;
        protected BigDecimal dayCountYearFraction;
        protected BigDecimal fixedRate;
        protected FloatingRateDefinition.FloatingRateDefinitionBuilder floatingRateDefinition;
        protected Money.MoneyBuilder forecastAmount;
        protected BigDecimal forecastRate;
        protected FxLinkedNotionalAmount.FxLinkedNotionalAmountBuilder fxLinkedNotionalAmount;
        protected BigDecimal notionalAmount;
        protected Date unadjustedEndDate;
        protected Date unadjustedStartDate;

        @Override
        public Integer getCalculationPeriodNumberOfDays() {
            return this.calculationPeriodNumberOfDays;
        }

        @Override
        public BigDecimal getDayCountYearFraction() {
            return this.dayCountYearFraction;
        }

        @Override
        public BigDecimal getFixedRate() {
            return this.fixedRate;
        }

        @Override
        public FloatingRateDefinition.FloatingRateDefinitionBuilder getFloatingRateDefinition() {
            return this.floatingRateDefinition;
        }

        @Override
        public FloatingRateDefinition.FloatingRateDefinitionBuilder getOrCreateFloatingRateDefinition() {
            FloatingRateDefinition.FloatingRateDefinitionBuilder result = this.floatingRateDefinition != null ? this.floatingRateDefinition : (this.floatingRateDefinition = FloatingRateDefinition.builder());
            return result;
        }

        @Override
        public Money.MoneyBuilder getForecastAmount() {
            return this.forecastAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateForecastAmount() {
            Money.MoneyBuilder result = this.forecastAmount != null ? this.forecastAmount : (this.forecastAmount = Money.builder());
            return result;
        }

        @Override
        public BigDecimal getForecastRate() {
            return this.forecastRate;
        }

        @Override
        public FxLinkedNotionalAmount.FxLinkedNotionalAmountBuilder getFxLinkedNotionalAmount() {
            return this.fxLinkedNotionalAmount;
        }

        @Override
        public FxLinkedNotionalAmount.FxLinkedNotionalAmountBuilder getOrCreateFxLinkedNotionalAmount() {
            FxLinkedNotionalAmount.FxLinkedNotionalAmountBuilder result = this.fxLinkedNotionalAmount != null ? this.fxLinkedNotionalAmount : (this.fxLinkedNotionalAmount = FxLinkedNotionalAmount.builder());
            return result;
        }

        @Override
        public BigDecimal getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        public Date getUnadjustedEndDate() {
            return this.unadjustedEndDate;
        }

        @Override
        public Date getUnadjustedStartDate() {
            return this.unadjustedStartDate;
        }

        @Override
        public CalculationPeriodBuilder setCalculationPeriodNumberOfDays(Integer calculationPeriodNumberOfDays) {
            this.calculationPeriodNumberOfDays = calculationPeriodNumberOfDays == null ? null : calculationPeriodNumberOfDays;
            return this;
        }

        @Override
        public CalculationPeriodBuilder setDayCountYearFraction(BigDecimal dayCountYearFraction) {
            this.dayCountYearFraction = dayCountYearFraction == null ? null : dayCountYearFraction;
            return this;
        }

        @Override
        public CalculationPeriodBuilder setFixedRate(BigDecimal fixedRate) {
            this.fixedRate = fixedRate == null ? null : fixedRate;
            return this;
        }

        @Override
        public CalculationPeriodBuilder setFloatingRateDefinition(FloatingRateDefinition floatingRateDefinition) {
            this.floatingRateDefinition = floatingRateDefinition == null ? null : floatingRateDefinition.toBuilder();
            return this;
        }

        @Override
        public CalculationPeriodBuilder setForecastAmount(Money forecastAmount) {
            this.forecastAmount = forecastAmount == null ? null : forecastAmount.toBuilder();
            return this;
        }

        @Override
        public CalculationPeriodBuilder setForecastRate(BigDecimal forecastRate) {
            this.forecastRate = forecastRate == null ? null : forecastRate;
            return this;
        }

        @Override
        public CalculationPeriodBuilder setFxLinkedNotionalAmount(FxLinkedNotionalAmount fxLinkedNotionalAmount) {
            this.fxLinkedNotionalAmount = fxLinkedNotionalAmount == null ? null : fxLinkedNotionalAmount.toBuilder();
            return this;
        }

        @Override
        public CalculationPeriodBuilder setNotionalAmount(BigDecimal notionalAmount) {
            this.notionalAmount = notionalAmount == null ? null : notionalAmount;
            return this;
        }

        @Override
        public CalculationPeriodBuilder setUnadjustedEndDate(Date unadjustedEndDate) {
            this.unadjustedEndDate = unadjustedEndDate == null ? null : unadjustedEndDate;
            return this;
        }

        @Override
        public CalculationPeriodBuilder setUnadjustedStartDate(Date unadjustedStartDate) {
            this.unadjustedStartDate = unadjustedStartDate == null ? null : unadjustedStartDate;
            return this;
        }

        @Override
        public CalculationPeriodBuilder setAdjustedEndDate(Date adjustedEndDate) {
            this.adjustedEndDate = adjustedEndDate == null ? null : adjustedEndDate;
            return this;
        }

        @Override
        public CalculationPeriodBuilder setAdjustedStartDate(Date adjustedStartDate) {
            this.adjustedStartDate = adjustedStartDate == null ? null : adjustedStartDate;
            return this;
        }

        @Override
        public CalculationPeriodBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public CalculationPeriod build() {
            return new CalculationPeriodImpl(this);
        }

        @Override
        public CalculationPeriodBuilder toBuilder() {
            return this;
        }

        @Override
        public CalculationPeriodBuilder prune() {
            super.prune();
            if (this.floatingRateDefinition != null && !this.floatingRateDefinition.prune().hasData()) {
                this.floatingRateDefinition = null;
            }
            if (this.forecastAmount != null && !this.forecastAmount.prune().hasData()) {
                this.forecastAmount = null;
            }
            if (this.fxLinkedNotionalAmount != null && !this.fxLinkedNotionalAmount.prune().hasData()) {
                this.fxLinkedNotionalAmount = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCalculationPeriodNumberOfDays() != null) {
                return true;
            }
            if (this.getDayCountYearFraction() != null) {
                return true;
            }
            if (this.getFixedRate() != null) {
                return true;
            }
            if (this.getFloatingRateDefinition() != null && this.getFloatingRateDefinition().hasData()) {
                return true;
            }
            if (this.getForecastAmount() != null && this.getForecastAmount().hasData()) {
                return true;
            }
            if (this.getForecastRate() != null) {
                return true;
            }
            if (this.getFxLinkedNotionalAmount() != null && this.getFxLinkedNotionalAmount().hasData()) {
                return true;
            }
            if (this.getNotionalAmount() != null) {
                return true;
            }
            if (this.getUnadjustedEndDate() != null) {
                return true;
            }
            return this.getUnadjustedStartDate() != null;
        }

        @Override
        public CalculationPeriodBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CalculationPeriodBuilder o = (CalculationPeriodBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFloatingRateDefinition(), (RosettaModelObjectBuilder)o.getFloatingRateDefinition(), this::setFloatingRateDefinition);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getForecastAmount(), (RosettaModelObjectBuilder)o.getForecastAmount(), this::setForecastAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxLinkedNotionalAmount(), (RosettaModelObjectBuilder)o.getFxLinkedNotionalAmount(), this::setFxLinkedNotionalAmount);
            merger.mergeBasic((Object)this.getCalculationPeriodNumberOfDays(), (Object)o.getCalculationPeriodNumberOfDays(), this::setCalculationPeriodNumberOfDays, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDayCountYearFraction(), (Object)o.getDayCountYearFraction(), this::setDayCountYearFraction, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedRate(), (Object)o.getFixedRate(), this::setFixedRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getForecastRate(), (Object)o.getForecastRate(), this::setForecastRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNotionalAmount(), (Object)o.getNotionalAmount(), this::setNotionalAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnadjustedEndDate(), (Object)o.getUnadjustedEndDate(), this::setUnadjustedEndDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnadjustedStartDate(), (Object)o.getUnadjustedStartDate(), this::setUnadjustedStartDate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CalculationPeriod _that = (CalculationPeriod)this.getType().cast(o);
            if (!Objects.equals(this.calculationPeriodNumberOfDays, _that.getCalculationPeriodNumberOfDays())) {
                return false;
            }
            if (!Objects.equals(this.dayCountYearFraction, _that.getDayCountYearFraction())) {
                return false;
            }
            if (!Objects.equals(this.fixedRate, _that.getFixedRate())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateDefinition, _that.getFloatingRateDefinition())) {
                return false;
            }
            if (!Objects.equals(this.forecastAmount, _that.getForecastAmount())) {
                return false;
            }
            if (!Objects.equals(this.forecastRate, _that.getForecastRate())) {
                return false;
            }
            if (!Objects.equals(this.fxLinkedNotionalAmount, _that.getFxLinkedNotionalAmount())) {
                return false;
            }
            if (!Objects.equals(this.notionalAmount, _that.getNotionalAmount())) {
                return false;
            }
            if (!Objects.equals(this.unadjustedEndDate, _that.getUnadjustedEndDate())) {
                return false;
            }
            return Objects.equals(this.unadjustedStartDate, _that.getUnadjustedStartDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.calculationPeriodNumberOfDays != null ? this.calculationPeriodNumberOfDays.hashCode() : 0);
            _result = 31 * _result + (this.dayCountYearFraction != null ? this.dayCountYearFraction.hashCode() : 0);
            _result = 31 * _result + (this.fixedRate != null ? this.fixedRate.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateDefinition != null ? this.floatingRateDefinition.hashCode() : 0);
            _result = 31 * _result + (this.forecastAmount != null ? this.forecastAmount.hashCode() : 0);
            _result = 31 * _result + (this.forecastRate != null ? this.forecastRate.hashCode() : 0);
            _result = 31 * _result + (this.fxLinkedNotionalAmount != null ? this.fxLinkedNotionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.unadjustedEndDate != null ? this.unadjustedEndDate.hashCode() : 0);
            _result = 31 * _result + (this.unadjustedStartDate != null ? this.unadjustedStartDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CalculationPeriodBuilder {calculationPeriodNumberOfDays=" + this.calculationPeriodNumberOfDays + ", dayCountYearFraction=" + this.dayCountYearFraction + ", fixedRate=" + this.fixedRate + ", floatingRateDefinition=" + this.floatingRateDefinition + ", forecastAmount=" + this.forecastAmount + ", forecastRate=" + this.forecastRate + ", fxLinkedNotionalAmount=" + this.fxLinkedNotionalAmount + ", notionalAmount=" + this.notionalAmount + ", unadjustedEndDate=" + this.unadjustedEndDate + ", unadjustedStartDate=" + this.unadjustedStartDate + '}' + " " + super.toString();
        }
    }

    public static class CalculationPeriodImpl
    extends CalculationPeriodBase.CalculationPeriodBaseImpl
    implements CalculationPeriod {
        private final Integer calculationPeriodNumberOfDays;
        private final BigDecimal dayCountYearFraction;
        private final BigDecimal fixedRate;
        private final FloatingRateDefinition floatingRateDefinition;
        private final Money forecastAmount;
        private final BigDecimal forecastRate;
        private final FxLinkedNotionalAmount fxLinkedNotionalAmount;
        private final BigDecimal notionalAmount;
        private final Date unadjustedEndDate;
        private final Date unadjustedStartDate;

        protected CalculationPeriodImpl(CalculationPeriodBuilder builder) {
            super(builder);
            this.calculationPeriodNumberOfDays = builder.getCalculationPeriodNumberOfDays();
            this.dayCountYearFraction = builder.getDayCountYearFraction();
            this.fixedRate = builder.getFixedRate();
            this.floatingRateDefinition = Optional.ofNullable(builder.getFloatingRateDefinition()).map(f -> f.build()).orElse(null);
            this.forecastAmount = Optional.ofNullable(builder.getForecastAmount()).map(f -> f.build()).orElse(null);
            this.forecastRate = builder.getForecastRate();
            this.fxLinkedNotionalAmount = Optional.ofNullable(builder.getFxLinkedNotionalAmount()).map(f -> f.build()).orElse(null);
            this.notionalAmount = builder.getNotionalAmount();
            this.unadjustedEndDate = builder.getUnadjustedEndDate();
            this.unadjustedStartDate = builder.getUnadjustedStartDate();
        }

        @Override
        public Integer getCalculationPeriodNumberOfDays() {
            return this.calculationPeriodNumberOfDays;
        }

        @Override
        public BigDecimal getDayCountYearFraction() {
            return this.dayCountYearFraction;
        }

        @Override
        public BigDecimal getFixedRate() {
            return this.fixedRate;
        }

        @Override
        public FloatingRateDefinition getFloatingRateDefinition() {
            return this.floatingRateDefinition;
        }

        @Override
        public Money getForecastAmount() {
            return this.forecastAmount;
        }

        @Override
        public BigDecimal getForecastRate() {
            return this.forecastRate;
        }

        @Override
        public FxLinkedNotionalAmount getFxLinkedNotionalAmount() {
            return this.fxLinkedNotionalAmount;
        }

        @Override
        public BigDecimal getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        public Date getUnadjustedEndDate() {
            return this.unadjustedEndDate;
        }

        @Override
        public Date getUnadjustedStartDate() {
            return this.unadjustedStartDate;
        }

        @Override
        public CalculationPeriod build() {
            return this;
        }

        @Override
        public CalculationPeriodBuilder toBuilder() {
            CalculationPeriodBuilder builder = CalculationPeriod.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CalculationPeriodBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCalculationPeriodNumberOfDays()).ifPresent(builder::setCalculationPeriodNumberOfDays);
            Optional.ofNullable(this.getDayCountYearFraction()).ifPresent(builder::setDayCountYearFraction);
            Optional.ofNullable(this.getFixedRate()).ifPresent(builder::setFixedRate);
            Optional.ofNullable(this.getFloatingRateDefinition()).ifPresent(builder::setFloatingRateDefinition);
            Optional.ofNullable(this.getForecastAmount()).ifPresent(builder::setForecastAmount);
            Optional.ofNullable(this.getForecastRate()).ifPresent(builder::setForecastRate);
            Optional.ofNullable(this.getFxLinkedNotionalAmount()).ifPresent(builder::setFxLinkedNotionalAmount);
            Optional.ofNullable(this.getNotionalAmount()).ifPresent(builder::setNotionalAmount);
            Optional.ofNullable(this.getUnadjustedEndDate()).ifPresent(builder::setUnadjustedEndDate);
            Optional.ofNullable(this.getUnadjustedStartDate()).ifPresent(builder::setUnadjustedStartDate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CalculationPeriod _that = (CalculationPeriod)this.getType().cast(o);
            if (!Objects.equals(this.calculationPeriodNumberOfDays, _that.getCalculationPeriodNumberOfDays())) {
                return false;
            }
            if (!Objects.equals(this.dayCountYearFraction, _that.getDayCountYearFraction())) {
                return false;
            }
            if (!Objects.equals(this.fixedRate, _that.getFixedRate())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateDefinition, _that.getFloatingRateDefinition())) {
                return false;
            }
            if (!Objects.equals(this.forecastAmount, _that.getForecastAmount())) {
                return false;
            }
            if (!Objects.equals(this.forecastRate, _that.getForecastRate())) {
                return false;
            }
            if (!Objects.equals(this.fxLinkedNotionalAmount, _that.getFxLinkedNotionalAmount())) {
                return false;
            }
            if (!Objects.equals(this.notionalAmount, _that.getNotionalAmount())) {
                return false;
            }
            if (!Objects.equals(this.unadjustedEndDate, _that.getUnadjustedEndDate())) {
                return false;
            }
            return Objects.equals(this.unadjustedStartDate, _that.getUnadjustedStartDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.calculationPeriodNumberOfDays != null ? this.calculationPeriodNumberOfDays.hashCode() : 0);
            _result = 31 * _result + (this.dayCountYearFraction != null ? this.dayCountYearFraction.hashCode() : 0);
            _result = 31 * _result + (this.fixedRate != null ? this.fixedRate.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateDefinition != null ? this.floatingRateDefinition.hashCode() : 0);
            _result = 31 * _result + (this.forecastAmount != null ? this.forecastAmount.hashCode() : 0);
            _result = 31 * _result + (this.forecastRate != null ? this.forecastRate.hashCode() : 0);
            _result = 31 * _result + (this.fxLinkedNotionalAmount != null ? this.fxLinkedNotionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.unadjustedEndDate != null ? this.unadjustedEndDate.hashCode() : 0);
            _result = 31 * _result + (this.unadjustedStartDate != null ? this.unadjustedStartDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CalculationPeriod {calculationPeriodNumberOfDays=" + this.calculationPeriodNumberOfDays + ", dayCountYearFraction=" + this.dayCountYearFraction + ", fixedRate=" + this.fixedRate + ", floatingRateDefinition=" + this.floatingRateDefinition + ", forecastAmount=" + this.forecastAmount + ", forecastRate=" + this.forecastRate + ", fxLinkedNotionalAmount=" + this.fxLinkedNotionalAmount + ", notionalAmount=" + this.notionalAmount + ", unadjustedEndDate=" + this.unadjustedEndDate + ", unadjustedStartDate=" + this.unadjustedStartDate + '}' + " " + super.toString();
        }
    }

    public static interface CalculationPeriodBuilder
    extends CalculationPeriod,
    CalculationPeriodBase.CalculationPeriodBaseBuilder,
    RosettaModelObjectBuilder {
        public FloatingRateDefinition.FloatingRateDefinitionBuilder getOrCreateFloatingRateDefinition();

        @Override
        public FloatingRateDefinition.FloatingRateDefinitionBuilder getFloatingRateDefinition();

        public Money.MoneyBuilder getOrCreateForecastAmount();

        @Override
        public Money.MoneyBuilder getForecastAmount();

        public FxLinkedNotionalAmount.FxLinkedNotionalAmountBuilder getOrCreateFxLinkedNotionalAmount();

        @Override
        public FxLinkedNotionalAmount.FxLinkedNotionalAmountBuilder getFxLinkedNotionalAmount();

        public CalculationPeriodBuilder setCalculationPeriodNumberOfDays(Integer var1);

        public CalculationPeriodBuilder setDayCountYearFraction(BigDecimal var1);

        public CalculationPeriodBuilder setFixedRate(BigDecimal var1);

        public CalculationPeriodBuilder setFloatingRateDefinition(FloatingRateDefinition var1);

        public CalculationPeriodBuilder setForecastAmount(Money var1);

        public CalculationPeriodBuilder setForecastRate(BigDecimal var1);

        public CalculationPeriodBuilder setFxLinkedNotionalAmount(FxLinkedNotionalAmount var1);

        public CalculationPeriodBuilder setNotionalAmount(BigDecimal var1);

        public CalculationPeriodBuilder setUnadjustedEndDate(Date var1);

        public CalculationPeriodBuilder setUnadjustedStartDate(Date var1);

        @Override
        public CalculationPeriodBuilder setAdjustedEndDate(Date var1);

        @Override
        public CalculationPeriodBuilder setAdjustedStartDate(Date var1);

        @Override
        public CalculationPeriodBuilder setMeta(MetaFields var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            CalculationPeriodBase.CalculationPeriodBaseBuilder.super.process(path, processor);
            processor.processBasic(path.newSubPath("calculationPeriodNumberOfDays"), Integer.class, (Object)this.getCalculationPeriodNumberOfDays(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("dayCountYearFraction"), BigDecimal.class, (Object)this.getDayCountYearFraction(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRate"), BigDecimal.class, (Object)this.getFixedRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("forecastRate"), BigDecimal.class, (Object)this.getForecastRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalAmount"), BigDecimal.class, (Object)this.getNotionalAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("unadjustedEndDate"), Date.class, (Object)this.getUnadjustedEndDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("unadjustedStartDate"), Date.class, (Object)this.getUnadjustedStartDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("floatingRateDefinition"), processor, FloatingRateDefinition.FloatingRateDefinitionBuilder.class, this.getFloatingRateDefinition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("forecastAmount"), processor, Money.MoneyBuilder.class, this.getForecastAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxLinkedNotionalAmount"), processor, FxLinkedNotionalAmount.FxLinkedNotionalAmountBuilder.class, this.getFxLinkedNotionalAmount(), new AttributeMeta[0]);
        }

        @Override
        public CalculationPeriodBuilder prune();
    }
}

