/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.schedule;

import cdm.base.datetime.AveragingSchedule;
import cdm.base.datetime.DateTimeList;
import cdm.observable.event.MarketDisruptionEnum;
import cdm.observable.event.metafields.FieldWithMetaMarketDisruptionEnum;
import cdm.product.common.schedule.AveragingObservationList;
import cdm.product.common.schedule.meta.AveragingPeriodMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaClass;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaClass
public interface AveragingPeriod
extends RosettaModelObject {
    public static final AveragingPeriodMeta metaData = new AveragingPeriodMeta();

    public AveragingPeriod build();

    public AveragingPeriodBuilder toBuilder();

    public DateTimeList getAveragingDateTimes();

    public AveragingObservationList getAveragingObservations();

    public FieldWithMetaMarketDisruptionEnum getMarketDisruption();

    public List<? extends AveragingSchedule> getSchedule();

    default public RosettaMetaData<? extends AveragingPeriod> metaData() {
        return metaData;
    }

    public static AveragingPeriodBuilder builder() {
        return new AveragingPeriodBuilderImpl();
    }

    default public Class<? extends AveragingPeriod> getType() {
        return AveragingPeriod.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("averagingDateTimes"), processor, DateTimeList.class, this.getAveragingDateTimes(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("averagingObservations"), processor, AveragingObservationList.class, this.getAveragingObservations(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("marketDisruption"), processor, FieldWithMetaMarketDisruptionEnum.class, this.getMarketDisruption(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("schedule"), processor, AveragingSchedule.class, this.getSchedule(), new AttributeMeta[0]);
    }

    public static class AveragingPeriodBuilderImpl
    implements AveragingPeriodBuilder {
        protected DateTimeList.DateTimeListBuilder averagingDateTimes;
        protected AveragingObservationList.AveragingObservationListBuilder averagingObservations;
        protected FieldWithMetaMarketDisruptionEnum.FieldWithMetaMarketDisruptionEnumBuilder marketDisruption;
        protected List<AveragingSchedule.AveragingScheduleBuilder> schedule = new ArrayList<AveragingSchedule.AveragingScheduleBuilder>();

        @Override
        public DateTimeList.DateTimeListBuilder getAveragingDateTimes() {
            return this.averagingDateTimes;
        }

        @Override
        public DateTimeList.DateTimeListBuilder getOrCreateAveragingDateTimes() {
            DateTimeList.DateTimeListBuilder result = this.averagingDateTimes != null ? this.averagingDateTimes : (this.averagingDateTimes = DateTimeList.builder());
            return result;
        }

        @Override
        public AveragingObservationList.AveragingObservationListBuilder getAveragingObservations() {
            return this.averagingObservations;
        }

        @Override
        public AveragingObservationList.AveragingObservationListBuilder getOrCreateAveragingObservations() {
            AveragingObservationList.AveragingObservationListBuilder result = this.averagingObservations != null ? this.averagingObservations : (this.averagingObservations = AveragingObservationList.builder());
            return result;
        }

        @Override
        public FieldWithMetaMarketDisruptionEnum.FieldWithMetaMarketDisruptionEnumBuilder getMarketDisruption() {
            return this.marketDisruption;
        }

        @Override
        public FieldWithMetaMarketDisruptionEnum.FieldWithMetaMarketDisruptionEnumBuilder getOrCreateMarketDisruption() {
            FieldWithMetaMarketDisruptionEnum.FieldWithMetaMarketDisruptionEnumBuilder result = this.marketDisruption != null ? this.marketDisruption : (this.marketDisruption = FieldWithMetaMarketDisruptionEnum.builder());
            return result;
        }

        @Override
        public List<? extends AveragingSchedule.AveragingScheduleBuilder> getSchedule() {
            return this.schedule;
        }

        @Override
        public AveragingSchedule.AveragingScheduleBuilder getOrCreateSchedule(int _index) {
            if (this.schedule == null) {
                this.schedule = new ArrayList<AveragingSchedule.AveragingScheduleBuilder>();
            }
            return (AveragingSchedule.AveragingScheduleBuilder)this.getIndex(this.schedule, _index, () -> {
                AveragingSchedule.AveragingScheduleBuilder newSchedule = AveragingSchedule.builder();
                return newSchedule;
            });
        }

        @Override
        public AveragingPeriodBuilder setAveragingDateTimes(DateTimeList averagingDateTimes) {
            this.averagingDateTimes = averagingDateTimes == null ? null : averagingDateTimes.toBuilder();
            return this;
        }

        @Override
        public AveragingPeriodBuilder setAveragingObservations(AveragingObservationList averagingObservations) {
            this.averagingObservations = averagingObservations == null ? null : averagingObservations.toBuilder();
            return this;
        }

        @Override
        public AveragingPeriodBuilder setMarketDisruption(FieldWithMetaMarketDisruptionEnum marketDisruption) {
            this.marketDisruption = marketDisruption == null ? null : marketDisruption.toBuilder();
            return this;
        }

        @Override
        public AveragingPeriodBuilder setMarketDisruptionValue(MarketDisruptionEnum marketDisruption) {
            this.getOrCreateMarketDisruption().setValue(marketDisruption);
            return this;
        }

        @Override
        public AveragingPeriodBuilder addSchedule(AveragingSchedule schedule) {
            if (schedule != null) {
                this.schedule.add(schedule.toBuilder());
            }
            return this;
        }

        @Override
        public AveragingPeriodBuilder addSchedule(AveragingSchedule schedule, int _idx) {
            this.getIndex(this.schedule, _idx, () -> schedule.toBuilder());
            return this;
        }

        @Override
        public AveragingPeriodBuilder addSchedule(List<? extends AveragingSchedule> schedules) {
            if (schedules != null) {
                for (AveragingSchedule averagingSchedule : schedules) {
                    this.schedule.add(averagingSchedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        public AveragingPeriodBuilder setSchedule(List<? extends AveragingSchedule> schedules) {
            this.schedule = schedules == null ? new ArrayList<AveragingSchedule.AveragingScheduleBuilder>() : (List)schedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AveragingPeriod build() {
            return new AveragingPeriodImpl(this);
        }

        @Override
        public AveragingPeriodBuilder toBuilder() {
            return this;
        }

        @Override
        public AveragingPeriodBuilder prune() {
            if (this.averagingDateTimes != null && !this.averagingDateTimes.prune().hasData()) {
                this.averagingDateTimes = null;
            }
            if (this.averagingObservations != null && !this.averagingObservations.prune().hasData()) {
                this.averagingObservations = null;
            }
            if (this.marketDisruption != null && !this.marketDisruption.prune().hasData()) {
                this.marketDisruption = null;
            }
            this.schedule = this.schedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getAveragingDateTimes() != null && this.getAveragingDateTimes().hasData()) {
                return true;
            }
            if (this.getAveragingObservations() != null && this.getAveragingObservations().hasData()) {
                return true;
            }
            if (this.getMarketDisruption() != null) {
                return true;
            }
            return this.getSchedule() != null && this.getSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public AveragingPeriodBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AveragingPeriodBuilder o = (AveragingPeriodBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAveragingDateTimes(), (RosettaModelObjectBuilder)o.getAveragingDateTimes(), this::setAveragingDateTimes);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAveragingObservations(), (RosettaModelObjectBuilder)o.getAveragingObservations(), this::setAveragingObservations);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMarketDisruption(), (RosettaModelObjectBuilder)o.getMarketDisruption(), this::setMarketDisruption);
            merger.mergeRosetta(this.getSchedule(), o.getSchedule(), this::getOrCreateSchedule);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AveragingPeriod _that = this.getType().cast(o);
            if (!Objects.equals(this.averagingDateTimes, _that.getAveragingDateTimes())) {
                return false;
            }
            if (!Objects.equals(this.averagingObservations, _that.getAveragingObservations())) {
                return false;
            }
            if (!Objects.equals(this.marketDisruption, _that.getMarketDisruption())) {
                return false;
            }
            return ListEquals.listEquals(this.schedule, _that.getSchedule());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.averagingDateTimes != null ? this.averagingDateTimes.hashCode() : 0);
            _result = 31 * _result + (this.averagingObservations != null ? this.averagingObservations.hashCode() : 0);
            _result = 31 * _result + (this.marketDisruption != null ? this.marketDisruption.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.schedule != null ? this.schedule.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AveragingPeriodBuilder {averagingDateTimes=" + this.averagingDateTimes + ", averagingObservations=" + this.averagingObservations + ", marketDisruption=" + this.marketDisruption + ", schedule=" + this.schedule + '}';
        }
    }

    public static class AveragingPeriodImpl
    implements AveragingPeriod {
        private final DateTimeList averagingDateTimes;
        private final AveragingObservationList averagingObservations;
        private final FieldWithMetaMarketDisruptionEnum marketDisruption;
        private final List<? extends AveragingSchedule> schedule;

        protected AveragingPeriodImpl(AveragingPeriodBuilder builder) {
            this.averagingDateTimes = Optional.ofNullable(builder.getAveragingDateTimes()).map(f -> f.build()).orElse(null);
            this.averagingObservations = Optional.ofNullable(builder.getAveragingObservations()).map(f -> f.build()).orElse(null);
            this.marketDisruption = Optional.ofNullable(builder.getMarketDisruption()).map(f -> f.build()).orElse(null);
            this.schedule = Optional.ofNullable(builder.getSchedule()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        public DateTimeList getAveragingDateTimes() {
            return this.averagingDateTimes;
        }

        @Override
        public AveragingObservationList getAveragingObservations() {
            return this.averagingObservations;
        }

        @Override
        public FieldWithMetaMarketDisruptionEnum getMarketDisruption() {
            return this.marketDisruption;
        }

        @Override
        public List<? extends AveragingSchedule> getSchedule() {
            return this.schedule;
        }

        @Override
        public AveragingPeriod build() {
            return this;
        }

        @Override
        public AveragingPeriodBuilder toBuilder() {
            AveragingPeriodBuilder builder = AveragingPeriod.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AveragingPeriodBuilder builder) {
            Optional.ofNullable(this.getAveragingDateTimes()).ifPresent(builder::setAveragingDateTimes);
            Optional.ofNullable(this.getAveragingObservations()).ifPresent(builder::setAveragingObservations);
            Optional.ofNullable(this.getMarketDisruption()).ifPresent(builder::setMarketDisruption);
            Optional.ofNullable(this.getSchedule()).ifPresent(builder::setSchedule);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AveragingPeriod _that = this.getType().cast(o);
            if (!Objects.equals(this.averagingDateTimes, _that.getAveragingDateTimes())) {
                return false;
            }
            if (!Objects.equals(this.averagingObservations, _that.getAveragingObservations())) {
                return false;
            }
            if (!Objects.equals(this.marketDisruption, _that.getMarketDisruption())) {
                return false;
            }
            return ListEquals.listEquals(this.schedule, _that.getSchedule());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.averagingDateTimes != null ? this.averagingDateTimes.hashCode() : 0);
            _result = 31 * _result + (this.averagingObservations != null ? this.averagingObservations.hashCode() : 0);
            _result = 31 * _result + (this.marketDisruption != null ? this.marketDisruption.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.schedule != null ? this.schedule.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AveragingPeriod {averagingDateTimes=" + this.averagingDateTimes + ", averagingObservations=" + this.averagingObservations + ", marketDisruption=" + this.marketDisruption + ", schedule=" + this.schedule + '}';
        }
    }

    public static interface AveragingPeriodBuilder
    extends AveragingPeriod,
    RosettaModelObjectBuilder {
        public DateTimeList.DateTimeListBuilder getOrCreateAveragingDateTimes();

        @Override
        public DateTimeList.DateTimeListBuilder getAveragingDateTimes();

        public AveragingObservationList.AveragingObservationListBuilder getOrCreateAveragingObservations();

        @Override
        public AveragingObservationList.AveragingObservationListBuilder getAveragingObservations();

        public FieldWithMetaMarketDisruptionEnum.FieldWithMetaMarketDisruptionEnumBuilder getOrCreateMarketDisruption();

        @Override
        public FieldWithMetaMarketDisruptionEnum.FieldWithMetaMarketDisruptionEnumBuilder getMarketDisruption();

        public AveragingSchedule.AveragingScheduleBuilder getOrCreateSchedule(int var1);

        public List<? extends AveragingSchedule.AveragingScheduleBuilder> getSchedule();

        public AveragingPeriodBuilder setAveragingDateTimes(DateTimeList var1);

        public AveragingPeriodBuilder setAveragingObservations(AveragingObservationList var1);

        public AveragingPeriodBuilder setMarketDisruption(FieldWithMetaMarketDisruptionEnum var1);

        public AveragingPeriodBuilder setMarketDisruptionValue(MarketDisruptionEnum var1);

        public AveragingPeriodBuilder addSchedule(AveragingSchedule var1);

        public AveragingPeriodBuilder addSchedule(AveragingSchedule var1, int var2);

        public AveragingPeriodBuilder addSchedule(List<? extends AveragingSchedule> var1);

        public AveragingPeriodBuilder setSchedule(List<? extends AveragingSchedule> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("averagingDateTimes"), processor, DateTimeList.DateTimeListBuilder.class, this.getAveragingDateTimes(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("averagingObservations"), processor, AveragingObservationList.AveragingObservationListBuilder.class, this.getAveragingObservations(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("marketDisruption"), processor, FieldWithMetaMarketDisruptionEnum.FieldWithMetaMarketDisruptionEnumBuilder.class, this.getMarketDisruption(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("schedule"), processor, AveragingSchedule.AveragingScheduleBuilder.class, this.getSchedule(), new AttributeMeta[0]);
        }

        public AveragingPeriodBuilder prune();
    }
}

